/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model.paste;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.filter.FilterMapRule;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Artigosmovimentos;
import org.projectocolibri.api.database.model.Entidadesartigos;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.api.database.model.Entidadesmovimentos;
import org.projectocolibri.api.database.query.QueryDefinition;
import org.projectocolibri.api.database.query.QueryOrdering;

public class EntidadesdocumentosPaste
extends EnumMap<TABLES, FilterMap> {
    private static final long serialVersionUID = 1L;
    private final Entidadesdocumentos documento;

    private FilterMap get(TABLES table) {
        FilterMap map = (FilterMap)super.get((Object)table);
        if (map == null) {
            map = new FilterMap(table);
            this.put(table, map);
        }
        return map;
    }

    private FilterMap get(FilterMap map) {
        return map.replace(this.get(map.table));
    }

    public EntidadesdocumentosPaste(Entidadesdocumentos documento) {
        super(TABLES.class);
        this.documento = documento;
        this.get(TABLES.artigos).addRule(new FilterMapRule(FIELDS.artigos_estado).equal(1));
        this.get(TABLES.artigosmovimentos).addRule(new FilterMapRule(FIELDS.artigosmovimentos_tipodocumento, FIELDS.documentostipos_tipoentidade, FIELDS.entidadestipos_codigo).equal(documento.getTipodocumento().getTipoentidade().getCodigo())).addRule(new FilterMapRule(FIELDS.artigosmovimentos_entidade, FIELDS.entidades_numero).equal(documento.getEntidade() == null ? -1 : documento.getEntidade().getNumero())).addRule(new FilterMapRule(FIELDS.artigosmovimentos_tipodocumento, FIELDS.documentostipos_codigo).notEqual(documento.getTipodocumento().getCodigo())).addRule(new FilterMapRule(FIELDS.artigosmovimentos_tipostock).notEqual(0)).addRule(new FilterMapRule(FIELDS.artigosmovimentos_numerolinhaproducao).equal(0)).addRule(new FilterMapRule(FIELDS.artigosmovimentos_quantidadependente).notEqual(0));
        this.get(TABLES.entidadesmovimentos).addRule(new FilterMapRule(FIELDS.entidadesmovimentos_tipodocumento, FIELDS.documentostipos_tipoentidade, FIELDS.entidadestipos_codigo).equal(documento.getTipodocumento().getTipoentidade().getCodigo())).addRule(new FilterMapRule(FIELDS.entidadesmovimentos_entidade, FIELDS.entidades_numero).equal(documento.getEntidade() == null ? -1 : documento.getEntidade().getNumero())).addRule(new FilterMapRule(FIELDS.entidadesmovimentos_seriedocumento, FIELDS.documentosseries_regimeiva).equal(documento.getSeriedocumento() == null ? 0 : documento.getSeriedocumento().getRegimeiva())).addRule(new FilterMapRule(FIELDS.entidadesmovimentos_tiposaldo).equal(0)).addRule(new FilterMapRule(FIELDS.entidadesmovimentos_valorpendente).notEqual(0));
        this.get(TABLES.entidadesdocumentos).addRule(new FilterMapRule(FIELDS.entidadesdocumentos_tipodocumento, FIELDS.documentostipos_tipoentidade, FIELDS.entidadestipos_codigo).equal(documento.getTipodocumento().getTipoentidade().getCodigo())).addRule(new FilterMapRule(FIELDS.entidadesdocumentos_entidade, FIELDS.entidades_numero).equal(documento.getEntidade() == null ? -1 : documento.getEntidade().getNumero())).addRule(new FilterMapRule(FIELDS.entidadesdocumentos_seriedocumento, FIELDS.documentosseries_regimeiva).equal(documento.getSeriedocumento() == null ? 0 : documento.getSeriedocumento().getRegimeiva())).addRule(new FilterMapRule(FIELDS.entidadesdocumentos_tipodocumento, FIELDS.documentostipos_tiposaldo).equal(0)).addRule(new FilterMapRule(FIELDS.entidadesdocumentos_tipodocumento, FIELDS.documentostipos_tipodocumento).equal(1).or().equal(3)).addRule(new FilterMapRule(FIELDS.entidadesdocumentos_estado).notEqual(1));
    }

    public Collection<Entidadesdocumentoslinhas> filter(FilterMap map) {
        switch (map.table) {
            default: {
                throw new IllegalArgumentException();
            }
            case artigos: {
                return this.artigos(this.documento.getManager().getArtigosCollection(new QueryDefinition(this.get(map), new QueryOrdering(QueryOrdering.DIRECTION.ASCENDING, new TableFieldKey(FIELDS.artigos_codigo)))));
            }
            case artigosmovimentos: {
                return this.artigosmovimentos(this.documento.getManager().getArtigosmovimentosCollection(new QueryDefinition(this.get(map), new QueryOrdering(QueryOrdering.DIRECTION.ASCENDING, new TableFieldKey(FIELDS.artigosmovimentos_tipodocumento, FIELDS.documentostipos_codigo), new TableFieldKey(FIELDS.artigosmovimentos_seriedocumento), new TableFieldKey(FIELDS.artigosmovimentos_numerodocumento), new TableFieldKey(FIELDS.artigosmovimentos_numerolinha), new TableFieldKey(FIELDS.artigosmovimentos_numerolinhaproducao)))));
            }
            case entidadesmovimentos: {
                return this.entidadesmovimentos(this.documento.getManager().getEntidadesmovimentosCollection(new QueryDefinition(this.get(map), new QueryOrdering(QueryOrdering.DIRECTION.DESCENDING, new TableFieldKey(FIELDS.entidadesmovimentos_datacriacao), new TableFieldKey(FIELDS.entidadesmovimentos_tipodocumento, FIELDS.documentostipos_codigo), new TableFieldKey(FIELDS.entidadesmovimentos_seriedocumento), new TableFieldKey(FIELDS.entidadesmovimentos_numerodocumento)))));
            }
            case entidadesdocumentos: 
        }
        return this.entidadesdocumentos(this.documento.getManager().getEntidadesdocumentosCollection(new QueryDefinition(this.get(map), new QueryOrdering(QueryOrdering.DIRECTION.DESCENDING, new TableFieldKey(FIELDS.entidadesdocumentos_datacriacao), new TableFieldKey(FIELDS.entidadesdocumentos_tipodocumento, FIELDS.documentostipos_codigo), new TableFieldKey(FIELDS.entidadesdocumentos_seriedocumento), new TableFieldKey(FIELDS.entidadesdocumentos_numerodocumento)))));
    }

    public Collection<Entidadesdocumentoslinhas> artigos(Collection<Artigos> col) {
        ArrayList<Entidadesdocumentoslinhas> list = new ArrayList<Entidadesdocumentoslinhas>();
        if (!this.documento.getTipodocumento().isTipodocumento(2)) {
            for (Artigos element : col) {
                Artigos artigo = this.documento.getManager().loadArtigos(element.getCodigo(), false);
                Entidadesdocumentoslinhas linha = this.documento.createLinhasdocumento();
                linha.setArtigo(artigo);
                list.add(linha);
            }
        }
        return list;
    }

    public Collection<Entidadesdocumentoslinhas> entidadesartigos(Collection<Entidadesartigos> col) {
        ArrayList<Artigos> list = new ArrayList<Artigos>();
        for (Entidadesartigos element : col) {
            list.add(element.getArtigo());
        }
        return this.artigos(list);
    }

    public Collection<Entidadesdocumentoslinhas> artigosmovimentos(Collection<Artigosmovimentos> col) {
        ArrayList<Entidadesdocumentoslinhas> list = new ArrayList<Entidadesdocumentoslinhas>();
        if (this.documento.getTipodocumento().isTipodocumento(1) || this.documento.getTipodocumento().isTipodocumento(3) || this.documento.getTipodocumento().isTipodocumento(5)) {
            class DocumentosOrigemMap
            extends LinkedHashMap<String, Collection<Artigosmovimentos>> {
                public boolean add(String key, Artigosmovimentos movimento) {
                    if (movimento.getTipodocumento().isTabela(1)) {
                        if (!this.containsKey(key)) {
                            this.put(key, new ArrayList());
                        }
                        return ((Collection)this.get(key)).add(movimento);
                    }
                    return false;
                }

                public DocumentosOrigemMap(Collection<Artigosmovimentos> col) {
                    switch (EntidadesdocumentosPaste.this.documento.getTipodocumento().getTipocarregamento()) {
                        case 1: 
                        case 2: {
                            for (Artigosmovimentos element : col) {
                                Artigosmovimentos movimento = EntidadesdocumentosPaste.this.documento.getManager().loadArtigosmovimentos(element.getKey());
                                String key = Entidadesdocumentos.generateKey(movimento.getTipodocumento().getCodigo(), movimento.getSeriedocumento().getSerie(), movimento.getNumerodocumento());
                                this.add(key, movimento);
                            }
                            break;
                        }
                    }
                }
            }
            DocumentosOrigemMap documentosorigem = new DocumentosOrigemMap(col);
            for (String key : documentosorigem.keySet()) {
                Entidadesdocumentos documento = this.documento.getManager().loadEntidadesdocumentos(key);
                if (!list.isEmpty()) {
                    list.add(this.documento.createLinhasdocumento());
                }
                Entidadesdocumentoslinhas linha = this.documento.createLinhasdocumento(0);
                linha.setDatadocumento(documento.getDatadocumento());
                linha.setDescricao(documento);
                list.add(linha);
                for (Artigosmovimentos movimento : (Collection)documentosorigem.get(key)) {
                    list.add(this.documento.createLinhasdocumento(movimento));
                    if (!this.documento.getTipodocumento().isTipocarregamento(1)) continue;
                    int index = movimento.getNumerolinha();
                    while (index < documento.getLinhasdocumento().size() && !(linha = documento.getLinhasdocumento(index)).isTipo(1)) {
                        if (linha.isTipo(2)) {
                            Entidadesdocumentoslinhas clone = linha.cloneCopy();
                            clone.setDocumento(this.documento);
                            list.add(clone);
                        }
                        ++index;
                    }
                }
            }
        }
        return list;
    }

    public Collection<Entidadesdocumentoslinhas> entidadesmovimentos(Collection<Entidadesmovimentos> col) {
        ArrayList<Entidadesdocumentoslinhas> list = new ArrayList<Entidadesdocumentoslinhas>();
        if (this.documento.getTipodocumento().isTipodocumento(2)) {
            class EntidadesmovimentosList
            extends ArrayList<Entidadesmovimentos> {
                EntidadesmovimentosList() {
                }

                public Collection<Entidadesdocumentoslinhas> process(boolean deducao) {
                    ArrayList<Entidadesdocumentoslinhas> list = new ArrayList<Entidadesdocumentoslinhas>();
                    for (Entidadesmovimentos movimento : this) {
                        Entidadesdocumentoslinhas linha = EntidadesdocumentosPaste.this.documento.createLinhasdocumento(movimento);
                        linha.setDescricao(movimento);
                        linha.setDeducao(deducao);
                        list.add(linha);
                    }
                    return list;
                }
            }
            EntidadesmovimentosList debitos = new EntidadesmovimentosList();
            EntidadesmovimentosList creditos = new EntidadesmovimentosList();
            for (Entidadesmovimentos element : col) {
                Entidadesmovimentos movimento = this.documento.getManager().loadEntidadesmovimentos(element.getKey());
                switch (movimento.getTipodocumento().getMovimentaentidades()) {
                    case 1: {
                        debitos.add(movimento);
                        break;
                    }
                    case 2: {
                        creditos.add(movimento);
                    }
                }
            }
            switch (this.documento.getTipodocumento().getMovimentaentidades()) {
                case 1: {
                    list.addAll(creditos.process(false));
                    list.addAll(debitos.process(true));
                    break;
                }
                case 2: {
                    list.addAll(debitos.process(false));
                    list.addAll(creditos.process(true));
                }
            }
        }
        return list;
    }

    public Collection<Entidadesdocumentoslinhas> entidadesdocumentos(Collection<Entidadesdocumentos> col) {
        ArrayList<Entidadesdocumentoslinhas> list = new ArrayList<Entidadesdocumentoslinhas>();
        if (this.documento.getTipodocumento().isTipodocumento(4)) {
            for (Entidadesdocumentos element : col) {
                Entidadesdocumentos documento = this.documento.getManager().loadEntidadesdocumentos(element.getKey());
                if (!list.isEmpty()) {
                    list.add(this.documento.createLinhasdocumento());
                }
                Entidadesdocumentoslinhas linha = this.documento.createLinhasdocumento(0);
                linha.setDatadocumento(documento.getDatadocumento());
                linha.setDescricao(documento);
                list.add(linha);
                Entidadesdocumentos clone = documento.cleanCopy();
                for (Entidadesdocumentoslinhas linhaorigem : documento.getLinhasdocumento()) {
                    linha = clone.getLinhasdocumento(linhaorigem.getNumerolinha() - 1);
                    if (linhaorigem.isTipo(0)) continue;
                    linha.setLinhaorigem(linhaorigem);
                    list.add(linha);
                }
            }
        }
        return list;
    }

    public Collection<Entidadesdocumentoslinhas> entidadesdocumentoslinhas(Collection<Entidadesdocumentoslinhas> col) {
        ArrayList<Entidadesdocumentoslinhas> list = new ArrayList<Entidadesdocumentoslinhas>();
        if (!this.documento.getTipodocumento().isTipodocumento(2)) {
            for (Entidadesdocumentoslinhas element : col) {
                Entidadesdocumentoslinhas linha = element.cloneCopy();
                linha.setDocumento(this.documento);
                linha.removeRelations();
                list.add(linha);
            }
        }
        return list;
    }
}

