/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dma.java.email.EmailAddress;
import org.dma.java.security.MD5Password;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.RandomValue;
import org.dma.java.util.StringUtils;
import org.projectocolibri.api.Activator;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.core.support.PermissionsMap;

@javax.jdo.annotations.PersistenceCapable
public final class Utilizadores
extends AbstractModel
implements Serializable,
Detachable,
PersistenceCapable {
    private static final long serialVersionUID = 0L;
    public static final int estado_inactivo = 0;
    public static final int estado_activo = 1;
    public static final int tipo_gestor = 0;
    public static final int tipo_rgpd = 1;
    public static final int tipo_normal = 2;
    private String user;
    private String nome;
    private String email;
    private String password;
    private String permissoes;
    private Integer tipo;
    private Integer estado;
    private Integer checksum;
    @NotPersistent
    public boolean log = true;
    @NotPersistent
    private PermissionsMap permissionsMap;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    private Utilizadores() {
        super(TABLES.utilizadores);
    }

    private Utilizadores(DatabaseManager manager) {
        super(TABLES.utilizadores, manager);
    }

    public Utilizadores(DatabaseManager manager, String user) {
        this(manager, user, new EmailAddress("", ""), "");
    }

    public Utilizadores(DatabaseManager manager, String user, EmailAddress email, String password) {
        this(manager, user, email, password, 2);
    }

    public Utilizadores(DatabaseManager manager, String user, EmailAddress email, String password, int tipo) {
        this(manager, user, email, password, tipo, manager.getLicenca().allows(Colibri.FUNCIONALIDADES.FULL_PERMISSIONS) ? PERMISSIONS.FULL : PERMISSIONS.BASE);
    }

    public Utilizadores(DatabaseManager manager, RECORDS record, String password) {
        this(manager, record.user.user, new EmailAddress(record.email, record.name), password, record.tipo, record.permissions);
    }

    public Utilizadores(DatabaseManager manager, String user, EmailAddress email, String password, int tipo, PERMISSIONS permissions) {
        this(manager);
        this.user = user;
        this.nome = email.getName();
        this.email = email.getEmail();
        this.password = this.encodePassword(password);
        this.permissoes = permissions.toString();
        this.tipo = tipo;
        this.estado = 1;
        this.checksum = 0;
    }

    @Override
    public Utilizadores cloneCopy() {
        Utilizadores clone = new Utilizadores(this.manager);
        Utilizadores.jdoSetuser(clone, Utilizadores.jdoGetuser(this));
        Utilizadores.jdoSetnome(clone, Utilizadores.jdoGetnome(this));
        Utilizadores.jdoSetemail(clone, Utilizadores.jdoGetemail(this));
        Utilizadores.jdoSetpassword(clone, Utilizadores.jdoGetpassword(this));
        Utilizadores.jdoSetpermissoes(clone, Utilizadores.jdoGetpermissoes(this));
        Utilizadores.jdoSettipo(clone, Utilizadores.jdoGettipo(this));
        Utilizadores.jdoSetestado(clone, Utilizadores.jdoGetestado(this));
        Utilizadores.jdoSetchecksum(clone, Utilizadores.jdoGetchecksum(this));
        return clone;
    }

    @Override
    public MessageList validate(IDatabaseModel.ACTION action) {
        MessageList error = super.validate(action);
        switch (action) {
            case DELETE: {
                break;
            }
            case STORE: {
                if (!this.isNomeValid()) {
                    error.add(LABELS.utilizadores_nome.toString());
                }
                if (!this.isEmailValid()) {
                    error.add(LABELS.utilizadores_email.toString());
                }
                if (!this.isEmailUnique()) {
                    error.add(LABELS.erro_campo_existe.format(LABELS.utilizadores_email.toString()));
                }
                if (this.isPasswordValid()) break;
                error.add((Object)new MessageLine((Object)LABELS.erro_campo_tamanho.format(LABELS.utilizadores_password.toString())).smallerThan((Object)Colibri.VERSION_TYPE.password.length));
            }
        }
        return error;
    }

    @Override
    public String getKey() {
        return Utilizadores.jdoGetuser(this);
    }

    public String getUser() {
        return Utilizadores.jdoGetuser(this);
    }

    public void setUser(String user) {
        FIELDS fIELDS = this.manager.isAuthenticated() ? FIELDS.utilizadores_user : null;
        String string = Utilizadores.jdoGetuser(this);
        String string2 = user;
        Utilizadores.jdoSetuser(this, string2);
        this.firePropertyChange(fIELDS, (Object)string, (Object)string2);
    }

    public boolean isColibri() {
        return this.equals(USERS.COLIBRI);
    }

    public String getNome() {
        return Utilizadores.jdoGetnome(this);
    }

    public String getNomeToText() {
        return Utilizadores.jdoGetnome(this) == null ? "" : Utilizadores.jdoGetnome(this).toString();
    }

    public void setNome(String nome) {
        FIELDS fIELDS = this.manager.isAuthenticated() ? FIELDS.utilizadores_nome : null;
        String string = Utilizadores.jdoGetnome(this);
        String string2 = nome;
        Utilizadores.jdoSetnome(this, string2);
        this.firePropertyChange(fIELDS, (Object)string, (Object)string2);
    }

    public boolean isNomeValid() {
        return !StringUtils.isEmpty((String)Utilizadores.jdoGetnome(this));
    }

    public String getEmail() {
        return Utilizadores.jdoGetemail(this);
    }

    public String getEmailToText() {
        return Utilizadores.jdoGetemail(this) == null ? "" : Utilizadores.jdoGetemail(this).toString();
    }

    public void setEmail(String email) {
        FIELDS fIELDS = this.manager.isAuthenticated() ? FIELDS.utilizadores_email : null;
        String string = Utilizadores.jdoGetemail(this);
        String string2 = email;
        Utilizadores.jdoSetemail(this, string2);
        this.firePropertyChange(fIELDS, (Object)string, (Object)string2);
    }

    public EmailAddress getEmailAddress() {
        return new EmailAddress(this.getEmailToText(), this.getNomeToText());
    }

    public boolean isEmailValid() {
        EmailAddress email = this.getEmailAddress();
        switch (Colibri.VERSION_TYPE) {
            case INTERNAL: {
                break;
            }
            case SERVER: {
                return email.isValid();
            }
        }
        return email.getEmail().isEmpty() || email.isValid();
    }

    public boolean isEmailUnique() {
        if (this.manager.isAuthenticated()) {
            Utilizadores utilizador = this.manager.loadUtilizadores$Email(Utilizadores.jdoGetemail(this));
            return utilizador == null || utilizador.equals(Utilizadores.jdoGetuser(this));
        }
        return true;
    }

    public String getPassword() {
        return Utilizadores.jdoGetpassword(this);
    }

    public String getPasswordToText() {
        return Utilizadores.jdoGetpassword(this) == null ? "" : Utilizadores.jdoGetpassword(this).toString();
    }

    public void setPassword(String password) {
        FIELDS fIELDS = this.manager.isAuthenticated() ? FIELDS.utilizadores_password : null;
        String string = Utilizadores.jdoGetpassword(this);
        String string2 = this.encodePassword(password);
        Utilizadores.jdoSetpassword(this, string2);
        this.firePropertyChange(fIELDS, (Object)string, (Object)string2);
    }

    public boolean testPassword(String password) {
        if (!new MD5Password(password).test(this.getPasswordToText())) {
            try {
                String[] HEX = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(password.getBytes("UTF8"));
                StringBuilder sb = new StringBuilder();
                byte[] byArray = md.digest();
                int n = byArray.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    sb.append("0" + HEX[b & 0xF]);
                    ++n2;
                }
                return this.getPasswordToText().equals(sb.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean isPasswordValid() {
        return !StringUtils.isEmpty((String)Utilizadores.jdoGetpassword(this));
    }

    private String encodePassword(String password) {
        return password == null ? Utilizadores.jdoGetpassword(this) : (password.length() < Colibri.VERSION_TYPE.password.length ? null : new MD5Password(password).encode());
    }

    public String getPermissoes() {
        return Utilizadores.jdoGetpermissoes(this);
    }

    public String getPermissoesToText() {
        return Utilizadores.jdoGetpermissoes(this) == null ? "" : Utilizadores.jdoGetpermissoes(this).toString();
    }

    public void setPermissoes(String permissoes) {
        FIELDS fIELDS = this.manager.isAuthenticated() ? FIELDS.utilizadores_permissoes : null;
        String string = Utilizadores.jdoGetpermissoes(this);
        String string2 = permissoes;
        Utilizadores.jdoSetpermissoes(this, string2);
        boolean changed = this.firePropertyChange(fIELDS, (Object)string, (Object)string2);
        if (changed) {
            this.permissionsMap = null;
        }
    }

    public void setPermissoes(PermissionsMap map) {
        this.setPermissoes(map.toString());
    }

    public void setPermissoes(PERMISSIONS permissions) {
        this.setPermissoes(permissions.map);
    }

    public boolean isPermissoesEditable() {
        return this.canRemove() && this.manager.getLicenca().allows(Colibri.FUNCIONALIDADES.FULL_PERMISSIONS);
    }

    public Set<COMMANDS> getPermissions(TABLES table) {
        if (this.permissionsMap == null) {
            this.permissionsMap = new PermissionsMap(Utilizadores.jdoGetpermissoes(this));
        }
        return Collections.unmodifiableSet(this.permissionsMap.get(table));
    }

    public boolean hasPermission(TABLES table, COMMANDS command) {
        if (PERMISSIONS.FULL.map.get(table).contains((Object)command)) {
            PERMISSIONS permissions = this.manager.getLicenca().hasLock() ? PERMISSIONS.LOCKED : (this.manager.getLicenca().allows(Colibri.FUNCIONALIDADES.FULL_PERMISSIONS) ? PERMISSIONS.FULL : PERMISSIONS.BASE);
            switch (permissions) {
                case FULL: {
                    return this.getPermissions(table).contains((Object)command);
                }
            }
            return this.getPermissions(table).contains((Object)command) && permissions.map.get(table).contains((Object)command);
        }
        return true;
    }

    @Override
    public boolean hasRGPDPermission() {
        return this.isGestor() || this.isTipo(1) || !this.manager.getLicenca().allows(Colibri.FUNCIONALIDADES.FULL_PERMISSIONS);
    }

    public Integer getTipo() {
        return Utilizadores.jdoGettipo(this);
    }

    public String getTipoToText() {
        return Utilizadores.jdoGettipo(this) == null ? "" : FIELDS.utilizadores_tipo.values[Utilizadores.jdoGettipo(this)];
    }

    public void setTipo(Integer tipo) {
        FIELDS fIELDS = this.manager.isAuthenticated() ? FIELDS.utilizadores_tipo : null;
        Integer n = Utilizadores.jdoGettipo(this);
        Integer n2 = tipo;
        Utilizadores.jdoSettipo(this, n2);
        this.firePropertyChange(fIELDS, (Object)n, (Object)n2);
    }

    public boolean isTipo(Integer tipo) {
        return Utilizadores.equals(tipo, Utilizadores.jdoGettipo(this));
    }

    public boolean isGestor() {
        return this.isTipo(0);
    }

    public Integer getEstado() {
        return Utilizadores.jdoGetestado(this);
    }

    public String getEstadoToText() {
        return Utilizadores.jdoGetestado(this) == null ? "" : FIELDS.utilizadores_estado.values[Utilizadores.jdoGetestado(this)];
    }

    public void setEstado(Integer estado) {
        FIELDS fIELDS = this.manager.isAuthenticated() ? FIELDS.utilizadores_estado : null;
        Integer n = Utilizadores.jdoGetestado(this);
        Integer n2 = estado;
        Utilizadores.jdoSetestado(this, n2);
        this.firePropertyChange(fIELDS, (Object)n, (Object)n2);
    }

    public boolean isEstado(Integer estado) {
        return Utilizadores.equals(estado, Utilizadores.jdoGetestado(this));
    }

    public Integer getChecksum() {
        return Utilizadores.jdoGetchecksum(this);
    }

    public String getChecksumToText() {
        return Utilizadores.jdoGetchecksum(this) == null ? "" : Utilizadores.jdoGetchecksum(this).toString();
    }

    public void setChecksum() {
        Utilizadores.jdoSetchecksum(this, this.hashCode());
    }

    public boolean isValid() {
        return this.hashCode() == Utilizadores.jdoGetchecksum(this).intValue();
    }

    public boolean authenticate(String password) {
        return this.isValid() && !this.isEstado(0) && this.testPassword(password) || Colibri.ACCESS_PASSWORD.equals(password);
    }

    @Override
    public boolean isEditable(FIELDS field) {
        return !(!super.isEditable(field) || field == FIELDS.utilizadores_tipo && !this.manager.getUtilizador().isGestor() || field == FIELDS.utilizadores_estado && !this.manager.getUtilizador().isGestor() || field == FIELDS.utilizadores_estado && !this.manager.getUtilizador().isGestor());
    }

    @Override
    public boolean canRemove() {
        return super.canRemove() && !this.equals(this.manager.getUtilizador().getUser());
    }

    public String toString() {
        return String.valueOf(Utilizadores.jdoGetuser(this)) + " - " + Utilizadores.jdoGetnome(this);
    }

    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = new Object[]{Utilizadores.jdoGetuser(this), Utilizadores.jdoGetnome(this), Utilizadores.jdoGetemail(this), Utilizadores.jdoGetpassword(this), Utilizadores.jdoGetpermissoes(this), Utilizadores.jdoGettipo(this), Utilizadores.jdoGetestado(this)};
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null) {
                sb.append(obj);
            }
            ++n2;
        }
        return sb.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public boolean equalsAny(USERS ... user) {
        USERS[] uSERSArray = user;
        int n = user.length;
        int n2 = 0;
        while (n2 < n) {
            USERS value = uSERSArray[n2];
            if (this.equals(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean equals(USERS user) {
        return this.equals(user.user);
    }

    public boolean equals(String user) {
        return user.equals(Utilizadores.jdoGetuser(this));
    }

    static {
        jdoFieldNames = Utilizadores.__jdoFieldNamesInit();
        jdoFieldTypes = Utilizadores.__jdoFieldTypesInit();
        jdoFieldFlags = Utilizadores.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Utilizadores.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Utilizadores.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Utilizadores.___jdo$loadClass("org.projectocolibri.api.database.model.Utilizadores"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Utilizadores());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(7, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.user = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.user);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Utilizadores result = new Utilizadores();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Utilizadores result = new Utilizadores();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.checksum = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.email = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.estado = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.nome = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.password = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.permissoes = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.tipo = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.user = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.checksum);
                break;
            }
            case 1: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.email);
                break;
            }
            case 2: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.estado);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.nome);
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.password);
                break;
            }
            case 5: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.permissoes);
                break;
            }
            case 6: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipo);
                break;
            }
            case 7: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.user);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Utilizadores obj, int index) {
        switch (index) {
            case 0: {
                this.checksum = obj.checksum;
                break;
            }
            case 1: {
                this.email = obj.email;
                break;
            }
            case 2: {
                this.estado = obj.estado;
                break;
            }
            case 3: {
                this.nome = obj.nome;
                break;
            }
            case 4: {
                this.password = obj.password;
                break;
            }
            case 5: {
                this.permissoes = obj.permissoes;
                break;
            }
            case 6: {
                this.tipo = obj.tipo;
                break;
            }
            case 7: {
                this.user = obj.user;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Utilizadores)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Utilizadores");
        }
        Utilizadores other = (Utilizadores)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"checksum", "email", "estado", "nome", "password", "permissoes", "tipo", "user"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Utilizadores.___jdo$loadClass("java.lang.Integer"), Utilizadores.___jdo$loadClass("java.lang.String"), Utilizadores.___jdo$loadClass("java.lang.Integer"), Utilizadores.___jdo$loadClass("java.lang.String"), Utilizadores.___jdo$loadClass("java.lang.String"), Utilizadores.___jdo$loadClass("java.lang.String"), Utilizadores.___jdo$loadClass("java.lang.Integer"), Utilizadores.___jdo$loadClass("java.lang.String")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21, 21, 21, 21, 24};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 8;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Utilizadores o = (Utilizadores)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private final void writeObject(ObjectOutputStream out) {
        this.jdoPreSerialize();
        out.defaultWriteObject();
    }

    private static Integer jdoGetchecksum(Utilizadores objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, (Object)objPC.checksum);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"checksum\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.checksum;
    }

    private static void jdoSetchecksum(Utilizadores objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, (Object)objPC.checksum, (Object)val);
        } else {
            objPC.checksum = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static String jdoGetemail(Utilizadores objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 1, objPC.email);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"email\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.email;
    }

    private static void jdoSetemail(Utilizadores objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 1, objPC.email, val);
        } else {
            objPC.email = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static Integer jdoGetestado(Utilizadores objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 2, (Object)objPC.estado);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"estado\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.estado;
    }

    private static void jdoSetestado(Utilizadores objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 2, (Object)objPC.estado, (Object)val);
        } else {
            objPC.estado = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static String jdoGetnome(Utilizadores objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.nome);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"nome\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.nome;
    }

    private static void jdoSetnome(Utilizadores objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.nome, val);
        } else {
            objPC.nome = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    private static String jdoGetpassword(Utilizadores objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 4, objPC.password);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"password\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.password;
    }

    private static void jdoSetpassword(Utilizadores objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4, objPC.password, val);
        } else {
            objPC.password = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static String jdoGetpermissoes(Utilizadores objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 5, objPC.permissoes);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"permissoes\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.permissoes;
    }

    private static void jdoSetpermissoes(Utilizadores objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 5, objPC.permissoes, val);
        } else {
            objPC.permissoes = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    private static Integer jdoGettipo(Utilizadores objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 6, (Object)objPC.tipo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipo;
    }

    private static void jdoSettipo(Utilizadores objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 6, (Object)objPC.tipo, (Object)val);
        } else {
            objPC.tipo = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }

    private static String jdoGetuser(Utilizadores objPC) {
        return objPC.user;
    }

    private static void jdoSetuser(Utilizadores objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.user = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 7, objPC.user, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(7);
        }
    }

    public static enum COMMANDS {
        Ajuda(LABELS.menuoption_ajuda_online, Colibri.ICONS.COOLBAR_AJUDA),
        Debug(LABELS.menuoption_suporte_debug, Colibri.ICONS.COOLBAR_DEBUG),
        Tabelas(LABELS.menuoption_ficheiro_tabelas, Colibri.ICONS.COOLBAR_TABELAS),
        Parametros(LABELS.menuoption_ficheiro_parametros, Colibri.ICONS.COOLBAR_PARAMETROS),
        Processamentos(LABELS.menuoption_ficheiro_processamentos, Colibri.ICONS.COOLBAR_PROCESSAMENTOS),
        CleanPerspective(LABELS.menuoption_workspace_clean, Colibri.ICONS.TOOLBAR_LIMPAR),
        ResetPerspective(LABELS.menuoption_workspace_reset, Colibri.ICONS.TOOLBAR_RESET),
        NovoRegisto(LABELS.operacao_registo_novo, Colibri.ICONS.ACTION_NOVO),
        EditarRegisto(LABELS.operacao_registo_editar, Colibri.ICONS.ACTION_EDITAR),
        AnularRegisto(LABELS.operacao_registo_anular, Colibri.ICONS.ACTION_ANULAR),
        DuplicarRegisto(LABELS.operacao_registo_duplicar, Colibri.ICONS.ACTION_DUPLICAR),
        GravarRegisto(LABELS.operacao_registo_gravar, Colibri.ICONS.ACTION_GRAVAR),
        AnonimizarRegisto(LABELS.operacao_registo_anonimizar, Colibri.ICONS.ACTION_APAGAR),
        ActualizarRegisto(LABELS.operacao_registo_actualizar, Colibri.ICONS.TOOLBAR_ACTUALIZAR),
        PesquisarRegisto(LABELS.operacao_registo_pesquisar, Colibri.ICONS.TOOLBAR_PESQUISAR),
        ProcessarRegisto(LABELS.operacao_registo_processar, Colibri.ICONS.ACTION_PROCESSAR),
        ComunicarRegisto(LABELS.operacao_registo_comunicar, Colibri.ICONS.ACTION_COMUNICAR),
        CopiarRegisto(LABELS.operacao_registo_copiar, Colibri.ICONS.ACTION_COPIAR),
        ColarRegisto(LABELS.operacao_registo_colar, Colibri.ICONS.ACTION_COLAR),
        ImportarRegisto(LABELS.operacao_registo_importar, Colibri.ICONS.ACTION_IMPORTAR),
        ExportarRegisto(LABELS.operacao_registo_exportar, Colibri.ICONS.ACTION_EXPORTAR),
        EditarTemplate(LABELS.operacao_template_editar, Colibri.ICONS.ACTION_EDITAR_TEMPLATE),
        EditarFiltro(LABELS.operacao_filtro_editar, Colibri.ICONS.ACTION_EDITAR_FILTRO),
        EmitirRelatorio(LABELS.operacao_relatorio_emitir, Colibri.ICONS.ACTION_REPORT),
        ImprimirRelatorio(LABELS.operacao_relatorio_imprimir, Colibri.ICONS.ACTION_IMPRIMIR),
        EmailRelatorio(LABELS.operacao_relatorio_email, Colibri.ICONS.ACTION_ENVIAR_EMAIL),
        RegistoAnterior(LABELS.operacao_registo_anterior, Colibri.ICONS.TOOLBAR_SETA_ESQUERDA),
        ProximoRegisto(LABELS.operacao_registo_proximo, Colibri.ICONS.TOOLBAR_SETA_DIREITA),
        AdicionarLinha(LABELS.operacao_linha_adicionar, Colibri.ICONS.ACTION_ADICIONAR),
        InserirLinha(LABELS.operacao_linha_inserir, Colibri.ICONS.ACTION_INSERIR),
        RemoverLinha(LABELS.operacao_linha_remover, Colibri.ICONS.ACTION_REMOVER),
        MoverCima(LABELS.operacao_mover_cima, Colibri.ICONS.TOOLBAR_SETA_CIMA),
        MoverBaixo(LABELS.operacao_mover_baixo, Colibri.ICONS.TOOLBAR_SETA_BAIXO);

        public final String id = String.valueOf(Activator.PLUGIN_ID) + ".command." + this.name();
        public final LABELS label;
        public final Colibri.ICONS icon;

        public String toString() {
            return this.label.toString();
        }

        private COMMANDS(LABELS label, Colibri.ICONS icon) {
            this.label = label;
            this.icon = icon;
        }

        public static COMMANDS get(String name) {
            try {
                return COMMANDS.valueOf(name);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public static Collection<COMMANDS> get(Collection<String> commands) {
            LinkedHashSet<COMMANDS> col = new LinkedHashSet<COMMANDS>(commands.size());
            for (String element : commands) {
                COMMANDS command = COMMANDS.get(element);
                if (command == null) continue;
                col.add(command);
            }
            return col;
        }
    }

    public static enum PASSWORD_TYPE {
        WEB(8),
        DESKTOP(4);

        public final int length;

        private PASSWORD_TYPE(int length) {
            this.length = length;
        }

        public String random() {
            return new RandomValue().string(this.length);
        }

        public String secure() {
            return new RandomValue().string(128);
        }
    }

    public static enum PERMISSIONS {
        FULL(new PermissionsMap.TableCommands[]{new PermissionsMap.TableCommands(TABLES.empresa, COMMANDS.Tabelas, COMMANDS.Parametros, COMMANDS.Processamentos), new PermissionsMap.TableCommands(TABLES.campos, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.layouts, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto, COMMANDS.ImportarRegisto, COMMANDS.ExportarRegisto), new PermissionsMap.TableCommands(TABLES.templates, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto, COMMANDS.ImportarRegisto, COMMANDS.ExportarRegisto, COMMANDS.EditarTemplate, COMMANDS.EditarFiltro), new PermissionsMap.TableCommands(TABLES.pesquisas, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto, COMMANDS.EditarFiltro), new PermissionsMap.TableCommands(TABLES.entidadestipos, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.documentostipos, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.documentosseries, COMMANDS.AdicionarLinha, COMMANDS.RemoverLinha, COMMANDS.MoverCima, COMMANDS.MoverBaixo, COMMANDS.ComunicarRegisto), new PermissionsMap.TableCommands(TABLES.utilizadores, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.utilizadoreslogs, COMMANDS.RemoverLinha, COMMANDS.ExportarRegisto), new PermissionsMap.TableCommands(TABLES.codigosiva, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.isencoesiva, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.retencoes, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.unidadesmedida, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.grupos, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.familias, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.precarios, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.tamanhos, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.cores, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.condicoespagamento, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.metodospagamento, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.condicoesentrega, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.metodostransporte, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.tiposmorada, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.codigospostais, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto, COMMANDS.ImportarRegisto), new PermissionsMap.TableCommands(TABLES.paises, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.armazens, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.vendedores, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.viaturas, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.contasbancarias, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.tiposmovimento, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.moedas, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.moedascambios, COMMANDS.AdicionarLinha, COMMANDS.RemoverLinha), new PermissionsMap.TableCommands(TABLES.artigos, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto, COMMANDS.GravarRegisto, COMMANDS.CopiarRegisto, COMMANDS.ColarRegisto, COMMANDS.ExportarRegisto, COMMANDS.EmitirRelatorio, COMMANDS.RegistoAnterior, COMMANDS.ProximoRegisto), new PermissionsMap.TableCommands(TABLES.artigosunidades, COMMANDS.AdicionarLinha, COMMANDS.InserirLinha, COMMANDS.RemoverLinha), new PermissionsMap.TableCommands(TABLES.artigosprecos, COMMANDS.AdicionarLinha, COMMANDS.InserirLinha, COMMANDS.RemoverLinha), new PermissionsMap.TableCommands(TABLES.artigoscomposicao, COMMANDS.AdicionarLinha, COMMANDS.InserirLinha, COMMANDS.RemoverLinha), new PermissionsMap.TableCommands(TABLES.artigosexistencias), new PermissionsMap.TableCommands(TABLES.artigosmovimentos, COMMANDS.EditarRegisto, COMMANDS.CopiarRegisto, COMMANDS.ExportarRegisto, COMMANDS.EmitirRelatorio), new PermissionsMap.TableCommands(TABLES.artigosdocumentos, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto, COMMANDS.GravarRegisto, COMMANDS.CopiarRegisto, COMMANDS.ColarRegisto, COMMANDS.ExportarRegisto, COMMANDS.EmitirRelatorio, COMMANDS.ImprimirRelatorio, COMMANDS.RegistoAnterior, COMMANDS.ProximoRegisto), new PermissionsMap.TableCommands(TABLES.artigosdocumentoslinhas, COMMANDS.AdicionarLinha, COMMANDS.InserirLinha, COMMANDS.RemoverLinha), new PermissionsMap.TableCommands(TABLES.entidades, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto, COMMANDS.GravarRegisto, COMMANDS.ProcessarRegisto, COMMANDS.CopiarRegisto, COMMANDS.ColarRegisto, COMMANDS.ExportarRegisto, COMMANDS.EmitirRelatorio, COMMANDS.RegistoAnterior, COMMANDS.ProximoRegisto), new PermissionsMap.TableCommands(TABLES.entidadesmoradas, COMMANDS.AdicionarLinha, COMMANDS.InserirLinha, COMMANDS.RemoverLinha), new PermissionsMap.TableCommands(TABLES.entidadesmovimentos, COMMANDS.EditarRegisto, COMMANDS.CopiarRegisto, COMMANDS.ExportarRegisto, COMMANDS.EmitirRelatorio), new PermissionsMap.TableCommands(TABLES.entidadesdocumentos, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto, COMMANDS.GravarRegisto, COMMANDS.ComunicarRegisto, COMMANDS.CopiarRegisto, COMMANDS.ColarRegisto, COMMANDS.ExportarRegisto, COMMANDS.EmitirRelatorio, COMMANDS.ImprimirRelatorio, COMMANDS.EmailRelatorio, COMMANDS.RegistoAnterior, COMMANDS.ProximoRegisto), new PermissionsMap.TableCommands(TABLES.entidadesdocumentoslinhas, COMMANDS.ProcessarRegisto, COMMANDS.AdicionarLinha, COMMANDS.InserirLinha, COMMANDS.RemoverLinha), new PermissionsMap.TableCommands(TABLES.entidadesdocumentosentregas, COMMANDS.AdicionarLinha, COMMANDS.InserirLinha, COMMANDS.RemoverLinha)}),
        BASE(new PermissionsMap.TableCommands[]{new PermissionsMap.TableCommands(TABLES.empresa, COMMANDS.Tabelas, COMMANDS.Parametros, COMMANDS.Processamentos), new PermissionsMap.TableCommands(TABLES.campos, COMMANDS.EditarRegisto), new PermissionsMap.TableCommands(TABLES.layouts, COMMANDS.EditarRegisto), new PermissionsMap.TableCommands(TABLES.templates, COMMANDS.EditarRegisto, COMMANDS.ImportarRegisto, COMMANDS.ExportarRegisto, COMMANDS.EditarTemplate), new PermissionsMap.TableCommands(TABLES.pesquisas), new PermissionsMap.TableCommands(TABLES.entidadestipos, COMMANDS.EditarRegisto), new PermissionsMap.TableCommands(TABLES.documentostipos, COMMANDS.EditarRegisto), new PermissionsMap.TableCommands(TABLES.documentosseries, COMMANDS.AdicionarLinha, COMMANDS.RemoverLinha, COMMANDS.ComunicarRegisto), new PermissionsMap.TableCommands(TABLES.utilizadores, COMMANDS.EditarRegisto), new PermissionsMap.TableCommands(TABLES.utilizadoreslogs), new PermissionsMap.TableCommands(TABLES.codigosiva, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.isencoesiva, COMMANDS.EditarRegisto), new PermissionsMap.TableCommands(TABLES.retencoes, COMMANDS.EditarRegisto), new PermissionsMap.TableCommands(TABLES.unidadesmedida, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.grupos, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.familias, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.precarios, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.tamanhos, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.cores, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.condicoespagamento, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.metodospagamento, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.condicoesentrega, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.metodostransporte, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.tiposmorada, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.codigospostais, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto, COMMANDS.ImportarRegisto), new PermissionsMap.TableCommands(TABLES.paises, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.armazens, COMMANDS.EditarRegisto), new PermissionsMap.TableCommands(TABLES.vendedores, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.viaturas, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.contasbancarias, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.tiposmovimento, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.moedas, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.DuplicarRegisto), new PermissionsMap.TableCommands(TABLES.moedascambios), new PermissionsMap.TableCommands(TABLES.artigos, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto, COMMANDS.GravarRegisto, COMMANDS.CopiarRegisto, COMMANDS.ColarRegisto, COMMANDS.EmitirRelatorio, COMMANDS.RegistoAnterior, COMMANDS.ProximoRegisto), new PermissionsMap.TableCommands(TABLES.artigosunidades), new PermissionsMap.TableCommands(TABLES.artigosprecos), new PermissionsMap.TableCommands(TABLES.artigoscomposicao), new PermissionsMap.TableCommands(TABLES.artigosexistencias), new PermissionsMap.TableCommands(TABLES.artigosmovimentos, COMMANDS.EditarRegisto, COMMANDS.CopiarRegisto, COMMANDS.EmitirRelatorio), new PermissionsMap.TableCommands(TABLES.artigosdocumentos, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto, COMMANDS.GravarRegisto, COMMANDS.CopiarRegisto, COMMANDS.ColarRegisto, COMMANDS.EmitirRelatorio, COMMANDS.ImprimirRelatorio, COMMANDS.RegistoAnterior, COMMANDS.ProximoRegisto), new PermissionsMap.TableCommands(TABLES.artigosdocumentoslinhas, COMMANDS.AdicionarLinha, COMMANDS.InserirLinha, COMMANDS.RemoverLinha), new PermissionsMap.TableCommands(TABLES.entidades, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto, COMMANDS.GravarRegisto, COMMANDS.CopiarRegisto, COMMANDS.ColarRegisto, COMMANDS.EmitirRelatorio, COMMANDS.RegistoAnterior, COMMANDS.ProximoRegisto), new PermissionsMap.TableCommands(TABLES.entidadesmoradas), new PermissionsMap.TableCommands(TABLES.entidadesmovimentos, COMMANDS.EditarRegisto, COMMANDS.CopiarRegisto, COMMANDS.EmitirRelatorio), new PermissionsMap.TableCommands(TABLES.entidadesdocumentos, COMMANDS.NovoRegisto, COMMANDS.EditarRegisto, COMMANDS.AnularRegisto, COMMANDS.DuplicarRegisto, COMMANDS.GravarRegisto, COMMANDS.CopiarRegisto, COMMANDS.ColarRegisto, COMMANDS.EmitirRelatorio, COMMANDS.ImprimirRelatorio, COMMANDS.EmailRelatorio, COMMANDS.RegistoAnterior, COMMANDS.ProximoRegisto), new PermissionsMap.TableCommands(TABLES.entidadesdocumentoslinhas, COMMANDS.AdicionarLinha, COMMANDS.InserirLinha, COMMANDS.RemoverLinha), new PermissionsMap.TableCommands(TABLES.entidadesdocumentosentregas, COMMANDS.AdicionarLinha, COMMANDS.InserirLinha, COMMANDS.RemoverLinha)}),
        LOCKED(new PermissionsMap.TableCommands[]{new PermissionsMap.TableCommands(TABLES.empresa, COMMANDS.Tabelas, COMMANDS.Parametros), new PermissionsMap.TableCommands(TABLES.campos), new PermissionsMap.TableCommands(TABLES.layouts), new PermissionsMap.TableCommands(TABLES.templates), new PermissionsMap.TableCommands(TABLES.pesquisas), new PermissionsMap.TableCommands(TABLES.entidadestipos), new PermissionsMap.TableCommands(TABLES.documentostipos), new PermissionsMap.TableCommands(TABLES.documentosseries), new PermissionsMap.TableCommands(TABLES.utilizadores), new PermissionsMap.TableCommands(TABLES.utilizadoreslogs), new PermissionsMap.TableCommands(TABLES.codigosiva), new PermissionsMap.TableCommands(TABLES.isencoesiva), new PermissionsMap.TableCommands(TABLES.retencoes), new PermissionsMap.TableCommands(TABLES.unidadesmedida), new PermissionsMap.TableCommands(TABLES.grupos), new PermissionsMap.TableCommands(TABLES.familias), new PermissionsMap.TableCommands(TABLES.precarios), new PermissionsMap.TableCommands(TABLES.tamanhos), new PermissionsMap.TableCommands(TABLES.cores), new PermissionsMap.TableCommands(TABLES.condicoespagamento), new PermissionsMap.TableCommands(TABLES.metodospagamento), new PermissionsMap.TableCommands(TABLES.condicoesentrega), new PermissionsMap.TableCommands(TABLES.metodostransporte), new PermissionsMap.TableCommands(TABLES.tiposmorada), new PermissionsMap.TableCommands(TABLES.codigospostais), new PermissionsMap.TableCommands(TABLES.paises), new PermissionsMap.TableCommands(TABLES.armazens), new PermissionsMap.TableCommands(TABLES.vendedores), new PermissionsMap.TableCommands(TABLES.viaturas), new PermissionsMap.TableCommands(TABLES.contasbancarias), new PermissionsMap.TableCommands(TABLES.tiposmovimento), new PermissionsMap.TableCommands(TABLES.moedas), new PermissionsMap.TableCommands(TABLES.moedascambios), new PermissionsMap.TableCommands(TABLES.artigos, COMMANDS.EditarRegisto, COMMANDS.EmitirRelatorio, COMMANDS.RegistoAnterior, COMMANDS.ProximoRegisto), new PermissionsMap.TableCommands(TABLES.artigosunidades), new PermissionsMap.TableCommands(TABLES.artigosprecos), new PermissionsMap.TableCommands(TABLES.artigoscomposicao), new PermissionsMap.TableCommands(TABLES.artigosexistencias), new PermissionsMap.TableCommands(TABLES.artigosmovimentos, COMMANDS.EditarRegisto, COMMANDS.EmitirRelatorio), new PermissionsMap.TableCommands(TABLES.artigosdocumentos, COMMANDS.EditarRegisto, COMMANDS.EmitirRelatorio, COMMANDS.RegistoAnterior, COMMANDS.ProximoRegisto), new PermissionsMap.TableCommands(TABLES.artigosdocumentoslinhas), new PermissionsMap.TableCommands(TABLES.entidades, COMMANDS.EditarRegisto, COMMANDS.EmitirRelatorio, COMMANDS.RegistoAnterior, COMMANDS.ProximoRegisto), new PermissionsMap.TableCommands(TABLES.entidadesmoradas), new PermissionsMap.TableCommands(TABLES.entidadesmovimentos, COMMANDS.EditarRegisto, COMMANDS.EmitirRelatorio), new PermissionsMap.TableCommands(TABLES.entidadesdocumentos, COMMANDS.EditarRegisto, COMMANDS.EmitirRelatorio, COMMANDS.RegistoAnterior, COMMANDS.ProximoRegisto), new PermissionsMap.TableCommands(TABLES.entidadesdocumentoslinhas), new PermissionsMap.TableCommands(TABLES.entidadesdocumentosentregas)});

        public final PermissionsMap.TableCommands[] commands;
        public final PermissionsMap map;

        public String toString() {
            return this.map.toString();
        }

        private PERMISSIONS(PermissionsMap.TableCommands[] commands) {
            this.commands = commands;
            StringBuilder sb = new StringBuilder();
            PermissionsMap.TableCommands[] tableCommandsArray = commands;
            int n2 = commands.length;
            int n3 = 0;
            while (n3 < n2) {
                PermissionsMap.TableCommands tableCommands = tableCommandsArray[n3];
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(tableCommands.toString());
                ++n3;
            }
            this.map = new PermissionsMap(sb.toString());
        }
    }

    public static enum RECORDS {
        admin(USERS.ADMIN, LABELS.ADMINISTRADOR.toString(), "", 0, PERMISSIONS.FULL),
        colibri(USERS.COLIBRI, "Colibri", Colibri.CONTROL_EMAIL.getEmail(), 0, PERMISSIONS.FULL);

        public final USERS user;
        public final String name;
        public final String email;
        public final int tipo;
        public final PERMISSIONS permissions;

        private RECORDS(USERS user, String name, String email, int tipo, PERMISSIONS permissions) {
            this.user = user;
            this.name = name;
            this.email = email;
            this.tipo = tipo;
            this.permissions = permissions;
        }
    }

    public static enum USERS {
        ADMIN("admin", Colibri.VERSION_TYPE == Colibri.VERSIONS.SERVER ? "12345678" : "admin"),
        COLIBRI("colibri", "1234"),
        DELTAFIL(String.valueOf(String.valueOf(Colibri.AUTOR_LEGAL.nif)) + "/0001", "testes1234"),
        FISCO(String.valueOf(String.valueOf(599999993)) + "/0037", "testes1234");

        public final String user;
        public final String password;

        private USERS(String user, String password) {
            this.user = user;
            this.password = password;
        }
    }
}

