/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.NoSuchElementException;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dma.java.io.ByteFile;
import org.dma.java.io.CustomFile;
import org.dma.java.io.FileParameters;
import org.dma.java.io.Folder;
import org.dma.java.util.Debug;
import org.dma.java.util.MessageList;
import org.dma.java.util.VersionNumber;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.birt.design.BIRTDesignHandler;
import org.projectocolibri.api.birt.design.BIRTParametersMap;
import org.projectocolibri.api.birt.render.BIRTRenderTask;
import org.projectocolibri.api.birt.report.BIRTReport;
import org.projectocolibri.api.birt.report.BIRTReportParameters;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.IDocumentoModel;
import org.projectocolibri.api.database.ILayoutModel;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableLayout;
import org.projectocolibri.api.database.mapper.TableLayoutArray;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.language.LABELS;

@javax.jdo.annotations.PersistenceCapable
public class Templates
extends AbstractModel
implements ILayoutModel,
Detachable,
PersistenceCapable {
    public static final int tabela_artigos = 0;
    public static final int tabela_artigosmovimentos = 1;
    public static final int tabela_artigosdocumentos = 2;
    public static final int tabela_entidades = 3;
    public static final int tabela_entidadesmovimentos = 4;
    public static final int tabela_entidadesdocumentos = 5;
    public static final int tipo_documento = 0;
    public static final int tipo_listagem = 1;
    public static final int tipo_acumulados = 2;
    public static final String PROPERTIES_OPERATOR = "=";
    private String codigo;
    private String descricao;
    private String ficheiro;
    private String layout;
    private String filtro;
    private Integer tabela;
    private Integer tipo;
    private byte[] template;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    private Templates() {
        super(TABLES.templates);
    }

    private Templates(DatabaseManager manager) {
        super(TABLES.templates, manager);
    }

    public Templates(DatabaseManager manager, String codigo) {
        this(manager, codigo, "");
    }

    public Templates(DatabaseManager manager, String codigo, String descricao) {
        this(manager, codigo, "", 0);
    }

    public Templates(DatabaseManager manager, String codigo, String descricao, Integer tabela) {
        this(manager);
        this.codigo = codigo;
        this.descricao = descricao;
        this.ficheiro = "";
        this.layout = "";
        this.filtro = "";
        this.tabela = tabela;
        this.tipo = 0;
        this.template = null;
    }

    @Override
    public Templates cloneCopy() {
        Templates clone = new Templates(this.manager);
        Templates.jdoSetcodigo(clone, Templates.jdoGetcodigo(this));
        Templates.jdoSetdescricao(clone, Templates.jdoGetdescricao(this));
        Templates.jdoSetficheiro(clone, Templates.jdoGetficheiro(this));
        Templates.jdoSetlayout(clone, Templates.jdoGetlayout(this));
        Templates.jdoSetfiltro(clone, Templates.jdoGetfiltro(this));
        Templates.jdoSettabela(clone, Templates.jdoGettabela(this));
        Templates.jdoSettipo(clone, Templates.jdoGettipo(this));
        Templates.jdoSettemplate(clone, this.getTemplate());
        return clone;
    }

    public Templates cleanCopy() {
        Templates clone = this.cloneCopy();
        Templates.jdoSetficheiro(clone, "");
        clone.markDirty();
        return clone;
    }

    @Override
    public MessageList validate(IDatabaseModel.ACTION action) {
        MessageList error = super.validate(action);
        switch (action) {
            case DELETE: {
                break;
            }
            case STORE: {
                if (this.isLayoutValid()) break;
                error.add(LABELS.templates_layout.toString());
            }
        }
        return error;
    }

    private FileParameters getFileParameters(String prefix, String suffix, File folder) {
        return new FileParameters(CustomFile.normalize((String)prefix), suffix, folder);
    }

    public FileParameters getFileParameters(IDocumentoModel prefix, BIRTReport.REPORT_FORMATS suffix) {
        return this.getFileParameters(prefix.toString(), suffix.output, (File)Colibri.FOLDERS.TEMPLATES.folder);
    }

    private FileParameters getFileParameters(String suffix, File folder) {
        return this.getFileParameters(this.toString(), suffix, folder);
    }

    public FileParameters getFileParameters(String suffix) {
        return this.getFileParameters(suffix, (File)Colibri.FOLDERS.TEMPLATES.folder);
    }

    public FileParameters getFileParameters(BIRTReport.REPORT_FORMATS suffix) {
        return this.getFileParameters(suffix.output);
    }

    public ByteFile createDesignFile() {
        return this.getFileParameters(Colibri.FILES.TEMPLATES.parameters.suffix).createTempFile(this.isEmpty() ? new byte[]{} : Templates.jdoGettemplate(this));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importDesign(File designFile, boolean backup) throws Exception {
        BIRTDesignHandler handler = new BIRTDesignHandler(designFile, Templates.jdoGettipo(this));
        if (!handler.openDesign()) throw new Exception("Invalid design file");
        try {
            Debug.out((Object)designFile);
            if (backup) {
                this.exportDesign((File)Colibri.FOLDERS.BACKUPS.folder);
            }
            this.setDescricao(handler.getDesign().getDescription());
            this.setFicheiro(designFile);
            this.setTemplate(designFile);
            class PropertiesMap
            extends HashMap<String, String> {
                public PropertiesMap(String comments) {
                    if (comments != null) {
                        String[] stringArray = comments.split("\n");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String line = stringArray[n2];
                            String[] elements = line.split(Templates.PROPERTIES_OPERATOR, 2);
                            this.put(elements[0].trim(), elements[1].trim());
                            ++n2;
                        }
                    }
                }
            }
            PropertiesMap map = new PropertiesMap(handler.getDesign().getComments());
            if (map.isEmpty()) return;
            this.setTabela(Integer.valueOf((String)map.get(FIELDS.templates_tabela.name)));
            this.setTipo(Integer.valueOf((String)map.get(FIELDS.templates_tipo.name)));
            this.setLayout((String)map.get(FIELDS.templates_layout.name));
            this.setFiltro((String)map.get(FIELDS.templates_filtro.name));
            return;
        }
        finally {
            handler.closeDesign();
        }
    }

    public void importDesign(File folder, String wildcards, boolean backup) throws Exception {
        File[] files = new Folder(folder).listFiles(String.valueOf(Templates.jdoGetcodigo(this)) + wildcards);
        if (files != null && files.length > 0) {
            this.importDesign(files[0], backup);
        }
    }

    public void exportDesign(File folder) throws Exception {
        CustomFile designFile = this.getFileParameters(Colibri.FILES.TEMPLATES.parameters.suffix, folder).toFile();
        if (!this.isEmpty() && new ByteFile((File)designFile).write(Templates.jdoGettemplate(this)) > 0) {
            BIRTDesignHandler handler = new BIRTDesignHandler((File)designFile, Templates.jdoGettipo(this));
            if (handler.openDesign()) {
                try {
                    Debug.out((Object)designFile);
                    handler.getDesign().setTitle(this.toString());
                    handler.getDesign().setDescription(Templates.jdoGetdescricao(this));
                    handler.getDesign().setProperty("comments", (Object)(FIELDS.templates_tabela.name + PROPERTIES_OPERATOR + Templates.jdoGettabela(this) + "\n" + FIELDS.templates_tipo.name + PROPERTIES_OPERATOR + Templates.jdoGettipo(this) + "\n" + FIELDS.templates_layout.name + PROPERTIES_OPERATOR + Templates.jdoGetlayout(this) + "\n" + FIELDS.templates_filtro.name + PROPERTIES_OPERATOR + this.getFiltroToText()));
                    handler.saveDesign();
                }
                finally {
                    handler.closeDesign();
                }
            } else {
                throw new Exception("Invalid design file");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VersionNumber getVersion() {
        try {
            ByteFile designFile = this.manager.getDesign().get(Templates.jdoGetcodigo(this));
            Debug.out((Object)designFile);
            BIRTDesignHandler handler = new BIRTDesignHandler((File)designFile, Templates.jdoGettipo(this));
            if (!handler.openDesign()) return new VersionNumber(15, 1);
            try {
                VariableElementHandle version = handler.getDesign().getPageVariable("version");
                if (version == null) return new VersionNumber(15, 1);
                VersionNumber versionNumber = VersionNumber.valueOf((String)version.getValue());
                return versionNumber;
            }
            finally {
                handler.closeDesign();
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return new VersionNumber(15, 1);
    }

    public boolean isValid() {
        block6: {
            if (!this.manager.getLicenca().allows(Colibri.FUNCIONALIDADES.LICENCA_COMERCIAL)) {
                try {
                    ByteFile designFile = this.manager.getDesign().get(Templates.jdoGetcodigo(this));
                    Debug.out((Object)designFile);
                    BIRTDesignHandler handler = new BIRTDesignHandler((File)designFile, Templates.jdoGettipo(this));
                    if (!handler.openDesign()) break block6;
                    try {
                        handler.checkDesign();
                    }
                    finally {
                        handler.closeDesign();
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isLegal() {
        if (!this.isTabela(5)) return true;
        try {
            String template = Templates.jdoGettemplate(this) == null ? "" : new String(Templates.jdoGettemplate(this));
            BIRTParametersMap.PARAMETERS_TYPES[] pARAMETERS_TYPESArray = new BIRTParametersMap.PARAMETERS_TYPES[]{BIRTParametersMap.PARAMETERS_TYPES.report_message, BIRTParametersMap.PARAMETERS_TYPES.AT_CUD, BIRTParametersMap.PARAMETERS_TYPES.AT_QR_code};
            int n = pARAMETERS_TYPESArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                BIRTParametersMap.PARAMETERS_TYPES parameter = pARAMETERS_TYPESArray[n2];
                if (!template.contains(parameter.expression)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (JDODetachedFieldAccessException e) {
            return this.manager.loadTemplates(Templates.jdoGetcodigo(this)).isLegal();
        }
    }

    public BIRTRenderTask getBirtRenderTask(final boolean resetCount) {
        return new BIRTRenderTask(this.getManager()){
            VersionNumber version;

            @Override
            public RenderOption getRenderOption(File outputFile, BIRTReport.REPORT_FORMATS format, int reportType) {
                RenderOption options = super.getRenderOption(outputFile, format, reportType);
                if (format == BIRTReport.REPORT_FORMATS.PDF && reportType == 0) {
                    if (this.version == null) {
                        this.version = Templates.this.getVersion();
                    }
                    Debug.out((String)"version", (Object)this.version);
                    if (this.version.major == 15) {
                        options.setOption("pdfRenderOption.pageOverflow", (Object)2);
                    }
                }
                return options;
            }

            @Override
            public BIRTParametersMap getParameterMap(BIRTReportParameters parameters, int reportType, int copyIndex, int renderCount) {
                return super.getParameterMap(parameters, reportType, copyIndex, resetCount ? 0 : renderCount);
            }
        };
    }

    @Override
    public String getKey() {
        return Templates.jdoGetcodigo(this);
    }

    public String getCodigo() {
        return Templates.jdoGetcodigo(this);
    }

    public String getCodigoToText() {
        return Templates.jdoGetcodigo(this) == null ? "" : Templates.jdoGetcodigo(this).toString();
    }

    public void setCodigo(String codigo) {
        String string = Templates.jdoGetcodigo(this);
        String string2 = codigo;
        Templates.jdoSetcodigo(this, string2);
        this.firePropertyChange(FIELDS.templates_codigo, (Object)string, (Object)string2);
    }

    public boolean isCodigoValid() {
        return Templates.jdoGetcodigo(this).length() == FIELDS.templates_codigo.format.getSize().size;
    }

    public String getDescricao() {
        return Templates.jdoGetdescricao(this);
    }

    public String getDescricaoToText() {
        return Templates.jdoGetdescricao(this) == null ? "" : Templates.jdoGetdescricao(this).toString();
    }

    public void setDescricao(String descricao) {
        String string = Templates.jdoGetdescricao(this);
        String string2 = descricao;
        Templates.jdoSetdescricao(this, string2);
        this.firePropertyChange(FIELDS.templates_descricao, (Object)string, (Object)string2);
    }

    public String getFicheiro() {
        return Templates.jdoGetficheiro(this);
    }

    public String getFicheiroToText() {
        return Templates.jdoGetficheiro(this) == null ? "" : Templates.jdoGetficheiro(this).toString();
    }

    public void setFicheiro(String ficheiro) {
        String string = Templates.jdoGetficheiro(this);
        String string2 = ficheiro;
        Templates.jdoSetficheiro(this, string2);
        this.firePropertyChange(FIELDS.templates_ficheiro, (Object)string, (Object)string2);
    }

    public void setFicheiro(File file) {
        this.setFicheiro(file.getAbsolutePath());
    }

    public String getLayout() {
        return Templates.jdoGetlayout(this);
    }

    public String getLayoutToText() {
        return Templates.jdoGetlayout(this) == null ? "" : Templates.jdoGetlayout(this).toString();
    }

    public void setLayout(String layout) {
        String string = Templates.jdoGetlayout(this);
        String string2 = layout;
        Templates.jdoSetlayout(this, string2);
        this.firePropertyChange(FIELDS.templates_layout, (Object)string, (Object)string2);
    }

    public void setLayout(TableLayoutArray layoutArray) {
        this.setLayout(layoutArray.toString());
    }

    @Override
    public TableLayout createLayout() {
        return this.table().map.createLayout(false).exclude(FIELDS.TYPES.TABLE);
    }

    @Override
    public TableLayoutArray getLayoutArray() {
        return TableLayoutArray.valueOf(this.getLayoutToText());
    }

    public boolean isLayoutValid() {
        return !this.isTipo(2) || new TableLayout(this).findFirst(FIELDS.TYPES.DATE) != null;
    }

    public String getFiltro() {
        return Templates.jdoGetfiltro(this);
    }

    public String getFiltroToText() {
        return Templates.jdoGetfiltro(this) == null ? "" : Templates.jdoGetfiltro(this).toString();
    }

    public FilterMap getFiltroToMap() {
        return new FilterMap(this.table(), this.getFiltroToText());
    }

    public void setFiltro(String filtro) {
        String string = Templates.jdoGetfiltro(this);
        String string2 = filtro;
        Templates.jdoSetfiltro(this, string2);
        this.firePropertyChange(FIELDS.templates_filtro, (Object)string, (Object)string2);
    }

    public void setFiltro(FilterMap filterMap) {
        this.setFiltro(filterMap.toString());
    }

    public Integer getTabela() {
        return Templates.jdoGettabela(this);
    }

    public String getTabelaToText() {
        return Templates.jdoGettabela(this) == null ? "" : FIELDS.templates_tabela.values[Templates.jdoGettabela(this)];
    }

    public void setTabela(Integer tabela) {
        Integer n = Templates.jdoGettabela(this);
        Integer n2 = tabela;
        Templates.jdoSettabela(this, n2);
        this.firePropertyChange(FIELDS.templates_tabela, (Object)n, (Object)n2);
    }

    public boolean isTabela(Integer tabela) {
        return Templates.equals(tabela, Templates.jdoGettabela(this));
    }

    @Override
    public TABLES table() {
        switch (Templates.jdoGettabela(this)) {
            case 0: {
                return TABLES.artigos;
            }
            case 1: {
                return TABLES.artigosmovimentos;
            }
            case 2: {
                return TABLES.artigosdocumentos;
            }
            case 3: {
                return TABLES.entidades;
            }
            case 4: {
                return TABLES.entidadesmovimentos;
            }
            case 5: {
                return TABLES.entidadesdocumentos;
            }
        }
        throw new IllegalArgumentException();
    }

    public Integer getTipo() {
        return Templates.jdoGettipo(this);
    }

    public String getTipoToText() {
        return Templates.jdoGettipo(this) == null ? "" : FIELDS.templates_tipo.values[Templates.jdoGettipo(this)];
    }

    public void setTipo(Integer tipo) {
        Integer n = Templates.jdoGettipo(this);
        Integer n2 = tipo;
        Templates.jdoSettipo(this, n2);
        this.firePropertyChange(FIELDS.templates_tipo, (Object)n, (Object)n2);
    }

    public boolean isTipo(Integer tipo) {
        return Templates.equals(tipo, Templates.jdoGettipo(this));
    }

    public byte[] getTemplate() {
        try {
            return Templates.jdoGettemplate(this);
        }
        catch (JDODetachedFieldAccessException jDODetachedFieldAccessException) {
            return null;
        }
    }

    public void setTemplate(byte[] template) {
        byte[] byArray = Templates.jdoGettemplate(this);
        byte[] byArray2 = template == null || template.length == 0 ? null : template;
        Templates.jdoSettemplate(this, byArray2);
        this.firePropertyChange(FIELDS.templates_template, (Object)byArray, (Object)byArray2);
    }

    public void setTemplate(File file) {
        this.setTemplate(new ByteFile(file).read());
    }

    public boolean isEmpty() {
        return this.getTemplate() == null || Templates.jdoGettemplate(this).length == 0;
    }

    @Override
    public boolean isEditable(FIELDS field) {
        return super.isEditable(field) && field != FIELDS.templates_tabela || !this.isEdited();
    }

    public String toString() {
        return String.valueOf(Templates.jdoGetcodigo(this)) + " - " + Templates.jdoGetdescricao(this);
    }

    public int hashCode() {
        return Templates.jdoGetcodigo(this) == null ? 0 : Templates.jdoGetcodigo(this).hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    static {
        jdoFieldNames = Templates.__jdoFieldNamesInit();
        jdoFieldTypes = Templates.__jdoFieldTypesInit();
        jdoFieldFlags = Templates.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Templates.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Templates.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Templates.___jdo$loadClass("org.projectocolibri.api.database.model.Templates"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Templates());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(0, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.codigo = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.codigo);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Templates result = new Templates();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Templates result = new Templates();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.codigo = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.descricao = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.ficheiro = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.filtro = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.layout = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.tabela = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.template = (byte[])this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.tipo = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.codigo);
                break;
            }
            case 1: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.descricao);
                break;
            }
            case 2: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.ficheiro);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.filtro);
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.layout);
                break;
            }
            case 5: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tabela);
                break;
            }
            case 6: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.template);
                break;
            }
            case 7: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipo);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Templates obj, int index) {
        switch (index) {
            case 0: {
                this.codigo = obj.codigo;
                break;
            }
            case 1: {
                this.descricao = obj.descricao;
                break;
            }
            case 2: {
                this.ficheiro = obj.ficheiro;
                break;
            }
            case 3: {
                this.filtro = obj.filtro;
                break;
            }
            case 4: {
                this.layout = obj.layout;
                break;
            }
            case 5: {
                this.tabela = obj.tabela;
                break;
            }
            case 6: {
                this.template = obj.template;
                break;
            }
            case 7: {
                this.tipo = obj.tipo;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Templates)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Templates");
        }
        Templates other = (Templates)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"codigo", "descricao", "ficheiro", "filtro", "layout", "tabela", "template", "tipo"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Templates.___jdo$loadClass("java.lang.String"), Templates.___jdo$loadClass("java.lang.String"), Templates.___jdo$loadClass("java.lang.String"), Templates.___jdo$loadClass("java.lang.String"), Templates.___jdo$loadClass("java.lang.String"), Templates.___jdo$loadClass("java.lang.Integer"), Templates.___jdo$loadClass("[B"), Templates.___jdo$loadClass("java.lang.Integer")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{24, 21, 21, 21, 21, 21, 26, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 8;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Templates o = (Templates)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static String jdoGetcodigo(Templates objPC) {
        return objPC.codigo;
    }

    private static void jdoSetcodigo(Templates objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.codigo = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 0, objPC.codigo, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(0);
        }
    }

    private static String jdoGetdescricao(Templates objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 1, objPC.descricao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"descricao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.descricao;
    }

    private static void jdoSetdescricao(Templates objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 1, objPC.descricao, val);
        } else {
            objPC.descricao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static String jdoGetficheiro(Templates objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 2, objPC.ficheiro);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"ficheiro\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.ficheiro;
    }

    private static void jdoSetficheiro(Templates objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 2, objPC.ficheiro, val);
        } else {
            objPC.ficheiro = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static String jdoGetfiltro(Templates objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.filtro);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"filtro\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.filtro;
    }

    private static void jdoSetfiltro(Templates objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.filtro, val);
        } else {
            objPC.filtro = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    private static String jdoGetlayout(Templates objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 4, objPC.layout);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"layout\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.layout;
    }

    private static void jdoSetlayout(Templates objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4, objPC.layout, val);
        } else {
            objPC.layout = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static Integer jdoGettabela(Templates objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 5, (Object)objPC.tabela);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tabela\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tabela;
    }

    private static void jdoSettabela(Templates objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 5, (Object)objPC.tabela, (Object)val);
        } else {
            objPC.tabela = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    private static byte[] jdoGettemplate(Templates objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return (byte[])objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 6, (Object)objPC.template);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6) && !((BitSet)objPC.jdoDetachedState[3]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"template\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.template;
    }

    private static void jdoSettemplate(Templates objPC, byte[] val) {
        if (objPC.jdoStateManager == null) {
            objPC.template = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 6, (Object)objPC.template, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(6);
        }
    }

    private static Integer jdoGettipo(Templates objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 7, (Object)objPC.tipo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipo;
    }

    private static void jdoSettipo(Templates objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 7, (Object)objPC.tipo, (Object)val);
        } else {
            objPC.tipo = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }

    public static enum RECORDS {
        artigosdocumentos_movimento_armazem("301"),
        entidadesmovimentos_diario_documentos("631"),
        entidadesdocumentos_factura("705"),
        entidadesdocumentos_recibo("715"),
        entidadesdocumentos_lancamento("725"),
        entidadesdocumentos_guia_transporte("755"),
        entidadesdocumentos_factura_talao("765"),
        entidadesdocumentos_factura_exportacao_PT("785"),
        entidadesdocumentos_factura_exportacao_EN("795");

        public final String codigo;

        private RECORDS(String codigo) {
            this.codigo = codigo;
        }

        public static Collection<Templates> getCollection(DatabaseManager manager) {
            ArrayList<Templates> col = new ArrayList<Templates>();
            RECORDS[] rECORDSArray = RECORDS.values();
            int n = rECORDSArray.length;
            int n2 = 0;
            while (n2 < n) {
                RECORDS value = rECORDSArray[n2];
                if (!manager.existsTemplates(value.codigo)) {
                    throw new NoSuchElementException(value.name());
                }
                ++n2;
            }
            return col;
        }
    }
}

