/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.TreeMap;
import org.dma.java.math.BusinessRules;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.model.Codigosiva;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentosivas;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;

public class TabelaivaMap
extends TreeMap<Codigosiva, Entidadesdocumentosivas> {
    private static final long serialVersionUID = 1L;
    private final Entidadesdocumentos documento;

    public Entidadesdocumentosivas get(Codigosiva codigoiva) {
        Entidadesdocumentosivas iva = (Entidadesdocumentosivas)super.get(codigoiva);
        if (iva == null) {
            iva = this.documento.createTabelaiva(codigoiva.getCodigo());
            this.put(codigoiva, iva);
        }
        return iva;
    }

    public TabelaivaMap(Entidadesdocumentos documento) {
        block7: {
            block6: {
                this.documento = documento;
                if (!documento.getTipodocumento().isTipodocumento(2)) break block6;
                if (!documento.getTipodocumento().isTipodocumentosaft(26)) break block7;
                for (Entidadesdocumentoslinhas linha : documento.getLinhasdocumento()) {
                    if (linha.getMovimentoorigem() == null) continue;
                    for (Entidadesdocumentosivas ivaorigem : linha.getMovimentoorigem().getTabelaiva()) {
                        BigDecimal valorbase = BusinessRules.proportionalValue((BigDecimal)linha.getMovimentoorigem().getTotalbruto(), (BigDecimal)ivaorigem.getValorbase(), (BigDecimal)linha.getValoriliquidoiva());
                        BigDecimal total = BusinessRules.proportionalValue((BigDecimal)linha.getMovimentoorigem().getTotalbruto(), (BigDecimal)ivaorigem.getTotal(), (BigDecimal)linha.getValoriliquidoiva());
                        Entidadesdocumentosivas iva = this.get(ivaorigem.getCodigoiva());
                        if (linha.getDeducao().booleanValue()) {
                            iva.setValorbase(iva.getValorbase().subtract(valorbase));
                            iva.setTotal(iva.getTotal().subtract(total));
                            continue;
                        }
                        iva.setValorbase(iva.getValorbase().add(valorbase));
                        iva.setTotal(iva.getTotal().add(total));
                    }
                }
                for (Entidadesdocumentosivas iva : this.values()) {
                    iva.setValorbase(FIELDS.entidadesdocumentosivas_valorbase.format.setScale(iva.getValorbase(), RoundingMode.HALF_UP));
                    iva.setTotal(FIELDS.entidadesdocumentosivas_valorbase.format.setScale(iva.getTotal(), RoundingMode.HALF_UP));
                }
                break block7;
            }
            for (Entidadesdocumentoslinhas linha : documento.getLinhasdocumento$Tipo(1)) {
                if (linha.getCodigoiva() == null) continue;
                Entidadesdocumentosivas iva = this.get(linha.getCodigoiva());
                iva.setValorprodutos(iva.getValorprodutos().add(linha.getValorprodutos()));
                iva.setValorservicos(iva.getValorservicos().add(linha.getValorservicos()));
                iva.setValorretencao(iva.getValorretencao().add(linha.getValorretencao()));
                iva.setValordesconto2(iva.getValordesconto2().add(linha.getValordesconto()));
                iva.setValorliquido(iva.getValorliquido().add(linha.getValorliquido()));
            }
            for (Entidadesdocumentosivas iva : this.values()) {
                BigDecimal valorprodutos = BusinessRules.netValue((BigDecimal)iva.getValorprodutos(), (BigDecimal)documento.getPercdesconto());
                BigDecimal valorservicos = BusinessRules.netValue((BigDecimal)iva.getValorservicos(), (BigDecimal)documento.getPercdesconto());
                BigDecimal valorretencao = BusinessRules.netValue((BigDecimal)iva.getValorretencao(), (BigDecimal)documento.getPercdesconto());
                BigDecimal valordesconto = BusinessRules.percentageValue((BigDecimal)iva.getValorliquido(), (BigDecimal)documento.getPercdesconto());
                BigDecimal valorbase = iva.getValorliquido().subtract(valordesconto);
                BigDecimal total = BusinessRules.percentageValue((BigDecimal)valorbase, (BigDecimal)iva.getTaxa());
                iva.setValorprodutos(FIELDS.entidadesdocumentos_totalprodutos.format.setScale(valorprodutos, RoundingMode.HALF_EVEN));
                iva.setValorservicos(FIELDS.entidadesdocumentos_totalservicos.format.setScale(valorservicos, RoundingMode.HALF_EVEN));
                iva.setValorretencao(FIELDS.entidadesdocumentos_totalretencoes.format.setScale(valorretencao, RoundingMode.HALF_EVEN));
                iva.setValordesconto(FIELDS.entidadesdocumentos_totaldesconto.format.setScale(valordesconto, RoundingMode.HALF_EVEN));
                iva.setValordesconto2(FIELDS.entidadesdocumentos_totaldesconto.format.setScale(iva.getValordesconto2(), RoundingMode.HALF_EVEN));
                iva.setValorliquido(FIELDS.entidadesdocumentos_totaldesconto.format.setScale(iva.getValorliquido(), RoundingMode.HALF_EVEN));
                iva.setValorbase(FIELDS.entidadesdocumentosivas_valorbase.format.setScale(valorbase, RoundingMode.HALF_UP));
                iva.setTotal(FIELDS.entidadesdocumentosivas_total.format.setScale(total, RoundingMode.HALF_UP));
            }
        }
    }
}

