/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.util.BitSet;
import java.util.Collection;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dma.java.util.StringUtils;
import org.dma.services.vies.CheckVatHandler;
import org.dma.services.vies.VatNumber;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.xml.beans.saft.ISAFTExport;

@javax.jdo.annotations.PersistenceCapable
public class Paises
extends AbstractModel
implements Detachable,
PersistenceCapable {
    public static final String ISO_STANDARD = "ISO 3166-1";
    public static final Collection<String> ISO3166_CODES = ISAFTExport.SAFT_VERSIONS.DEFAULT.tables.getCountryCodes();
    private String codigo;
    private String descricao;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    static {
        jdoFieldNames = Paises.__jdoFieldNamesInit();
        jdoFieldTypes = Paises.__jdoFieldTypesInit();
        jdoFieldFlags = Paises.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Paises.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Paises.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Paises.___jdo$loadClass("org.projectocolibri.api.database.model.Paises"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Paises());
    }

    private Paises() {
        super(TABLES.paises);
    }

    private Paises(DatabaseManager manager) {
        super(TABLES.paises, manager);
    }

    public Paises(DatabaseManager manager, String codigo) {
        this(manager, codigo, "");
    }

    public Paises(DatabaseManager manager, String codigo, String descricao) {
        this(manager);
        this.codigo = codigo;
        this.descricao = descricao;
    }

    @Override
    public Paises cloneCopy() {
        Paises clone = new Paises(this.manager);
        Paises.jdoSetcodigo(clone, Paises.jdoGetcodigo(this));
        Paises.jdoSetdescricao(clone, Paises.jdoGetdescricao(this));
        return clone;
    }

    @Override
    public String getKey() {
        return Paises.jdoGetcodigo(this);
    }

    public String getCodigo() {
        return Paises.jdoGetcodigo(this);
    }

    public String getCodigoToText() {
        return Paises.jdoGetcodigo(this) == null ? "" : Paises.jdoGetcodigo(this).toString();
    }

    public void setCodigo(String codigo) {
        String string = Paises.jdoGetcodigo(this);
        String string2 = codigo;
        Paises.jdoSetcodigo(this, string2);
        this.firePropertyChange(FIELDS.paises_codigo, (Object)string, (Object)string2);
    }

    public boolean isCodigoValid() {
        return ISO3166_CODES.contains(Paises.jdoGetcodigo(this)) || this.manager.getUtilizador().isColibri();
    }

    public boolean isPortugal() {
        return this.equals(CheckVatHandler.COUNTRIES.PT.code);
    }

    public boolean isEstrangeiro() {
        return !this.equals(this.manager.getParametros().getPais());
    }

    public String parseNif(String nif) {
        String compacted = nif == null ? "" : StringUtils.compact((String)nif).toUpperCase();
        return compacted.startsWith(Paises.jdoGetcodigo(this)) ? compacted.substring(Paises.jdoGetcodigo(this).length()) : compacted;
    }

    public boolean isNifValid(String nif) {
        CheckVatHandler.COUNTRIES country = CheckVatHandler.COUNTRIES.get((String)Paises.jdoGetcodigo(this));
        return country == null ? true : new VatNumber(country, nif).isValid();
    }

    public boolean isNifGenerico(String nif) {
        return !this.isPortugal() ? false : this.parseNif(nif).equals("999999990");
    }

    public boolean isCodigopostalValid(String codigo) {
        CheckVatHandler.COUNTRIES country = CheckVatHandler.COUNTRIES.get((String)Paises.jdoGetcodigo(this));
        return country == null ? true : country.checkZipcode(codigo);
    }

    public String getDescricao() {
        return Paises.jdoGetdescricao(this);
    }

    public String getDescricaoToText() {
        return Paises.jdoGetdescricao(this) == null ? "" : Paises.jdoGetdescricao(this).toString();
    }

    public void setDescricao(String descricao) {
        String string = Paises.jdoGetdescricao(this);
        String string2 = descricao;
        Paises.jdoSetdescricao(this, string2);
        this.firePropertyChange(FIELDS.paises_descricao, (Object)string, (Object)string2);
    }

    @Override
    public boolean canRemove() {
        return super.canRemove() && this.manager.getUtilizador().isColibri();
    }

    public String toString() {
        return String.valueOf(Paises.jdoGetcodigo(this)) + " - " + Paises.jdoGetdescricao(this);
    }

    public int hashCode() {
        return Paises.jdoGetcodigo(this) == null ? 0 : Paises.jdoGetcodigo(this).hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(0, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.codigo = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.codigo);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Paises result = new Paises();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Paises result = new Paises();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.codigo = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.descricao = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.codigo);
                break;
            }
            case 1: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.descricao);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Paises obj, int index) {
        switch (index) {
            case 0: {
                this.codigo = obj.codigo;
                break;
            }
            case 1: {
                this.descricao = obj.descricao;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Paises)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Paises");
        }
        Paises other = (Paises)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"codigo", "descricao"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Paises.___jdo$loadClass("java.lang.String"), Paises.___jdo$loadClass("java.lang.String")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{24, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 2;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Paises o = (Paises)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static String jdoGetcodigo(Paises objPC) {
        return objPC.codigo;
    }

    private static void jdoSetcodigo(Paises objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.codigo = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 0, objPC.codigo, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(0);
        }
    }

    private static String jdoGetdescricao(Paises objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 1, objPC.descricao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"descricao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.descricao;
    }

    private static void jdoSetdescricao(Paises objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 1, objPC.descricao, val);
        } else {
            objPC.descricao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }
}

