/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dma.icu.numerals.NumeralUnit;
import org.dma.icu.numerals.WordNumerals;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.TimeDateUtils;
import org.dma.java.util.UniqueArrayList;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.model.Moedascambios;
import org.projectocolibri.api.database.model.Paises;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.xml.beans.saft.ISAFTExport;

@javax.jdo.annotations.PersistenceCapable
public class Moedas
extends AbstractModel
implements Detachable,
PersistenceCapable {
    public static final String EUR_ISO4217 = "EUR";
    public static final String ISO_STANDARD = "ISO 4217";
    public static final Collection<String> ISO4217_CODES = Moedas.getCurrencyCodes();
    private String codigo;
    private String descricao;
    private String unidadeprincipal;
    private String unidadefraccionaria;
    @Deprecated
    private String inteiroplural;
    @Deprecated
    private String decimaisplural;
    private Set<Moedascambios> cambios = new LinkedHashSet<Moedascambios>();
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    static {
        jdoFieldNames = Moedas.__jdoFieldNamesInit();
        jdoFieldTypes = Moedas.__jdoFieldTypesInit();
        jdoFieldFlags = Moedas.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Moedas.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Moedas.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Moedas.___jdo$loadClass("org.projectocolibri.api.database.model.Moedas"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Moedas());
    }

    private static Collection<String> getCurrencyCodes() {
        UniqueArrayList col = new UniqueArrayList(ISAFTExport.SAFT_VERSIONS.DEFAULT.tables.getCurrencyCodes());
        col.add(EUR_ISO4217);
        return Collections.unmodifiableCollection(col);
    }

    public void print() {
        System.out.println("---CAMBIOS---");
        for (Moedascambios linha : this.getCambios()) {
            System.out.print("KEY=" + linha.getKey());
            System.out.print("; DATA=" + linha.getData());
            System.out.println("; CAMBIO=" + linha.getCambio());
        }
    }

    private Moedas() {
        super(TABLES.moedas);
    }

    private Moedas(DatabaseManager manager) {
        super(TABLES.moedas, manager);
    }

    public Moedas(DatabaseManager manager, String codigo) {
        this(manager, codigo, "");
    }

    public Moedas(DatabaseManager manager, String codigo, String descricao) {
        this(manager);
        this.codigo = codigo;
        this.descricao = descricao;
        this.unidadeprincipal = "";
        this.unidadefraccionaria = "";
        this.addCambios();
    }

    @Override
    public Moedas cloneCopy() {
        Moedas clone = new Moedas(this.manager);
        Moedas.jdoSetcodigo(clone, Moedas.jdoGetcodigo(this));
        Moedas.jdoSetdescricao(clone, Moedas.jdoGetdescricao(this));
        Moedas.jdoSetunidadeprincipal(clone, Moedas.jdoGetunidadeprincipal(this));
        Moedas.jdoSetunidadefraccionaria(clone, Moedas.jdoGetunidadefraccionaria(this));
        LinkedHashSet<Moedascambios> cambios = new LinkedHashSet<Moedascambios>();
        for (Moedascambios linha : Moedas.jdoGetcambios(this)) {
            cambios.add(linha.cloneCopy(clone));
        }
        Moedas.jdoSetcambios(clone, cambios);
        return clone;
    }

    public Moedas cleanCopy() {
        Moedas clone = this.cloneCopy();
        clone.removeCambios();
        clone.addCambios();
        clone.markDirty();
        return clone;
    }

    @Override
    public MessageList validate(IDatabaseModel.ACTION action) {
        MessageList error = super.validate(action);
        for (Moedascambios linha : this.getCambios()) {
            error.add(linha.validate(action));
        }
        switch (action) {
            case DELETE: {
                break;
            }
            case STORE: {
                if (!this.isCodigoValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.moedas_codigo));
                }
                if (!Moedas.jdoGetcambios(this).isEmpty()) break;
                error.add((Object)new MessageLine((Object)LABELS.moedas_cambios));
            }
        }
        return error;
    }

    @Override
    public String getKey() {
        return Moedas.jdoGetcodigo(this);
    }

    public String getCodigo() {
        return Moedas.jdoGetcodigo(this);
    }

    public String getCodigoToText() {
        return Moedas.jdoGetcodigo(this) == null ? "" : Moedas.jdoGetcodigo(this).toString();
    }

    public void setCodigo(String codigo) {
        String string = Moedas.jdoGetcodigo(this);
        String string2 = codigo;
        Moedas.jdoSetcodigo(this, string2);
        this.firePropertyChange(FIELDS.moedas_codigo, (Object)string, (Object)string2);
        for (Moedascambios linha : Moedas.jdoGetcambios(this)) {
            linha.setKey();
        }
    }

    public boolean isCodigoValid() {
        return ISO4217_CODES.contains(Moedas.jdoGetcodigo(this)) || this.manager.getUtilizador().isColibri();
    }

    public boolean isEuro() {
        return this.equals(EUR_ISO4217);
    }

    public String getSymbol() {
        String symbol = Currency.getInstance(Moedas.jdoGetcodigo(this)).getSymbol();
        return symbol.length() == 1 ? symbol : "$";
    }

    public String getExtenso(BigDecimal total) {
        return this.getExtenso(this.manager.getParametros().getPais(), total);
    }

    public String getExtenso(Paises pais, BigDecimal total) {
        return new WordNumerals(new Locale(this.manager.getParametros().getMoeda().equals(this) ? this.manager.getParametros().getPais().getCodigo() : pais.getCodigo()), FIELDS.entidadesdocumentos_total.format.getSize().scale, new NumeralUnit(this.getUnidadeprincipalToText(), this.getUnidadefraccionariaToText())).toString(total);
    }

    public String getDescricao() {
        return Moedas.jdoGetdescricao(this);
    }

    public String getDescricaoToText() {
        return Moedas.jdoGetdescricao(this) == null ? "" : Moedas.jdoGetdescricao(this).toString();
    }

    public void setDescricao(String descricao) {
        String string = Moedas.jdoGetdescricao(this);
        String string2 = descricao;
        Moedas.jdoSetdescricao(this, string2);
        this.firePropertyChange(FIELDS.moedas_descricao, (Object)string, (Object)string2);
    }

    public String getUnidadeprincipal() {
        return Moedas.jdoGetunidadeprincipal(this);
    }

    public String getUnidadeprincipalToText() {
        return Moedas.jdoGetunidadeprincipal(this) == null || Moedas.jdoGetunidadeprincipal(this).isEmpty() ? Currency.getInstance(Moedas.jdoGetcodigo(this)).getDisplayName() : Moedas.jdoGetunidadeprincipal(this).toString();
    }

    public void setUnidadeprincipal(String unidadeprincipal) {
        String string = Moedas.jdoGetunidadeprincipal(this);
        String string2 = unidadeprincipal;
        Moedas.jdoSetunidadeprincipal(this, string2);
        this.firePropertyChange(FIELDS.moedas_unidadeprincipal, (Object)string, (Object)string2);
    }

    public String getUnidadefraccionaria() {
        return Moedas.jdoGetunidadefraccionaria(this);
    }

    public String getUnidadefraccionariaToText() {
        return Moedas.jdoGetunidadefraccionaria(this) == null || Moedas.jdoGetunidadefraccionaria(this).isEmpty() ? "???" : Moedas.jdoGetunidadefraccionaria(this).toString();
    }

    public void setUnidadefraccionaria(String unidadefraccionaria) {
        String string = Moedas.jdoGetunidadefraccionaria(this);
        String string2 = unidadefraccionaria;
        Moedas.jdoSetunidadefraccionaria(this, string2);
        this.firePropertyChange(FIELDS.moedas_unidadefraccionaria, (Object)string, (Object)string2);
    }

    @Deprecated
    public String getInteirosingular() {
        return this.getInteiroplural();
    }

    @Deprecated
    public String getInteiroplural() {
        return Moedas.jdoGetinteiroplural(this) == null ? Moedas.jdoGetunidadeprincipal(this) : Moedas.jdoGetinteiroplural(this);
    }

    @Deprecated
    public String getDecimaissingular() {
        return this.getDecimaisplural();
    }

    @Deprecated
    public String getDecimaisplural() {
        return Moedas.jdoGetdecimaisplural(this) == null ? Moedas.jdoGetunidadefraccionaria(this) : Moedas.jdoGetdecimaisplural(this);
    }

    @Deprecated
    public BigDecimal getArredondaprecosvenda() {
        return null;
    }

    @Deprecated
    public BigDecimal getArredondaprecoscusto() {
        return null;
    }

    @Deprecated
    public BigDecimal getArredondatotais() {
        return null;
    }

    @Deprecated
    public BigDecimal getArredondaiva() {
        return null;
    }

    public Moedascambios createCambios() {
        Date data;
        int days = 0;
        do {
            data = TimeDateUtils.addDays((Calendar)TimeDateUtils.getCalendar(), (int)days++).getTime();
        } while (this.getCambios(Moedascambios.generateKey(Moedas.jdoGetcodigo(this), data)) != null);
        return new Moedascambios(this, data, BigDecimal.ONE);
    }

    private List<Moedascambios> sortedCambios() {
        ArrayList<Moedascambios> list = new ArrayList<Moedascambios>(Moedas.jdoGetcambios(this));
        Collections.sort(list);
        return list;
    }

    public Collection<Moedascambios> getCambios() {
        return Collections.unmodifiableList(this.sortedCambios());
    }

    public Moedascambios getCambios(int index) {
        return index >= Moedas.jdoGetcambios(this).size() ? null : this.sortedCambios().get(index);
    }

    public Moedascambios getCambios(String key) {
        for (Moedascambios linha : Moedas.jdoGetcambios(this)) {
            if (!linha.getKey().equals(key)) continue;
            return linha;
        }
        return null;
    }

    public void setCambios(Collection<Moedascambios> cambios) {
        Moedas.jdoGetcambios(this).clear();
        this.addCambios(cambios);
    }

    public Moedascambios addCambios() {
        return this.addCambios(this.createCambios());
    }

    public Moedascambios addCambios(Moedascambios cambios) {
        if (cambios != null) {
            this.addCambios(Arrays.asList(cambios));
        }
        return cambios;
    }

    public boolean addCambios(Collection<Moedascambios> cambios) {
        for (Moedascambios linha : cambios) {
            linha.setMoeda(this);
        }
        return Moedas.jdoGetcambios(this).addAll(cambios);
    }

    public void removeCambios() {
        this.removeCambios(Moedas.jdoGetcambios(this));
    }

    public void removeCambios(int index) {
        this.removeCambios(this.getCambios(index));
    }

    public void removeCambios(Moedascambios cambios) {
        this.removeCambios(Arrays.asList(cambios));
    }

    public void removeCambios(Collection<Moedascambios> cambios) {
        Moedas.jdoGetcambios(this).removeAll(cambios);
    }

    @Override
    public boolean canRemove() {
        return super.canRemove() && this.manager.getUtilizador().isColibri();
    }

    @Override
    public void attach(DatabaseManager manager) {
        manager.attach(Moedas.jdoGetcambios(this));
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.isDirty(Moedas.jdoGetcambios(this));
    }

    public String toString() {
        return String.valueOf(Moedas.jdoGetcodigo(this)) + " - " + Moedas.jdoGetdescricao(this);
    }

    public int hashCode() {
        return Moedas.jdoGetcodigo(this) == null ? 0 : Moedas.jdoGetcodigo(this).hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(1, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.codigo = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.codigo);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Moedas result = new Moedas();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Moedas result = new Moedas();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.cambios = (Set)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.codigo = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.decimaisplural = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.descricao = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.inteiroplural = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.unidadefraccionaria = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.unidadeprincipal = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, this.cambios);
                break;
            }
            case 1: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.codigo);
                break;
            }
            case 2: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.decimaisplural);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.descricao);
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.inteiroplural);
                break;
            }
            case 5: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.unidadefraccionaria);
                break;
            }
            case 6: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.unidadeprincipal);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Moedas obj, int index) {
        switch (index) {
            case 0: {
                this.cambios = obj.cambios;
                break;
            }
            case 1: {
                this.codigo = obj.codigo;
                break;
            }
            case 2: {
                this.decimaisplural = obj.decimaisplural;
                break;
            }
            case 3: {
                this.descricao = obj.descricao;
                break;
            }
            case 4: {
                this.inteiroplural = obj.inteiroplural;
                break;
            }
            case 5: {
                this.unidadefraccionaria = obj.unidadefraccionaria;
                break;
            }
            case 6: {
                this.unidadeprincipal = obj.unidadeprincipal;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Moedas)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Moedas");
        }
        Moedas other = (Moedas)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"cambios", "codigo", "decimaisplural", "descricao", "inteiroplural", "unidadefraccionaria", "unidadeprincipal"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Moedas.___jdo$loadClass("java.util.Set"), Moedas.___jdo$loadClass("java.lang.String"), Moedas.___jdo$loadClass("java.lang.String"), Moedas.___jdo$loadClass("java.lang.String"), Moedas.___jdo$loadClass("java.lang.String"), Moedas.___jdo$loadClass("java.lang.String"), Moedas.___jdo$loadClass("java.lang.String")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{5, 24, 21, 21, 21, 21, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 7;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Moedas o = (Moedas)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static Set jdoGetcambios(Moedas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return (Set)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, objPC.cambios);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"cambios\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.cambios;
    }

    private static void jdoSetcambios(Moedas objPC, Set val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, objPC.cambios, (Object)val);
        } else {
            objPC.cambios = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static String jdoGetcodigo(Moedas objPC) {
        return objPC.codigo;
    }

    private static void jdoSetcodigo(Moedas objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.codigo = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 1, objPC.codigo, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(1);
        }
    }

    private static String jdoGetdecimaisplural(Moedas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 2, objPC.decimaisplural);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"decimaisplural\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.decimaisplural;
    }

    private static void jdoSetdecimaisplural(Moedas objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 2, objPC.decimaisplural, val);
        } else {
            objPC.decimaisplural = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static String jdoGetdescricao(Moedas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.descricao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"descricao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.descricao;
    }

    private static void jdoSetdescricao(Moedas objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.descricao, val);
        } else {
            objPC.descricao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    private static String jdoGetinteiroplural(Moedas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 4, objPC.inteiroplural);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"inteiroplural\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.inteiroplural;
    }

    private static void jdoSetinteiroplural(Moedas objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4, objPC.inteiroplural, val);
        } else {
            objPC.inteiroplural = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static String jdoGetunidadefraccionaria(Moedas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 5, objPC.unidadefraccionaria);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"unidadefraccionaria\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.unidadefraccionaria;
    }

    private static void jdoSetunidadefraccionaria(Moedas objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 5, objPC.unidadefraccionaria, val);
        } else {
            objPC.unidadefraccionaria = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    private static String jdoGetunidadeprincipal(Moedas objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 6, objPC.unidadeprincipal);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"unidadeprincipal\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.unidadeprincipal;
    }

    private static void jdoSetunidadeprincipal(Moedas objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 6, objPC.unidadeprincipal, val);
        } else {
            objPC.unidadeprincipal = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }
}

