/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.security.SignatureException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import javax.xml.ws.WebServiceException;
import org.dma.java.awt.RenderedImageHandler;
import org.dma.java.email.EmailMessage;
import org.dma.java.email.EmailRecipients;
import org.dma.java.input.FieldFormat;
import org.dma.java.math.NumericUtils;
import org.dma.java.util.ErrorList;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringList;
import org.dma.java.util.StringUtils;
import org.dma.java.util.TimeDateUtils;
import org.dma.services.mb.MultibancoEntity;
import org.dma.services.mb.MultibancoRef;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.birt.render.BIRTRender;
import org.projectocolibri.api.birt.report.BIRTEmailParameters;
import org.projectocolibri.api.birt.report.BIRTReport;
import org.projectocolibri.api.birt.report.BIRTReportCopies;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.IDocumentoModel;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.filter.FilterMapRule;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.model.Armazens;
import org.projectocolibri.api.database.model.Artigoscomposicao;
import org.projectocolibri.api.database.model.Artigosmovimentos;
import org.projectocolibri.api.database.model.Codigospostais;
import org.projectocolibri.api.database.model.Condicoesentrega;
import org.projectocolibri.api.database.model.Condicoespagamento;
import org.projectocolibri.api.database.model.Documentosseries;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadesdocumentosatws;
import org.projectocolibri.api.database.model.Entidadesdocumentosentregas;
import org.projectocolibri.api.database.model.Entidadesdocumentosivas;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.api.database.model.Entidadesmoradas;
import org.projectocolibri.api.database.model.Entidadesmovimentos;
import org.projectocolibri.api.database.model.Entidadestipos;
import org.projectocolibri.api.database.model.Isencoesiva;
import org.projectocolibri.api.database.model.Metodospagamento;
import org.projectocolibri.api.database.model.Metodostransporte;
import org.projectocolibri.api.database.model.Moedas;
import org.projectocolibri.api.database.model.Moedascambios;
import org.projectocolibri.api.database.model.Paises;
import org.projectocolibri.api.database.model.TabelaivaMap;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.model.Vendedores;
import org.projectocolibri.api.database.model.Viaturas;
import org.projectocolibri.api.database.model.paste.EntidadesdocumentosPaste;
import org.projectocolibri.api.database.query.QueryDefinition;
import org.projectocolibri.api.database.query.QueryOrdering;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.api.services.at.ATWebserviceResponseType;
import org.projectocolibri.api.services.at.IATDocumentosService;
import org.projectocolibri.api.services.at.facturas.v2023.FaturasService;
import org.projectocolibri.api.services.at.transportes.StockMovementService;
import org.projectocolibri.core.RSAKEYS;
import org.projectocolibri.xml.beans.ciuspt.CIUS21Export;
import org.projectocolibri.xml.beans.ciuspt.CreditNoteExport;
import org.projectocolibri.xml.beans.ciuspt.ICIUSExport;
import org.projectocolibri.xml.beans.ciuspt.InvoiceExport;
import org.projectocolibri.xml.beans.saft.ATMessageFormatter;
import org.projectocolibri.xml.beans.saft.ISAFTExport;
import org.projectocolibri.xml.beans.saft.qrcode.ATQRCodeFieldList;

@javax.jdo.annotations.PersistenceCapable
public class Entidadesdocumentos
extends AbstractModel
implements IDocumentoModel,
Detachable,
PersistenceCapable {
    public static final int estado_normal = 0;
    public static final int estado_anulado = 1;
    public static final int estado_bloqueado = 2;
    public static final int estadoenvio_normal = 0;
    public static final int estadoenvio_pendente = 1;
    public static final int estadoenvio_registado = 2;
    public static final int estadoenvio_manual = 3;
    private String key;
    private Entidadesmovimentos movimentoentidades;
    private Utilizadores autor;
    private Utilizadores editor;
    private Templates template;
    private Documentostipos tipodocumento;
    private Documentosseries seriedocumento;
    private Entidades entidade;
    private Codigospostais codigopostal;
    private Codigospostais codigopostalcarga;
    private Codigospostais codigopostaldescarga;
    private Paises pais;
    private Paises paiscarga;
    private Paises paisdescarga;
    private Vendedores vendedor;
    private Condicoespagamento condicaopagamento;
    private Metodospagamento metodopagamento;
    private Condicoesentrega condicaoentrega;
    private Metodostransporte metodotransporte;
    private Viaturas viatura;
    private Moedas moeda;
    private Moedascambios cambio;
    private Date datasistema;
    private Time horasistema;
    private Date datacriacao;
    private Time horacriacao;
    private Date dataauxiliar;
    private Date datavencimento;
    private Date datacarga;
    private Time horacarga;
    private Date datadescarga;
    private Time horadescarga;
    @Deprecated
    private Date dataenvio;
    @Deprecated
    private Time horaenvio;
    private String hash;
    private String documentcode;
    private String codigovalidacao;
    private String numeroauxiliar;
    private String nome;
    private String morada;
    private String localidade;
    private String nif;
    private String expedicao;
    private String matricula;
    private String localcarga;
    private String localdescarga;
    private String dadostransporte;
    private String marcas;
    private String obs;
    @Deprecated
    private String returnmessage;
    private String campo1 = "";
    private String campo2 = "";
    private String campo3 = "";
    private String campo4 = "";
    private String campo5 = "";
    private String campo6 = "";
    private String campo7 = "";
    private String campo8 = "";
    private String campo9 = "";
    private String campo10 = "";
    private Integer hashcontrol;
    private Integer contadorvias;
    private Integer numerodocumento;
    private Integer embalagens;
    private Integer estado;
    private Integer estadoenvio;
    @Deprecated
    private Integer returncode;
    private BigDecimal pesobruto;
    private BigDecimal pesoliquido;
    private BigDecimal volume;
    private BigDecimal percdesconto;
    private BigDecimal totalentregue;
    private BigDecimal totalprodutos;
    private BigDecimal totalservicos;
    private BigDecimal totalretencoes;
    private BigDecimal totaliliquido;
    private BigDecimal totaldeducoes;
    private BigDecimal totaldesconto;
    private BigDecimal totalliquido;
    private BigDecimal totaliva;
    private BigDecimal totalbruto;
    private BigDecimal total;
    @NotPersistent
    private BigDecimal totalcambio;
    private List<Entidadesdocumentoslinhas> linhasdocumento = new ArrayList<Entidadesdocumentoslinhas>();
    private List<Entidadesdocumentosentregas> entregaspagamento = new ArrayList<Entidadesdocumentosentregas>();
    private List<Entidadesdocumentosivas> tabelaiva = new ArrayList<Entidadesdocumentosivas>();
    private List<Entidadesdocumentosatws> webservice = new ArrayList<Entidadesdocumentosatws>();
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    public EntidadesdocumentosPaste paste() {
        return new EntidadesdocumentosPaste(this);
    }

    private Entidadesdocumentos() {
        super(TABLES.entidadesdocumentos);
    }

    private Entidadesdocumentos(DatabaseManager manager) {
        super(TABLES.entidadesdocumentos, manager);
    }

    public Entidadesdocumentos(DatabaseManager manager, String tipodocumento) {
        this(manager, tipodocumento, TimeDateUtils.getCurrentDate());
    }

    public Entidadesdocumentos(DatabaseManager manager, String tipodocumento, Date datacriacao) {
        this(manager, manager.loadDocumentostipos(tipodocumento), datacriacao);
    }

    protected Entidadesdocumentos(DatabaseManager manager, Documentostipos tipodocumento, Date datacriacao) {
        this(manager);
        Armazens armazemcarga = tipodocumento.getArmazemcarga();
        Armazens armazemdescarga = tipodocumento.getArmazemdescarga();
        this.movimentoentidades = null;
        this.autor = manager.getUtilizador();
        this.editor = manager.getUtilizador();
        this.template = tipodocumento.getTemplate(0);
        this.tipodocumento = tipodocumento;
        this.seriedocumento = manager.loadDocumentosseries(tipodocumento.getCodigo(), 0);
        this.entidade = null;
        this.codigopostal = null;
        this.codigopostalcarga = armazemcarga.getCodigopostal();
        this.codigopostaldescarga = armazemdescarga.getCodigopostal();
        this.paiscarga = this.pais = manager.getParametros().getPais();
        this.paisdescarga = this.pais;
        this.vendedor = manager.loadVendedores(0);
        this.condicaopagamento = manager.getParametros().getCondicaopagamento();
        this.metodopagamento = manager.getParametros().getMetodopagamento();
        this.condicaoentrega = manager.loadCondicoesentrega(0);
        this.metodotransporte = manager.loadMetodostransporte(0);
        this.viatura = manager.loadViaturas(0);
        this.moeda = manager.getParametros().getMoeda();
        this.cambio = manager.loadMoedascambios(this.moeda.getCodigo(), 0);
        this.datasistema = TimeDateUtils.getDateWithoutTime((Date)datacriacao);
        this.horasistema = TimeDateUtils.getTime((Date)datacriacao);
        this.datacriacao = TimeDateUtils.getDateWithoutTime((Date)datacriacao);
        this.horacriacao = TimeDateUtils.getTimeWithoutSeconds((Date)datacriacao);
        this.dataauxiliar = TimeDateUtils.getDateWithoutTime((Date)datacriacao);
        this.datavencimento = TimeDateUtils.addDays((Date)datacriacao, (int)this.condicaopagamento.getPeriodo());
        this.datacarga = TimeDateUtils.getDateWithoutTime((Date)datacriacao);
        this.horacarga = TimeDateUtils.getTimeWithoutSeconds((Date)datacriacao);
        this.datadescarga = TimeDateUtils.getDateWithoutTime((Date)datacriacao);
        this.horadescarga = tipodocumento.getSAFTDocumentGroup() == Documentostipos.SAFT_DOCUMENT_GROUP.MOVEMENT ? TimeDateUtils.getTime((int)23, (int)59) : TimeDateUtils.getTimeWithoutSeconds((Date)datacriacao);
        this.hash = "";
        this.documentcode = "";
        this.codigovalidacao = "";
        this.numeroauxiliar = "";
        this.nome = "";
        this.morada = "";
        this.localidade = "";
        this.nif = "999999990";
        this.expedicao = this.viatura.getDescricao();
        this.matricula = this.viatura.getMatricula();
        this.localcarga = armazemcarga.getMorada();
        this.localdescarga = armazemdescarga.getMorada();
        this.dadostransporte = "";
        this.marcas = "";
        this.obs = "";
        this.hashcontrol = RSAKEYS.PRIVATE.CERTIFICACAO.version;
        this.contadorvias = 0;
        this.numerodocumento = this.getNumerodocumento$Default();
        this.embalagens = 0;
        this.estado = 0;
        this.estadoenvio = this.getEstadoenvio$Default();
        this.pesobruto = BigDecimal.ZERO;
        this.pesoliquido = BigDecimal.ZERO;
        this.volume = BigDecimal.ZERO;
        this.percdesconto = BigDecimal.ZERO;
        this.totalentregue = BigDecimal.ZERO;
        this.totalprodutos = BigDecimal.ZERO;
        this.totalservicos = BigDecimal.ZERO;
        this.totalretencoes = BigDecimal.ZERO;
        this.totaliliquido = BigDecimal.ZERO;
        this.totaldeducoes = BigDecimal.ZERO;
        this.totaldesconto = BigDecimal.ZERO;
        this.totalliquido = BigDecimal.ZERO;
        this.totaliva = BigDecimal.ZERO;
        this.totalbruto = BigDecimal.ZERO;
        this.total = BigDecimal.ZERO;
        this.key = this.generateKey();
    }

    public void clearDeprecated() {
        Entidadesdocumentos.jdoSetdataenvio(this, null);
        Entidadesdocumentos.jdoSethoraenvio(this, null);
        Entidadesdocumentos.jdoSetreturnmessage(this, null);
        Entidadesdocumentos.jdoSetreturncode(this, null);
    }

    @Override
    public Entidadesdocumentos cloneCopy() {
        Entidadesdocumentos clone = new Entidadesdocumentos(this.manager);
        Entidadesdocumentos.jdoSetkey(clone, Entidadesdocumentos.jdoGetkey(this));
        Entidadesdocumentos.jdoSetmovimentoentidades(clone, Entidadesdocumentos.jdoGetmovimentoentidades(this));
        Entidadesdocumentos.jdoSetautor(clone, Entidadesdocumentos.jdoGetautor(this));
        Entidadesdocumentos.jdoSeteditor(clone, Entidadesdocumentos.jdoGeteditor(this));
        Entidadesdocumentos.jdoSettemplate(clone, Entidadesdocumentos.jdoGettemplate(this));
        Entidadesdocumentos.jdoSettipodocumento(clone, Entidadesdocumentos.jdoGettipodocumento(this));
        Entidadesdocumentos.jdoSetseriedocumento(clone, Entidadesdocumentos.jdoGetseriedocumento(this));
        Entidadesdocumentos.jdoSetentidade(clone, Entidadesdocumentos.jdoGetentidade(this));
        Entidadesdocumentos.jdoSetcodigopostal(clone, Entidadesdocumentos.jdoGetcodigopostal(this));
        Entidadesdocumentos.jdoSetcodigopostalcarga(clone, Entidadesdocumentos.jdoGetcodigopostalcarga(this));
        Entidadesdocumentos.jdoSetcodigopostaldescarga(clone, Entidadesdocumentos.jdoGetcodigopostaldescarga(this));
        Entidadesdocumentos.jdoSetpais(clone, Entidadesdocumentos.jdoGetpais(this));
        Entidadesdocumentos.jdoSetpaiscarga(clone, Entidadesdocumentos.jdoGetpaiscarga(this));
        Entidadesdocumentos.jdoSetpaisdescarga(clone, Entidadesdocumentos.jdoGetpaisdescarga(this));
        Entidadesdocumentos.jdoSetvendedor(clone, Entidadesdocumentos.jdoGetvendedor(this));
        Entidadesdocumentos.jdoSetcondicaopagamento(clone, Entidadesdocumentos.jdoGetcondicaopagamento(this));
        Entidadesdocumentos.jdoSetmetodopagamento(clone, Entidadesdocumentos.jdoGetmetodopagamento(this));
        Entidadesdocumentos.jdoSetcondicaoentrega(clone, Entidadesdocumentos.jdoGetcondicaoentrega(this));
        Entidadesdocumentos.jdoSetmetodotransporte(clone, Entidadesdocumentos.jdoGetmetodotransporte(this));
        Entidadesdocumentos.jdoSetviatura(clone, Entidadesdocumentos.jdoGetviatura(this));
        Entidadesdocumentos.jdoSetmoeda(clone, Entidadesdocumentos.jdoGetmoeda(this));
        Entidadesdocumentos.jdoSetcambio(clone, Entidadesdocumentos.jdoGetcambio(this));
        Entidadesdocumentos.jdoSetdatasistema(clone, Entidadesdocumentos.jdoGetdatasistema(this));
        Entidadesdocumentos.jdoSethorasistema(clone, Entidadesdocumentos.jdoGethorasistema(this));
        Entidadesdocumentos.jdoSetdatacriacao(clone, Entidadesdocumentos.jdoGetdatacriacao(this));
        Entidadesdocumentos.jdoSethoracriacao(clone, Entidadesdocumentos.jdoGethoracriacao(this));
        Entidadesdocumentos.jdoSetdataauxiliar(clone, Entidadesdocumentos.jdoGetdataauxiliar(this));
        Entidadesdocumentos.jdoSetdatavencimento(clone, Entidadesdocumentos.jdoGetdatavencimento(this));
        Entidadesdocumentos.jdoSetdatacarga(clone, Entidadesdocumentos.jdoGetdatacarga(this));
        Entidadesdocumentos.jdoSethoracarga(clone, Entidadesdocumentos.jdoGethoracarga(this));
        Entidadesdocumentos.jdoSetdatadescarga(clone, Entidadesdocumentos.jdoGetdatadescarga(this));
        Entidadesdocumentos.jdoSethoradescarga(clone, Entidadesdocumentos.jdoGethoradescarga(this));
        Entidadesdocumentos.jdoSetdataenvio(clone, Entidadesdocumentos.jdoGetdataenvio(this));
        Entidadesdocumentos.jdoSethoraenvio(clone, Entidadesdocumentos.jdoGethoraenvio(this));
        Entidadesdocumentos.jdoSethash(clone, Entidadesdocumentos.jdoGethash(this));
        Entidadesdocumentos.jdoSetdocumentcode(clone, Entidadesdocumentos.jdoGetdocumentcode(this));
        Entidadesdocumentos.jdoSetcodigovalidacao(clone, Entidadesdocumentos.jdoGetcodigovalidacao(this));
        Entidadesdocumentos.jdoSetnumeroauxiliar(clone, Entidadesdocumentos.jdoGetnumeroauxiliar(this));
        Entidadesdocumentos.jdoSetnome(clone, Entidadesdocumentos.jdoGetnome(this));
        Entidadesdocumentos.jdoSetmorada(clone, Entidadesdocumentos.jdoGetmorada(this));
        Entidadesdocumentos.jdoSetlocalidade(clone, Entidadesdocumentos.jdoGetlocalidade(this));
        Entidadesdocumentos.jdoSetnif(clone, Entidadesdocumentos.jdoGetnif(this));
        Entidadesdocumentos.jdoSetexpedicao(clone, Entidadesdocumentos.jdoGetexpedicao(this));
        Entidadesdocumentos.jdoSetmatricula(clone, Entidadesdocumentos.jdoGetmatricula(this));
        Entidadesdocumentos.jdoSetlocalcarga(clone, Entidadesdocumentos.jdoGetlocalcarga(this));
        Entidadesdocumentos.jdoSetlocaldescarga(clone, Entidadesdocumentos.jdoGetlocaldescarga(this));
        Entidadesdocumentos.jdoSetdadostransporte(clone, Entidadesdocumentos.jdoGetdadostransporte(this));
        Entidadesdocumentos.jdoSetmarcas(clone, Entidadesdocumentos.jdoGetmarcas(this));
        Entidadesdocumentos.jdoSetobs(clone, Entidadesdocumentos.jdoGetobs(this));
        Entidadesdocumentos.jdoSetreturnmessage(clone, Entidadesdocumentos.jdoGetreturnmessage(this));
        Entidadesdocumentos.jdoSetcampo1(clone, Entidadesdocumentos.jdoGetcampo1(this));
        Entidadesdocumentos.jdoSetcampo2(clone, Entidadesdocumentos.jdoGetcampo2(this));
        Entidadesdocumentos.jdoSetcampo3(clone, Entidadesdocumentos.jdoGetcampo3(this));
        Entidadesdocumentos.jdoSetcampo4(clone, Entidadesdocumentos.jdoGetcampo4(this));
        Entidadesdocumentos.jdoSetcampo5(clone, Entidadesdocumentos.jdoGetcampo5(this));
        Entidadesdocumentos.jdoSetcampo6(clone, Entidadesdocumentos.jdoGetcampo6(this));
        Entidadesdocumentos.jdoSetcampo7(clone, Entidadesdocumentos.jdoGetcampo7(this));
        Entidadesdocumentos.jdoSetcampo8(clone, Entidadesdocumentos.jdoGetcampo8(this));
        Entidadesdocumentos.jdoSetcampo9(clone, Entidadesdocumentos.jdoGetcampo9(this));
        Entidadesdocumentos.jdoSetcampo10(clone, Entidadesdocumentos.jdoGetcampo10(this));
        Entidadesdocumentos.jdoSethashcontrol(clone, Entidadesdocumentos.jdoGethashcontrol(this));
        Entidadesdocumentos.jdoSetcontadorvias(clone, Entidadesdocumentos.jdoGetcontadorvias(this));
        Entidadesdocumentos.jdoSetnumerodocumento(clone, Entidadesdocumentos.jdoGetnumerodocumento(this));
        Entidadesdocumentos.jdoSetembalagens(clone, Entidadesdocumentos.jdoGetembalagens(this));
        Entidadesdocumentos.jdoSetestado(clone, Entidadesdocumentos.jdoGetestado(this));
        Entidadesdocumentos.jdoSetestadoenvio(clone, Entidadesdocumentos.jdoGetestadoenvio(this));
        Entidadesdocumentos.jdoSetreturncode(clone, Entidadesdocumentos.jdoGetreturncode(this));
        Entidadesdocumentos.jdoSetpesobruto(clone, Entidadesdocumentos.jdoGetpesobruto(this));
        Entidadesdocumentos.jdoSetpesoliquido(clone, Entidadesdocumentos.jdoGetpesoliquido(this));
        Entidadesdocumentos.jdoSetvolume(clone, Entidadesdocumentos.jdoGetvolume(this));
        Entidadesdocumentos.jdoSetpercdesconto(clone, Entidadesdocumentos.jdoGetpercdesconto(this));
        Entidadesdocumentos.jdoSettotalentregue(clone, Entidadesdocumentos.jdoGettotalentregue(this));
        Entidadesdocumentos.jdoSettotalprodutos(clone, Entidadesdocumentos.jdoGettotalprodutos(this));
        Entidadesdocumentos.jdoSettotalservicos(clone, Entidadesdocumentos.jdoGettotalservicos(this));
        Entidadesdocumentos.jdoSettotalretencoes(clone, Entidadesdocumentos.jdoGettotalretencoes(this));
        Entidadesdocumentos.jdoSettotaliliquido(clone, Entidadesdocumentos.jdoGettotaliliquido(this));
        Entidadesdocumentos.jdoSettotaldeducoes(clone, Entidadesdocumentos.jdoGettotaldeducoes(this));
        Entidadesdocumentos.jdoSettotaldesconto(clone, Entidadesdocumentos.jdoGettotaldesconto(this));
        Entidadesdocumentos.jdoSettotalliquido(clone, Entidadesdocumentos.jdoGettotalliquido(this));
        Entidadesdocumentos.jdoSettotaliva(clone, Entidadesdocumentos.jdoGettotaliva(this));
        Entidadesdocumentos.jdoSettotalbruto(clone, Entidadesdocumentos.jdoGettotalbruto(this));
        Entidadesdocumentos.jdoSettotal(clone, Entidadesdocumentos.jdoGettotal(this));
        ArrayList<Entidadesdocumentoslinhas> linhasdocumento = new ArrayList<Entidadesdocumentoslinhas>();
        for (Entidadesdocumentoslinhas linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
            linhasdocumento.add(linha.cloneCopy(clone));
        }
        Entidadesdocumentos.jdoSetlinhasdocumento(clone, linhasdocumento);
        ArrayList<Entidadesdocumentosentregas> entregaspagamento = new ArrayList<Entidadesdocumentosentregas>();
        for (Entidadesdocumentosentregas linha : Entidadesdocumentos.jdoGetentregaspagamento(this)) {
            entregaspagamento.add(linha.cloneCopy(clone));
        }
        Entidadesdocumentos.jdoSetentregaspagamento(clone, entregaspagamento);
        ArrayList<Entidadesdocumentosivas> tabelaiva = new ArrayList<Entidadesdocumentosivas>();
        for (Entidadesdocumentosivas linha : Entidadesdocumentos.jdoGettabelaiva(this)) {
            tabelaiva.add(linha.cloneCopy(clone));
        }
        Entidadesdocumentos.jdoSettabelaiva(clone, tabelaiva);
        ArrayList<Entidadesdocumentosatws> webservice = new ArrayList<Entidadesdocumentosatws>();
        for (Entidadesdocumentosatws linha : Entidadesdocumentos.jdoGetwebservice(this)) {
            webservice.add(linha.cloneCopy(clone));
        }
        Entidadesdocumentos.jdoSetwebservice(clone, webservice);
        return clone;
    }

    public Entidadesdocumentos cleanCopy() {
        Entidadesdocumentos clone = this.cloneCopy();
        clone.removeRelations();
        Entidadesdocumentos.jdoSetseriedocumento(clone, this.manager.loadDocumentosseries(Entidadesdocumentos.jdoGettipodocumento(this).getCodigo(), 0));
        Entidadesdocumentos.jdoSetautor(clone, this.manager.getUtilizador());
        Entidadesdocumentos.jdoSeteditor(clone, this.manager.getUtilizador());
        Entidadesdocumentos.jdoSettemplate(clone, Entidadesdocumentos.jdoGettipodocumento(clone).getTemplate(0));
        Date datacriacao = TimeDateUtils.getCurrentDate();
        Entidadesdocumentos.jdoSetdatasistema(clone, TimeDateUtils.getDateWithoutTime((Date)datacriacao));
        Entidadesdocumentos.jdoSethorasistema(clone, TimeDateUtils.getTime((Date)datacriacao));
        Entidadesdocumentos.jdoSetdatacriacao(clone, TimeDateUtils.getDateWithoutTime((Date)datacriacao));
        Entidadesdocumentos.jdoSethoracriacao(clone, TimeDateUtils.getTimeWithoutSeconds((Date)datacriacao));
        Entidadesdocumentos.jdoSetdataauxiliar(clone, TimeDateUtils.getDateWithoutTime((Date)datacriacao));
        Entidadesdocumentos.jdoSetdatavencimento(clone, TimeDateUtils.addDays((Date)datacriacao, (int)Entidadesdocumentos.jdoGetcondicaopagamento(clone).getPeriodo()));
        Entidadesdocumentos.jdoSetdatacarga(clone, TimeDateUtils.getDateWithoutTime((Date)datacriacao));
        Entidadesdocumentos.jdoSethoracarga(clone, TimeDateUtils.getTimeWithoutSeconds((Date)datacriacao));
        Entidadesdocumentos.jdoSetdatadescarga(clone, TimeDateUtils.getDateWithoutTime((Date)datacriacao));
        Entidadesdocumentos.jdoSethoradescarga(clone, Entidadesdocumentos.jdoGettipodocumento(clone).getSAFTDocumentGroup() == Documentostipos.SAFT_DOCUMENT_GROUP.MOVEMENT ? TimeDateUtils.getTime((int)23, (int)59) : TimeDateUtils.getTimeWithoutSeconds((Date)datacriacao));
        Entidadesdocumentos.jdoSetentregaspagamento(clone, new ArrayList());
        Entidadesdocumentos.jdoSettotalentregue(clone, BigDecimal.ZERO);
        Entidadesdocumentos.jdoSetdocumentcode(clone, "");
        Entidadesdocumentos.jdoSetestadoenvio(clone, clone.getEstadoenvio$Default());
        Entidadesdocumentos.jdoSetwebservice(clone, new ArrayList());
        Entidadesdocumentos.jdoSethash(clone, "");
        Entidadesdocumentos.jdoSethashcontrol(clone, RSAKEYS.PRIVATE.CERTIFICACAO.version);
        Entidadesdocumentos.jdoSetcontadorvias(clone, 0);
        Entidadesdocumentos.jdoSetestado(clone, 0);
        Entidadesdocumentos.jdoSetcodigovalidacao(clone, "");
        Entidadesdocumentos.jdoSetnumerodocumento(clone, clone.getNumerodocumento$Default());
        clone.setKey();
        clone.markDirty();
        return clone;
    }

    public void removeRelations() {
        for (Entidadesdocumentoslinhas linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
            linha.removeRelations();
        }
        Entidadesdocumentos.jdoSetmovimentoentidades(this, null);
    }

    @Override
    public MessageList validate(IDatabaseModel.ACTION action) {
        return this.validate(action, null, null, null);
    }

    public MessageList validate(IDatabaseModel.ACTION action, Entidadesdocumentos stored, Entidadesdocumentos previous, Entidadesdocumentos next) {
        MessageList error = super.validate(action);
        for (AbstractModel linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
            error.add(((Entidadesdocumentoslinhas)linha).validate(action));
        }
        for (AbstractModel linha : Entidadesdocumentos.jdoGetentregaspagamento(this)) {
            error.add(((Entidadesdocumentosentregas)linha).validate(action));
        }
        for (AbstractModel linha : Entidadesdocumentos.jdoGettabelaiva(this)) {
            error.add(linha.validate(action));
        }
        for (AbstractModel linha : Entidadesdocumentos.jdoGetwebservice(this)) {
            error.add(linha.validate(action));
        }
        if (this.hasValorjustificado()) {
            error.add((Object)new MessageLine((Object)LABELS.entidadesmovimentos_valorjustificado).biggerThan((Object)0));
        }
        if (this.isEstado(1) || this.isEstado(2)) {
            error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_estado).brackets((Object)this.getEstadoToText()));
        }
        Date datalimite = ISAFTExport.SAFT_VERSIONS.getDatalimite(Entidadesdocumentos.jdoGetdatacriacao(this));
        if (this.isAssinado() && !this.isEstadoenvio(2) && datalimite.before(TimeDateUtils.getCurrentDate())) {
            error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_datacriacao).smallerThan((Object)datalimite).append((Object)" (SAFT)"));
        }
        switch (action) {
            case DELETE: {
                break;
            }
            case STORE: {
                Entidadesdocumentos clone = this.cloneCopy().process();
                if (Entidadesdocumentos.jdoGettabelaiva(this).size() == Entidadesdocumentos.jdoGettabelaiva(clone).size()) {
                    for (AbstractModel linha : Entidadesdocumentos.jdoGettabelaiva(this)) {
                        error.add(linha.validate(clone.getTabelaiva(((Entidadesdocumentosivas)linha).getKey()), new FIELDS[0]).prefix(LABELS.entidadesdocumentos_tabelaiva.toString()));
                    }
                } else {
                    error.add(LABELS.entidadesdocumentos_tabelaiva.toString());
                }
                for (AbstractModel linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
                    error.add(linha.validate(clone.getLinhasdocumento(((Entidadesdocumentoslinhas)linha).getKey()), new FIELDS[0]).prefix(LABELS.entidadesdocumentos_linhasdocumento.toString()));
                }
                error.add(this.validate(clone, new FIELDS[0]));
                if (previous != null && Entidadesdocumentos.jdoGetdatacriacao(this).before(previous.getDatacriacao())) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_datacriacao).smallerThan((Object)previous.getDatacriacao()));
                }
                if (next != null && Entidadesdocumentos.jdoGetdatacriacao(this).after(next.getDatacriacao())) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_datacriacao).biggerThan((Object)next.getDatacriacao()));
                }
                if (stored == null && next != null && next.isAssinado()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_numerodocumento));
                }
                if (stored != null && !stored.getHash().equals(Entidadesdocumentos.jdoGethash(this))) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_hash));
                }
                if (!this.isHashValid(previous)) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_hash));
                }
                if (stored != null && stored.hasDocumentcode() && !stored.getDocumentcode().equals(Entidadesdocumentos.jdoGetdocumentcode(this))) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_documentcode).notEqual((Object)stored.getDocumentcode()));
                }
                if (Entidadesdocumentos.jdoGetseriedocumento(this) != null) {
                    error.add(Entidadesdocumentos.jdoGetseriedocumento(this).validate(action));
                }
                if (!this.isSeriedocumentoValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_seriedocumento));
                }
                if (this.needsCodigovalidacao()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_seriedocumento).brackets((Object)LABELS.documentosseries_codigovalidacao));
                }
                if (!this.isCodigovalidacaoValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_codigovalidacao));
                }
                if (previous != null && previous.hasCodigovalidacao() && !previous.getCodigovalidacao().equals(Entidadesdocumentos.jdoGetcodigovalidacao(this))) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_codigovalidacao).notEqual((Object)previous.getCodigovalidacao()));
                }
                if (!this.isNumerodocumentoValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_numerodocumento));
                }
                if (previous != null && previous.isAssinado() && Entidadesdocumentos.jdoGetnumerodocumento(this) != previous.getNumerodocumento() + 1) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_numerodocumento).notEqual((Object)(previous.getNumerodocumento() + 1)));
                }
                if (!this.isNumeroauxiliarValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_numeroauxiliar));
                }
                if (!this.isEntidadeValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_entidade));
                }
                if (Entidadesdocumentos.jdoGetentidade(this) != null && Entidadesdocumentos.jdoGetentidade(this).isEstado(0)) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_entidade).brackets((Object)Entidadesdocumentos.jdoGetentidade(this).getEstadoToText()));
                }
                if (stored != null && stored.isAssinado() && !stored.getEntidade().getKey().equals(Entidadesdocumentos.jdoGetentidade(this).getKey())) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_entidade).notEqual((Object)stored.getEntidade().getKey()));
                }
                if (!this.isCodigopostalValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_codigopostal));
                }
                if (!this.isNifValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_nif).brackets((Object)Entidadesdocumentos.jdoGetnif(this)));
                }
                if (stored != null && stored.isAssinado() && !stored.isNifEqual(Entidadesdocumentos.jdoGetpais(this), Entidadesdocumentos.jdoGetnif(this))) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_nif).notEqual((Object)stored.getNif()));
                }
                if (!this.isCambioValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_cambio));
                }
                if (!this.isPercdescontoValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_percdesconto));
                }
                if (!this.isTotalentregueValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_totalentregue));
                }
                if (!this.isTipocarregamentoValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.documentostipos_tipocarregamento).brackets((Object)Entidadesdocumentos.jdoGettipodocumento(this).getTipocarregamentoToText()));
                }
                if (Entidadesdocumentos.jdoGettipodocumento(this).isTipodocumento(2)) {
                    if (this.getMovimentoorigem().size() == 0) {
                        error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_linhasdocumento));
                    }
                    if (this.getMovimentoorigem().size() <= 1 || !Entidadesdocumentos.jdoGettipodocumento(this).isTipodocumentosaft(26)) break;
                    error.add((Object)new MessageLine((Object)LABELS.entidades_regimeiva).brackets((Object)LABELS.entidadesdocumentos_linhasdocumento));
                    break;
                }
                if (Entidadesdocumentos.jdoGetlinhasdocumento(this).size() == 0) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_linhasdocumento).brackets((Object)LABELS.valor_vazio));
                }
                if (Entidadesdocumentos.jdoGetentidade(this) != null && !Entidadesdocumentos.jdoGetentidade(this).isRegimeiva(Entidadesdocumentos.jdoGetseriedocumento(this).getRegimeiva())) {
                    error.add((Object)new MessageLine((Object)LABELS.entidades_regimeiva).brackets((Object)LABELS.entidadesdocumentos_seriedocumento));
                }
                if (Entidadesdocumentos.jdoGetlocalcarga(this).isEmpty()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_localcarga));
                }
                if (this.getQuantidade().signum() == 0) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentoslinhas_quantidade).equal((Object)0));
                }
                if (!this.isTotalprodutosValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_totalprodutos).biggerThan((Object)1000));
                }
                if (!this.isTotalservicosValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_totalservicos).biggerThan((Object)100));
                }
                if (this.isTotalbrutoValid()) break;
                error.add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_total).smallerThan((Object)0));
            }
        }
        return error;
    }

    public ErrorList warnings(PersistenceManager pm) {
        ErrorList error = new ErrorList();
        for (Entidadesdocumentoslinhas linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
            error.add(linha.warnings());
        }
        if (!this.isTemplateLegal()) {
            error.warnings().add((Object)new MessageLine((Object)LABELS.info_template_ilegal));
        }
        if (!Entidadesdocumentos.jdoGetseriedocumento(this).isIntegracao() && Entidadesdocumentos.jdoGetdatacriacao(this).after(TimeDateUtils.getDateWithoutTime())) {
            error.warnings().add((Object)new MessageLine((Object)LABELS.entidadesdocumentos_datacriacao).biggerThan((Object)TimeDateUtils.getCurrentDate()));
        }
        if (!Entidadesdocumentos.jdoGettipodocumento(this).isTipodocumento(2) && Entidadesdocumentos.jdoGettipodocumento(this).isTipodocumento(1) && Entidadesdocumentos.jdoGettipodocumento(this).isTiposaldo(0)) {
            QueryDefinition query = new QueryDefinition(TABLES.entidadesmovimentos, QueryOrdering.DIRECTION.ASCENDING);
            query.addRule(new FilterMapRule(FIELDS.entidadesmovimentos_tipodocumento, FIELDS.documentostipos_tipoentidade, FIELDS.entidadestipos_codigo).equal(Entidadesdocumentos.jdoGettipodocumento(this).getTipoentidade().getCodigo())).addRule(new FilterMapRule(FIELDS.entidadesmovimentos_tipodocumento, FIELDS.documentostipos_tipodocumento).equal(1)).addRule(new FilterMapRule(FIELDS.entidadesmovimentos_tiposaldo).equal(0)).addRule(new FilterMapRule(FIELDS.entidadesmovimentos_entidade, FIELDS.entidades_numero).equal(Entidadesdocumentos.jdoGetentidade(this).getNumero())).addRule(new FilterMapRule(FIELDS.entidadesmovimentos_valorpendente).biggerThan(0)).addRule(new FilterMapRule(FIELDS.entidadesmovimentos_datavencimento).smallerEqual(TimeDateUtils.getCurrentDate())).addRule(new FilterMapRule(FIELDS.entidadesmovimentos_key).notEqual(Entidadesdocumentos.jdoGetkey(this)));
            if (!this.manager.getParametros().isAvisafacturasvencidas(0) && query.execute(pm).size() > 0) {
                switch (this.manager.getParametros().getAvisafacturasvencidas()) {
                    case 1: {
                        error.warnings().add((Object)new MessageLine((Object)LABELS.info_database_facturasvencidas));
                        break;
                    }
                    case 2: {
                        error.errors().add((Object)new MessageLine((Object)LABELS.info_database_facturasvencidas));
                    }
                }
            }
            query.close();
            if (!this.manager.getParametros().isAvisalimitecredito(0) && Entidadesdocumentos.jdoGetentidade(this).isLimitecreditoReached()) {
                switch (this.manager.getParametros().getAvisalimitecredito()) {
                    case 1: {
                        error.warnings().add((Object)new MessageLine((Object)LABELS.entidades_limitecredito).brackets((Object)Entidadesdocumentos.jdoGetentidade(this).getLimitecreditoToText()));
                        break;
                    }
                    case 2: {
                        error.errors().add((Object)new MessageLine((Object)LABELS.entidades_limitecredito).brackets((Object)Entidadesdocumentos.jdoGetentidade(this).getLimitecreditoToText()));
                    }
                }
            }
        }
        return error;
    }

    Entidadesdocumentos process() {
        if (!this.busy) {
            this.busy = true;
            boolean cascade = this.setCascade(false);
            TabelaivaMap tabelaivaMap = new TabelaivaMap(this);
            BigDecimal totalprodutos = BigDecimal.ZERO;
            BigDecimal totalservicos = BigDecimal.ZERO;
            BigDecimal totalretencoes = BigDecimal.ZERO;
            BigDecimal totaliliquido = BigDecimal.ZERO;
            BigDecimal totaldeducoes = BigDecimal.ZERO;
            BigDecimal totaldesconto = BigDecimal.ZERO;
            BigDecimal totalliquido = BigDecimal.ZERO;
            BigDecimal totaliva = BigDecimal.ZERO;
            if (Entidadesdocumentos.jdoGettipodocumento(this).isTipodocumento(2)) {
                for (Entidadesdocumentoslinhas linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
                    if (linha.getDeducao().booleanValue()) {
                        totalservicos = totalservicos.subtract(linha.getValorservicos());
                        totalretencoes = totalretencoes.subtract(linha.getValorretencao());
                        totaldeducoes = totaldeducoes.add(linha.getValoriliquido());
                        totaldesconto = totaldesconto.subtract(linha.getValordesconto());
                        totalliquido = totalliquido.subtract(linha.getValorliquido());
                        totaliva = totaliva.subtract(linha.getValoriva());
                        continue;
                    }
                    totalservicos = totalservicos.add(linha.getValorservicos());
                    totalretencoes = totalretencoes.add(linha.getValorretencao());
                    totaliliquido = totaliliquido.add(linha.getValoriliquido());
                    totaldesconto = totaldesconto.add(linha.getValordesconto());
                    totalliquido = totalliquido.add(linha.getValorliquido());
                    totaliva = totaliva.add(linha.getValoriva());
                }
            } else {
                for (Entidadesdocumentosivas iva : tabelaivaMap.values()) {
                    totalprodutos = totalprodutos.add(iva.getValorprodutos());
                    totalservicos = totalservicos.add(iva.getValorservicos());
                    totalretencoes = totalretencoes.add(iva.getValorretencao());
                    totaliliquido = totaliliquido.add(iva.getValorbase().add(iva.getValordesconto().add(iva.getValordesconto2())));
                    totaldesconto = totaldesconto.add(iva.getValordesconto().add(iva.getValordesconto2()));
                    totalliquido = totalliquido.add(iva.getValorbase());
                    totaliva = totaliva.add(iva.getTotal());
                }
            }
            this.setTabelaiva(tabelaivaMap.values());
            this.setTotalprodutos(totalprodutos);
            this.setTotalservicos(totalservicos);
            this.setTotalretencoes(totalretencoes);
            this.setTotaliliquido(totaliliquido);
            this.setTotaldeducoes(totaldeducoes);
            this.setTotaldesconto(totaldesconto);
            this.setTotalliquido(totalliquido);
            this.setTotaliva(totaliva);
            this.setTotalbruto(totalliquido.add(totaliva));
            if (this.setTotal(Entidadesdocumentos.jdoGettotalbruto(this).subtract(totalretencoes))) {
                if (Entidadesdocumentos.jdoGetentregaspagamento(this).isEmpty() && !Entidadesdocumentos.jdoGettipodocumento(this).isMovimentabancos(0)) {
                    this.addEntregaspagamento();
                }
                if (Entidadesdocumentos.jdoGetentregaspagamento(this).size() == 1) {
                    this.getEntregaspagamento(0).setValor(Entidadesdocumentos.jdoGettotal(this));
                }
            }
            BigDecimal totalentregue = BigDecimal.ZERO;
            for (Entidadesdocumentosentregas linha : Entidadesdocumentos.jdoGetentregaspagamento(this)) {
                totalentregue = totalentregue.add(linha.getValor());
            }
            this.setTotalentregue(totalentregue);
            this.setCascade(cascade);
            this.busy = false;
        }
        return this;
    }

    public void processComposicao() {
        ArrayList<Entidadesdocumentoslinhas> col = new ArrayList<Entidadesdocumentoslinhas>();
        for (Entidadesdocumentoslinhas linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
            if (linha.hasArtigo()) {
                linha.getArtigo().isTipo(1);
                col.add(linha);
                for (Artigoscomposicao composicao : linha.getArtigo().getComposicao()) {
                    Entidadesdocumentoslinhas linha2 = this.createLinhasdocumento();
                    linha2.setDescricao("x" + composicao.getQuantidade().stripTrailingZeros().toPlainString() + " " + composicao.getDescricao());
                    linha2.setUnidademedida(composicao.getUnidademedida());
                    linha2.setTipo(3);
                    col.add(linha2);
                }
                continue;
            }
            if (linha.isTipo(3)) continue;
            col.add(linha);
        }
        this.setLinhasdocumento(col);
    }

    public IATDocumentosService service() throws WebServiceException {
        switch (Entidadesdocumentos.jdoGettipodocumento(this).getServiceDocumentGroup()) {
            case UNSUPPORTED: {
                break;
            }
            case INVOICE: {
                return new FaturasService(this.manager.getParametros().getDocumentosService(), this);
            }
            case MOVEMENT: {
                return new StockMovementService(this.manager.getParametros().getStockMovementService(), this);
            }
        }
        return null;
    }

    public boolean hasService() {
        try {
            this.service().checkService();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public BIRTReport createReport() {
        return this.createReport(false);
    }

    public BIRTReport createReport(boolean resetCount) {
        return new BIRTReport(Entidadesdocumentos.jdoGettemplate(this), resetCount){

            @Override
            public FilterMap getFilterMap() {
                return new FilterMap(TABLES.entidadesdocumentos).addRule(new FilterMapRule(FIELDS.entidadesdocumentos_key).equal(Entidadesdocumentos.jdoGetkey(Entidadesdocumentos.this)));
            }
        };
    }

    @Override
    public Entidadesdocumentos reportCopy() {
        Entidadesdocumentos clone = this.cloneCopy();
        if (this.isNifGenerico()) {
            clone.setNif(Entidades.RECORDS.consumidor_final.nome);
        }
        if (!Entidadesdocumentos.jdoGettipodocumento(this).isTipodocumento(2)) {
            MessageList list = new MessageList(new String[]{this.getObs()});
            for (Isencoesiva isencao : this.getIsencoesiva()) {
                list.add((Object)((Object)isencao.getMotivoAT()) + "=" + isencao.getArtigolegal());
            }
            clone.setObs(list.toString());
        }
        clone.setContadorvias(this.hasContadorvias() ? Entidadesdocumentos.jdoGetcontadorvias(this) : 0);
        return clone;
    }

    @Override
    public BIRTReportCopies getReportCopies(BIRTReport.REPORT_ACTIONS action) {
        if (Entidadesdocumentos.jdoGetentidade(this) != null && action == BIRTReport.REPORT_ACTIONS.EMAIL) {
            switch (Entidadesdocumentos.jdoGetentidade(this).getSendmail()) {
                case 0: {
                    return Entidadesdocumentos.jdoGettipodocumento(this).getReportCopies(BIRTReport.REPORT_ACTIONS.PREVIEW);
                }
            }
        }
        return Entidadesdocumentos.jdoGettipodocumento(this).getReportCopies(action);
    }

    @Override
    public BIRTRender.BACKGROUND getReportBackground() {
        if (!this.manager.getLicenca().isFormacao()) {
            switch (Entidadesdocumentos.jdoGetestado(this)) {
                case 0: {
                    return BIRTRender.BACKGROUND.NONE;
                }
                case 1: {
                    return BIRTRender.BACKGROUND.DELETED;
                }
                case 2: {
                    return BIRTRender.BACKGROUND.WATERMARK;
                }
            }
        }
        return BIRTRender.BACKGROUND.DRAFT;
    }

    @Override
    public String getReportTtitle() {
        return Entidadesdocumentos.jdoGettipodocumento(this).getTituloToText();
    }

    @Override
    public String getReportMessage() {
        if (Colibri.MARKET_TYPE == Colibri.MARKETS.INTERNAL) {
            StringBuilder sb = new StringBuilder();
            if (this.isAssinado()) {
                sb.append(String.valueOf(this.getHashCheckdigits()) + "-");
            }
            if (this.isTipodocumentosaftCertificado()) {
                sb.append("PROCESSADO POR PROGRAMA CERTIFICADO N\u00ba38/AT");
            } else {
                sb.append("EMITIDO POR PROGRAMA CERTIFICADO N\u00ba38/AT");
            }
            if (Entidadesdocumentos.jdoGettipodocumento(this).getSAFTDocumentGroup() != Documentostipos.SAFT_DOCUMENT_GROUP.INVOICE) {
                sb.append(" - ESTE DOCUMENTO NAO SERVE DE FACTURA");
            }
            if (Entidadesdocumentos.jdoGetseriedocumento(this) != null) {
                switch (Entidadesdocumentos.jdoGetseriedocumento(this).getTipoSerie()) {
                    case N: {
                        if (!Entidadesdocumentos.jdoGetseriedocumento(this).isRegimeiva(1)) break;
                        sb.append(" - IVA\u2013REGIME DE CAIXA");
                        break;
                    }
                    case F: {
                        sb.append(" - DOCUMENTO EMITIDO PARA FINS DE FORMACAO");
                        break;
                    }
                    case R: {
                        sb.append(" - C\u00d3PIA DO DOCUMENTO ORIGINAL");
                    }
                }
            }
            return sb.toString();
        }
        return PROCESSADO_COMPUTADOR;
    }

    @Override
    public MultibancoRef getMultibanco() {
        MultibancoEntity multibanco = this.manager.getParametros().getMultibanco();
        if (multibanco != null) {
            BigDecimal[] bigDecimalArray = new BigDecimal[]{Entidadesdocumentos.jdoGettotal(this), MultibancoEntity.VALOR_MAX};
            int n = bigDecimalArray.length;
            int n2 = 0;
            while (n2 < n) {
                BigDecimal total = bigDecimalArray[n2];
                try {
                    switch (this.manager.getParametros().getMbidpagamento()) {
                        case 0: {
                            return multibanco.generate(Entidadesdocumentos.jdoGetentidade(this).getNumeroToText(), total);
                        }
                        case 1: {
                            return multibanco.generate(this.getNumerodocumentoToText(), total);
                        }
                        case 2: {
                            return multibanco.generate(this.getNumeroauxiliar(), total);
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    System.err.println(e);
                }
                ++n2;
            }
        }
        return MultibancoRef.DEFAULT;
    }

    @Override
    public String getKey() {
        return Entidadesdocumentos.jdoGetkey(this);
    }

    public void setKey(String key) {
        String string = Entidadesdocumentos.jdoGetkey(this);
        String string2 = key;
        Entidadesdocumentos.jdoSetkey(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_key, (Object)string, (Object)string2);
    }

    void setKey() {
        this.setKey(this.generateKey());
        for (AbstractModel linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
            ((Entidadesdocumentoslinhas)linha).setKey();
        }
        for (AbstractModel linha : Entidadesdocumentos.jdoGetentregaspagamento(this)) {
            ((Entidadesdocumentosentregas)linha).setKey();
        }
        for (AbstractModel linha : Entidadesdocumentos.jdoGettabelaiva(this)) {
            ((Entidadesdocumentosivas)linha).setKey();
        }
        for (AbstractModel linha : Entidadesdocumentos.jdoGetwebservice(this)) {
            ((Entidadesdocumentosatws)linha).setKey();
        }
    }

    String generateKey() {
        return Entidadesdocumentos.jdoGettipodocumento(this) == null || Entidadesdocumentos.jdoGetseriedocumento(this) == null || Entidadesdocumentos.jdoGetnumerodocumento(this) == null ? null : Entidadesdocumentos.generateKey(Entidadesdocumentos.jdoGettipodocumento(this).getCodigo(), Entidadesdocumentos.jdoGetseriedocumento(this).getSerie(), Entidadesdocumentos.jdoGetnumerodocumento(this));
    }

    public static String generateKey(String tipodocumento, String serie, Integer numerodocumento) {
        return String.valueOf(Documentosseries.generateKey(tipodocumento, serie)) + ":" + numerodocumento;
    }

    public Entidadesmovimentos getMovimentoentidades() {
        return Entidadesdocumentos.jdoGetmovimentoentidades(this);
    }

    void setMovimentoentidades(Entidadesmovimentos movimentoentidades) {
        Entidadesmovimentos entidadesmovimentos = Entidadesdocumentos.jdoGetmovimentoentidades(this);
        Entidadesmovimentos entidadesmovimentos2 = movimentoentidades;
        Entidadesdocumentos.jdoSetmovimentoentidades(this, entidadesmovimentos2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_movimentoentidades, (Object)entidadesmovimentos, (Object)entidadesmovimentos2);
    }

    public boolean hasValorjustificado() {
        return Entidadesdocumentos.jdoGetmovimentoentidades(this) != null && Entidadesdocumentos.jdoGetmovimentoentidades(this).hasValorjustificado();
    }

    public boolean hasDocumentosorigem() {
        for (Entidadesdocumentoslinhas linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
            if (linha.getMovimentoorigem() == null) continue;
            return true;
        }
        return false;
    }

    public Utilizadores getAutor() {
        return Entidadesdocumentos.jdoGetautor(this);
    }

    public void setAutor(Utilizadores autor) {
        Utilizadores utilizadores = Entidadesdocumentos.jdoGetautor(this);
        Utilizadores utilizadores2 = autor;
        Entidadesdocumentos.jdoSetautor(this, utilizadores2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_autor, (Object)utilizadores, (Object)utilizadores2);
    }

    public Utilizadores getEditor() {
        return Entidadesdocumentos.jdoGeteditor(this);
    }

    public void setEditor(Utilizadores editor) {
        Utilizadores utilizadores = Entidadesdocumentos.jdoGeteditor(this);
        Utilizadores utilizadores2 = editor;
        Entidadesdocumentos.jdoSeteditor(this, utilizadores2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_editor, (Object)utilizadores, (Object)utilizadores2);
    }

    @Override
    public Templates getTemplate() {
        return Entidadesdocumentos.jdoGettemplate(this);
    }

    public void setTemplate(Templates template) {
        Templates templates = Entidadesdocumentos.jdoGettemplate(this);
        Templates templates2 = template;
        Entidadesdocumentos.jdoSettemplate(this, templates2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_template, (Object)templates, (Object)templates2);
    }

    public boolean isTemplateLegal() {
        return !Entidadesdocumentos.jdoGettipodocumento(this).isTipodocumentosaftCertificado() || Entidadesdocumentos.jdoGettemplate(this).isLegal();
    }

    public Documentostipos getTipodocumento() {
        return Entidadesdocumentos.jdoGettipodocumento(this);
    }

    public void setTipodocumento(Documentostipos tipodocumento) {
        Documentostipos documentostipos = Entidadesdocumentos.jdoGettipodocumento(this);
        Documentostipos documentostipos2 = tipodocumento;
        Entidadesdocumentos.jdoSettipodocumento(this, documentostipos2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_tipodocumento, (Object)documentostipos, (Object)documentostipos2);
        this.setKey();
    }

    public boolean isTipodocumentosaftCertificado() {
        return Entidadesdocumentos.jdoGettipodocumento(this).isTipodocumentosaftCertificado();
    }

    public boolean isTipocarregamentoValid() {
        return !Entidadesdocumentos.jdoGettipodocumento(this).isTipocarregamento(0) || this.getLinhaorigem().isEmpty() && this.getMovimentoorigem().isEmpty() && this.getMovimentoorigem2().isEmpty();
    }

    public ICIUSExport getCIUSExport() {
        switch (Entidadesdocumentos.jdoGettipodocumento(this).getCIUSDocumentGroup()) {
            case UNKNOWN: {
                break;
            }
            case INVOICE: {
                return new InvoiceExport(this);
            }
            case CREDIT: {
                return new CreditNoteExport(this);
            }
        }
        return new CIUS21Export(this){

            @Override
            public void process() throws Exception {
            }

            public boolean save(OutputStream out) {
                return true;
            }

            public boolean save(File file) {
                return true;
            }

            public boolean isEmpty() {
                return true;
            }

            public boolean isValid() {
                return false;
            }
        };
    }

    public Documentosseries getSeriedocumento() {
        return Entidadesdocumentos.jdoGetseriedocumento(this);
    }

    public void setSeriedocumento(Documentosseries seriedocumento) {
        Documentosseries documentosseries = Entidadesdocumentos.jdoGetseriedocumento(this);
        Documentosseries documentosseries2 = seriedocumento;
        Entidadesdocumentos.jdoSetseriedocumento(this, documentosseries2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_seriedocumento, (Object)documentosseries, (Object)documentosseries2);
        if (changed && this.cascade && seriedocumento != null) {
            this.setCodigovalidacao(seriedocumento.getCodigovalidacao());
            this.setNumerodocumento(this.getNumerodocumento$Default());
        }
    }

    public boolean isSeriedocumentoValid() {
        return Entidadesdocumentos.jdoGetseriedocumento(this) != null && Entidadesdocumentos.jdoGetseriedocumento(this).isEstado(1);
    }

    public MessageList registerSeriedocumento() {
        return this.manager.registerDocumentosseries(Entidadesdocumentos.jdoGetseriedocumento(this) == null ? null : Entidadesdocumentos.jdoGetseriedocumento(this).getKey());
    }

    public Entidades getEntidade() {
        return Entidadesdocumentos.jdoGetentidade(this);
    }

    public void setEntidade(Entidades entidade) {
        Entidades entidades = Entidadesdocumentos.jdoGetentidade(this);
        Entidades entidades2 = entidade;
        Entidadesdocumentos.jdoSetentidade(this, entidades2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_entidade, (Object)entidades, (Object)entidades2);
        if (changed && this.cascade && entidade != null) {
            this.setNome(entidade.getNome());
            int[] nArray = new int[2];
            nArray[1] = 1;
            int[] nArray2 = nArray;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int tipo = nArray2[n2];
                this.setMorada(tipo);
                ++n2;
            }
            this.setNif(entidade.getNif());
            this.setVendedor(entidade.getVendedor());
            this.setCondicaopagamento(entidade.getCondicaopagamento());
            this.setMetodopagamento(entidade.getMetodopagamento());
            this.setMoeda(entidade.getMoeda());
        }
    }

    public void setEntidade(Integer numero) {
        this.setEntidade(this.manager.loadEntidades(Entidadesdocumentos.jdoGettipodocumento(this).getTipoentidade().getCodigo(), numero));
    }

    public boolean isEntidadeValid() {
        return Entidadesdocumentos.jdoGetentidade(this) != null && Entidadesdocumentos.jdoGetentidade(this).getTipoentidade().equals(Entidadesdocumentos.jdoGettipodocumento(this).getTipoentidade());
    }

    public boolean isEntidadeEditable() {
        return Entidadesdocumentos.jdoGetentidade(this) == null ? Colibri.VERSION_TYPE == Colibri.VERSIONS.SERVER : Entidadesdocumentos.jdoGetentidade(this).isNifGenerico();
    }

    public boolean hasSendmail() {
        return Entidadesdocumentos.jdoGetentidade(this) != null && Entidadesdocumentos.jdoGetentidade(this).hasSendmail() && Entidadesdocumentos.jdoGettipodocumento(this).getCopiasemail() > 0;
    }

    public EmailRecipients getEmailRecipients() {
        EmailRecipients recipients = Entidadesdocumentos.jdoGetentidade(this) == null ? new EmailRecipients() : Entidadesdocumentos.jdoGetentidade(this).getEmailRecipients();
        return recipients;
    }

    public BIRTEmailParameters getEmailParameters() {
        String subject = String.valueOf(this.manager.getEmpresa().getNomeToText()) + " | " + Entidadesdocumentos.jdoGettipodocumento(this).getTipodocumentosaftToText() + " " + this.toString();
        String body = Entidadesdocumentos.jdoGettipodocumento(this).getTextoemailToText().isEmpty() ? this.manager.getParametros().getTextoemail() : Entidadesdocumentos.jdoGettipodocumento(this).getTextoemail();
        return this.manager.getEmpresa().getEmailParameters(this.getEmailRecipients(), new EmailMessage(subject, body));
    }

    @Deprecated
    public Entidadestipos getTipoentidade() {
        return Entidadesdocumentos.jdoGettipodocumento(this).getTipoentidade();
    }

    public Codigospostais getCodigopostal() {
        return Entidadesdocumentos.jdoGetcodigopostal(this);
    }

    public void setCodigopostal(Codigospostais codigopostal) {
        Codigospostais codigospostais = Entidadesdocumentos.jdoGetcodigopostal(this);
        Codigospostais codigospostais2 = codigopostal;
        Entidadesdocumentos.jdoSetcodigopostal(this, codigospostais2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_codigopostal, (Object)codigospostais, (Object)codigospostais2);
        if (changed && this.cascade && codigopostal != null) {
            this.setLocalidade(codigopostal.getDescricao());
            switch (Entidadesdocumentos.jdoGettipodocumento(this).getMovimentaartigos()) {
                case 0: {
                    switch (Entidadesdocumentos.jdoGettipodocumento(this).getTipoentidade().getTipoentidade()) {
                        case 0: {
                            this.setCodigopostaldescarga(codigopostal);
                            break;
                        }
                        case 1: {
                            this.setCodigopostalcarga(codigopostal);
                        }
                    }
                    break;
                }
                case 1: {
                    this.setCodigopostaldescarga(codigopostal);
                    break;
                }
                case 2: 
                case 3: {
                    this.setCodigopostalcarga(codigopostal);
                }
            }
        }
    }

    public boolean isCodigopostalValid() {
        return !this.getLocalidadeToText().isEmpty() && Entidadesdocumentos.jdoGetcodigopostal(this) != null && Entidadesdocumentos.jdoGetcodigopostal(this).isValid(Entidadesdocumentos.jdoGetpais(this));
    }

    public Codigospostais getCodigopostalcarga() {
        return Entidadesdocumentos.jdoGetcodigopostalcarga(this);
    }

    public void setCodigopostalcarga(Codigospostais codigopostalcarga) {
        Codigospostais codigospostais = Entidadesdocumentos.jdoGetcodigopostalcarga(this);
        Codigospostais codigospostais2 = codigopostalcarga;
        Entidadesdocumentos.jdoSetcodigopostalcarga(this, codigospostais2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_codigopostalcarga, (Object)codigospostais, (Object)codigospostais2);
        if (changed) {
            this.firePropertyChange(FIELDS.codigospostais_localidade, "carga");
        }
    }

    public boolean isCodigopostalcargaValid() {
        return !this.getLocalidadecargaToText().isEmpty() && Entidadesdocumentos.jdoGetcodigopostalcarga(this) != null && Entidadesdocumentos.jdoGetcodigopostalcarga(this).isValid(Entidadesdocumentos.jdoGetpaiscarga(this));
    }

    public Codigospostais getCodigopostaldescarga() {
        return Entidadesdocumentos.jdoGetcodigopostaldescarga(this);
    }

    public void setCodigopostaldescarga(Codigospostais codigopostaldescarga) {
        Codigospostais codigospostais = Entidadesdocumentos.jdoGetcodigopostaldescarga(this);
        Codigospostais codigospostais2 = codigopostaldescarga;
        Entidadesdocumentos.jdoSetcodigopostaldescarga(this, codigospostais2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_codigopostaldescarga, (Object)codigospostais, (Object)codigospostais2);
        if (changed) {
            this.firePropertyChange(FIELDS.codigospostais_localidade, "descarga");
        }
    }

    public boolean isCodigopostaldescargaValid() {
        return !this.getLocalidadedescargaToText().isEmpty() && Entidadesdocumentos.jdoGetcodigopostaldescarga(this) != null && Entidadesdocumentos.jdoGetcodigopostaldescarga(this).isValid(Entidadesdocumentos.jdoGetpaisdescarga(this));
    }

    public Paises getPais() {
        return Entidadesdocumentos.jdoGetpais(this);
    }

    public void setPais(Paises pais) {
        Paises paises = Entidadesdocumentos.jdoGetpais(this);
        Paises paises2 = pais;
        Entidadesdocumentos.jdoSetpais(this, paises2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_pais, (Object)paises, (Object)paises2);
        if (changed && this.cascade && pais != null) {
            this.setEstadoenvio(this.getEstadoenvio$Default());
            switch (Entidadesdocumentos.jdoGettipodocumento(this).getMovimentaartigos()) {
                case 0: {
                    switch (Entidadesdocumentos.jdoGettipodocumento(this).getTipoentidade().getTipoentidade()) {
                        case 0: {
                            this.setPaisdescarga(pais);
                            break;
                        }
                        case 1: {
                            this.setPaiscarga(pais);
                        }
                    }
                    break;
                }
                case 1: {
                    this.setPaisdescarga(pais);
                    break;
                }
                case 2: 
                case 3: {
                    this.setPaiscarga(pais);
                }
            }
        }
    }

    public Paises getPaiscarga() {
        return Entidadesdocumentos.jdoGetpaiscarga(this);
    }

    public void setPaiscarga(Paises paiscarga) {
        Paises paises = Entidadesdocumentos.jdoGetpaiscarga(this);
        Paises paises2 = paiscarga;
        Entidadesdocumentos.jdoSetpaiscarga(this, paises2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_paiscarga, (Object)paises, (Object)paises2);
    }

    public Paises getPaisdescarga() {
        return Entidadesdocumentos.jdoGetpaisdescarga(this);
    }

    public void setPaisdescarga(Paises paisdescarga) {
        Paises paises = Entidadesdocumentos.jdoGetpaisdescarga(this);
        Paises paises2 = paisdescarga;
        Entidadesdocumentos.jdoSetpaisdescarga(this, paises2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_paisdescarga, (Object)paises, (Object)paises2);
    }

    public Vendedores getVendedor() {
        return Entidadesdocumentos.jdoGetvendedor(this);
    }

    public void setVendedor(Vendedores vendedor) {
        Vendedores vendedores = Entidadesdocumentos.jdoGetvendedor(this);
        Vendedores vendedores2 = vendedor;
        Entidadesdocumentos.jdoSetvendedor(this, vendedores2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_vendedor, (Object)vendedores, (Object)vendedores2);
    }

    public Condicoespagamento getCondicaopagamento() {
        return Entidadesdocumentos.jdoGetcondicaopagamento(this);
    }

    public void setCondicaopagamento(Condicoespagamento condicaopagamento) {
        Condicoespagamento condicoespagamento = Entidadesdocumentos.jdoGetcondicaopagamento(this);
        Condicoespagamento condicoespagamento2 = condicaopagamento;
        Entidadesdocumentos.jdoSetcondicaopagamento(this, condicoespagamento2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_condicaopagamento, (Object)condicoespagamento, (Object)condicoespagamento2);
        if (changed && this.cascade && condicaopagamento != null) {
            this.setDatavencimento(this.getDatadocumento(), condicaopagamento.getPeriodo());
        }
    }

    public Metodospagamento getMetodopagamento() {
        return Entidadesdocumentos.jdoGetmetodopagamento(this);
    }

    public void setMetodopagamento(Metodospagamento metodopagamento) {
        Metodospagamento metodospagamento = Entidadesdocumentos.jdoGetmetodopagamento(this);
        Metodospagamento metodospagamento2 = metodopagamento;
        Entidadesdocumentos.jdoSetmetodopagamento(this, metodospagamento2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_metodopagamento, (Object)metodospagamento, (Object)metodospagamento2);
    }

    public Condicoesentrega getCondicaoentrega() {
        return Entidadesdocumentos.jdoGetcondicaoentrega(this);
    }

    public void setCondicaoentrega(Condicoesentrega condicaoentrega) {
        Condicoesentrega condicoesentrega = Entidadesdocumentos.jdoGetcondicaoentrega(this);
        Condicoesentrega condicoesentrega2 = condicaoentrega;
        Entidadesdocumentos.jdoSetcondicaoentrega(this, condicoesentrega2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_condicaoentrega, (Object)condicoesentrega, (Object)condicoesentrega2);
    }

    public Metodostransporte getMetodotransporte() {
        return Entidadesdocumentos.jdoGetmetodotransporte(this);
    }

    public void setMetodotransporte(Metodostransporte metodotransporte) {
        Metodostransporte metodostransporte = Entidadesdocumentos.jdoGetmetodotransporte(this);
        Metodostransporte metodostransporte2 = metodotransporte;
        Entidadesdocumentos.jdoSetmetodotransporte(this, metodostransporte2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_metodotransporte, (Object)metodostransporte, (Object)metodostransporte2);
    }

    public Viaturas getViatura() {
        return Entidadesdocumentos.jdoGetviatura(this);
    }

    public void setViatura(Viaturas viatura) {
        Viaturas viaturas = Entidadesdocumentos.jdoGetviatura(this);
        Viaturas viaturas2 = viatura;
        Entidadesdocumentos.jdoSetviatura(this, viaturas2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_viatura, (Object)viaturas, (Object)viaturas2);
        if (changed && this.cascade && viatura != null) {
            this.setExpedicao(viatura.getDescricao());
            this.setMatricula(viatura.getMatricula());
        }
    }

    public Moedas getMoeda() {
        return Entidadesdocumentos.jdoGetmoeda(this);
    }

    public void setMoeda(Moedas moeda) {
        Moedas moedas = Entidadesdocumentos.jdoGetmoeda(this);
        Moedas moedas2 = moeda;
        Entidadesdocumentos.jdoSetmoeda(this, moedas2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_moeda, (Object)moedas, (Object)moedas2);
        if (changed && this.cascade && moeda != null) {
            this.setCambio(this.manager.loadMoedascambios(moeda.getCodigo(), 0));
        }
    }

    public Moedascambios getCambio() {
        return Entidadesdocumentos.jdoGetcambio(this);
    }

    public void setCambio(Moedascambios cambio) {
        Moedascambios moedascambios = Entidadesdocumentos.jdoGetcambio(this);
        Moedascambios moedascambios2 = cambio;
        Entidadesdocumentos.jdoSetcambio(this, moedascambios2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_cambio, (Object)moedascambios, (Object)moedascambios2);
        if (changed) {
            this.firePropertyChange(FIELDS.entidadesdocumentos_totalcambio);
        }
    }

    public boolean isCambioValid() {
        return Entidadesdocumentos.jdoGetcambio(this).getMoeda().equals(Entidadesdocumentos.jdoGetmoeda(this));
    }

    public Date getDatasistema() {
        return Entidadesdocumentos.jdoGetdatasistema(this);
    }

    public Date getDatasistemaWithTime() {
        return TimeDateUtils.getDateWithTime((Date)Entidadesdocumentos.jdoGetdatasistema(this), (Time)Entidadesdocumentos.jdoGethorasistema(this));
    }

    public String getDatasistemaToText() {
        return Entidadesdocumentos.jdoGetdatasistema(this) == null ? "" : FIELDS.entidadesdocumentos_datasistema.format.format(Entidadesdocumentos.jdoGetdatasistema(this));
    }

    public void setDatasistema(Date datasistema) {
        Date date = Entidadesdocumentos.jdoGetdatasistema(this);
        Date date2 = TimeDateUtils.getDateWithoutTime((Date)datasistema);
        Entidadesdocumentos.jdoSetdatasistema(this, date2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_datasistema, (Object)date, (Object)date2);
        this.setHorasistema(TimeDateUtils.getTime((Date)datasistema));
    }

    public Time getHorasistema() {
        return Entidadesdocumentos.jdoGethorasistema(this);
    }

    public String getHorasistemaToText() {
        return Entidadesdocumentos.jdoGethorasistema(this) == null ? "" : FIELDS.entidadesdocumentos_horasistema.format.format(Entidadesdocumentos.jdoGethorasistema(this));
    }

    public void setHorasistema(Time horasistema) {
        Time time = Entidadesdocumentos.jdoGethorasistema(this);
        Time time2 = horasistema;
        Entidadesdocumentos.jdoSethorasistema(this, time2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_horasistema, (Object)time, (Object)time2);
    }

    @Override
    public Date getDatacriacao() {
        return Entidadesdocumentos.jdoGetdatacriacao(this);
    }

    public Date getDatacriacaoWithTime() {
        return TimeDateUtils.getDateWithTime((Date)Entidadesdocumentos.jdoGetdatacriacao(this), (Time)Entidadesdocumentos.jdoGethoracriacao(this));
    }

    public String getDatacriacaoToText() {
        return Entidadesdocumentos.jdoGetdatacriacao(this) == null ? "" : FIELDS.entidadesdocumentos_datacriacao.format.format(Entidadesdocumentos.jdoGetdatacriacao(this));
    }

    public void setDatacriacao(Date datacriacao) {
        boolean changed = !Entidadesdocumentos.equals(datacriacao, Entidadesdocumentos.jdoGetdatacriacao(this));
        Date date = Entidadesdocumentos.jdoGetdatacriacao(this);
        Date date2 = TimeDateUtils.getDateWithoutTime((Date)datacriacao);
        Entidadesdocumentos.jdoSetdatacriacao(this, date2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_datacriacao, (Object)date, (Object)date2);
        if (changed && this.cascade && datacriacao != null) {
            this.setDataauxiliar(datacriacao);
        }
    }

    public boolean isDatacriacaoEditable() {
        return this.manager.getUtilizador().isGestor();
    }

    public Date getDatadocumento() {
        switch (Entidadesdocumentos.jdoGettipodocumento(this).getTipoentidade().getTipoentidade()) {
            case 0: {
                return Entidadesdocumentos.jdoGetdatacriacao(this);
            }
            case 1: {
                switch (this.manager.getParametros().getDataregisto()) {
                    case 0: {
                        return Entidadesdocumentos.jdoGetdatacriacao(this);
                    }
                    case 1: {
                        return Entidadesdocumentos.jdoGetdataauxiliar(this);
                    }
                }
            }
        }
        return null;
    }

    public Time getHoracriacao() {
        return Entidadesdocumentos.jdoGethoracriacao(this);
    }

    public String getHoracriacaoToText() {
        return Entidadesdocumentos.jdoGethoracriacao(this) == null ? "" : FIELDS.entidadesdocumentos_horacriacao.format.format(Entidadesdocumentos.jdoGethoracriacao(this));
    }

    public void setHoracriacao(Time horacriacao) {
        Time time = Entidadesdocumentos.jdoGethoracriacao(this);
        Time time2 = TimeDateUtils.getTimeWithoutSeconds((Time)horacriacao);
        Entidadesdocumentos.jdoSethoracriacao(this, time2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_horacriacao, (Object)time, (Object)time2);
    }

    public Date getDataauxiliar() {
        return Entidadesdocumentos.jdoGetdataauxiliar(this);
    }

    public String getDataauxiliarToText() {
        return Entidadesdocumentos.jdoGetdataauxiliar(this) == null ? "" : FIELDS.entidadesdocumentos_dataauxiliar.format.format(Entidadesdocumentos.jdoGetdataauxiliar(this));
    }

    public void setDataauxiliar(Date dataauxiliar) {
        boolean changed = !Entidadesdocumentos.equals(dataauxiliar, Entidadesdocumentos.jdoGetdataauxiliar(this));
        Date date = Entidadesdocumentos.jdoGetdataauxiliar(this);
        Date date2 = TimeDateUtils.getDateWithoutTime((Date)dataauxiliar);
        Entidadesdocumentos.jdoSetdataauxiliar(this, date2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_dataauxiliar, (Object)date, (Object)date2);
        if (changed && this.cascade && dataauxiliar != null) {
            this.setDatacarga(TimeDateUtils.addMinutes((Date)this.getDatadocumento(), (int)5));
            this.setDatadescarga(TimeDateUtils.addMinutes((Date)this.getDatadocumento(), (int)60));
            this.setDatavencimento(this.getDatadocumento(), Entidadesdocumentos.jdoGetcondicaopagamento(this).getPeriodo());
        }
    }

    public Date getDatavencimento() {
        return Entidadesdocumentos.jdoGetdatavencimento(this);
    }

    public String getDatavencimentoToText() {
        return Entidadesdocumentos.jdoGetdatavencimento(this) == null ? "" : FIELDS.entidadesdocumentos_datavencimento.format.format(Entidadesdocumentos.jdoGetdatavencimento(this));
    }

    public void setDatavencimento(Date datavencimento) {
        Date date = Entidadesdocumentos.jdoGetdatavencimento(this);
        Date date2 = TimeDateUtils.getDateWithoutTime((Date)datavencimento);
        Entidadesdocumentos.jdoSetdatavencimento(this, date2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_datavencimento, (Object)date, (Object)date2);
    }

    public void setDatavencimento(Date datavencimento, int periodo) {
        this.setDatavencimento(datavencimento == null ? TimeDateUtils.getCurrentDate() : TimeDateUtils.addDays((Date)datavencimento, (int)periodo));
    }

    public boolean isVencido() {
        return !Entidadesdocumentos.jdoGetdatavencimento(this).after(TimeDateUtils.getDateWithoutTime());
    }

    public Date getDatacarga() {
        return Entidadesdocumentos.jdoGetdatacarga(this);
    }

    public Date getDatacargaWithTime() {
        return TimeDateUtils.getDateWithTime((Date)Entidadesdocumentos.jdoGetdatacarga(this), (Time)Entidadesdocumentos.jdoGethoracarga(this));
    }

    public String getDatacargaToText() {
        return Entidadesdocumentos.jdoGetdatacarga(this) == null ? "" : FIELDS.entidadesdocumentos_datacarga.format.format(Entidadesdocumentos.jdoGetdatacarga(this));
    }

    public void setDatacarga(Date datacarga) {
        Date date = Entidadesdocumentos.jdoGetdatacarga(this);
        Date date2 = TimeDateUtils.getDateWithoutTime((Date)datacarga);
        Entidadesdocumentos.jdoSetdatacarga(this, date2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_datacarga, (Object)date, (Object)date2);
    }

    public Time getHoracarga() {
        return Entidadesdocumentos.jdoGethoracarga(this);
    }

    public String getHoracargaToText() {
        return Entidadesdocumentos.jdoGethoracarga(this) == null ? "" : FIELDS.entidadesdocumentos_horacarga.format.format(Entidadesdocumentos.jdoGethoracarga(this));
    }

    public void setHoracarga(Time horacarga) {
        Time time = Entidadesdocumentos.jdoGethoracarga(this);
        Time time2 = TimeDateUtils.getTimeWithoutSeconds((Time)horacarga);
        Entidadesdocumentos.jdoSethoracarga(this, time2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_horacarga, (Object)time, (Object)time2);
    }

    public Date getDatadescarga() {
        return Entidadesdocumentos.jdoGetdatadescarga(this);
    }

    public Date getDatadescargaWithTime() {
        return TimeDateUtils.getDateWithTime((Date)Entidadesdocumentos.jdoGetdatadescarga(this), (Time)Entidadesdocumentos.jdoGethoradescarga(this));
    }

    public String getDatadescargaToText() {
        return Entidadesdocumentos.jdoGetdatadescarga(this) == null ? "" : FIELDS.entidadesdocumentos_datadescarga.format.format(Entidadesdocumentos.jdoGetdatadescarga(this));
    }

    public void setDatadescarga(Date datadescarga) {
        Date date = Entidadesdocumentos.jdoGetdatadescarga(this);
        Date date2 = TimeDateUtils.getDateWithoutTime((Date)datadescarga);
        Entidadesdocumentos.jdoSetdatadescarga(this, date2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_datadescarga, (Object)date, (Object)date2);
    }

    public Time getHoradescarga() {
        return Entidadesdocumentos.jdoGethoradescarga(this);
    }

    public String getHoradescargaToText() {
        return Entidadesdocumentos.jdoGethoradescarga(this) == null ? "" : FIELDS.entidadesdocumentos_horadescarga.format.format(Entidadesdocumentos.jdoGethoradescarga(this));
    }

    public void setHoradescarga(Time horadescarga) {
        Time time = Entidadesdocumentos.jdoGethoradescarga(this);
        Time time2 = TimeDateUtils.getTimeWithoutSeconds((Time)horadescarga);
        Entidadesdocumentos.jdoSethoradescarga(this, time2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_horadescarga, (Object)time, (Object)time2);
    }

    public Date getDataenvio() {
        return Entidadesdocumentos.jdoGetwebservice(this).size() == 0 ? Entidadesdocumentos.jdoGetdataenvio(this) : this.getWebservice(0).getDataenvio();
    }

    public Time getHoraenvio() {
        return Entidadesdocumentos.jdoGetwebservice(this).size() == 0 ? Entidadesdocumentos.jdoGethoraenvio(this) : this.getWebservice(0).getHoraenvio();
    }

    public String getHash() {
        return Entidadesdocumentos.jdoGethash(this);
    }

    public String getHashToText() {
        return this.isAssinado() ? Entidadesdocumentos.jdoGethash(this) : "0";
    }

    public void setHash(String hash) {
        String string = Entidadesdocumentos.jdoGethash(this);
        String string2 = hash;
        Entidadesdocumentos.jdoSethash(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_hash, (Object)string, (Object)string2);
    }

    public void setHash(Entidadesdocumentos previous) throws SignatureException {
        this.setHash(this.isTipodocumentosaftCertificado() ? RSAKEYS.PRIVATE.CERTIFICACAO.sign(this.createHashMessage(previous)) : "");
    }

    public boolean isAssinado() {
        return !StringUtils.isEmpty((String)Entidadesdocumentos.jdoGethash(this));
    }

    public String getHashCheckdigits() {
        return this.isAssinado() ? new String(new char[]{Entidadesdocumentos.jdoGethash(this).charAt(0), Entidadesdocumentos.jdoGethash(this).charAt(10), Entidadesdocumentos.jdoGethash(this).charAt(20), Entidadesdocumentos.jdoGethash(this).charAt(30)}) : "";
    }

    public boolean isHashValid() {
        return this.isHashValid(this.isEdited() ? this.manager.loadEntidadesdocumentos$Previous(Entidadesdocumentos.jdoGettipodocumento(this).getCodigo(), Entidadesdocumentos.jdoGetseriedocumento(this).getSerie(), Entidadesdocumentos.jdoGetnumerodocumento(this), new int[0]) : null);
    }

    private boolean isHashValid(Entidadesdocumentos previous) {
        return !this.isAssinado() || RSAKEYS.PUBLIC.CERTIFICACAO.verify(Entidadesdocumentos.jdoGethash(this), this.createHashMessage(previous));
    }

    private String createHashMessage(Entidadesdocumentos previous) {
        StringBuilder sb = new StringBuilder(ATMessageFormatter.getInvoiceDate(Entidadesdocumentos.jdoGetdatacriacao(this))).append(';').append(ATMessageFormatter.getSystemEntryDate(this.getDatasistemaWithTime())).append(';').append(this.toString()).append(';').append(ATMessageFormatter.getGrossTotal(Entidadesdocumentos.jdoGettotalbruto(this)).toPlainString()).append(';');
        if (previous != null) {
            sb.append(Entidadesdocumentos.jdoGethash(previous));
        }
        return sb.toString();
    }

    public String getCodigovalidacao() {
        return Entidadesdocumentos.jdoGetcodigovalidacao(this);
    }

    public String getCodigovalidacaoToText() {
        return Entidadesdocumentos.jdoGetcodigovalidacao(this) == null ? "" : Entidadesdocumentos.jdoGetcodigovalidacao(this).toString();
    }

    public void setCodigovalidacao(String codigovalidacao) {
        String string = Entidadesdocumentos.jdoGetcodigovalidacao(this);
        String string2 = codigovalidacao;
        Entidadesdocumentos.jdoSetcodigovalidacao(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_codigovalidacao, (Object)string, (Object)string2);
    }

    public boolean hasCodigovalidacao() {
        return !StringUtils.isEmpty((String)Entidadesdocumentos.jdoGetcodigovalidacao(this));
    }

    public boolean needsCodigovalidacao() {
        Documentosseries serie;
        Documentosseries documentosseries = serie = Entidadesdocumentos.jdoGetseriedocumento(this) == null ? null : this.manager.loadDocumentosseries(Entidadesdocumentos.jdoGetseriedocumento(this).getKey());
        return !this.isEdited() && serie != null && serie.needsCodigovalidacao();
    }

    public boolean isCodigovalidacaoValid() {
        Documentosseries serie;
        Documentosseries documentosseries = serie = Entidadesdocumentos.jdoGetseriedocumento(this) == null ? null : this.manager.loadDocumentosseries(Entidadesdocumentos.jdoGetseriedocumento(this).getKey());
        return this.isEdited() || serie != null && serie.getCodigovalidacao().equals(Entidadesdocumentos.jdoGetcodigovalidacao(this));
    }

    @Override
    public String getATCUD() {
        return this.hasCodigovalidacao() ? String.valueOf(Entidadesdocumentos.jdoGetcodigovalidacao(this)) + "-" + Entidadesdocumentos.jdoGetnumerodocumento(this) : "0";
    }

    @Override
    public byte[] getATQRCode() {
        BufferedImage image = new ATQRCodeFieldList(this).toImage();
        return new RenderedImageHandler((RenderedImage)image).getBytes("png");
    }

    @Override
    public String getDocumentcode() {
        return Entidadesdocumentos.jdoGetdocumentcode(this);
    }

    public String getDocumentcodeToText() {
        return Entidadesdocumentos.jdoGetdocumentcode(this) == null ? "" : Entidadesdocumentos.jdoGetdocumentcode(this).toString();
    }

    public void setDocumentcode(String documentcode) {
        String string = Entidadesdocumentos.jdoGetdocumentcode(this);
        String string2 = documentcode;
        Entidadesdocumentos.jdoSetdocumentcode(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_documentcode, (Object)string, (Object)string2);
    }

    public boolean hasDocumentcode() {
        return !StringUtils.isEmpty((String)Entidadesdocumentos.jdoGetdocumentcode(this));
    }

    public boolean isDocumentcodeEditable() {
        return Colibri.VERSION_TYPE != Colibri.VERSIONS.SERVER || this.manager.getUtilizador().isColibri();
    }

    public String getNumeroauxiliar() {
        return Entidadesdocumentos.jdoGetnumeroauxiliar(this);
    }

    public String getNumeroauxiliarToText() {
        return Entidadesdocumentos.jdoGetnumeroauxiliar(this) == null ? "" : Entidadesdocumentos.jdoGetnumeroauxiliar(this).toString();
    }

    public void setNumeroauxiliar(String numeroauxiliar) {
        String string = Entidadesdocumentos.jdoGetnumeroauxiliar(this);
        String string2 = numeroauxiliar;
        Entidadesdocumentos.jdoSetnumeroauxiliar(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_numeroauxiliar, (Object)string, (Object)string2);
    }

    public boolean isNumeroauxiliarValid() {
        if (Entidadesdocumentos.jdoGetseriedocumento(this) != null) {
            switch (Entidadesdocumentos.jdoGetseriedocumento(this).getIntegracao()) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: {
                    return FIELDS.PATTERNS.NUMERO_AUXILIAR.matches(Entidadesdocumentos.jdoGetnumeroauxiliar(this));
                }
            }
        }
        return FIELDS.entidadesdocumentos_numeroauxiliar.isValid(Entidadesdocumentos.jdoGetnumeroauxiliar(this));
    }

    public String getNome() {
        return Entidadesdocumentos.jdoGetnome(this);
    }

    public String getNomeToText() {
        return Entidadesdocumentos.jdoGetnome(this) == null ? "" : Entidadesdocumentos.jdoGetnome(this).toString();
    }

    public void setNome(String nome) {
        String string = Entidadesdocumentos.jdoGetnome(this);
        String string2 = nome;
        Entidadesdocumentos.jdoSetnome(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_nome, (Object)string, (Object)string2);
    }

    public String getMorada() {
        return Entidadesdocumentos.jdoGetmorada(this);
    }

    public String getMoradaToText() {
        return Entidadesdocumentos.jdoGetmorada(this) == null ? "" : FIELDS.entidadesdocumentos_morada.format.format(Entidadesdocumentos.jdoGetmorada(this));
    }

    public void setMorada(String morada) {
        String string = Entidadesdocumentos.jdoGetmorada(this);
        String string2 = morada;
        Entidadesdocumentos.jdoSetmorada(this, string2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_morada, (Object)string, (Object)string2);
        if (changed && this.cascade && morada != null) {
            switch (Entidadesdocumentos.jdoGettipodocumento(this).getMovimentaartigos()) {
                case 0: {
                    switch (Entidadesdocumentos.jdoGettipodocumento(this).getTipoentidade().getTipoentidade()) {
                        case 0: {
                            this.setLocaldescarga(morada);
                            break;
                        }
                        case 1: {
                            this.setLocalcarga(morada);
                        }
                    }
                    break;
                }
                case 1: {
                    this.setLocaldescarga(morada);
                    break;
                }
                case 2: 
                case 3: {
                    this.setLocalcarga(morada);
                }
            }
        }
    }

    public void setMorada(Entidadesmoradas morada) {
        this.setMorada(morada, morada.getTipomorada().getTipo());
    }

    public void setMorada(int tipo) {
        Entidadesmoradas morada = Entidadesdocumentos.jdoGetentidade(this).getMoradas$Tipo(tipo);
        this.setMorada(morada == null ? Entidadesdocumentos.jdoGetentidade(this).getMoradas(0) : morada, tipo);
    }

    public void setMorada(Entidadesmoradas morada, int tipo) {
        block0 : switch (tipo) {
            case 0: {
                this.setMorada(morada.getMorada());
                this.setCodigopostal(morada.getCodigopostal());
                this.setLocalidade(morada.getLocalidade());
                this.setPais(morada.getPais());
                break;
            }
            case 1: 
            case 2: {
                if (Entidadesdocumentos.jdoGettipodocumento(this).isTipodocumento(2)) break;
                switch (Entidadesdocumentos.jdoGettipodocumento(this).getMovimentaartigos()) {
                    case 0: {
                        switch (Entidadesdocumentos.jdoGettipodocumento(this).getTipoentidade().getTipoentidade()) {
                            case 0: {
                                this.setMoradadescarga(morada);
                                break block0;
                            }
                            case 1: {
                                this.setMoradacarga(morada);
                            }
                        }
                        break block0;
                    }
                    case 1: {
                        this.setMoradadescarga(morada);
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        this.setMoradacarga(morada);
                    }
                }
            }
        }
    }

    public void setMoradacarga(Entidadesmoradas morada) {
        this.setLocalcarga(morada.getMorada());
        this.setCodigopostalcarga(morada.getCodigopostal());
        this.setPaiscarga(morada.getPais());
    }

    public void setMoradadescarga(Entidadesmoradas morada) {
        this.setLocaldescarga(morada.getMorada());
        this.setCodigopostaldescarga(morada.getCodigopostal());
        this.setPaisdescarga(morada.getPais());
    }

    public String getLocalidade() {
        return Entidadesdocumentos.jdoGetlocalidade(this);
    }

    public String getLocalidadeToText() {
        return Entidadesdocumentos.jdoGetlocalidade(this) == null ? "" : Entidadesdocumentos.jdoGetlocalidade(this).toString();
    }

    public void setLocalidade(String localidade) {
        String string = Entidadesdocumentos.jdoGetlocalidade(this);
        String string2 = localidade;
        Entidadesdocumentos.jdoSetlocalidade(this, string2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_localidade, (Object)string, (Object)string2);
        if (changed && this.cascade && localidade != null && Entidadesdocumentos.jdoGetcodigopostal(this) != null) {
            Entidadesdocumentos.jdoGetcodigopostal(this).setDescricao(localidade);
        }
    }

    public String getLocalidadecarga() {
        return this.getLocalidadecargaToText();
    }

    public String getLocalidadecargaToText() {
        return Entidadesdocumentos.jdoGetcodigopostalcarga(this) == null ? "" : Entidadesdocumentos.jdoGetcodigopostalcarga(this).getDescricaoToText();
    }

    public String getLocalidadedescarga() {
        return this.getLocalidadedescargaToText();
    }

    public String getLocalidadedescargaToText() {
        return Entidadesdocumentos.jdoGetcodigopostaldescarga(this) == null ? "" : Entidadesdocumentos.jdoGetcodigopostaldescarga(this).getDescricaoToText();
    }

    public String getNif() {
        return Entidadesdocumentos.jdoGetnif(this);
    }

    public String getNifToText() {
        return Entidadesdocumentos.jdoGetnif(this) == null ? "" : Entidadesdocumentos.jdoGetnif(this).toString();
    }

    public void setNif(String nif) {
        String string = Entidadesdocumentos.jdoGetnif(this);
        String string2 = nif;
        Entidadesdocumentos.jdoSetnif(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_nif, (Object)string, (Object)string2);
    }

    public String getNifToNumbers() {
        return StringUtils.numbers((String)this.getNifToText());
    }

    public Integer getNifToInteger() {
        return StringUtils.val((String)this.getNifToNumbers());
    }

    public String getNifParsed() {
        return Entidadesdocumentos.jdoGetpais(this) == null ? this.getNifToText() : Entidadesdocumentos.jdoGetpais(this).parseNif(Entidadesdocumentos.jdoGetnif(this));
    }

    public boolean isNifEqual(Paises pais, String nif) {
        return pais != null && Entidadesdocumentos.jdoGetpais(this).equals(pais) && pais.parseNif(nif).equals(this.getNifParsed());
    }

    public boolean isNifValid() {
        return Entidadesdocumentos.jdoGetpais(this) != null && Entidadesdocumentos.jdoGetentidade(this) != null && Entidadesdocumentos.jdoGetpais(this).isNifValid(Entidadesdocumentos.jdoGetnif(this)) && (Entidadesdocumentos.jdoGetentidade(this).isNifEqual(Entidadesdocumentos.jdoGetpais(this), Entidadesdocumentos.jdoGetnif(this)) || Entidadesdocumentos.jdoGetentidade(this).isNifGenerico());
    }

    public boolean isNifGenerico() {
        return Entidadesdocumentos.jdoGetpais(this) != null && Entidadesdocumentos.jdoGetpais(this).isNifGenerico(Entidadesdocumentos.jdoGetnif(this));
    }

    public String getExpedicao() {
        return Entidadesdocumentos.jdoGetexpedicao(this);
    }

    public String getExpedicaoToText() {
        return Entidadesdocumentos.jdoGetexpedicao(this) == null ? "" : Entidadesdocumentos.jdoGetexpedicao(this).toString();
    }

    public void setExpedicao(String expedicao) {
        String string = Entidadesdocumentos.jdoGetexpedicao(this);
        String string2 = expedicao;
        Entidadesdocumentos.jdoSetexpedicao(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_expedicao, (Object)string, (Object)string2);
    }

    public String getMatricula() {
        return Entidadesdocumentos.jdoGetmatricula(this);
    }

    public String getMatriculaToText() {
        return Entidadesdocumentos.jdoGetmatricula(this) == null ? "" : Entidadesdocumentos.jdoGetmatricula(this).toString();
    }

    public void setMatricula(String matricula) {
        String string = Entidadesdocumentos.jdoGetmatricula(this);
        String string2 = matricula;
        Entidadesdocumentos.jdoSetmatricula(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_matricula, (Object)string, (Object)string2);
    }

    public String getLocalcarga() {
        return Entidadesdocumentos.jdoGetlocalcarga(this);
    }

    public String getLocalcargaToText() {
        return Entidadesdocumentos.jdoGetlocalcarga(this) == null ? "" : FIELDS.entidadesdocumentos_localcarga.format.format(Entidadesdocumentos.jdoGetlocalcarga(this));
    }

    public void setLocalcarga(String localcarga) {
        String string = Entidadesdocumentos.jdoGetlocalcarga(this);
        String string2 = localcarga;
        Entidadesdocumentos.jdoSetlocalcarga(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_localcarga, (Object)string, (Object)string2);
    }

    public String getLocaldescarga() {
        return Entidadesdocumentos.jdoGetlocaldescarga(this);
    }

    public String getLocaldescargaToText() {
        return Entidadesdocumentos.jdoGetlocaldescarga(this) == null ? "" : FIELDS.entidadesdocumentos_localdescarga.format.format(Entidadesdocumentos.jdoGetlocaldescarga(this));
    }

    public void setLocaldescarga(String localdescarga) {
        String string = Entidadesdocumentos.jdoGetlocaldescarga(this);
        String string2 = localdescarga;
        Entidadesdocumentos.jdoSetlocaldescarga(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_localdescarga, (Object)string, (Object)string2);
    }

    public String getDadostransporte() {
        return Entidadesdocumentos.jdoGetdadostransporte(this);
    }

    public String getDadostransporteToText() {
        return Entidadesdocumentos.jdoGetdadostransporte(this) == null ? "" : Entidadesdocumentos.jdoGetdadostransporte(this).toString();
    }

    public void setDadostransporte(String dadostransporte) {
        String string = Entidadesdocumentos.jdoGetdadostransporte(this);
        String string2 = dadostransporte;
        Entidadesdocumentos.jdoSetdadostransporte(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_dadostransporte, (Object)string, (Object)string2);
    }

    public String getMarcas() {
        return Entidadesdocumentos.jdoGetmarcas(this);
    }

    public String getMarcasToText() {
        return Entidadesdocumentos.jdoGetmarcas(this) == null ? "" : Entidadesdocumentos.jdoGetmarcas(this).toString();
    }

    public void setMarcas(String marcas) {
        String string = Entidadesdocumentos.jdoGetmarcas(this);
        String string2 = marcas;
        Entidadesdocumentos.jdoSetmarcas(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_marcas, (Object)string, (Object)string2);
    }

    public String getObs() {
        return Entidadesdocumentos.jdoGetobs(this);
    }

    public String getObsToText() {
        return Entidadesdocumentos.jdoGetobs(this) == null ? "" : FIELDS.entidadesdocumentos_obs.format.format(Entidadesdocumentos.jdoGetobs(this));
    }

    public StringList getObsToList() {
        return StringUtils.split((String)this.getObsToText(), (String)FieldFormat.SEPARATOR.SEMICOLON.value);
    }

    public void setObs(String obs) {
        String string = Entidadesdocumentos.jdoGetobs(this);
        String string2 = obs;
        Entidadesdocumentos.jdoSetobs(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_obs, (Object)string, (Object)string2);
    }

    public String getReturnmessage() {
        return Entidadesdocumentos.jdoGetwebservice(this).size() == 0 ? Entidadesdocumentos.jdoGetreturnmessage(this) : this.getWebservice(0).getMensagem();
    }

    public String getCampo1() {
        return Entidadesdocumentos.jdoGetcampo1(this);
    }

    public String getCampo1ToText() {
        return Entidadesdocumentos.jdoGetcampo1(this) == null ? "" : Entidadesdocumentos.jdoGetcampo1(this).toString();
    }

    public void setCampo1(String campo1) {
        String string = Entidadesdocumentos.jdoGetcampo1(this);
        String string2 = campo1;
        Entidadesdocumentos.jdoSetcampo1(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_campo1, (Object)string, (Object)string2);
    }

    public String getCampo2() {
        return Entidadesdocumentos.jdoGetcampo2(this);
    }

    public String getCampo2ToText() {
        return Entidadesdocumentos.jdoGetcampo2(this) == null ? "" : Entidadesdocumentos.jdoGetcampo2(this).toString();
    }

    public void setCampo2(String campo2) {
        String string = Entidadesdocumentos.jdoGetcampo2(this);
        String string2 = campo2;
        Entidadesdocumentos.jdoSetcampo2(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_campo2, (Object)string, (Object)string2);
    }

    public String getCampo3() {
        return Entidadesdocumentos.jdoGetcampo3(this);
    }

    public String getCampo3ToText() {
        return Entidadesdocumentos.jdoGetcampo3(this) == null ? "" : Entidadesdocumentos.jdoGetcampo3(this).toString();
    }

    public void setCampo3(String campo3) {
        String string = Entidadesdocumentos.jdoGetcampo3(this);
        String string2 = campo3;
        Entidadesdocumentos.jdoSetcampo3(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_campo3, (Object)string, (Object)string2);
    }

    public String getCampo4() {
        return Entidadesdocumentos.jdoGetcampo4(this);
    }

    public String getCampo4ToText() {
        return Entidadesdocumentos.jdoGetcampo4(this) == null ? "" : Entidadesdocumentos.jdoGetcampo4(this).toString();
    }

    public void setCampo4(String campo4) {
        String string = Entidadesdocumentos.jdoGetcampo4(this);
        String string2 = campo4;
        Entidadesdocumentos.jdoSetcampo4(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_campo4, (Object)string, (Object)string2);
    }

    public String getCampo5() {
        return Entidadesdocumentos.jdoGetcampo5(this);
    }

    public String getCampo5ToText() {
        return Entidadesdocumentos.jdoGetcampo5(this) == null ? "" : Entidadesdocumentos.jdoGetcampo5(this).toString();
    }

    public void setCampo5(String campo5) {
        String string = Entidadesdocumentos.jdoGetcampo5(this);
        String string2 = campo5;
        Entidadesdocumentos.jdoSetcampo5(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_campo5, (Object)string, (Object)string2);
    }

    public String getCampo6() {
        return Entidadesdocumentos.jdoGetcampo6(this);
    }

    public String getCampo6ToText() {
        return Entidadesdocumentos.jdoGetcampo6(this) == null ? "" : Entidadesdocumentos.jdoGetcampo6(this).toString();
    }

    public void setCampo6(String campo6) {
        String string = Entidadesdocumentos.jdoGetcampo6(this);
        String string2 = campo6;
        Entidadesdocumentos.jdoSetcampo6(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_campo6, (Object)string, (Object)string2);
    }

    public String getCampo7() {
        return Entidadesdocumentos.jdoGetcampo7(this);
    }

    public String getCampo7ToText() {
        return Entidadesdocumentos.jdoGetcampo7(this) == null ? "" : Entidadesdocumentos.jdoGetcampo7(this).toString();
    }

    public void setCampo7(String campo7) {
        String string = Entidadesdocumentos.jdoGetcampo7(this);
        String string2 = campo7;
        Entidadesdocumentos.jdoSetcampo7(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_campo7, (Object)string, (Object)string2);
    }

    public String getCampo8() {
        return Entidadesdocumentos.jdoGetcampo8(this);
    }

    public String getCampo8ToText() {
        return Entidadesdocumentos.jdoGetcampo8(this) == null ? "" : Entidadesdocumentos.jdoGetcampo8(this).toString();
    }

    public void setCampo8(String campo8) {
        String string = Entidadesdocumentos.jdoGetcampo8(this);
        String string2 = campo8;
        Entidadesdocumentos.jdoSetcampo8(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_campo8, (Object)string, (Object)string2);
    }

    public String getCampo9() {
        return Entidadesdocumentos.jdoGetcampo9(this);
    }

    public String getCampo9ToText() {
        return Entidadesdocumentos.jdoGetcampo9(this) == null ? "" : Entidadesdocumentos.jdoGetcampo9(this).toString();
    }

    public void setCampo9(String campo9) {
        String string = Entidadesdocumentos.jdoGetcampo9(this);
        String string2 = campo9;
        Entidadesdocumentos.jdoSetcampo9(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_campo9, (Object)string, (Object)string2);
    }

    public String getCampo10() {
        return Entidadesdocumentos.jdoGetcampo10(this);
    }

    public String getCampo10ToText() {
        return Entidadesdocumentos.jdoGetcampo10(this) == null ? "" : Entidadesdocumentos.jdoGetcampo10(this).toString();
    }

    public void setCampo10(String campo10) {
        String string = Entidadesdocumentos.jdoGetcampo10(this);
        String string2 = campo10;
        Entidadesdocumentos.jdoSetcampo10(this, string2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_campo10, (Object)string, (Object)string2);
    }

    public Integer getHashcontrol() {
        return Entidadesdocumentos.jdoGethashcontrol(this);
    }

    public String getHashcontrolToText() {
        switch (Entidadesdocumentos.jdoGetseriedocumento(this).getIntegracao()) {
            case 0: {
                return String.valueOf(Entidadesdocumentos.jdoGethashcontrol(this));
            }
            case 1: {
                return String.valueOf(String.valueOf(Entidadesdocumentos.jdoGethashcontrol(this))) + "-" + Entidadesdocumentos.jdoGettipodocumento(this).getCodigo() + "M " + Entidadesdocumentos.jdoGetnumeroauxiliar(this);
            }
            case 2: {
                return String.valueOf(String.valueOf(Entidadesdocumentos.jdoGethashcontrol(this))) + "-" + Entidadesdocumentos.jdoGettipodocumento(this).getCodigo() + "D " + Entidadesdocumentos.jdoGetnumeroauxiliar(this);
            }
            case 3: {
                return "?.?";
            }
        }
        return "";
    }

    public void setHashcontrol(Integer hashcontrol) {
        Integer n = Entidadesdocumentos.jdoGethashcontrol(this);
        Integer n2 = hashcontrol;
        Entidadesdocumentos.jdoSethashcontrol(this, n2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_hashcontrol, (Object)n, (Object)n2);
    }

    @Override
    public Integer getContadorvias() {
        return Entidadesdocumentos.jdoGetcontadorvias(this);
    }

    public String getContadorviasToText() {
        return Entidadesdocumentos.jdoGetcontadorvias(this) == null ? "" : Entidadesdocumentos.jdoGetcontadorvias(this).toString();
    }

    public void setContadorvias(Integer contadorvias) {
        Integer n = Entidadesdocumentos.jdoGetcontadorvias(this);
        Integer n2 = contadorvias;
        Entidadesdocumentos.jdoSetcontadorvias(this, n2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_contadorvias, (Object)n, (Object)n2);
    }

    @Override
    public void incrementContadorvias() {
        this.manager.incrementEntidadesdocumentos(Entidadesdocumentos.jdoGetkey(this), FIELDS.entidadesdocumentos_contadorvias);
    }

    public boolean hasContadorvias() {
        return this.isTipodocumentosaftCertificado() && !this.isEstado(1) && Entidadesdocumentos.jdoGetcontadorvias(this) > 0;
    }

    public Integer getNumerodocumento() {
        return Entidadesdocumentos.jdoGetnumerodocumento(this);
    }

    public String getNumerodocumentoToText() {
        return Entidadesdocumentos.jdoGetnumerodocumento(this) == null ? "" : Entidadesdocumentos.jdoGetnumerodocumento(this).toString();
    }

    public void setNumerodocumento(Integer numerodocumento) {
        Integer n = Entidadesdocumentos.jdoGetnumerodocumento(this);
        Integer n2 = numerodocumento;
        Entidadesdocumentos.jdoSetnumerodocumento(this, n2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_numerodocumento, (Object)n, (Object)n2);
        this.setKey();
    }

    public Integer getNumerodocumento$Next() {
        return this.manager.getDocumentosseries$NextNumero(Entidadesdocumentos.jdoGettipodocumento(this).getCodigo(), Entidadesdocumentos.jdoGetseriedocumento(this) == null ? null : Entidadesdocumentos.jdoGetseriedocumento(this).getSerie());
    }

    public Integer getNumerodocumento$Default() {
        return Colibri.VERSION_TYPE == Colibri.VERSIONS.SERVER ? -1 : this.getNumerodocumento$Next();
    }

    public boolean isNumerodocumentoValid() {
        return FIELDS.entidadesdocumentos_numerodocumento.isValid(Entidadesdocumentos.jdoGetnumerodocumento(this)) && Entidadesdocumentos.jdoGetnumerodocumento(this) > 0 && Entidadesdocumentos.jdoGetseriedocumento(this) != null && Entidadesdocumentos.jdoGetnumerodocumento(this) <= Entidadesdocumentos.jdoGetseriedocumento(this).getNumero() + 1;
    }

    public boolean logNumerodocumento() throws Exception {
        return Entidadesdocumentos.jdoGetseriedocumento(this).logNumero();
    }

    public Integer getEmbalagens() {
        return Entidadesdocumentos.jdoGetembalagens(this);
    }

    public String getEmbalagensToText() {
        return Entidadesdocumentos.jdoGetembalagens(this) == null ? "" : Entidadesdocumentos.jdoGetembalagens(this).toString();
    }

    public void setEmbalagens(Integer embalagens) {
        Integer n = Entidadesdocumentos.jdoGetembalagens(this);
        Integer n2 = embalagens;
        Entidadesdocumentos.jdoSetembalagens(this, n2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_embalagens, (Object)n, (Object)n2);
    }

    public Integer getEstado() {
        return Entidadesdocumentos.jdoGetestado(this);
    }

    public String getEstadoToText() {
        return Entidadesdocumentos.jdoGetestado(this) == null ? "" : FIELDS.entidadesdocumentos_estado.values[Entidadesdocumentos.jdoGetestado(this)];
    }

    public void setEstado(Integer estado) {
        Integer n = Entidadesdocumentos.jdoGetestado(this);
        Integer n2 = estado;
        Entidadesdocumentos.jdoSetestado(this, n2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_estado, (Object)n, (Object)n2);
    }

    public boolean isEstado(Integer estado) {
        return Entidadesdocumentos.equals(estado, Entidadesdocumentos.jdoGetestado(this));
    }

    public Integer getEstadoenvio() {
        return Entidadesdocumentos.jdoGetestadoenvio(this);
    }

    public Integer getEstadoenvio$Default() {
        if (Entidadesdocumentos.jdoGettipodocumento(this).isTipodocumentosaftCertificado()) {
            block0 : switch (Entidadesdocumentos.jdoGettipodocumento(this).getServiceDocumentGroup()) {
                case UNSUPPORTED: {
                    break;
                }
                case INVOICE: {
                    switch (this.manager.getParametros().getAtwebservice()) {
                        case 1: {
                            return 1;
                        }
                        case 2: {
                            break block0;
                        }
                        case 3: {
                            return 1;
                        }
                    }
                    break;
                }
                case MOVEMENT: {
                    if (!Entidadesdocumentos.jdoGetpais(this).isPortugal()) break;
                    switch (this.manager.getParametros().getAtwebservice()) {
                        case 1: {
                            break block0;
                        }
                        case 2: {
                            return 1;
                        }
                        case 3: {
                            return 1;
                        }
                    }
                }
            }
        }
        return 0;
    }

    public String getEstadoenvioToText() {
        return Entidadesdocumentos.jdoGetestadoenvio(this) == null ? "" : FIELDS.entidadesdocumentos_estadoenvio.values[Entidadesdocumentos.jdoGetestadoenvio(this)];
    }

    public void setEstadoenvio(Integer estadoenvio) {
        Integer n = Entidadesdocumentos.jdoGetestadoenvio(this);
        Integer n2 = estadoenvio;
        Entidadesdocumentos.jdoSetestadoenvio(this, n2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_estadoenvio, (Object)n, (Object)n2);
    }

    public boolean isEstadoenvio(Integer estadoenvio) {
        return Entidadesdocumentos.equals(estadoenvio, Entidadesdocumentos.jdoGetestadoenvio(this));
    }

    public boolean isEstadoenvioEditable() {
        boolean registado;
        Entidadesdocumentosatws ws = this.getWebservice(0);
        boolean bl = registado = ws != null && ws.isRegistado();
        return !registado && this.manager.getUtilizador().isGestor() || this.manager.getUtilizador().isColibri();
    }

    public Integer getReturncode() {
        return Entidadesdocumentos.jdoGetwebservice(this).size() == 0 ? Entidadesdocumentos.jdoGetreturncode(this) : this.getWebservice(0).getResultado();
    }

    public BigDecimal getPesobruto() {
        return Entidadesdocumentos.jdoGetpesobruto(this);
    }

    public String getPesobrutoToText() {
        return Entidadesdocumentos.jdoGetpesobruto(this) == null ? "" : FIELDS.entidadesdocumentos_pesobruto.format.format(Entidadesdocumentos.jdoGetpesobruto(this));
    }

    public void setPesobruto(BigDecimal pesobruto) {
        BigDecimal bigDecimal = Entidadesdocumentos.jdoGetpesobruto(this);
        BigDecimal bigDecimal2 = pesobruto;
        Entidadesdocumentos.jdoSetpesobruto(this, bigDecimal2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_pesobruto, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getPesoliquido() {
        return Entidadesdocumentos.jdoGetpesoliquido(this);
    }

    public String getPesoliquidoToText() {
        return Entidadesdocumentos.jdoGetpesoliquido(this) == null ? "" : FIELDS.entidadesdocumentos_pesoliquido.format.format(Entidadesdocumentos.jdoGetpesoliquido(this));
    }

    public void setPesoliquido(BigDecimal pesoliquido) {
        BigDecimal bigDecimal = Entidadesdocumentos.jdoGetpesoliquido(this);
        BigDecimal bigDecimal2 = pesoliquido;
        Entidadesdocumentos.jdoSetpesoliquido(this, bigDecimal2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_pesoliquido, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getVolume() {
        return Entidadesdocumentos.jdoGetvolume(this);
    }

    public String getVolumeToText() {
        return Entidadesdocumentos.jdoGetvolume(this) == null ? "" : FIELDS.entidadesdocumentos_volume.format.format(Entidadesdocumentos.jdoGetvolume(this));
    }

    public void setVolume(BigDecimal volume) {
        BigDecimal bigDecimal = Entidadesdocumentos.jdoGetvolume(this);
        BigDecimal bigDecimal2 = volume;
        Entidadesdocumentos.jdoSetvolume(this, bigDecimal2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_volume, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getPercdesconto() {
        return Entidadesdocumentos.jdoGetpercdesconto(this);
    }

    public String getPercdescontoToText() {
        return Entidadesdocumentos.jdoGetpercdesconto(this) == null ? "" : FIELDS.entidadesdocumentos_percdesconto.format.format(Entidadesdocumentos.jdoGetpercdesconto(this));
    }

    public void setPercdesconto(BigDecimal percdesconto) {
        BigDecimal bigDecimal = Entidadesdocumentos.jdoGetpercdesconto(this);
        BigDecimal bigDecimal2 = percdesconto;
        Entidadesdocumentos.jdoSetpercdesconto(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_percdesconto, (Object)bigDecimal, (Object)bigDecimal2);
        if (this.cascade && changed) {
            this.process();
        }
    }

    public boolean isPercdescontoEditable() {
        return Entidadesdocumentos.jdoGettipodocumento(this).isTiposaldo(0) && !Entidadesdocumentos.jdoGettipodocumento(this).isTipodocumento(2);
    }

    public boolean isPercdescontoValid() {
        return this.isPercdescontoEditable() || Entidadesdocumentos.jdoGetpercdesconto(this).signum() == 0;
    }

    public BigDecimal getTotalentregue() {
        return Entidadesdocumentos.jdoGettotalentregue(this);
    }

    public String getTotalentregueToText() {
        return Entidadesdocumentos.jdoGettotalentregue(this) == null ? "" : FIELDS.entidadesdocumentos_totalentregue.format.format(Entidadesdocumentos.jdoGettotalentregue(this));
    }

    public void setTotalentregue(BigDecimal totalentregue) {
        BigDecimal bigDecimal = Entidadesdocumentos.jdoGettotalentregue(this);
        BigDecimal bigDecimal2 = totalentregue;
        Entidadesdocumentos.jdoSettotalentregue(this, bigDecimal2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_totalentregue, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public boolean isTotalentregueValid() {
        return Entidadesdocumentos.jdoGettotalentregue(this).signum() == 0 || NumericUtils.isLesserOrEqual((BigDecimal)Entidadesdocumentos.jdoGettotalentregue(this), (BigDecimal)Entidadesdocumentos.jdoGettotal(this));
    }

    public BigDecimal getTotalartigos() {
        BigDecimal totalartigos = BigDecimal.ZERO;
        for (Entidadesdocumentoslinhas linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
            if (!linha.hasArtigo()) continue;
            totalartigos = totalartigos.add(linha.getValoriliquido());
        }
        return totalartigos;
    }

    @Deprecated
    public String getTotalartigosToText() {
        return this.getTotalartigos().toPlainString();
    }

    public BigDecimal getTotalprodutos() {
        return Entidadesdocumentos.jdoGettotalprodutos(this);
    }

    public String getTotalprodutosToText() {
        return Entidadesdocumentos.jdoGettotalprodutos(this) == null ? "" : FIELDS.entidadesdocumentos_totalprodutos.format.format(Entidadesdocumentos.jdoGettotalprodutos(this));
    }

    public void setTotalprodutos(BigDecimal totalprodutos) {
        BigDecimal bigDecimal = Entidadesdocumentos.jdoGettotalprodutos(this);
        BigDecimal bigDecimal2 = totalprodutos;
        Entidadesdocumentos.jdoSettotalprodutos(this, bigDecimal2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_totalprodutos, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public boolean isTotalprodutosValid() {
        return !Entidadesdocumentos.jdoGettipodocumento(this).isTipodocumentosaft(2) || NumericUtils.isLesserOrEqual((BigDecimal)Entidadesdocumentos.jdoGettotalprodutos(this), (BigDecimal)BigDecimal.valueOf(1000L));
    }

    public BigDecimal getTotalservicos() {
        return Entidadesdocumentos.jdoGettotalservicos(this);
    }

    public String getTotalservicosToText() {
        return Entidadesdocumentos.jdoGettotalservicos(this) == null ? "" : FIELDS.entidadesdocumentos_totalservicos.format.format(Entidadesdocumentos.jdoGettotalservicos(this));
    }

    public void setTotalservicos(BigDecimal totalservicos) {
        BigDecimal bigDecimal = Entidadesdocumentos.jdoGettotalservicos(this);
        BigDecimal bigDecimal2 = totalservicos;
        Entidadesdocumentos.jdoSettotalservicos(this, bigDecimal2);
        this.firePropertyChange(FIELDS.entidadesdocumentos_totalservicos, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public boolean isTotalservicosValid() {
        return !Entidadesdocumentos.jdoGettipodocumento(this).isTipodocumentosaft(2) || NumericUtils.isLesserOrEqual((BigDecimal)Entidadesdocumentos.jdoGettotalservicos(this), (BigDecimal)BigDecimal.valueOf(100L));
    }

    public BigDecimal getTotalretencoes() {
        return Entidadesdocumentos.jdoGettotalretencoes(this);
    }

    public String getTotalretencoesToText() {
        return Entidadesdocumentos.jdoGettotalretencoes(this) == null ? "" : FIELDS.entidadesdocumentos_totalretencoes.format.format(Entidadesdocumentos.jdoGettotalretencoes(this));
    }

    public void setTotalretencoes(BigDecimal totalretencoes) {
        BigDecimal bigDecimal = Entidadesdocumentos.jdoGettotalretencoes(this);
        BigDecimal bigDecimal2 = totalretencoes;
        Entidadesdocumentos.jdoSettotalretencoes(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_totalretencoes, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed && this.cascade) {
            this.setTotal(Entidadesdocumentos.jdoGettotalbruto(this).subtract(totalretencoes));
        }
    }

    public BigDecimal getTotaliliquido() {
        return Entidadesdocumentos.jdoGettotaliliquido(this);
    }

    public String getTotaliliquidoToText() {
        return Entidadesdocumentos.jdoGettotaliliquido(this) == null ? "" : FIELDS.entidadesdocumentos_totaliliquido.format.format(Entidadesdocumentos.jdoGettotaliliquido(this));
    }

    public void setTotaliliquido(BigDecimal totaliliquido) {
        BigDecimal bigDecimal = Entidadesdocumentos.jdoGettotaliliquido(this);
        BigDecimal bigDecimal2 = totaliliquido;
        Entidadesdocumentos.jdoSettotaliliquido(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_totaliliquido, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed && this.cascade) {
            this.setTotalliquido(totaliliquido.subtract(Entidadesdocumentos.jdoGettotaldeducoes(this)).subtract(Entidadesdocumentos.jdoGettotaldesconto(this)));
        }
    }

    public BigDecimal getTotaldeducoes() {
        return Entidadesdocumentos.jdoGettotaldeducoes(this);
    }

    public String getTotaldeducoesToText() {
        return Entidadesdocumentos.jdoGettotaldeducoes(this) == null ? "" : FIELDS.entidadesdocumentos_totaldeducoes.format.format(Entidadesdocumentos.jdoGettotaldeducoes(this));
    }

    public void setTotaldeducoes(BigDecimal totaldeducoes) {
        BigDecimal bigDecimal = Entidadesdocumentos.jdoGettotaldeducoes(this);
        BigDecimal bigDecimal2 = totaldeducoes;
        Entidadesdocumentos.jdoSettotaldeducoes(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_totaldeducoes, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed && this.cascade) {
            this.setTotalliquido(Entidadesdocumentos.jdoGettotaliliquido(this).subtract(totaldeducoes).subtract(Entidadesdocumentos.jdoGettotaldesconto(this)));
        }
    }

    public BigDecimal getTotaldesconto() {
        return Entidadesdocumentos.jdoGettotaldesconto(this);
    }

    public String getTotaldescontoToText() {
        return Entidadesdocumentos.jdoGettotaldesconto(this) == null ? "" : FIELDS.entidadesdocumentos_totaldesconto.format.format(Entidadesdocumentos.jdoGettotaldesconto(this));
    }

    public void setTotaldesconto(BigDecimal totaldesconto) {
        BigDecimal bigDecimal = Entidadesdocumentos.jdoGettotaldesconto(this);
        BigDecimal bigDecimal2 = totaldesconto;
        Entidadesdocumentos.jdoSettotaldesconto(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_totaldesconto, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed && this.cascade) {
            this.setTotalliquido(Entidadesdocumentos.jdoGettotaliliquido(this).subtract(Entidadesdocumentos.jdoGettotaldeducoes(this)).subtract(totaldesconto));
        }
    }

    public BigDecimal getTotaldesconto2() {
        BigDecimal total = BigDecimal.ZERO;
        for (Entidadesdocumentosivas iva : new TabelaivaMap(this).values()) {
            total = total.add(iva.getValordesconto2());
        }
        return total;
    }

    public BigDecimal getTotalliquido() {
        return Entidadesdocumentos.jdoGettotalliquido(this);
    }

    public String getTotalliquidoToText() {
        return Entidadesdocumentos.jdoGettotalliquido(this) == null ? "" : FIELDS.entidadesdocumentos_totalliquido.format.format(Entidadesdocumentos.jdoGettotalliquido(this));
    }

    public void setTotalliquido(BigDecimal totalliquido) {
        BigDecimal bigDecimal = Entidadesdocumentos.jdoGettotalliquido(this);
        BigDecimal bigDecimal2 = totalliquido;
        Entidadesdocumentos.jdoSettotalliquido(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_totalliquido, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed && this.cascade) {
            this.setTotalbruto(totalliquido.add(Entidadesdocumentos.jdoGettotaliva(this)));
        }
    }

    public BigDecimal getTotalliquido2() {
        BigDecimal total = BigDecimal.ZERO;
        for (Entidadesdocumentosivas iva : new TabelaivaMap(this).values()) {
            total = total.add(iva.getValorliquido());
        }
        return total;
    }

    public BigDecimal getTotaliva() {
        return Entidadesdocumentos.jdoGettotaliva(this);
    }

    public String getTotalivaToText() {
        return Entidadesdocumentos.jdoGettotaliva(this) == null ? "" : FIELDS.entidadesdocumentos_totaliva.format.format(Entidadesdocumentos.jdoGettotaliva(this));
    }

    public void setTotaliva(BigDecimal totaliva) {
        BigDecimal bigDecimal = Entidadesdocumentos.jdoGettotaliva(this);
        BigDecimal bigDecimal2 = totaliva;
        Entidadesdocumentos.jdoSettotaliva(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_totaliva, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed && this.cascade) {
            this.setTotalbruto(Entidadesdocumentos.jdoGettotalliquido(this).add(totaliva));
        }
    }

    public BigDecimal getTotalbruto() {
        return Entidadesdocumentos.jdoGettotalbruto(this);
    }

    BigDecimal getTotalbruto(int tiposaldo) {
        switch (tiposaldo) {
            case 0: {
                return Entidadesdocumentos.jdoGettotalbruto(this);
            }
            case 1: {
                return this.getTotalartigos();
            }
        }
        return BigDecimal.ZERO;
    }

    public String getTotalbrutoToText() {
        return Entidadesdocumentos.jdoGettotalbruto(this) == null ? "" : FIELDS.entidadesdocumentos_totalbruto.format.format(Entidadesdocumentos.jdoGettotalbruto(this));
    }

    public void setTotalbruto(BigDecimal totalbruto) {
        BigDecimal bigDecimal = Entidadesdocumentos.jdoGettotalbruto(this);
        BigDecimal bigDecimal2 = totalbruto;
        Entidadesdocumentos.jdoSettotalbruto(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_totalbruto, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed && this.cascade) {
            this.setTotal(totalbruto.subtract(Entidadesdocumentos.jdoGettotalretencoes(this)));
        }
    }

    public boolean isTotalbrutoValid() {
        return Entidadesdocumentos.jdoGettotalbruto(this).signum() >= 0 || !this.isAssinado() || Entidadesdocumentos.jdoGettipodocumento(this).getSAFTDocumentGroup() != Documentostipos.SAFT_DOCUMENT_GROUP.INVOICE;
    }

    public BigDecimal getTotal() {
        return Entidadesdocumentos.jdoGettotal(this);
    }

    public String getTotalToText() {
        return Entidadesdocumentos.jdoGettotal(this) == null ? "" : FIELDS.entidadesdocumentos_total.format.format(Entidadesdocumentos.jdoGettotal(this));
    }

    public boolean setTotal(BigDecimal total) {
        BigDecimal bigDecimal = Entidadesdocumentos.jdoGettotal(this);
        BigDecimal bigDecimal2 = total;
        Entidadesdocumentos.jdoSettotal(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.entidadesdocumentos_total, (Object)bigDecimal, (Object)bigDecimal2);
        if (changed) {
            this.firePropertyChange(FIELDS.entidadesdocumentos_totalcambio);
        }
        return changed;
    }

    @Override
    public BigDecimal getTotalcambio() {
        return Entidadesdocumentos.jdoGettotal(this).multiply(Entidadesdocumentos.jdoGetcambio(this).getCambio());
    }

    public String getTotalcambioToText() {
        return FIELDS.entidadesdocumentos_totalcambio.format.format(this.getTotalcambio());
    }

    @Deprecated
    public BigDecimal getTotalpagar() {
        return Entidadesdocumentos.jdoGettotalbruto(this).subtract(Entidadesdocumentos.jdoGettotalretencoes(this));
    }

    @Override
    public String getTotalextenso() {
        return Entidadesdocumentos.jdoGetmoeda(this).getExtenso(Entidadesdocumentos.jdoGetpais(this), this.getTotalcambio());
    }

    @Deprecated
    public String getExtenso() {
        return this.getTotalextenso();
    }

    public Entidadesdocumentoslinhas createLinhasdocumento() {
        return this.createLinhasdocumento(2);
    }

    public Entidadesdocumentoslinhas createLinhasdocumento(int tipo) {
        return Entidadesdocumentos.jdoGetentidade(this) == null ? null : new Entidadesdocumentoslinhas(this, tipo);
    }

    public Entidadesdocumentoslinhas createLinhasdocumento(Artigosmovimentos movimento) {
        return new Entidadesdocumentoslinhas(this, movimento);
    }

    public Entidadesdocumentoslinhas createLinhasdocumento(Entidadesmovimentos movimento) {
        return Entidadesdocumentos.jdoGetentidade(this) == null ? null : new Entidadesdocumentoslinhas(this, movimento);
    }

    public Collection<Entidadesdocumentoslinhas> getLinhasdocumento() {
        return Collections.unmodifiableList(Entidadesdocumentos.jdoGetlinhasdocumento(this));
    }

    public Entidadesdocumentoslinhas getLinhasdocumento(int index) {
        return index >= Entidadesdocumentos.jdoGetlinhasdocumento(this).size() ? null : (Entidadesdocumentoslinhas)Entidadesdocumentos.jdoGetlinhasdocumento(this).get(index);
    }

    public Entidadesdocumentoslinhas getLinhasdocumento(String key) {
        for (Entidadesdocumentoslinhas linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
            if (!linha.getKey().equals(key)) continue;
            return linha;
        }
        return null;
    }

    public Collection<Entidadesdocumentoslinhas> getLinhasdocumento$Tipo(int tipo) {
        ArrayList<Entidadesdocumentoslinhas> col = new ArrayList<Entidadesdocumentoslinhas>();
        for (Entidadesdocumentoslinhas linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
            if (!linha.isTipo(tipo)) continue;
            col.add(linha);
        }
        return col;
    }

    public void setLinhasdocumento(Collection<Entidadesdocumentoslinhas> linhasdocumento) {
        Entidadesdocumentos.jdoGetlinhasdocumento(this).clear();
        this.addLinhasdocumento(linhasdocumento);
    }

    public Entidadesdocumentoslinhas addLinhasdocumento() {
        return this.addLinhasdocumento(this.createLinhasdocumento());
    }

    public Entidadesdocumentoslinhas addLinhasdocumento(int index) {
        if (index >= 0 && index <= Entidadesdocumentos.jdoGetlinhasdocumento(this).size()) {
            ArrayList<Entidadesdocumentoslinhas> linhasdocumento = new ArrayList<Entidadesdocumentoslinhas>(Entidadesdocumentos.jdoGetlinhasdocumento(this));
            Entidadesdocumentoslinhas linha = this.createLinhasdocumento();
            linhasdocumento.add(index, linha);
            this.setLinhasdocumento(linhasdocumento);
            return linha;
        }
        return this.addLinhasdocumento();
    }

    public Entidadesdocumentoslinhas addLinhasdocumento(Entidadesdocumentoslinhas linhasdocumento) {
        this.addLinhasdocumento((Collection<Entidadesdocumentoslinhas>)(linhasdocumento == null ? Collections.EMPTY_LIST : Arrays.asList(linhasdocumento)));
        return linhasdocumento;
    }

    public void addLinhasdocumento(Collection<Entidadesdocumentoslinhas> linhasdocumento) {
        int index = Entidadesdocumentos.jdoGetlinhasdocumento(this).size();
        for (Entidadesdocumentoslinhas linha : linhasdocumento) {
            linha.setNumerolinha(++index);
            linha.setDocumento(this);
        }
        boolean changed = Entidadesdocumentos.jdoGetlinhasdocumento(this).addAll(linhasdocumento);
        if (changed && this.cascade) {
            this.process();
        }
    }

    public void removeLinhasdocumento() {
        this.removeLinhasdocumento(Entidadesdocumentos.jdoGetlinhasdocumento(this));
    }

    public void removeLinhasdocumento(int index) {
        this.removeLinhasdocumento(this.getLinhasdocumento(index));
    }

    public void removeLinhasdocumento(Entidadesdocumentoslinhas linhasdocumento) {
        this.removeLinhasdocumento(Arrays.asList(linhasdocumento));
    }

    public void removeLinhasdocumento$Tipo(int tipo) {
        ArrayList<Entidadesdocumentoslinhas> linhasdocumento = new ArrayList<Entidadesdocumentoslinhas>();
        for (Entidadesdocumentoslinhas linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
            if (!linha.isTipo(tipo)) continue;
            linhasdocumento.add(linha);
        }
        this.removeLinhasdocumento(linhasdocumento);
    }

    public void removeLinhasdocumento(Collection<Entidadesdocumentoslinhas> linhasdocumento) {
        Entidadesdocumentos.jdoGetlinhasdocumento(this).removeAll(linhasdocumento);
        int index = 0;
        for (Entidadesdocumentoslinhas linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
            linha.setNumerolinha(++index);
        }
        if (this.cascade) {
            this.process();
        }
    }

    public Collection<Isencoesiva> getIsencoesiva() {
        TreeSet<Isencoesiva> col = new TreeSet<Isencoesiva>();
        for (Entidadesdocumentoslinhas linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
            if (!linha.isIsencaoiva()) continue;
            col.add(linha.getIsencaoiva());
        }
        return col;
    }

    public Collection<Entidadesdocumentoslinhas> getLinhaorigem() {
        ArrayList<Entidadesdocumentoslinhas> col = new ArrayList<Entidadesdocumentoslinhas>();
        for (Entidadesdocumentoslinhas linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
            if (linha.getLinhaorigem() == null) continue;
            col.add(linha.getLinhaorigem());
        }
        return col;
    }

    public Collection<Entidadesmovimentos> getMovimentoorigem() {
        LinkedHashSet<Entidadesmovimentos> col = new LinkedHashSet<Entidadesmovimentos>();
        for (Entidadesdocumentoslinhas linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
            if (linha.getMovimentoorigem() == null) continue;
            col.add(linha.getMovimentoorigem());
        }
        return col;
    }

    public Collection<Artigosmovimentos> getMovimentoorigem2() {
        ArrayList<Artigosmovimentos> col = new ArrayList<Artigosmovimentos>();
        for (Entidadesdocumentoslinhas linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
            if (linha.getMovimentoorigem2() == null) continue;
            col.add(linha.getMovimentoorigem2());
        }
        return col;
    }

    public BigDecimal getQuantidade() {
        BigDecimal quantidade = BigDecimal.ZERO;
        for (Entidadesdocumentoslinhas linha : Entidadesdocumentos.jdoGetlinhasdocumento(this)) {
            quantidade = quantidade.add(linha.getQuantidade());
        }
        return quantidade;
    }

    public Entidadesdocumentosentregas createEntregaspagamento() {
        return this.createEntregaspagamento(Entidadesdocumentos.jdoGetentidade(this).getMetodopagamento().getCodigo());
    }

    public Entidadesdocumentosentregas createEntregaspagamento(String metodopagamento) {
        return new Entidadesdocumentosentregas(this, this.manager.loadMetodospagamento(metodopagamento));
    }

    public Collection<Entidadesdocumentosentregas> getEntregaspagamento() {
        return Collections.unmodifiableList(Entidadesdocumentos.jdoGetentregaspagamento(this));
    }

    public Entidadesdocumentosentregas getEntregaspagamento(int index) {
        return index >= Entidadesdocumentos.jdoGetentregaspagamento(this).size() ? null : (Entidadesdocumentosentregas)Entidadesdocumentos.jdoGetentregaspagamento(this).get(index);
    }

    public Entidadesdocumentosentregas getEntregaspagamento(String key) {
        for (Entidadesdocumentosentregas linha : Entidadesdocumentos.jdoGetentregaspagamento(this)) {
            if (!linha.getKey().equals(key)) continue;
            return linha;
        }
        return null;
    }

    public void setEntregaspagamento(Collection<Entidadesdocumentosentregas> entregaspagamento) {
        Entidadesdocumentos.jdoGetentregaspagamento(this).clear();
        this.addEntregaspagamento(entregaspagamento);
    }

    public Entidadesdocumentosentregas addEntregaspagamento() {
        return this.addEntregaspagamento(this.createEntregaspagamento());
    }

    public Entidadesdocumentosentregas addEntregaspagamento(String metodopagamento) {
        return this.addEntregaspagamento(this.createEntregaspagamento(metodopagamento));
    }

    public Entidadesdocumentosentregas addEntregaspagamento(Entidadesdocumentosentregas entregaspagamento) {
        this.addEntregaspagamento((Collection<Entidadesdocumentosentregas>)(entregaspagamento == null ? Collections.EMPTY_LIST : Arrays.asList(entregaspagamento)));
        return entregaspagamento;
    }

    public void addEntregaspagamento(Collection<Entidadesdocumentosentregas> entregaspagamento) {
        int index = Entidadesdocumentos.jdoGetentregaspagamento(this).size();
        for (Entidadesdocumentosentregas linha : entregaspagamento) {
            linha.setNumerolinha(++index);
            linha.setDocumento(this);
        }
        boolean changed = Entidadesdocumentos.jdoGetentregaspagamento(this).addAll(entregaspagamento);
        if (changed && this.cascade) {
            this.process();
        }
    }

    public void removeEntregaspagamento() {
        this.removeEntregaspagamento(Entidadesdocumentos.jdoGetentregaspagamento(this));
    }

    public void removeEntregaspagamento(int index) {
        this.removeEntregaspagamento(this.getEntregaspagamento(index));
    }

    public void removeEntregaspagamento(Entidadesdocumentosentregas entregaspagamento) {
        this.removeEntregaspagamento(Arrays.asList(entregaspagamento));
    }

    public void removeEntregaspagamento(Collection<Entidadesdocumentosentregas> entregaspagamento) {
        Entidadesdocumentos.jdoGetentregaspagamento(this).removeAll(entregaspagamento);
        int index = 0;
        for (Entidadesdocumentosentregas linha : Entidadesdocumentos.jdoGetentregaspagamento(this)) {
            linha.setNumerolinha(++index);
        }
        if (this.cascade) {
            this.process();
        }
    }

    public Entidadesdocumentosivas createTabelaiva() {
        return this.createTabelaiva(Entidadesdocumentos.jdoGetentidade(this).getCodigoiva().getCodigo());
    }

    public Entidadesdocumentosivas createTabelaiva(String codigoiva) {
        return new Entidadesdocumentosivas(this, this.manager.loadCodigosiva(codigoiva));
    }

    public Collection<Entidadesdocumentosivas> getTabelaiva() {
        return Collections.unmodifiableList(Entidadesdocumentos.jdoGettabelaiva(this));
    }

    public Entidadesdocumentosivas getTabelaiva(int index) {
        return index >= Entidadesdocumentos.jdoGettabelaiva(this).size() ? null : (Entidadesdocumentosivas)Entidadesdocumentos.jdoGettabelaiva(this).get(index);
    }

    public Entidadesdocumentosivas getTabelaiva(String key) {
        for (Entidadesdocumentosivas linha : Entidadesdocumentos.jdoGettabelaiva(this)) {
            if (!linha.getKey().equals(key)) continue;
            return linha;
        }
        return null;
    }

    public void setTabelaiva(Collection<Entidadesdocumentosivas> tabelaiva) {
        Entidadesdocumentos.jdoGettabelaiva(this).clear();
        this.addTabelaiva(tabelaiva);
    }

    public Entidadesdocumentosivas addTabelaiva(String codigoiva) {
        return this.addTabelaiva(this.createTabelaiva(codigoiva));
    }

    public Entidadesdocumentosivas addTabelaiva(Entidadesdocumentosivas tabelaiva) {
        this.addTabelaiva((Collection<Entidadesdocumentosivas>)(tabelaiva == null ? Collections.EMPTY_LIST : Arrays.asList(tabelaiva)));
        return tabelaiva;
    }

    public void addTabelaiva(Collection<Entidadesdocumentosivas> tabelaiva) {
        int index = Entidadesdocumentos.jdoGettabelaiva(this).size();
        for (Entidadesdocumentosivas linha : tabelaiva) {
            linha.setNumerolinha(++index);
            linha.setDocumento(this);
        }
        Entidadesdocumentos.jdoGettabelaiva(this).addAll(tabelaiva);
    }

    public void removeTabelaiva() {
        this.removeTabelaiva(Entidadesdocumentos.jdoGettabelaiva(this));
    }

    public void removeTabelaiva(Entidadesdocumentosivas tabelaiva) {
        this.removeTabelaiva(Arrays.asList(tabelaiva));
    }

    public void removeTabelaiva(Collection<Entidadesdocumentosivas> tabelaiva) {
        Entidadesdocumentos.jdoGettabelaiva(this).removeAll(tabelaiva);
        int index = 0;
        for (Entidadesdocumentosivas linha : Entidadesdocumentos.jdoGettabelaiva(this)) {
            linha.setNumerolinha(++index);
        }
    }

    public Entidadesdocumentosatws createWebservice() {
        return this.createWebservice(new ATWebserviceResponseType());
    }

    public Entidadesdocumentosatws createWebservice(ATWebserviceResponseType response) {
        return new Entidadesdocumentosatws(this, response);
    }

    public Collection<Entidadesdocumentosatws> getWebservice() {
        return Collections.unmodifiableList(Entidadesdocumentos.jdoGetwebservice(this));
    }

    public Entidadesdocumentosatws getWebservice(int index) {
        return index >= Entidadesdocumentos.jdoGetwebservice(this).size() ? null : (Entidadesdocumentosatws)Entidadesdocumentos.jdoGetwebservice(this).get(index);
    }

    public Entidadesdocumentosatws getWebservice(String key) {
        for (Entidadesdocumentosatws linha : Entidadesdocumentos.jdoGetwebservice(this)) {
            if (!linha.getKey().equals(key)) continue;
            return linha;
        }
        return null;
    }

    public void setWebservice(Collection<Entidadesdocumentosatws> webservice) {
        Entidadesdocumentos.jdoGetwebservice(this).clear();
        this.addWebservice(webservice);
    }

    public Entidadesdocumentosatws addWebservice(ATWebserviceResponseType response) {
        return this.addWebservice(this.createWebservice(response));
    }

    public Entidadesdocumentosatws addWebservice(Entidadesdocumentosatws webservice) {
        this.addWebservice((Collection<Entidadesdocumentosatws>)(webservice == null ? Collections.EMPTY_LIST : Arrays.asList(webservice)));
        return webservice;
    }

    public void addWebservice(Collection<Entidadesdocumentosatws> webservice) {
        int index = Entidadesdocumentos.jdoGetwebservice(this).size();
        for (Entidadesdocumentosatws linha : webservice) {
            linha.setNumerolinha(++index);
            linha.setDocumento(this);
        }
        Entidadesdocumentos.jdoGetwebservice(this).addAll(webservice);
    }

    public void removeWebservice() {
        this.removeWebservice(Entidadesdocumentos.jdoGetwebservice(this));
    }

    public void removeWebservice(Entidadesdocumentosatws webservice) {
        this.removeWebservice(Arrays.asList(webservice));
    }

    public void removeWebservice(Collection<Entidadesdocumentosatws> webservice) {
        Entidadesdocumentos.jdoGetwebservice(this).removeAll(webservice);
        int index = 0;
        for (Entidadesdocumentosatws linha : Entidadesdocumentos.jdoGetwebservice(this)) {
            linha.setNumerolinha(++index);
        }
    }

    @Override
    public boolean isEditable(FIELDS field) {
        switch (Entidadesdocumentos.jdoGetestado(this)) {
            case 0: {
                return !(field == FIELDS.entidadesdocumentos_autor || field == FIELDS.entidadesdocumentos_editor || field == FIELDS.entidadesdocumentos_documentcode && !this.isDocumentcodeEditable() || field == FIELDS.entidadesdocumentos_seriedocumento && this.isEdited() || field == FIELDS.entidadesdocumentos_numerodocumento && this.isEdited() || field == FIELDS.entidadesdocumentos_datasistema || field == FIELDS.entidadesdocumentos_horasistema || field == FIELDS.entidadesdocumentos_datacriacao && this.isEdited() && !this.isDatacriacaoEditable() || field == FIELDS.entidadesdocumentos_entidade && this.isEdited() && this.isAssinado() || field == FIELDS.entidadesdocumentos_nome && (!this.isEditable(FIELDS.entidadesdocumentos_entidade) || !this.isEntidadeEditable()) || field == FIELDS.entidadesdocumentos_morada && (!this.isEditable(FIELDS.entidadesdocumentos_entidade) || !this.isEntidadeEditable()) || field == FIELDS.entidadesdocumentos_codigopostal && (!this.isEditable(FIELDS.entidadesdocumentos_entidade) || !this.isEntidadeEditable()) || field == FIELDS.entidadesdocumentos_localidade && (!this.isEditable(FIELDS.entidadesdocumentos_entidade) || !this.isEntidadeEditable()) || field == FIELDS.entidadesdocumentos_nif && (!this.isEditable(FIELDS.entidadesdocumentos_entidade) || !this.isEntidadeEditable()) || field == FIELDS.entidadesdocumentos_percdesconto && !this.isPercdescontoEditable() || field == FIELDS.entidadesdocumentos_totalentregue || field == FIELDS.entidadesdocumentos_totalprodutos || field == FIELDS.entidadesdocumentos_totalservicos || field == FIELDS.entidadesdocumentos_totalretencoes || field == FIELDS.entidadesdocumentos_totaliliquido || field == FIELDS.entidadesdocumentos_totaldeducoes || field == FIELDS.entidadesdocumentos_totaldesconto || field == FIELDS.entidadesdocumentos_totalliquido || field == FIELDS.entidadesdocumentos_totaliva || field == FIELDS.entidadesdocumentos_totalbruto || field == FIELDS.entidadesdocumentos_total || field == FIELDS.entidadesdocumentos_totalcambio);
            }
        }
        return false;
    }

    @Override
    public void attach(DatabaseManager manager) {
        manager.attach(Entidadesdocumentos.jdoGetlinhasdocumento(this));
        manager.attach(Entidadesdocumentos.jdoGetentregaspagamento(this));
        manager.attach(Entidadesdocumentos.jdoGettabelaiva(this));
        manager.attach(Entidadesdocumentos.jdoGetwebservice(this));
        manager.attach(new AbstractModel[]{Entidadesdocumentos.jdoGetmovimentoentidades(this), Entidadesdocumentos.jdoGetautor(this), Entidadesdocumentos.jdoGeteditor(this), Entidadesdocumentos.jdoGettemplate(this), Entidadesdocumentos.jdoGettipodocumento(this), Entidadesdocumentos.jdoGetseriedocumento(this), Entidadesdocumentos.jdoGetentidade(this), Entidadesdocumentos.jdoGetcodigopostal(this), Entidadesdocumentos.jdoGetcodigopostalcarga(this), Entidadesdocumentos.jdoGetcodigopostaldescarga(this), Entidadesdocumentos.jdoGetpais(this), Entidadesdocumentos.jdoGetpaiscarga(this), Entidadesdocumentos.jdoGetpaisdescarga(this), Entidadesdocumentos.jdoGetvendedor(this), Entidadesdocumentos.jdoGetcondicaopagamento(this), Entidadesdocumentos.jdoGetmetodopagamento(this), Entidadesdocumentos.jdoGetcondicaoentrega(this), Entidadesdocumentos.jdoGetmetodotransporte(this), Entidadesdocumentos.jdoGetviatura(this), Entidadesdocumentos.jdoGetmoeda(this), Entidadesdocumentos.jdoGetcambio(this)});
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.isDirty(Entidadesdocumentos.jdoGetlinhasdocumento(this)) || this.isDirty(Entidadesdocumentos.jdoGetentregaspagamento(this)) || this.isDirty(Entidadesdocumentos.jdoGettabelaiva(this)) || this.isDirty(Entidadesdocumentos.jdoGetwebservice(this));
    }

    public String toString() {
        return ATMessageFormatter.getInvoiceNo(Entidadesdocumentos.jdoGettipodocumento(this) == null ? null : Entidadesdocumentos.jdoGettipodocumento(this).getCodigo(), Entidadesdocumentos.jdoGetseriedocumento(this) == null ? null : Entidadesdocumentos.jdoGetseriedocumento(this).getSerie(), Entidadesdocumentos.jdoGetnumerodocumento(this));
    }

    public int hashCode() {
        return Entidadesdocumentos.jdoGetkey(this) == null ? 0 : Entidadesdocumentos.jdoGetkey(this).hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    static {
        jdoFieldNames = Entidadesdocumentos.__jdoFieldNamesInit();
        jdoFieldTypes = Entidadesdocumentos.__jdoFieldTypesInit();
        jdoFieldFlags = Entidadesdocumentos.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Entidadesdocumentos.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Entidadesdocumentos.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Entidadesdocumentos"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Entidadesdocumentos());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(42, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.key = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.key);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Entidadesdocumentos result = new Entidadesdocumentos();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Entidadesdocumentos result = new Entidadesdocumentos();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.autor = (Utilizadores)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.cambio = (Moedascambios)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.campo1 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.campo10 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.campo2 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.campo3 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.campo4 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.campo5 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 8: {
                this.campo6 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 9: {
                this.campo7 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 10: {
                this.campo8 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 11: {
                this.campo9 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 12: {
                this.codigopostal = (Codigospostais)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 13: {
                this.codigopostalcarga = (Codigospostais)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 14: {
                this.codigopostaldescarga = (Codigospostais)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 15: {
                this.codigovalidacao = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 16: {
                this.condicaoentrega = (Condicoesentrega)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 17: {
                this.condicaopagamento = (Condicoespagamento)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 18: {
                this.contadorvias = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 19: {
                this.dadostransporte = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 20: {
                this.dataauxiliar = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 21: {
                this.datacarga = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 22: {
                this.datacriacao = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 23: {
                this.datadescarga = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 24: {
                this.dataenvio = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 25: {
                this.datasistema = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 26: {
                this.datavencimento = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 27: {
                this.documentcode = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 28: {
                this.editor = (Utilizadores)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 29: {
                this.embalagens = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 30: {
                this.entidade = (Entidades)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 31: {
                this.entregaspagamento = (List)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 32: {
                this.estado = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 33: {
                this.estadoenvio = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 34: {
                this.expedicao = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 35: {
                this.hash = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 36: {
                this.hashcontrol = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 37: {
                this.horacarga = (Time)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 38: {
                this.horacriacao = (Time)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 39: {
                this.horadescarga = (Time)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 40: {
                this.horaenvio = (Time)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 41: {
                this.horasistema = (Time)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 42: {
                this.key = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 43: {
                this.linhasdocumento = (List)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 44: {
                this.localcarga = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 45: {
                this.localdescarga = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 46: {
                this.localidade = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 47: {
                this.marcas = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 48: {
                this.matricula = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 49: {
                this.metodopagamento = (Metodospagamento)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 50: {
                this.metodotransporte = (Metodostransporte)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 51: {
                this.moeda = (Moedas)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 52: {
                this.morada = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 53: {
                this.movimentoentidades = (Entidadesmovimentos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 54: {
                this.nif = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 55: {
                this.nome = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 56: {
                this.numeroauxiliar = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 57: {
                this.numerodocumento = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 58: {
                this.obs = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 59: {
                this.pais = (Paises)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 60: {
                this.paiscarga = (Paises)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 61: {
                this.paisdescarga = (Paises)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 62: {
                this.percdesconto = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 63: {
                this.pesobruto = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 64: {
                this.pesoliquido = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 65: {
                this.returncode = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 66: {
                this.returnmessage = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 67: {
                this.seriedocumento = (Documentosseries)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 68: {
                this.tabelaiva = (List)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 69: {
                this.template = (Templates)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 70: {
                this.tipodocumento = (Documentostipos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 71: {
                this.total = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 72: {
                this.totalbruto = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 73: {
                this.totaldeducoes = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 74: {
                this.totaldesconto = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 75: {
                this.totalentregue = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 76: {
                this.totaliliquido = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 77: {
                this.totaliva = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 78: {
                this.totalliquido = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 79: {
                this.totalprodutos = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 80: {
                this.totalretencoes = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 81: {
                this.totalservicos = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 82: {
                this.vendedor = (Vendedores)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 83: {
                this.viatura = (Viaturas)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 84: {
                this.volume = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 85: {
                this.webservice = (List)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.autor);
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.cambio);
                break;
            }
            case 2: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo1);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo10);
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo2);
                break;
            }
            case 5: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo3);
                break;
            }
            case 6: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo4);
                break;
            }
            case 7: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo5);
                break;
            }
            case 8: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo6);
                break;
            }
            case 9: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo7);
                break;
            }
            case 10: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo8);
                break;
            }
            case 11: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.campo9);
                break;
            }
            case 12: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.codigopostal);
                break;
            }
            case 13: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.codigopostalcarga);
                break;
            }
            case 14: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.codigopostaldescarga);
                break;
            }
            case 15: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.codigovalidacao);
                break;
            }
            case 16: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.condicaoentrega);
                break;
            }
            case 17: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.condicaopagamento);
                break;
            }
            case 18: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.contadorvias);
                break;
            }
            case 19: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.dadostransporte);
                break;
            }
            case 20: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.dataauxiliar);
                break;
            }
            case 21: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.datacarga);
                break;
            }
            case 22: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.datacriacao);
                break;
            }
            case 23: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.datadescarga);
                break;
            }
            case 24: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.dataenvio);
                break;
            }
            case 25: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.datasistema);
                break;
            }
            case 26: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.datavencimento);
                break;
            }
            case 27: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.documentcode);
                break;
            }
            case 28: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.editor);
                break;
            }
            case 29: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.embalagens);
                break;
            }
            case 30: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.entidade);
                break;
            }
            case 31: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, this.entregaspagamento);
                break;
            }
            case 32: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.estado);
                break;
            }
            case 33: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.estadoenvio);
                break;
            }
            case 34: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.expedicao);
                break;
            }
            case 35: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.hash);
                break;
            }
            case 36: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.hashcontrol);
                break;
            }
            case 37: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.horacarga);
                break;
            }
            case 38: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.horacriacao);
                break;
            }
            case 39: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.horadescarga);
                break;
            }
            case 40: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.horaenvio);
                break;
            }
            case 41: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.horasistema);
                break;
            }
            case 42: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.key);
                break;
            }
            case 43: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, this.linhasdocumento);
                break;
            }
            case 44: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.localcarga);
                break;
            }
            case 45: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.localdescarga);
                break;
            }
            case 46: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.localidade);
                break;
            }
            case 47: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.marcas);
                break;
            }
            case 48: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.matricula);
                break;
            }
            case 49: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.metodopagamento);
                break;
            }
            case 50: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.metodotransporte);
                break;
            }
            case 51: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.moeda);
                break;
            }
            case 52: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.morada);
                break;
            }
            case 53: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.movimentoentidades);
                break;
            }
            case 54: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.nif);
                break;
            }
            case 55: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.nome);
                break;
            }
            case 56: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.numeroauxiliar);
                break;
            }
            case 57: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.numerodocumento);
                break;
            }
            case 58: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.obs);
                break;
            }
            case 59: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.pais);
                break;
            }
            case 60: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.paiscarga);
                break;
            }
            case 61: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.paisdescarga);
                break;
            }
            case 62: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.percdesconto);
                break;
            }
            case 63: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.pesobruto);
                break;
            }
            case 64: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.pesoliquido);
                break;
            }
            case 65: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.returncode);
                break;
            }
            case 66: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.returnmessage);
                break;
            }
            case 67: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.seriedocumento);
                break;
            }
            case 68: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, this.tabelaiva);
                break;
            }
            case 69: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.template);
                break;
            }
            case 70: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipodocumento);
                break;
            }
            case 71: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.total);
                break;
            }
            case 72: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.totalbruto);
                break;
            }
            case 73: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.totaldeducoes);
                break;
            }
            case 74: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.totaldesconto);
                break;
            }
            case 75: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.totalentregue);
                break;
            }
            case 76: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.totaliliquido);
                break;
            }
            case 77: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.totaliva);
                break;
            }
            case 78: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.totalliquido);
                break;
            }
            case 79: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.totalprodutos);
                break;
            }
            case 80: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.totalretencoes);
                break;
            }
            case 81: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.totalservicos);
                break;
            }
            case 82: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.vendedor);
                break;
            }
            case 83: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.viatura);
                break;
            }
            case 84: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.volume);
                break;
            }
            case 85: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, this.webservice);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Entidadesdocumentos obj, int index) {
        switch (index) {
            case 0: {
                this.autor = obj.autor;
                break;
            }
            case 1: {
                this.cambio = obj.cambio;
                break;
            }
            case 2: {
                this.campo1 = obj.campo1;
                break;
            }
            case 3: {
                this.campo10 = obj.campo10;
                break;
            }
            case 4: {
                this.campo2 = obj.campo2;
                break;
            }
            case 5: {
                this.campo3 = obj.campo3;
                break;
            }
            case 6: {
                this.campo4 = obj.campo4;
                break;
            }
            case 7: {
                this.campo5 = obj.campo5;
                break;
            }
            case 8: {
                this.campo6 = obj.campo6;
                break;
            }
            case 9: {
                this.campo7 = obj.campo7;
                break;
            }
            case 10: {
                this.campo8 = obj.campo8;
                break;
            }
            case 11: {
                this.campo9 = obj.campo9;
                break;
            }
            case 12: {
                this.codigopostal = obj.codigopostal;
                break;
            }
            case 13: {
                this.codigopostalcarga = obj.codigopostalcarga;
                break;
            }
            case 14: {
                this.codigopostaldescarga = obj.codigopostaldescarga;
                break;
            }
            case 15: {
                this.codigovalidacao = obj.codigovalidacao;
                break;
            }
            case 16: {
                this.condicaoentrega = obj.condicaoentrega;
                break;
            }
            case 17: {
                this.condicaopagamento = obj.condicaopagamento;
                break;
            }
            case 18: {
                this.contadorvias = obj.contadorvias;
                break;
            }
            case 19: {
                this.dadostransporte = obj.dadostransporte;
                break;
            }
            case 20: {
                this.dataauxiliar = obj.dataauxiliar;
                break;
            }
            case 21: {
                this.datacarga = obj.datacarga;
                break;
            }
            case 22: {
                this.datacriacao = obj.datacriacao;
                break;
            }
            case 23: {
                this.datadescarga = obj.datadescarga;
                break;
            }
            case 24: {
                this.dataenvio = obj.dataenvio;
                break;
            }
            case 25: {
                this.datasistema = obj.datasistema;
                break;
            }
            case 26: {
                this.datavencimento = obj.datavencimento;
                break;
            }
            case 27: {
                this.documentcode = obj.documentcode;
                break;
            }
            case 28: {
                this.editor = obj.editor;
                break;
            }
            case 29: {
                this.embalagens = obj.embalagens;
                break;
            }
            case 30: {
                this.entidade = obj.entidade;
                break;
            }
            case 31: {
                this.entregaspagamento = obj.entregaspagamento;
                break;
            }
            case 32: {
                this.estado = obj.estado;
                break;
            }
            case 33: {
                this.estadoenvio = obj.estadoenvio;
                break;
            }
            case 34: {
                this.expedicao = obj.expedicao;
                break;
            }
            case 35: {
                this.hash = obj.hash;
                break;
            }
            case 36: {
                this.hashcontrol = obj.hashcontrol;
                break;
            }
            case 37: {
                this.horacarga = obj.horacarga;
                break;
            }
            case 38: {
                this.horacriacao = obj.horacriacao;
                break;
            }
            case 39: {
                this.horadescarga = obj.horadescarga;
                break;
            }
            case 40: {
                this.horaenvio = obj.horaenvio;
                break;
            }
            case 41: {
                this.horasistema = obj.horasistema;
                break;
            }
            case 42: {
                this.key = obj.key;
                break;
            }
            case 43: {
                this.linhasdocumento = obj.linhasdocumento;
                break;
            }
            case 44: {
                this.localcarga = obj.localcarga;
                break;
            }
            case 45: {
                this.localdescarga = obj.localdescarga;
                break;
            }
            case 46: {
                this.localidade = obj.localidade;
                break;
            }
            case 47: {
                this.marcas = obj.marcas;
                break;
            }
            case 48: {
                this.matricula = obj.matricula;
                break;
            }
            case 49: {
                this.metodopagamento = obj.metodopagamento;
                break;
            }
            case 50: {
                this.metodotransporte = obj.metodotransporte;
                break;
            }
            case 51: {
                this.moeda = obj.moeda;
                break;
            }
            case 52: {
                this.morada = obj.morada;
                break;
            }
            case 53: {
                this.movimentoentidades = obj.movimentoentidades;
                break;
            }
            case 54: {
                this.nif = obj.nif;
                break;
            }
            case 55: {
                this.nome = obj.nome;
                break;
            }
            case 56: {
                this.numeroauxiliar = obj.numeroauxiliar;
                break;
            }
            case 57: {
                this.numerodocumento = obj.numerodocumento;
                break;
            }
            case 58: {
                this.obs = obj.obs;
                break;
            }
            case 59: {
                this.pais = obj.pais;
                break;
            }
            case 60: {
                this.paiscarga = obj.paiscarga;
                break;
            }
            case 61: {
                this.paisdescarga = obj.paisdescarga;
                break;
            }
            case 62: {
                this.percdesconto = obj.percdesconto;
                break;
            }
            case 63: {
                this.pesobruto = obj.pesobruto;
                break;
            }
            case 64: {
                this.pesoliquido = obj.pesoliquido;
                break;
            }
            case 65: {
                this.returncode = obj.returncode;
                break;
            }
            case 66: {
                this.returnmessage = obj.returnmessage;
                break;
            }
            case 67: {
                this.seriedocumento = obj.seriedocumento;
                break;
            }
            case 68: {
                this.tabelaiva = obj.tabelaiva;
                break;
            }
            case 69: {
                this.template = obj.template;
                break;
            }
            case 70: {
                this.tipodocumento = obj.tipodocumento;
                break;
            }
            case 71: {
                this.total = obj.total;
                break;
            }
            case 72: {
                this.totalbruto = obj.totalbruto;
                break;
            }
            case 73: {
                this.totaldeducoes = obj.totaldeducoes;
                break;
            }
            case 74: {
                this.totaldesconto = obj.totaldesconto;
                break;
            }
            case 75: {
                this.totalentregue = obj.totalentregue;
                break;
            }
            case 76: {
                this.totaliliquido = obj.totaliliquido;
                break;
            }
            case 77: {
                this.totaliva = obj.totaliva;
                break;
            }
            case 78: {
                this.totalliquido = obj.totalliquido;
                break;
            }
            case 79: {
                this.totalprodutos = obj.totalprodutos;
                break;
            }
            case 80: {
                this.totalretencoes = obj.totalretencoes;
                break;
            }
            case 81: {
                this.totalservicos = obj.totalservicos;
                break;
            }
            case 82: {
                this.vendedor = obj.vendedor;
                break;
            }
            case 83: {
                this.viatura = obj.viatura;
                break;
            }
            case 84: {
                this.volume = obj.volume;
                break;
            }
            case 85: {
                this.webservice = obj.webservice;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Entidadesdocumentos)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Entidadesdocumentos");
        }
        Entidadesdocumentos other = (Entidadesdocumentos)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"autor", "cambio", "campo1", "campo10", "campo2", "campo3", "campo4", "campo5", "campo6", "campo7", "campo8", "campo9", "codigopostal", "codigopostalcarga", "codigopostaldescarga", "codigovalidacao", "condicaoentrega", "condicaopagamento", "contadorvias", "dadostransporte", "dataauxiliar", "datacarga", "datacriacao", "datadescarga", "dataenvio", "datasistema", "datavencimento", "documentcode", "editor", "embalagens", "entidade", "entregaspagamento", "estado", "estadoenvio", "expedicao", "hash", "hashcontrol", "horacarga", "horacriacao", "horadescarga", "horaenvio", "horasistema", "key", "linhasdocumento", "localcarga", "localdescarga", "localidade", "marcas", "matricula", "metodopagamento", "metodotransporte", "moeda", "morada", "movimentoentidades", "nif", "nome", "numeroauxiliar", "numerodocumento", "obs", "pais", "paiscarga", "paisdescarga", "percdesconto", "pesobruto", "pesoliquido", "returncode", "returnmessage", "seriedocumento", "tabelaiva", "template", "tipodocumento", "total", "totalbruto", "totaldeducoes", "totaldesconto", "totalentregue", "totaliliquido", "totaliva", "totalliquido", "totalprodutos", "totalretencoes", "totalservicos", "vendedor", "viatura", "volume", "webservice"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Utilizadores"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Moedascambios"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Codigospostais"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Codigospostais"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Codigospostais"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Condicoesentrega"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Condicoespagamento"), Entidadesdocumentos.___jdo$loadClass("java.lang.Integer"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.util.Date"), Entidadesdocumentos.___jdo$loadClass("java.util.Date"), Entidadesdocumentos.___jdo$loadClass("java.util.Date"), Entidadesdocumentos.___jdo$loadClass("java.util.Date"), Entidadesdocumentos.___jdo$loadClass("java.util.Date"), Entidadesdocumentos.___jdo$loadClass("java.util.Date"), Entidadesdocumentos.___jdo$loadClass("java.util.Date"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Utilizadores"), Entidadesdocumentos.___jdo$loadClass("java.lang.Integer"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Entidades"), Entidadesdocumentos.___jdo$loadClass("java.util.List"), Entidadesdocumentos.___jdo$loadClass("java.lang.Integer"), Entidadesdocumentos.___jdo$loadClass("java.lang.Integer"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.lang.Integer"), Entidadesdocumentos.___jdo$loadClass("java.sql.Time"), Entidadesdocumentos.___jdo$loadClass("java.sql.Time"), Entidadesdocumentos.___jdo$loadClass("java.sql.Time"), Entidadesdocumentos.___jdo$loadClass("java.sql.Time"), Entidadesdocumentos.___jdo$loadClass("java.sql.Time"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.util.List"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Metodospagamento"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Metodostransporte"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Moedas"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Entidadesmovimentos"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("java.lang.Integer"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Paises"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Paises"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Paises"), Entidadesdocumentos.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentos.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentos.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentos.___jdo$loadClass("java.lang.Integer"), Entidadesdocumentos.___jdo$loadClass("java.lang.String"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Documentosseries"), Entidadesdocumentos.___jdo$loadClass("java.util.List"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Templates"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Documentostipos"), Entidadesdocumentos.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentos.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentos.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentos.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentos.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentos.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentos.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentos.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentos.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentos.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentos.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Vendedores"), Entidadesdocumentos.___jdo$loadClass("org.projectocolibri.api.database.model.Viaturas"), Entidadesdocumentos.___jdo$loadClass("java.math.BigDecimal"), Entidadesdocumentos.___jdo$loadClass("java.util.List")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 5, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 5, 5, 5, 21, 5, 5, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 5, 5, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 24, 5, 21, 21, 21, 21, 21, 5, 5, 5, 21, 5, 21, 21, 21, 21, 21, 5, 5, 5, 21, 21, 21, 21, 21, 5, 5, 5, 5, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 5, 5, 21, 5};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 86;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Entidadesdocumentos o = (Entidadesdocumentos)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static Utilizadores jdoGetautor(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return (Utilizadores)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, (Object)objPC.autor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"autor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.autor;
    }

    private static void jdoSetautor(Entidadesdocumentos objPC, Utilizadores val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, (Object)objPC.autor, (Object)val);
        } else {
            objPC.autor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static Moedascambios jdoGetcambio(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (Moedascambios)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, (Object)objPC.cambio);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"cambio\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.cambio;
    }

    private static void jdoSetcambio(Entidadesdocumentos objPC, Moedascambios val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, (Object)objPC.cambio, (Object)val);
        } else {
            objPC.cambio = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static String jdoGetcampo1(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 2, objPC.campo1);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo1\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo1;
    }

    private static void jdoSetcampo1(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 2, objPC.campo1, val);
        } else {
            objPC.campo1 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static String jdoGetcampo10(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.campo10);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo10\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo10;
    }

    private static void jdoSetcampo10(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.campo10, val);
        } else {
            objPC.campo10 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    private static String jdoGetcampo2(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 4, objPC.campo2);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo2\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo2;
    }

    private static void jdoSetcampo2(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4, objPC.campo2, val);
        } else {
            objPC.campo2 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static String jdoGetcampo3(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 5, objPC.campo3);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo3\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo3;
    }

    private static void jdoSetcampo3(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 5, objPC.campo3, val);
        } else {
            objPC.campo3 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    private static String jdoGetcampo4(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 6, objPC.campo4);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo4\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo4;
    }

    private static void jdoSetcampo4(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 6, objPC.campo4, val);
        } else {
            objPC.campo4 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }

    private static String jdoGetcampo5(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 7, objPC.campo5);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo5\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo5;
    }

    private static void jdoSetcampo5(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 7, objPC.campo5, val);
        } else {
            objPC.campo5 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }

    private static String jdoGetcampo6(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 8, objPC.campo6);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo6\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo6;
    }

    private static void jdoSetcampo6(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 8, objPC.campo6, val);
        } else {
            objPC.campo6 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(8);
            }
        }
    }

    private static String jdoGetcampo7(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 9, objPC.campo7);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo7\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo7;
    }

    private static void jdoSetcampo7(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 9, objPC.campo7, val);
        } else {
            objPC.campo7 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(9);
            }
        }
    }

    private static String jdoGetcampo8(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 10)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 10, objPC.campo8);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(10)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo8\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo8;
    }

    private static void jdoSetcampo8(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 10, objPC.campo8, val);
        } else {
            objPC.campo8 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(10);
            }
        }
    }

    private static String jdoGetcampo9(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 11)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 11, objPC.campo9);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(11)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"campo9\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.campo9;
    }

    private static void jdoSetcampo9(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 11, objPC.campo9, val);
        } else {
            objPC.campo9 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(11);
            }
        }
    }

    private static Codigospostais jdoGetcodigopostal(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 12)) {
            return (Codigospostais)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 12, (Object)objPC.codigopostal);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(12)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"codigopostal\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.codigopostal;
    }

    private static void jdoSetcodigopostal(Entidadesdocumentos objPC, Codigospostais val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 12, (Object)objPC.codigopostal, (Object)val);
        } else {
            objPC.codigopostal = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(12);
            }
        }
    }

    private static Codigospostais jdoGetcodigopostalcarga(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 13)) {
            return (Codigospostais)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 13, (Object)objPC.codigopostalcarga);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(13)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"codigopostalcarga\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.codigopostalcarga;
    }

    private static void jdoSetcodigopostalcarga(Entidadesdocumentos objPC, Codigospostais val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 13, (Object)objPC.codigopostalcarga, (Object)val);
        } else {
            objPC.codigopostalcarga = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(13);
            }
        }
    }

    private static Codigospostais jdoGetcodigopostaldescarga(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 14)) {
            return (Codigospostais)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 14, (Object)objPC.codigopostaldescarga);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(14)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"codigopostaldescarga\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.codigopostaldescarga;
    }

    private static void jdoSetcodigopostaldescarga(Entidadesdocumentos objPC, Codigospostais val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 14, (Object)objPC.codigopostaldescarga, (Object)val);
        } else {
            objPC.codigopostaldescarga = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(14);
            }
        }
    }

    private static String jdoGetcodigovalidacao(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 15)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 15, objPC.codigovalidacao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(15)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"codigovalidacao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.codigovalidacao;
    }

    private static void jdoSetcodigovalidacao(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 15, objPC.codigovalidacao, val);
        } else {
            objPC.codigovalidacao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(15);
            }
        }
    }

    private static Condicoesentrega jdoGetcondicaoentrega(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 16)) {
            return (Condicoesentrega)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 16, (Object)objPC.condicaoentrega);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(16)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"condicaoentrega\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.condicaoentrega;
    }

    private static void jdoSetcondicaoentrega(Entidadesdocumentos objPC, Condicoesentrega val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 16, (Object)objPC.condicaoentrega, (Object)val);
        } else {
            objPC.condicaoentrega = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(16);
            }
        }
    }

    private static Condicoespagamento jdoGetcondicaopagamento(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 17)) {
            return (Condicoespagamento)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 17, (Object)objPC.condicaopagamento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(17)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"condicaopagamento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.condicaopagamento;
    }

    private static void jdoSetcondicaopagamento(Entidadesdocumentos objPC, Condicoespagamento val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 17, (Object)objPC.condicaopagamento, (Object)val);
        } else {
            objPC.condicaopagamento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(17);
            }
        }
    }

    private static Integer jdoGetcontadorvias(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 18)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 18, (Object)objPC.contadorvias);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(18)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"contadorvias\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.contadorvias;
    }

    private static void jdoSetcontadorvias(Entidadesdocumentos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 18, (Object)objPC.contadorvias, (Object)val);
        } else {
            objPC.contadorvias = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(18);
            }
        }
    }

    private static String jdoGetdadostransporte(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 19)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 19, objPC.dadostransporte);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(19)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"dadostransporte\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.dadostransporte;
    }

    private static void jdoSetdadostransporte(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 19, objPC.dadostransporte, val);
        } else {
            objPC.dadostransporte = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(19);
            }
        }
    }

    private static Date jdoGetdataauxiliar(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 20)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 20, (Object)objPC.dataauxiliar);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(20)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"dataauxiliar\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.dataauxiliar;
    }

    private static void jdoSetdataauxiliar(Entidadesdocumentos objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 20, (Object)objPC.dataauxiliar, (Object)val);
        } else {
            objPC.dataauxiliar = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(20);
            }
        }
    }

    private static Date jdoGetdatacarga(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 21)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 21, (Object)objPC.datacarga);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(21)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"datacarga\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.datacarga;
    }

    private static void jdoSetdatacarga(Entidadesdocumentos objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 21, (Object)objPC.datacarga, (Object)val);
        } else {
            objPC.datacarga = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(21);
            }
        }
    }

    private static Date jdoGetdatacriacao(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 22)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 22, (Object)objPC.datacriacao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(22)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"datacriacao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.datacriacao;
    }

    private static void jdoSetdatacriacao(Entidadesdocumentos objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 22, (Object)objPC.datacriacao, (Object)val);
        } else {
            objPC.datacriacao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(22);
            }
        }
    }

    private static Date jdoGetdatadescarga(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 23)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 23, (Object)objPC.datadescarga);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(23)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"datadescarga\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.datadescarga;
    }

    private static void jdoSetdatadescarga(Entidadesdocumentos objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 23, (Object)objPC.datadescarga, (Object)val);
        } else {
            objPC.datadescarga = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(23);
            }
        }
    }

    private static Date jdoGetdataenvio(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 24)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 24, (Object)objPC.dataenvio);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(24)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"dataenvio\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.dataenvio;
    }

    private static void jdoSetdataenvio(Entidadesdocumentos objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 24, (Object)objPC.dataenvio, (Object)val);
        } else {
            objPC.dataenvio = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(24);
            }
        }
    }

    private static Date jdoGetdatasistema(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 25)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 25, (Object)objPC.datasistema);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(25)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"datasistema\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.datasistema;
    }

    private static void jdoSetdatasistema(Entidadesdocumentos objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 25, (Object)objPC.datasistema, (Object)val);
        } else {
            objPC.datasistema = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(25);
            }
        }
    }

    private static Date jdoGetdatavencimento(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 26)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 26, (Object)objPC.datavencimento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(26)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"datavencimento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.datavencimento;
    }

    private static void jdoSetdatavencimento(Entidadesdocumentos objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 26, (Object)objPC.datavencimento, (Object)val);
        } else {
            objPC.datavencimento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(26);
            }
        }
    }

    private static String jdoGetdocumentcode(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 27)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 27, objPC.documentcode);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(27)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"documentcode\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.documentcode;
    }

    private static void jdoSetdocumentcode(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 27, objPC.documentcode, val);
        } else {
            objPC.documentcode = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(27);
            }
        }
    }

    private static Utilizadores jdoGeteditor(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 28)) {
            return (Utilizadores)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 28, (Object)objPC.editor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(28)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"editor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.editor;
    }

    private static void jdoSeteditor(Entidadesdocumentos objPC, Utilizadores val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 28, (Object)objPC.editor, (Object)val);
        } else {
            objPC.editor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(28);
            }
        }
    }

    private static Integer jdoGetembalagens(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 29)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 29, (Object)objPC.embalagens);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(29)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"embalagens\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.embalagens;
    }

    private static void jdoSetembalagens(Entidadesdocumentos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 29, (Object)objPC.embalagens, (Object)val);
        } else {
            objPC.embalagens = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(29);
            }
        }
    }

    private static Entidades jdoGetentidade(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 30)) {
            return (Entidades)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 30, (Object)objPC.entidade);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(30)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"entidade\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.entidade;
    }

    private static void jdoSetentidade(Entidadesdocumentos objPC, Entidades val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 30, (Object)objPC.entidade, (Object)val);
        } else {
            objPC.entidade = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(30);
            }
        }
    }

    private static List jdoGetentregaspagamento(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 31)) {
            return (List)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 31, objPC.entregaspagamento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(31)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"entregaspagamento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.entregaspagamento;
    }

    private static void jdoSetentregaspagamento(Entidadesdocumentos objPC, List val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 31, objPC.entregaspagamento, (Object)val);
        } else {
            objPC.entregaspagamento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(31);
            }
        }
    }

    private static Integer jdoGetestado(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 32)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 32, (Object)objPC.estado);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(32)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"estado\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.estado;
    }

    private static void jdoSetestado(Entidadesdocumentos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 32, (Object)objPC.estado, (Object)val);
        } else {
            objPC.estado = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(32);
            }
        }
    }

    private static Integer jdoGetestadoenvio(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 33)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 33, (Object)objPC.estadoenvio);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(33)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"estadoenvio\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.estadoenvio;
    }

    private static void jdoSetestadoenvio(Entidadesdocumentos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 33, (Object)objPC.estadoenvio, (Object)val);
        } else {
            objPC.estadoenvio = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(33);
            }
        }
    }

    private static String jdoGetexpedicao(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 34)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 34, objPC.expedicao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(34)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"expedicao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.expedicao;
    }

    private static void jdoSetexpedicao(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 34, objPC.expedicao, val);
        } else {
            objPC.expedicao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(34);
            }
        }
    }

    private static String jdoGethash(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 35)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 35, objPC.hash);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(35)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"hash\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.hash;
    }

    private static void jdoSethash(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 35, objPC.hash, val);
        } else {
            objPC.hash = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(35);
            }
        }
    }

    private static Integer jdoGethashcontrol(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 36)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 36, (Object)objPC.hashcontrol);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(36)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"hashcontrol\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.hashcontrol;
    }

    private static void jdoSethashcontrol(Entidadesdocumentos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 36, (Object)objPC.hashcontrol, (Object)val);
        } else {
            objPC.hashcontrol = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(36);
            }
        }
    }

    private static Time jdoGethoracarga(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 37)) {
            return (Time)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 37, (Object)objPC.horacarga);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(37)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"horacarga\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.horacarga;
    }

    private static void jdoSethoracarga(Entidadesdocumentos objPC, Time val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 37, (Object)objPC.horacarga, (Object)val);
        } else {
            objPC.horacarga = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(37);
            }
        }
    }

    private static Time jdoGethoracriacao(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 38)) {
            return (Time)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 38, (Object)objPC.horacriacao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(38)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"horacriacao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.horacriacao;
    }

    private static void jdoSethoracriacao(Entidadesdocumentos objPC, Time val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 38, (Object)objPC.horacriacao, (Object)val);
        } else {
            objPC.horacriacao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(38);
            }
        }
    }

    private static Time jdoGethoradescarga(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 39)) {
            return (Time)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 39, (Object)objPC.horadescarga);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(39)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"horadescarga\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.horadescarga;
    }

    private static void jdoSethoradescarga(Entidadesdocumentos objPC, Time val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 39, (Object)objPC.horadescarga, (Object)val);
        } else {
            objPC.horadescarga = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(39);
            }
        }
    }

    private static Time jdoGethoraenvio(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 40)) {
            return (Time)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 40, (Object)objPC.horaenvio);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(40)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"horaenvio\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.horaenvio;
    }

    private static void jdoSethoraenvio(Entidadesdocumentos objPC, Time val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 40, (Object)objPC.horaenvio, (Object)val);
        } else {
            objPC.horaenvio = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(40);
            }
        }
    }

    private static Time jdoGethorasistema(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 41)) {
            return (Time)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 41, (Object)objPC.horasistema);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(41)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"horasistema\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.horasistema;
    }

    private static void jdoSethorasistema(Entidadesdocumentos objPC, Time val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 41, (Object)objPC.horasistema, (Object)val);
        } else {
            objPC.horasistema = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(41);
            }
        }
    }

    private static String jdoGetkey(Entidadesdocumentos objPC) {
        return objPC.key;
    }

    private static void jdoSetkey(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.key = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 42, objPC.key, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(42);
        }
    }

    private static List jdoGetlinhasdocumento(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 43)) {
            return (List)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 43, objPC.linhasdocumento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(43)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"linhasdocumento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.linhasdocumento;
    }

    private static void jdoSetlinhasdocumento(Entidadesdocumentos objPC, List val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 43, objPC.linhasdocumento, (Object)val);
        } else {
            objPC.linhasdocumento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(43);
            }
        }
    }

    private static String jdoGetlocalcarga(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 44)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 44, objPC.localcarga);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(44)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"localcarga\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.localcarga;
    }

    private static void jdoSetlocalcarga(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 44, objPC.localcarga, val);
        } else {
            objPC.localcarga = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(44);
            }
        }
    }

    private static String jdoGetlocaldescarga(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 45)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 45, objPC.localdescarga);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(45)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"localdescarga\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.localdescarga;
    }

    private static void jdoSetlocaldescarga(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 45, objPC.localdescarga, val);
        } else {
            objPC.localdescarga = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(45);
            }
        }
    }

    private static String jdoGetlocalidade(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 46)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 46, objPC.localidade);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(46)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"localidade\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.localidade;
    }

    private static void jdoSetlocalidade(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 46, objPC.localidade, val);
        } else {
            objPC.localidade = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(46);
            }
        }
    }

    private static String jdoGetmarcas(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 47)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 47, objPC.marcas);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(47)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"marcas\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.marcas;
    }

    private static void jdoSetmarcas(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 47, objPC.marcas, val);
        } else {
            objPC.marcas = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(47);
            }
        }
    }

    private static String jdoGetmatricula(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 48)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 48, objPC.matricula);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(48)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"matricula\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.matricula;
    }

    private static void jdoSetmatricula(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 48, objPC.matricula, val);
        } else {
            objPC.matricula = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(48);
            }
        }
    }

    private static Metodospagamento jdoGetmetodopagamento(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 49)) {
            return (Metodospagamento)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 49, (Object)objPC.metodopagamento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(49)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"metodopagamento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.metodopagamento;
    }

    private static void jdoSetmetodopagamento(Entidadesdocumentos objPC, Metodospagamento val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 49, (Object)objPC.metodopagamento, (Object)val);
        } else {
            objPC.metodopagamento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(49);
            }
        }
    }

    private static Metodostransporte jdoGetmetodotransporte(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 50)) {
            return (Metodostransporte)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 50, (Object)objPC.metodotransporte);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(50)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"metodotransporte\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.metodotransporte;
    }

    private static void jdoSetmetodotransporte(Entidadesdocumentos objPC, Metodostransporte val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 50, (Object)objPC.metodotransporte, (Object)val);
        } else {
            objPC.metodotransporte = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(50);
            }
        }
    }

    private static Moedas jdoGetmoeda(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 51)) {
            return (Moedas)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 51, (Object)objPC.moeda);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(51)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"moeda\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.moeda;
    }

    private static void jdoSetmoeda(Entidadesdocumentos objPC, Moedas val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 51, (Object)objPC.moeda, (Object)val);
        } else {
            objPC.moeda = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(51);
            }
        }
    }

    private static String jdoGetmorada(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 52)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 52, objPC.morada);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(52)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"morada\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.morada;
    }

    private static void jdoSetmorada(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 52, objPC.morada, val);
        } else {
            objPC.morada = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(52);
            }
        }
    }

    private static Entidadesmovimentos jdoGetmovimentoentidades(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 53)) {
            return (Entidadesmovimentos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 53, (Object)objPC.movimentoentidades);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(53)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"movimentoentidades\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.movimentoentidades;
    }

    private static void jdoSetmovimentoentidades(Entidadesdocumentos objPC, Entidadesmovimentos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 53, (Object)objPC.movimentoentidades, (Object)val);
        } else {
            objPC.movimentoentidades = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(53);
            }
        }
    }

    private static String jdoGetnif(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 54)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 54, objPC.nif);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(54)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"nif\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.nif;
    }

    private static void jdoSetnif(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 54, objPC.nif, val);
        } else {
            objPC.nif = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(54);
            }
        }
    }

    private static String jdoGetnome(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 55)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 55, objPC.nome);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(55)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"nome\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.nome;
    }

    private static void jdoSetnome(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 55, objPC.nome, val);
        } else {
            objPC.nome = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(55);
            }
        }
    }

    private static String jdoGetnumeroauxiliar(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 56)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 56, objPC.numeroauxiliar);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(56)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numeroauxiliar\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numeroauxiliar;
    }

    private static void jdoSetnumeroauxiliar(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 56, objPC.numeroauxiliar, val);
        } else {
            objPC.numeroauxiliar = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(56);
            }
        }
    }

    private static Integer jdoGetnumerodocumento(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 57)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 57, (Object)objPC.numerodocumento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(57)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numerodocumento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numerodocumento;
    }

    private static void jdoSetnumerodocumento(Entidadesdocumentos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 57, (Object)objPC.numerodocumento, (Object)val);
        } else {
            objPC.numerodocumento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(57);
            }
        }
    }

    private static String jdoGetobs(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 58)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 58, objPC.obs);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(58)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"obs\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.obs;
    }

    private static void jdoSetobs(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 58, objPC.obs, val);
        } else {
            objPC.obs = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(58);
            }
        }
    }

    private static Paises jdoGetpais(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 59)) {
            return (Paises)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 59, (Object)objPC.pais);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(59)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"pais\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.pais;
    }

    private static void jdoSetpais(Entidadesdocumentos objPC, Paises val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 59, (Object)objPC.pais, (Object)val);
        } else {
            objPC.pais = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(59);
            }
        }
    }

    private static Paises jdoGetpaiscarga(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 60)) {
            return (Paises)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 60, (Object)objPC.paiscarga);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(60)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"paiscarga\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.paiscarga;
    }

    private static void jdoSetpaiscarga(Entidadesdocumentos objPC, Paises val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 60, (Object)objPC.paiscarga, (Object)val);
        } else {
            objPC.paiscarga = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(60);
            }
        }
    }

    private static Paises jdoGetpaisdescarga(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 61)) {
            return (Paises)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 61, (Object)objPC.paisdescarga);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(61)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"paisdescarga\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.paisdescarga;
    }

    private static void jdoSetpaisdescarga(Entidadesdocumentos objPC, Paises val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 61, (Object)objPC.paisdescarga, (Object)val);
        } else {
            objPC.paisdescarga = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(61);
            }
        }
    }

    private static BigDecimal jdoGetpercdesconto(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 62)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 62, (Object)objPC.percdesconto);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(62)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"percdesconto\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.percdesconto;
    }

    private static void jdoSetpercdesconto(Entidadesdocumentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 62, (Object)objPC.percdesconto, (Object)val);
        } else {
            objPC.percdesconto = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(62);
            }
        }
    }

    private static BigDecimal jdoGetpesobruto(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 63)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 63, (Object)objPC.pesobruto);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(63)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"pesobruto\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.pesobruto;
    }

    private static void jdoSetpesobruto(Entidadesdocumentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 63, (Object)objPC.pesobruto, (Object)val);
        } else {
            objPC.pesobruto = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(63);
            }
        }
    }

    private static BigDecimal jdoGetpesoliquido(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 64)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 64, (Object)objPC.pesoliquido);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(64)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"pesoliquido\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.pesoliquido;
    }

    private static void jdoSetpesoliquido(Entidadesdocumentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 64, (Object)objPC.pesoliquido, (Object)val);
        } else {
            objPC.pesoliquido = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(64);
            }
        }
    }

    private static Integer jdoGetreturncode(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 65)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 65, (Object)objPC.returncode);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(65)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"returncode\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.returncode;
    }

    private static void jdoSetreturncode(Entidadesdocumentos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 65, (Object)objPC.returncode, (Object)val);
        } else {
            objPC.returncode = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(65);
            }
        }
    }

    private static String jdoGetreturnmessage(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 66)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 66, objPC.returnmessage);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(66)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"returnmessage\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.returnmessage;
    }

    private static void jdoSetreturnmessage(Entidadesdocumentos objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 66, objPC.returnmessage, val);
        } else {
            objPC.returnmessage = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(66);
            }
        }
    }

    private static Documentosseries jdoGetseriedocumento(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 67)) {
            return (Documentosseries)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 67, (Object)objPC.seriedocumento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(67)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"seriedocumento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.seriedocumento;
    }

    private static void jdoSetseriedocumento(Entidadesdocumentos objPC, Documentosseries val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 67, (Object)objPC.seriedocumento, (Object)val);
        } else {
            objPC.seriedocumento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(67);
            }
        }
    }

    private static List jdoGettabelaiva(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 68)) {
            return (List)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 68, objPC.tabelaiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(68)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tabelaiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tabelaiva;
    }

    private static void jdoSettabelaiva(Entidadesdocumentos objPC, List val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 68, objPC.tabelaiva, (Object)val);
        } else {
            objPC.tabelaiva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(68);
            }
        }
    }

    private static Templates jdoGettemplate(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 69)) {
            return (Templates)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 69, (Object)objPC.template);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(69)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"template\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.template;
    }

    private static void jdoSettemplate(Entidadesdocumentos objPC, Templates val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 69, (Object)objPC.template, (Object)val);
        } else {
            objPC.template = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(69);
            }
        }
    }

    private static Documentostipos jdoGettipodocumento(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 70)) {
            return (Documentostipos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 70, (Object)objPC.tipodocumento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(70)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipodocumento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipodocumento;
    }

    private static void jdoSettipodocumento(Entidadesdocumentos objPC, Documentostipos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 70, (Object)objPC.tipodocumento, (Object)val);
        } else {
            objPC.tipodocumento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(70);
            }
        }
    }

    private static BigDecimal jdoGettotal(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 71)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 71, (Object)objPC.total);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(71)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"total\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.total;
    }

    private static void jdoSettotal(Entidadesdocumentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 71, (Object)objPC.total, (Object)val);
        } else {
            objPC.total = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(71);
            }
        }
    }

    private static BigDecimal jdoGettotalbruto(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 72)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 72, (Object)objPC.totalbruto);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(72)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"totalbruto\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.totalbruto;
    }

    private static void jdoSettotalbruto(Entidadesdocumentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 72, (Object)objPC.totalbruto, (Object)val);
        } else {
            objPC.totalbruto = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(72);
            }
        }
    }

    private static BigDecimal jdoGettotaldeducoes(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 73)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 73, (Object)objPC.totaldeducoes);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(73)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"totaldeducoes\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.totaldeducoes;
    }

    private static void jdoSettotaldeducoes(Entidadesdocumentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 73, (Object)objPC.totaldeducoes, (Object)val);
        } else {
            objPC.totaldeducoes = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(73);
            }
        }
    }

    private static BigDecimal jdoGettotaldesconto(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 74)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 74, (Object)objPC.totaldesconto);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(74)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"totaldesconto\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.totaldesconto;
    }

    private static void jdoSettotaldesconto(Entidadesdocumentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 74, (Object)objPC.totaldesconto, (Object)val);
        } else {
            objPC.totaldesconto = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(74);
            }
        }
    }

    private static BigDecimal jdoGettotalentregue(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 75)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 75, (Object)objPC.totalentregue);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(75)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"totalentregue\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.totalentregue;
    }

    private static void jdoSettotalentregue(Entidadesdocumentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 75, (Object)objPC.totalentregue, (Object)val);
        } else {
            objPC.totalentregue = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(75);
            }
        }
    }

    private static BigDecimal jdoGettotaliliquido(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 76)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 76, (Object)objPC.totaliliquido);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(76)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"totaliliquido\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.totaliliquido;
    }

    private static void jdoSettotaliliquido(Entidadesdocumentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 76, (Object)objPC.totaliliquido, (Object)val);
        } else {
            objPC.totaliliquido = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(76);
            }
        }
    }

    private static BigDecimal jdoGettotaliva(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 77)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 77, (Object)objPC.totaliva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(77)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"totaliva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.totaliva;
    }

    private static void jdoSettotaliva(Entidadesdocumentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 77, (Object)objPC.totaliva, (Object)val);
        } else {
            objPC.totaliva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(77);
            }
        }
    }

    private static BigDecimal jdoGettotalliquido(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 78)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 78, (Object)objPC.totalliquido);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(78)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"totalliquido\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.totalliquido;
    }

    private static void jdoSettotalliquido(Entidadesdocumentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 78, (Object)objPC.totalliquido, (Object)val);
        } else {
            objPC.totalliquido = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(78);
            }
        }
    }

    private static BigDecimal jdoGettotalprodutos(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 79)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 79, (Object)objPC.totalprodutos);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(79)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"totalprodutos\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.totalprodutos;
    }

    private static void jdoSettotalprodutos(Entidadesdocumentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 79, (Object)objPC.totalprodutos, (Object)val);
        } else {
            objPC.totalprodutos = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(79);
            }
        }
    }

    private static BigDecimal jdoGettotalretencoes(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 80)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 80, (Object)objPC.totalretencoes);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(80)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"totalretencoes\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.totalretencoes;
    }

    private static void jdoSettotalretencoes(Entidadesdocumentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 80, (Object)objPC.totalretencoes, (Object)val);
        } else {
            objPC.totalretencoes = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(80);
            }
        }
    }

    private static BigDecimal jdoGettotalservicos(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 81)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 81, (Object)objPC.totalservicos);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(81)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"totalservicos\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.totalservicos;
    }

    private static void jdoSettotalservicos(Entidadesdocumentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 81, (Object)objPC.totalservicos, (Object)val);
        } else {
            objPC.totalservicos = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(81);
            }
        }
    }

    private static Vendedores jdoGetvendedor(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 82)) {
            return (Vendedores)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 82, (Object)objPC.vendedor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(82)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"vendedor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.vendedor;
    }

    private static void jdoSetvendedor(Entidadesdocumentos objPC, Vendedores val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 82, (Object)objPC.vendedor, (Object)val);
        } else {
            objPC.vendedor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(82);
            }
        }
    }

    private static Viaturas jdoGetviatura(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 83)) {
            return (Viaturas)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 83, (Object)objPC.viatura);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(83)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"viatura\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.viatura;
    }

    private static void jdoSetviatura(Entidadesdocumentos objPC, Viaturas val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 83, (Object)objPC.viatura, (Object)val);
        } else {
            objPC.viatura = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(83);
            }
        }
    }

    private static BigDecimal jdoGetvolume(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 84)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 84, (Object)objPC.volume);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(84)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"volume\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.volume;
    }

    private static void jdoSetvolume(Entidadesdocumentos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 84, (Object)objPC.volume, (Object)val);
        } else {
            objPC.volume = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(84);
            }
        }
    }

    private static List jdoGetwebservice(Entidadesdocumentos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 85)) {
            return (List)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 85, objPC.webservice);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(85)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"webservice\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.webservice;
    }

    private static void jdoSetwebservice(Entidadesdocumentos objPC, List val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 85, objPC.webservice, (Object)val);
        } else {
            objPC.webservice = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(85);
            }
        }
    }
}

