/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.util.BitSet;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.IntIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dma.java.email.EmailAddress;
import org.dma.java.email.EmailMessage;
import org.dma.java.email.EmailRecipients;
import org.dma.java.io.ByteFile;
import org.dma.java.security.JKSCertificate;
import org.dma.java.security.PdfSignature;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringUtils;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.birt.report.BIRTEmailParameters;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.model.Codigospostais;
import org.projectocolibri.api.database.model.Paises;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.core.CERTIFICATES;

@javax.jdo.annotations.PersistenceCapable
public class Empresa
extends AbstractModel
implements Detachable,
PersistenceCapable {
    public static final int NIF_FISCO = 599999993;
    private Integer id;
    private String nome;
    private String morada;
    private Codigospostais codigopostal;
    private String localidade;
    private Paises pais;
    private String nif;
    private String telefone;
    private String telefone2;
    private String telemovel;
    private String fax;
    private String email;
    private String url;
    private String conservatoria;
    private String registocomercial;
    private String capitalsocial;
    private String estabelecimento;
    private byte[] certificado;
    private String jkspassword;
    private byte[] logotipo;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    private Empresa() {
        super(TABLES.empresa);
    }

    public Empresa(DatabaseManager manager) {
        this(manager, 0);
    }

    private Empresa(DatabaseManager manager, Integer id) {
        super(TABLES.empresa, manager);
        this.id = id;
        this.nome = manager.getLicenca().getNomeTitular();
        this.morada = manager.getLicenca().xml.getTitular().getMorada();
        this.codigopostal = manager.loadCodigospostais();
        this.localidade = manager.getLicenca().xml.getTitular().getLocalidade();
        this.pais = manager.loadPaises(manager.getLicenca().getPaisTitular());
        this.nif = manager.getLicenca().getNifTitular();
        this.telefone = manager.getLicenca().xml.getTitular().getTelefone();
        this.telefone2 = "";
        this.telemovel = "";
        this.fax = "";
        this.email = manager.getLicenca().getEmailTitular();
        this.url = manager.getLicenca().xml.getTitular().getWebsite();
        this.conservatoria = "";
        this.registocomercial = "";
        this.capitalsocial = "";
        this.estabelecimento = manager.getLicenca().getNomeTitular();
        this.logotipo = new ByteFile(Colibri.FILES.IMAGES.BANNER_SMALL.pathname, new String[0]).read();
    }

    @Override
    public MessageList validate(IDatabaseModel.ACTION action) {
        return this.validate(action, null);
    }

    public MessageList validate(IDatabaseModel.ACTION action, Empresa stored) {
        MessageList error = super.validate(action);
        switch (action) {
            case DELETE: {
                break;
            }
            case STORE: {
                if (this.getNomeToText().isEmpty()) {
                    error.add((Object)new MessageLine((Object)LABELS.empresa_nome));
                }
                if (this.getMoradaToText().isEmpty()) {
                    error.add((Object)new MessageLine((Object)LABELS.empresa_morada));
                }
                if (!this.isCodigopostalValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.empresa_codigopostal));
                }
                if (Empresa.jdoGetpais(this) == null) {
                    error.add((Object)new MessageLine((Object)LABELS.empresa_pais));
                }
                if (!this.isNifValid() && !this.manager.getUtilizador().isColibri()) {
                    error.add((Object)new MessageLine((Object)LABELS.empresa_nif));
                }
                if (!this.isNifEqual(stored) && !this.manager.getUtilizador().isColibri() && this.manager.countEntidadesdocumentos(TABLES.entidadestipos.defaultKey()) > 0L) {
                    error.add((Object)new MessageLine((Object)LABELS.empresa_nif).notEqual((Object)stored.getNif()));
                }
                if (!this.isEmailValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.empresa_email));
                }
                if (this.isCertificadoValid()) break;
                error.add((Object)new MessageLine((Object)LABELS.empresa_certificado));
            }
        }
        return error;
    }

    @Override
    public Integer getKey() {
        return Empresa.jdoGetid(this);
    }

    public Integer getId() {
        return Empresa.jdoGetid(this);
    }

    public void setId(Integer id) {
        Integer n = Empresa.jdoGetid(this);
        Integer n2 = id;
        Empresa.jdoSetid(this, n2);
        this.firePropertyChange(FIELDS.empresa_id, (Object)n, (Object)n2);
    }

    public String getNome() {
        return Empresa.jdoGetnome(this);
    }

    public String getNomeToText() {
        return Empresa.jdoGetnome(this) == null ? "" : Empresa.jdoGetnome(this).toString();
    }

    public void setNome(String nome) {
        String string = Empresa.jdoGetnome(this);
        String string2 = nome;
        Empresa.jdoSetnome(this, string2);
        this.firePropertyChange(FIELDS.empresa_nome, (Object)string, (Object)string2);
    }

    public String getMorada() {
        return Empresa.jdoGetmorada(this);
    }

    public String getMoradaToText() {
        return Empresa.jdoGetmorada(this) == null ? "" : FIELDS.empresa_morada.format.format(Empresa.jdoGetmorada(this));
    }

    public void setMorada(String morada) {
        String string = Empresa.jdoGetmorada(this);
        String string2 = morada;
        Empresa.jdoSetmorada(this, string2);
        this.firePropertyChange(FIELDS.empresa_morada, (Object)string, (Object)string2);
    }

    public Codigospostais getCodigopostal() {
        return Empresa.jdoGetcodigopostal(this);
    }

    public void setCodigopostal(Codigospostais codigopostal) {
        Codigospostais codigospostais = Empresa.jdoGetcodigopostal(this);
        Codigospostais codigospostais2 = codigopostal;
        Empresa.jdoSetcodigopostal(this, codigospostais2);
        boolean changed = this.firePropertyChange(FIELDS.empresa_codigopostal, (Object)codigospostais, (Object)codigospostais2);
        if (changed && this.cascade && codigopostal != null) {
            this.setLocalidade(codigopostal.getDescricao());
        }
    }

    public boolean isCodigopostalValid() {
        return !StringUtils.isEmpty((String)Empresa.jdoGetlocalidade(this)) && Empresa.jdoGetcodigopostal(this) != null && Empresa.jdoGetcodigopostal(this).isValid(Empresa.jdoGetpais(this));
    }

    public String getLocalidade() {
        return Empresa.jdoGetlocalidade(this);
    }

    public String getLocalidadeToText() {
        return Empresa.jdoGetlocalidade(this) == null ? "" : Empresa.jdoGetlocalidade(this).toString();
    }

    public void setLocalidade(String localidade) {
        String string = Empresa.jdoGetlocalidade(this);
        String string2 = localidade;
        Empresa.jdoSetlocalidade(this, string2);
        this.firePropertyChange(FIELDS.empresa_localidade, (Object)string, (Object)string2);
    }

    public Paises getPais() {
        return Empresa.jdoGetpais(this);
    }

    public void setPais(Paises pais) {
        Paises paises = Empresa.jdoGetpais(this);
        Paises paises2 = pais;
        Empresa.jdoSetpais(this, paises2);
        this.firePropertyChange(FIELDS.empresa_pais, (Object)paises, (Object)paises2);
    }

    public String getNif() {
        return Empresa.jdoGetnif(this);
    }

    public String getNifToText() {
        return Empresa.jdoGetnif(this) == null ? "" : Empresa.jdoGetnif(this).toString();
    }

    public void setNif(String nif) {
        String string = Empresa.jdoGetnif(this);
        String string2 = nif;
        Empresa.jdoSetnif(this, string2);
        this.firePropertyChange(FIELDS.empresa_nif, (Object)string, (Object)string2);
    }

    public String getNifToNumbers() {
        return StringUtils.numbers((String)this.getNifToText());
    }

    public Integer getNifToInteger() {
        return StringUtils.val((String)this.getNifToNumbers());
    }

    public String getNifParsed() {
        return Empresa.jdoGetpais(this) == null ? this.getNifToText() : Empresa.jdoGetpais(this).parseNif(Empresa.jdoGetnif(this));
    }

    public boolean isNifValid() {
        return Empresa.jdoGetpais(this) != null && Empresa.jdoGetpais(this).isNifValid(this.getNifToText());
    }

    public boolean isNifEqual(Paises pais, String nif) {
        return pais != null && pais.equals(Empresa.jdoGetpais(this)) && pais.parseNif(nif).equals(this.getNifParsed());
    }

    public boolean isNifEqual(Empresa other) {
        return other == null || other.isNifEqual(Empresa.jdoGetpais(this), Empresa.jdoGetnif(this));
    }

    public boolean isNifEditable() {
        return this.manager.getUtilizador().isGestor();
    }

    public String getTelefone() {
        return Empresa.jdoGettelefone(this);
    }

    public String getTelefoneToText() {
        return Empresa.jdoGettelefone(this) == null ? "" : Empresa.jdoGettelefone(this).toString();
    }

    public void setTelefone(String telefone) {
        String string = Empresa.jdoGettelefone(this);
        String string2 = telefone;
        Empresa.jdoSettelefone(this, string2);
        this.firePropertyChange(FIELDS.empresa_telefone, (Object)string, (Object)string2);
    }

    public String getTelefone2() {
        return Empresa.jdoGettelefone2(this);
    }

    public String getTelefone2ToText() {
        return Empresa.jdoGettelefone2(this) == null ? "" : Empresa.jdoGettelefone2(this).toString();
    }

    public void setTelefone2(String telefone2) {
        String string = Empresa.jdoGettelefone2(this);
        String string2 = telefone2;
        Empresa.jdoSettelefone2(this, string2);
        this.firePropertyChange(FIELDS.empresa_telefone2, (Object)string, (Object)string2);
    }

    public String getTelemovel() {
        return Empresa.jdoGettelemovel(this);
    }

    public String getTelemovelToText() {
        return Empresa.jdoGettelemovel(this) == null ? "" : Empresa.jdoGettelemovel(this).toString();
    }

    public void setTelemovel(String telemovel) {
        String string = Empresa.jdoGettelemovel(this);
        String string2 = telemovel;
        Empresa.jdoSettelemovel(this, string2);
        this.firePropertyChange(FIELDS.empresa_telemovel, (Object)string, (Object)string2);
    }

    public String getFax() {
        return Empresa.jdoGetfax(this);
    }

    public String getFaxToText() {
        return Empresa.jdoGetfax(this) == null ? "" : Empresa.jdoGetfax(this).toString();
    }

    public void setFax(String fax) {
        String string = Empresa.jdoGetfax(this);
        String string2 = fax;
        Empresa.jdoSetfax(this, string2);
        this.firePropertyChange(FIELDS.empresa_fax, (Object)string, (Object)string2);
    }

    public String getEmail() {
        return Empresa.jdoGetemail(this);
    }

    public String getEmailToText() {
        return Empresa.jdoGetemail(this) == null ? "" : Empresa.jdoGetemail(this).toString();
    }

    public void setEmail(String email) {
        String string = Empresa.jdoGetemail(this);
        String string2 = email;
        Empresa.jdoSetemail(this, string2);
        this.firePropertyChange(FIELDS.empresa_email, (Object)string, (Object)string2);
    }

    public EmailAddress getEmailAddress() {
        return new EmailAddress(Empresa.jdoGetemail(this), Empresa.jdoGetnome(this));
    }

    public boolean isEmailValid() {
        EmailAddress address = this.getEmailAddress();
        return address == null || address.isValid();
    }

    public BIRTEmailParameters getEmailParameters(EmailRecipients recipients, EmailMessage message) {
        return new BIRTEmailParameters(this.manager.getParametros().getMailServer(), this.getEmailAddress(), recipients, message);
    }

    public String getUrl() {
        return Empresa.jdoGeturl(this);
    }

    public String getUrlToText() {
        return Empresa.jdoGeturl(this) == null ? "" : Empresa.jdoGeturl(this).toString();
    }

    public void setUrl(String url) {
        String string = Empresa.jdoGeturl(this);
        String string2 = url;
        Empresa.jdoSeturl(this, string2);
        this.firePropertyChange(FIELDS.empresa_url, (Object)string, (Object)string2);
    }

    public String getConservatoria() {
        return Empresa.jdoGetconservatoria(this);
    }

    public String getConservatoriaToText() {
        return Empresa.jdoGetconservatoria(this) == null ? "" : Empresa.jdoGetconservatoria(this).toString();
    }

    public void setConservatoria(String conservatoria) {
        String string = Empresa.jdoGetconservatoria(this);
        String string2 = conservatoria;
        Empresa.jdoSetconservatoria(this, string2);
        this.firePropertyChange(FIELDS.empresa_conservatoria, (Object)string, (Object)string2);
    }

    public String getRegistocomercial() {
        return Empresa.jdoGetregistocomercial(this);
    }

    public String getRegistocomercialToText() {
        return Empresa.jdoGetregistocomercial(this) == null ? "" : Empresa.jdoGetregistocomercial(this).toString();
    }

    public void setRegistocomercial(String registocomercial) {
        String string = Empresa.jdoGetregistocomercial(this);
        String string2 = registocomercial;
        Empresa.jdoSetregistocomercial(this, string2);
        this.firePropertyChange(FIELDS.empresa_registocomercial, (Object)string, (Object)string2);
    }

    public String getCapitalsocial() {
        return Empresa.jdoGetcapitalsocial(this);
    }

    public String getCapitalsocialToText() {
        return Empresa.jdoGetcapitalsocial(this) == null ? "" : Empresa.jdoGetcapitalsocial(this).toString();
    }

    public void setCapitalsocial(String capitalsocial) {
        String string = Empresa.jdoGetcapitalsocial(this);
        String string2 = capitalsocial;
        Empresa.jdoSetcapitalsocial(this, string2);
        this.firePropertyChange(FIELDS.empresa_capitalsocial, (Object)string, (Object)string2);
    }

    public String getEstabelecimento() {
        return Empresa.jdoGetestabelecimento(this);
    }

    public String getEstabelecimentoToText() {
        return Empresa.jdoGetestabelecimento(this) == null ? "" : Empresa.jdoGetestabelecimento(this).toString();
    }

    public void setEstabelecimento(String estabelecimento) {
        String string = Empresa.jdoGetestabelecimento(this);
        String string2 = estabelecimento;
        Empresa.jdoSetestabelecimento(this, string2);
        this.firePropertyChange(FIELDS.empresa_estabelecimento, (Object)string, (Object)string2);
    }

    public byte[] getCertificado() {
        return Empresa.jdoGetcertificado(this);
    }

    public String getCertificadoToText() {
        return this.getJkscertificate().toString();
    }

    public void setCertificado(byte[] certificado, String jkspassword) {
        this.setCertificado(certificado);
        this.setJkspassword(jkspassword);
    }

    public void setCertificado(byte[] certificado) {
        byte[] byArray = Empresa.jdoGetcertificado(this);
        byte[] byArray2 = certificado == null || certificado.length == 0 ? null : certificado;
        Empresa.jdoSetcertificado(this, byArray2);
        this.firePropertyChange(FIELDS.empresa_certificado, (Object)byArray, (Object)byArray2);
    }

    public boolean isCertificadoValid() {
        return !this.hasCertificado() || this.getJkscertificate().isValid();
    }

    public boolean hasCertificado() {
        return Empresa.jdoGetcertificado(this) != null;
    }

    public JKSCertificate getJkscertificate() {
        return this.hasCertificado() && this.manager.getLicenca().allows(Colibri.FUNCIONALIDADES.CERTIFICADO_DIGITAL) ? new JKSCertificate(JKSCertificate.KEYSTORE_TYPE.PKCS12, Empresa.jdoGetcertificado(this), this.getJkspassword(), new String[0]) : CERTIFICATES.DGITA_SW_PROD.cert;
    }

    public PdfSignature getPdfSignature() throws Exception {
        JKSCertificate cert = this.getJkscertificate();
        if (!cert.isValid()) {
            throw new Exception(LABELS.empresa_certificado.toString());
        }
        PdfSignature signature = new PdfSignature(cert);
        signature.setLocation(this.getLocalidadeToText());
        signature.setContact(this.getEmailToText());
        return signature;
    }

    public String getJkspassword() {
        return Colibri.PASSWORD_CIPHER.decode(this.getJkspasswordToText());
    }

    public String getJkspasswordToText() {
        return Empresa.jdoGetjkspassword(this) == null ? "" : Empresa.jdoGetjkspassword(this).toString();
    }

    public void setJkspassword(String jkspassword) {
        String string = Empresa.jdoGetjkspassword(this);
        String string2 = Colibri.PASSWORD_CIPHER.encode(jkspassword);
        Empresa.jdoSetjkspassword(this, string2);
        this.firePropertyChange(FIELDS.empresa_jkspassword, (Object)string, (Object)string2);
    }

    public byte[] getLogotipo() {
        return Empresa.jdoGetlogotipo(this);
    }

    public void setLogotipo(byte[] logotipo) {
        byte[] byArray = Empresa.jdoGetlogotipo(this);
        byte[] byArray2 = logotipo == null || logotipo.length == 0 ? null : logotipo;
        Empresa.jdoSetlogotipo(this, byArray2);
        this.firePropertyChange(FIELDS.empresa_logotipo, (Object)byArray, (Object)byArray2);
    }

    @Override
    public boolean isEditable(FIELDS field) {
        return field != FIELDS.empresa_nif || !this.isEdited() || this.isNifEditable();
    }

    @Override
    public void attach(DatabaseManager manager) {
        manager.attach(new AbstractModel[]{Empresa.jdoGetcodigopostal(this), Empresa.jdoGetpais(this)});
    }

    public String toString() {
        return "DADOS DA EMPRESA\nNIF: " + this.getNifToText() + "\nNome: " + this.getNomeToText() + "\nMorada: " + this.getMoradaToText() + "\nCodigo Postal: " + this.getCodigopostal().toString() + "\nLocalidade: " + this.getLocalidade() + "\nTelefone: " + this.getTelefoneToText() + "\nTelefone2: " + this.getTelefone2ToText() + "\nFax: " + this.getFaxToText() + "\nEmail: " + this.getEmailToText() + "\nWebsite: " + this.getUrlToText();
    }

    static {
        jdoFieldNames = Empresa.__jdoFieldNamesInit();
        jdoFieldTypes = Empresa.__jdoFieldTypesInit();
        jdoFieldFlags = Empresa.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Empresa.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Empresa.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Empresa.___jdo$loadClass("org.projectocolibri.api.database.model.Empresa"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Empresa());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof IntIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.IntIdentity");
        }
        IntIdentity o = (IntIdentity)oid;
        fc.storeObjectField(7, (Object)new Integer(o.getKey()));
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof IntIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.IntIdentity or null");
        }
        IntIdentity o = (IntIdentity)oid;
        this.id = new Integer(o.getKey());
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new IntIdentity(this.getClass(), this.id);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new IntIdentity(this.getClass(), (Integer)key);
        }
        return new IntIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Empresa result = new Empresa();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Empresa result = new Empresa();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.capitalsocial = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.certificado = (byte[])this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.codigopostal = (Codigospostais)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.conservatoria = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.email = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.estabelecimento = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.fax = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.id = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 8: {
                this.jkspassword = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 9: {
                this.localidade = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 10: {
                this.logotipo = (byte[])this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 11: {
                this.morada = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 12: {
                this.nif = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 13: {
                this.nome = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 14: {
                this.pais = (Paises)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 15: {
                this.registocomercial = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 16: {
                this.telefone = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 17: {
                this.telefone2 = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 18: {
                this.telemovel = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 19: {
                this.url = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.capitalsocial);
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.certificado);
                break;
            }
            case 2: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.codigopostal);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.conservatoria);
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.email);
                break;
            }
            case 5: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.estabelecimento);
                break;
            }
            case 6: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.fax);
                break;
            }
            case 7: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.id);
                break;
            }
            case 8: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.jkspassword);
                break;
            }
            case 9: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.localidade);
                break;
            }
            case 10: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.logotipo);
                break;
            }
            case 11: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.morada);
                break;
            }
            case 12: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.nif);
                break;
            }
            case 13: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.nome);
                break;
            }
            case 14: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.pais);
                break;
            }
            case 15: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.registocomercial);
                break;
            }
            case 16: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.telefone);
                break;
            }
            case 17: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.telefone2);
                break;
            }
            case 18: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.telemovel);
                break;
            }
            case 19: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.url);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Empresa obj, int index) {
        switch (index) {
            case 0: {
                this.capitalsocial = obj.capitalsocial;
                break;
            }
            case 1: {
                this.certificado = obj.certificado;
                break;
            }
            case 2: {
                this.codigopostal = obj.codigopostal;
                break;
            }
            case 3: {
                this.conservatoria = obj.conservatoria;
                break;
            }
            case 4: {
                this.email = obj.email;
                break;
            }
            case 5: {
                this.estabelecimento = obj.estabelecimento;
                break;
            }
            case 6: {
                this.fax = obj.fax;
                break;
            }
            case 7: {
                this.id = obj.id;
                break;
            }
            case 8: {
                this.jkspassword = obj.jkspassword;
                break;
            }
            case 9: {
                this.localidade = obj.localidade;
                break;
            }
            case 10: {
                this.logotipo = obj.logotipo;
                break;
            }
            case 11: {
                this.morada = obj.morada;
                break;
            }
            case 12: {
                this.nif = obj.nif;
                break;
            }
            case 13: {
                this.nome = obj.nome;
                break;
            }
            case 14: {
                this.pais = obj.pais;
                break;
            }
            case 15: {
                this.registocomercial = obj.registocomercial;
                break;
            }
            case 16: {
                this.telefone = obj.telefone;
                break;
            }
            case 17: {
                this.telefone2 = obj.telefone2;
                break;
            }
            case 18: {
                this.telemovel = obj.telemovel;
                break;
            }
            case 19: {
                this.url = obj.url;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Empresa)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Empresa");
        }
        Empresa other = (Empresa)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"capitalsocial", "certificado", "codigopostal", "conservatoria", "email", "estabelecimento", "fax", "id", "jkspassword", "localidade", "logotipo", "morada", "nif", "nome", "pais", "registocomercial", "telefone", "telefone2", "telemovel", "url"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Empresa.___jdo$loadClass("java.lang.String"), Empresa.___jdo$loadClass("[B"), Empresa.___jdo$loadClass("org.projectocolibri.api.database.model.Codigospostais"), Empresa.___jdo$loadClass("java.lang.String"), Empresa.___jdo$loadClass("java.lang.String"), Empresa.___jdo$loadClass("java.lang.String"), Empresa.___jdo$loadClass("java.lang.String"), Empresa.___jdo$loadClass("java.lang.Integer"), Empresa.___jdo$loadClass("java.lang.String"), Empresa.___jdo$loadClass("java.lang.String"), Empresa.___jdo$loadClass("[B"), Empresa.___jdo$loadClass("java.lang.String"), Empresa.___jdo$loadClass("java.lang.String"), Empresa.___jdo$loadClass("java.lang.String"), Empresa.___jdo$loadClass("org.projectocolibri.api.database.model.Paises"), Empresa.___jdo$loadClass("java.lang.String"), Empresa.___jdo$loadClass("java.lang.String"), Empresa.___jdo$loadClass("java.lang.String"), Empresa.___jdo$loadClass("java.lang.String"), Empresa.___jdo$loadClass("java.lang.String")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 5, 21, 21, 21, 21, 24, 21, 21, 21, 21, 21, 21, 5, 21, 21, 21, 21, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 20;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Empresa o = (Empresa)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static String jdoGetcapitalsocial(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 0, objPC.capitalsocial);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"capitalsocial\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.capitalsocial;
    }

    private static void jdoSetcapitalsocial(Empresa objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 0, objPC.capitalsocial, val);
        } else {
            objPC.capitalsocial = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static byte[] jdoGetcertificado(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (byte[])objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, (Object)objPC.certificado);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"certificado\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.certificado;
    }

    private static void jdoSetcertificado(Empresa objPC, byte[] val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, (Object)objPC.certificado, (Object)val);
        } else {
            objPC.certificado = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static Codigospostais jdoGetcodigopostal(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return (Codigospostais)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 2, (Object)objPC.codigopostal);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"codigopostal\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.codigopostal;
    }

    private static void jdoSetcodigopostal(Empresa objPC, Codigospostais val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 2, (Object)objPC.codigopostal, (Object)val);
        } else {
            objPC.codigopostal = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static String jdoGetconservatoria(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.conservatoria);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"conservatoria\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.conservatoria;
    }

    private static void jdoSetconservatoria(Empresa objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.conservatoria, val);
        } else {
            objPC.conservatoria = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    private static String jdoGetemail(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 4, objPC.email);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"email\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.email;
    }

    private static void jdoSetemail(Empresa objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4, objPC.email, val);
        } else {
            objPC.email = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static String jdoGetestabelecimento(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 5, objPC.estabelecimento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"estabelecimento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.estabelecimento;
    }

    private static void jdoSetestabelecimento(Empresa objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 5, objPC.estabelecimento, val);
        } else {
            objPC.estabelecimento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    private static String jdoGetfax(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 6, objPC.fax);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"fax\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.fax;
    }

    private static void jdoSetfax(Empresa objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 6, objPC.fax, val);
        } else {
            objPC.fax = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }

    private static Integer jdoGetid(Empresa objPC) {
        return objPC.id;
    }

    private static void jdoSetid(Empresa objPC, Integer val) {
        if (objPC.jdoStateManager == null) {
            objPC.id = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 7, (Object)objPC.id, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(7);
        }
    }

    private static String jdoGetjkspassword(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 8, objPC.jkspassword);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"jkspassword\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.jkspassword;
    }

    private static void jdoSetjkspassword(Empresa objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 8, objPC.jkspassword, val);
        } else {
            objPC.jkspassword = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(8);
            }
        }
    }

    private static String jdoGetlocalidade(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 9, objPC.localidade);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"localidade\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.localidade;
    }

    private static void jdoSetlocalidade(Empresa objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 9, objPC.localidade, val);
        } else {
            objPC.localidade = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(9);
            }
        }
    }

    private static byte[] jdoGetlogotipo(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 10)) {
            return (byte[])objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 10, (Object)objPC.logotipo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(10)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"logotipo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.logotipo;
    }

    private static void jdoSetlogotipo(Empresa objPC, byte[] val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 10, (Object)objPC.logotipo, (Object)val);
        } else {
            objPC.logotipo = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(10);
            }
        }
    }

    private static String jdoGetmorada(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 11)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 11, objPC.morada);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(11)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"morada\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.morada;
    }

    private static void jdoSetmorada(Empresa objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 11, objPC.morada, val);
        } else {
            objPC.morada = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(11);
            }
        }
    }

    private static String jdoGetnif(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 12)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 12, objPC.nif);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(12)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"nif\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.nif;
    }

    private static void jdoSetnif(Empresa objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 12, objPC.nif, val);
        } else {
            objPC.nif = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(12);
            }
        }
    }

    private static String jdoGetnome(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 13)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 13, objPC.nome);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(13)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"nome\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.nome;
    }

    private static void jdoSetnome(Empresa objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 13, objPC.nome, val);
        } else {
            objPC.nome = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(13);
            }
        }
    }

    private static Paises jdoGetpais(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 14)) {
            return (Paises)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 14, (Object)objPC.pais);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(14)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"pais\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.pais;
    }

    private static void jdoSetpais(Empresa objPC, Paises val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 14, (Object)objPC.pais, (Object)val);
        } else {
            objPC.pais = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(14);
            }
        }
    }

    private static String jdoGetregistocomercial(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 15)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 15, objPC.registocomercial);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(15)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"registocomercial\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.registocomercial;
    }

    private static void jdoSetregistocomercial(Empresa objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 15, objPC.registocomercial, val);
        } else {
            objPC.registocomercial = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(15);
            }
        }
    }

    private static String jdoGettelefone(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 16)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 16, objPC.telefone);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(16)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"telefone\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.telefone;
    }

    private static void jdoSettelefone(Empresa objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 16, objPC.telefone, val);
        } else {
            objPC.telefone = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(16);
            }
        }
    }

    private static String jdoGettelefone2(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 17)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 17, objPC.telefone2);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(17)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"telefone2\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.telefone2;
    }

    private static void jdoSettelefone2(Empresa objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 17, objPC.telefone2, val);
        } else {
            objPC.telefone2 = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(17);
            }
        }
    }

    private static String jdoGettelemovel(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 18)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 18, objPC.telemovel);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(18)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"telemovel\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.telemovel;
    }

    private static void jdoSettelemovel(Empresa objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 18, objPC.telemovel, val);
        } else {
            objPC.telemovel = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(18);
            }
        }
    }

    private static String jdoGeturl(Empresa objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 19)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 19, objPC.url);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(19)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"url\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.url;
    }

    private static void jdoSeturl(Empresa objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 19, objPC.url, val);
        } else {
            objPC.url = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(19);
            }
        }
    }
}

