/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dma.java.input.FieldRegex;
import org.dma.java.util.Debug;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringList;
import org.dma.java.util.StringUtils;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.Activator;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.api.services.at.series.SeriesService;
import pt.gov.portaldasfinancas.servicos.series.types.EstadoSerieType;
import pt.gov.portaldasfinancas.servicos.series.types.TipoDocType;
import pt.gov.portaldasfinancas.servicos.series.types.TipoSerieType;

@javax.jdo.annotations.PersistenceCapable
public class Documentosseries
extends AbstractModel
implements Detachable,
PersistenceCapable {
    public static final int estado_inactiva = 0;
    public static final int estado_activa = 1;
    public static final int estado_anulada = 2;
    public static final int estado_finalizada = 3;
    public static final int regimeiva_geral = 0;
    public static final int regimeiva_caixa = 1;
    public static final int integracao_nenhuma = 0;
    public static final int integracao_manual = 1;
    public static final int integracao_duplicado = 2;
    public static final int integracao_automatica = 3;
    private String key;
    private Documentostipos tipodocumento;
    private String serie;
    private String codigovalidacao;
    private Integer numerolinha;
    private Integer numero;
    private Integer estado;
    private Integer integracao;
    private Integer regimeiva;
    @Deprecated
    private Integer tipo;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    public static int getYear() {
        return TimeDateUtils.getCurrentMonth() == 12 ? TimeDateUtils.getCurrentYear() + 1 : TimeDateUtils.getCurrentYear();
    }

    public static String generateSerie(int value, Integer integracao, Integer regimeiva) {
        StringBuilder sb = new StringBuilder();
        sb.append(value);
        switch (regimeiva) {
            case 0: {
                break;
            }
            case 1: {
                sb.append('C');
            }
        }
        switch (integracao) {
            case 0: {
                break;
            }
            case 1: {
                sb.append('M');
                break;
            }
            case 2: {
                sb.append('D');
                break;
            }
            case 3: {
                sb.append('A');
            }
        }
        return sb.toString();
    }

    @Override
    public int compareTo(IDatabaseModel model) {
        return Documentosseries.jdoGetnumerolinha(this).compareTo(((Documentosseries)model).getNumerolinha());
    }

    private Documentosseries() {
        super(TABLES.documentosseries);
    }

    private Documentosseries(DatabaseManager manager) {
        super(TABLES.documentosseries, manager);
    }

    public Documentosseries(Documentostipos tipodocumento, String serie) {
        this(tipodocumento, serie, 0, 0);
    }

    public Documentosseries(Documentostipos tipodocumento, String serie, int integracao, int regimeiva) {
        this(tipodocumento.getManager());
        this.tipodocumento = tipodocumento;
        this.serie = serie;
        this.codigovalidacao = "";
        this.numerolinha = tipodocumento.getSeries().size() + 1;
        this.numero = 0;
        this.estado = 1;
        this.integracao = integracao;
        this.regimeiva = regimeiva;
        this.key = this.generateKey();
    }

    @Override
    public Documentosseries cloneCopy() {
        Documentosseries clone = new Documentosseries(this.manager);
        Documentosseries.jdoSetkey(clone, Documentosseries.jdoGetkey(this));
        Documentosseries.jdoSettipodocumento(clone, Documentosseries.jdoGettipodocumento(this));
        Documentosseries.jdoSetnumerolinha(clone, Documentosseries.jdoGetnumerolinha(this));
        Documentosseries.jdoSetnumero(clone, Documentosseries.jdoGetnumero(this));
        Documentosseries.jdoSetestado(clone, Documentosseries.jdoGetestado(this));
        Documentosseries.jdoSetintegracao(clone, Documentosseries.jdoGetintegracao(this));
        Documentosseries.jdoSetregimeiva(clone, Documentosseries.jdoGetregimeiva(this));
        Documentosseries.jdoSetserie(clone, Documentosseries.jdoGetserie(this));
        Documentosseries.jdoSetcodigovalidacao(clone, Documentosseries.jdoGetcodigovalidacao(this));
        return clone;
    }

    Documentosseries cloneCopy(Documentostipos tipodocumento) {
        Documentosseries clone = this.cloneCopy();
        Documentosseries.jdoSettipodocumento(clone, tipodocumento);
        clone.setKey();
        return clone;
    }

    @Override
    public MessageList validate(IDatabaseModel.ACTION action) {
        MessageList error = super.validate(action);
        switch (action) {
            case DELETE: {
                if (!this.hasCodigovalidacao()) break;
                error.add((Object)new MessageLine((Object)LABELS.documentosseries_codigovalidacao));
                break;
            }
            case STORE: {
                if (!this.isSerieValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.documentosseries_serie));
                }
                if (!this.isCodigovalidacaoValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.documentosseries_codigovalidacao));
                }
                if (!this.isCodigovalidacaoUnique()) {
                    error.add(LABELS.erro_campo_existe.format(LABELS.documentosseries_codigovalidacao.toString()));
                }
                if (!this.isRegimeivaValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.documentosseries_regimeiva));
                }
                if (!this.isNumeroValid()) {
                    error.add((Object)new MessageLine((Object)LABELS.documentosseries_numero));
                }
                if (new Despacho_8632().validate()) break;
                error.add((Object)new MessageLine((Object)LABELS.erro_database_registoinconsistente));
            }
        }
        return error.prefix((Object)((Object)LABELS.documentosseries_serie) + " " + this.getSerieToText());
    }

    public SeriesService service() {
        return new SeriesService(this.manager.getParametros().getSeriesService(), this);
    }

    public boolean hasService() {
        try {
            this.service().checkService();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public String getKey() {
        return Documentosseries.jdoGetkey(this);
    }

    public void setKey(String key) {
        String string = Documentosseries.jdoGetkey(this);
        String string2 = key;
        Documentosseries.jdoSetkey(this, string2);
        this.firePropertyChange(FIELDS.documentosseries_key, (Object)string, (Object)string2);
    }

    void setKey() {
        this.setKey(this.generateKey());
    }

    String generateKey() {
        return Documentosseries.jdoGettipodocumento(this) == null || Documentosseries.jdoGetserie(this) == null ? null : Documentosseries.generateKey(Documentosseries.jdoGettipodocumento(this).getCodigo(), Documentosseries.jdoGetserie(this));
    }

    public static String generateKey(String tipodocumento, String serie) {
        return String.valueOf(tipodocumento) + ":" + serie;
    }

    public Documentostipos getTipodocumento() {
        return Documentosseries.jdoGettipodocumento(this);
    }

    public void setTipodocumento(Documentostipos tipodocumento) {
        Documentostipos documentostipos = Documentosseries.jdoGettipodocumento(this);
        Documentostipos documentostipos2 = tipodocumento;
        Documentosseries.jdoSettipodocumento(this, documentostipos2);
        this.firePropertyChange(FIELDS.documentosseries_tipodocumento, (Object)documentostipos, (Object)documentostipos2);
        this.setKey();
    }

    public TipoDocType getTipoDoc() {
        switch (Documentosseries.jdoGettipodocumento(this).getTipodocumentosaft()) {
            case 1: {
                return TipoDocType.FT;
            }
            case 2: {
                return TipoDocType.FS;
            }
            case 3: {
                return TipoDocType.FR;
            }
            case 4: {
                return TipoDocType.ND;
            }
            case 5: {
                return TipoDocType.NC;
            }
            case 11: {
                return TipoDocType.GR;
            }
            case 12: {
                return TipoDocType.GT;
            }
            case 13: {
                return TipoDocType.GA;
            }
            case 14: {
                return TipoDocType.GC;
            }
            case 15: {
                return TipoDocType.GD;
            }
            case 16: {
                return TipoDocType.CM;
            }
            case 17: {
                return TipoDocType.CC;
            }
            case 18: {
                return TipoDocType.FC;
            }
            case 19: {
                return TipoDocType.FO;
            }
            case 20: {
                return TipoDocType.NE;
            }
            case 21: {
                return TipoDocType.OR;
            }
            case 22: {
                return TipoDocType.PF;
            }
            case 23: {
                return TipoDocType.OU;
            }
            case 25: {
                return TipoDocType.RG;
            }
            case 26: {
                return TipoDocType.RC;
            }
        }
        return null;
    }

    @Deprecated
    public Date getDatacriacao() {
        return null;
    }

    @Deprecated
    public Date getDatautilizacao() {
        return null;
    }

    public String getSerie() {
        return Documentosseries.jdoGetserie(this);
    }

    public String getSerieToText() {
        return Documentosseries.jdoGetserie(this) == null ? "" : Documentosseries.jdoGetserie(this).toString();
    }

    public int getSerieToInt() {
        Matcher matcher = FieldRegex.getPattern((String)"[^0-9]").matcher(Documentosseries.jdoGetserie(this));
        return StringUtils.val((String)matcher.replaceAll(""));
    }

    public void setSerie(String serie) {
        String string = Documentosseries.jdoGetserie(this);
        String string2 = serie;
        Documentosseries.jdoSetserie(this, string2);
        this.firePropertyChange(FIELDS.documentosseries_serie, (Object)string, (Object)string2);
        this.setKey();
    }

    public void setSerie(int value) {
        this.setSerie(Documentosseries.generateSerie(value, Documentosseries.jdoGetintegracao(this), Documentosseries.jdoGetregimeiva(this)));
    }

    public boolean isSerieValid() {
        boolean valid;
        boolean bl = valid = Documentosseries.jdoGetserie(this) != null && Documentosseries.jdoGetserie(this).length() <= 35 && !Documentosseries.jdoGetserie(this).startsWith(".") && !Documentosseries.jdoGetserie(this).startsWith("_") && !Documentosseries.jdoGetserie(this).startsWith("-") && !Documentosseries.jdoGetserie(this).endsWith(".") && !Documentosseries.jdoGetserie(this).endsWith("_") && !Documentosseries.jdoGetserie(this).endsWith("-") && !Documentosseries.jdoGetserie(this).contains("..") && !Documentosseries.jdoGetserie(this).contains("._") && !Documentosseries.jdoGetserie(this).contains(".-") && !Documentosseries.jdoGetserie(this).contains("__") && !Documentosseries.jdoGetserie(this).contains("_.") && !Documentosseries.jdoGetserie(this).contains("_-") && !Documentosseries.jdoGetserie(this).contains("--") && !Documentosseries.jdoGetserie(this).contains("-.") && !Documentosseries.jdoGetserie(this).contains("-_") && FIELDS.PATTERNS.IDENTIFICADOR_SERIE.matches(Documentosseries.jdoGetserie(this));
        return valid || this.isEdited();
    }

    public String getCodigovalidacao() {
        return Documentosseries.jdoGetcodigovalidacao(this);
    }

    public String getCodigovalidacaoToText() {
        return Documentosseries.jdoGetcodigovalidacao(this) == null ? "" : Documentosseries.jdoGetcodigovalidacao(this).toString();
    }

    public void setCodigovalidacao(String codigovalidacao) {
        String string = Documentosseries.jdoGetcodigovalidacao(this);
        String string2 = codigovalidacao;
        Documentosseries.jdoSetcodigovalidacao(this, string2);
        this.firePropertyChange(FIELDS.documentosseries_codigovalidacao, (Object)string, (Object)string2);
    }

    public boolean hasCodigovalidacao() {
        return !StringUtils.isEmpty((String)Documentosseries.jdoGetcodigovalidacao(this));
    }

    public boolean needsCodigovalidacao() {
        return !this.hasCodigovalidacao() && Documentosseries.jdoGettipodocumento(this).isTipodocumentosaftCertificado();
    }

    public boolean isCodigovalidacaoValid() {
        return !this.hasCodigovalidacao() || Documentosseries.jdoGetcodigovalidacao(this).length() >= 8 && FIELDS.PATTERNS.CODIGO_VALIDACAO.matches(Documentosseries.jdoGetcodigovalidacao(this));
    }

    public boolean isCodigovalidacaoUnique() {
        HashMap<String, ArrayList<Documentosseries>> map = new HashMap<String, ArrayList<Documentosseries>>();
        for (Documentosseries serie : Documentosseries.jdoGettipodocumento(this).getSeries()) {
            try {
                if (!serie.hasCodigovalidacao()) continue;
                String key = serie.getCodigovalidacao();
                ArrayList<Documentosseries> value = (ArrayList<Documentosseries>)map.get(key);
                if (value == null) {
                    value = new ArrayList<Documentosseries>();
                    map.put(key, value);
                }
                value.add(serie);
            }
            catch (JDODetachedFieldAccessException jDODetachedFieldAccessException) {
                // empty catch block
            }
        }
        return !map.containsKey(Documentosseries.jdoGetcodigovalidacao(this)) || ((List)map.get(Documentosseries.jdoGetcodigovalidacao(this))).indexOf(this) == 0;
    }

    public Integer getNumerolinha() {
        return Documentosseries.jdoGetnumerolinha(this);
    }

    public String getNumerolinhaToText() {
        return Documentosseries.jdoGetnumerolinha(this) == null ? "" : Documentosseries.jdoGetnumerolinha(this).toString();
    }

    protected void setNumerolinha(Integer numerolinha) {
        Integer n = Documentosseries.jdoGetnumerolinha(this);
        Integer n2 = numerolinha;
        Documentosseries.jdoSetnumerolinha(this, n2);
        this.firePropertyChange(FIELDS.documentosseries_numerolinha, (Object)n, (Object)n2);
    }

    public Integer getNumero() {
        return Documentosseries.jdoGetnumero(this);
    }

    public String getNumeroToText() {
        return Documentosseries.jdoGetnumero(this) == null ? "" : Documentosseries.jdoGetnumero(this).toString();
    }

    public void setNumero(Integer numero) {
        Integer n = Documentosseries.jdoGetnumero(this);
        Integer n2 = numero;
        Documentosseries.jdoSetnumero(this, n2);
        this.firePropertyChange(FIELDS.documentosseries_numero, (Object)n, (Object)n2);
    }

    public boolean isNumeroValid() {
        return Documentosseries.jdoGetnumero(this) == 0 || !this.isIntegracao() || this.isEdited();
    }

    boolean logNumero() throws Exception {
        return Colibri.VERSION_TYPE == Colibri.VERSIONS.SERVER ? false : new Despacho_8632().log();
    }

    public Integer getEstado() {
        return Documentosseries.jdoGetestado(this);
    }

    public String getEstadoToText() {
        return Documentosseries.jdoGetestado(this) == null ? "" : FIELDS.documentosseries_estado.values[Documentosseries.jdoGetestado(this)];
    }

    public void setEstado(Integer estado) {
        Integer n = Documentosseries.jdoGetestado(this);
        Integer n2 = estado;
        Documentosseries.jdoSetestado(this, n2);
        this.firePropertyChange(FIELDS.documentosseries_estado, (Object)n, (Object)n2);
    }

    public boolean isEstado(Integer estado) {
        return Documentosseries.equals(estado, Documentosseries.jdoGetestado(this));
    }

    public EstadoSerieType getEstadoSerie() {
        switch (Documentosseries.jdoGetestado(this)) {
            case 0: 
            case 1: {
                return EstadoSerieType.A;
            }
            case 2: {
                return EstadoSerieType.N;
            }
            case 3: {
                return EstadoSerieType.F;
            }
        }
        return null;
    }

    public Integer getIntegracao() {
        return Documentosseries.jdoGetintegracao(this);
    }

    public String getIntegracaoToText() {
        return Documentosseries.jdoGetintegracao(this) == null ? "" : Documentosseries.jdoGetintegracao(this).toString();
    }

    public void setIntegracao(Integer integracao) {
        Integer n = Documentosseries.jdoGetintegracao(this);
        Integer n2 = integracao;
        Documentosseries.jdoSetintegracao(this, n2);
        boolean changed = this.firePropertyChange(FIELDS.documentosseries_integracao, (Object)n, (Object)n2);
        if (changed && this.cascade && !this.isEdited()) {
            this.setSerie(this.getSerieToInt());
        }
    }

    public boolean isIntegracao(Integer integracao) {
        return Documentosseries.equals(integracao, Documentosseries.jdoGetintegracao(this));
    }

    public boolean isIntegracao() {
        return !this.isIntegracao(0);
    }

    public TipoSerieType getTipoSerie() {
        if (!this.manager.getLicenca().isFormacao()) {
            switch (Documentosseries.jdoGetintegracao(this)) {
                case 0: {
                    return TipoSerieType.N;
                }
                case 1: 
                case 2: 
                case 3: {
                    return TipoSerieType.R;
                }
            }
        }
        return TipoSerieType.F;
    }

    public Integer getRegimeiva() {
        return Documentosseries.jdoGetregimeiva(this);
    }

    public String getRegimeivaToText() {
        return Documentosseries.jdoGetregimeiva(this) == null ? "" : Documentosseries.jdoGetregimeiva(this).toString();
    }

    public void setRegimeiva(Integer regimeiva) {
        Integer n = Documentosseries.jdoGetregimeiva(this);
        Integer n2 = regimeiva;
        Documentosseries.jdoSetregimeiva(this, n2);
        boolean changed = this.firePropertyChange(FIELDS.documentosseries_regimeiva, (Object)n, (Object)n2);
        if (changed && this.cascade && !this.isEdited()) {
            this.setSerie(this.getSerieToInt());
        }
    }

    public boolean isRegimeiva(Integer regimeiva) {
        return Documentosseries.equals(regimeiva, Documentosseries.jdoGetregimeiva(this));
    }

    public boolean isRegimeivaValid() {
        switch (Documentosseries.jdoGetregimeiva(this)) {
            case 1: {
                return !Documentosseries.jdoGettipodocumento(this).isTipodocumentosaft(25);
            }
            case 0: {
                return !Documentosseries.jdoGettipodocumento(this).isTipodocumentosaft(26);
            }
        }
        return true;
    }

    @Deprecated
    public Integer getTipo() {
        return Documentosseries.jdoGettipo(this) == null ? Documentosseries.jdoGetintegracao(this) : Documentosseries.jdoGettipo(this);
    }

    @Override
    public boolean isEditable(FIELDS field) {
        switch (Documentosseries.jdoGetestado(this)) {
            case 0: {
                return field == FIELDS.documentosseries_estado;
            }
            case 1: {
                switch (field) {
                    case documentosseries_serie: {
                        return !this.isEdited();
                    }
                    case documentosseries_numero: {
                        return !this.hasCodigovalidacao() || this.manager.getUtilizador().isColibri();
                    }
                    case documentosseries_estado: {
                        return this.isEdited() || this.manager.getUtilizador().isColibri();
                    }
                    case documentosseries_codigovalidacao: {
                        return !(!this.needsCodigovalidacao() && this.isCodigovalidacaoValid() || Colibri.VERSION_TYPE == Colibri.VERSIONS.SERVER && !this.manager.getUtilizador().isColibri());
                    }
                    case documentosseries_integracao: {
                        return !this.hasCodigovalidacao() || !this.isCodigovalidacaoValid();
                    }
                    case documentosseries_regimeiva: {
                        return Documentosseries.jdoGetnumero(this) == 0 && this.manager.getLicenca().allows(Colibri.FUNCIONALIDADES.REGIME_IVA_CAIXA);
                    }
                }
                return false;
            }
            case 2: {
                return field == FIELDS.documentosseries_estado && this.manager.getUtilizador().isColibri();
            }
            case 3: {
                return field == FIELDS.documentosseries_estado && this.manager.getUtilizador().isColibri();
            }
        }
        return false;
    }

    @Override
    public void attach(DatabaseManager manager) {
        manager.attach(Documentosseries.jdoGettipodocumento(this));
    }

    public String toString() {
        return Documentosseries.jdoGettipodocumento(this) == null ? Documentosseries.jdoGetserie(this) : String.valueOf(Documentosseries.jdoGettipodocumento(this).getCodigo()) + " " + Documentosseries.jdoGetserie(this);
    }

    public int hashCode() {
        return Documentosseries.jdoGetkey(this) == null ? 0 : Documentosseries.jdoGetkey(this).hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    static {
        jdoFieldNames = Documentosseries.__jdoFieldNamesInit();
        jdoFieldTypes = Documentosseries.__jdoFieldTypesInit();
        jdoFieldFlags = Documentosseries.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Documentosseries.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Documentosseries.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Documentosseries.___jdo$loadClass("org.projectocolibri.api.database.model.Documentosseries"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Documentosseries());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(3, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.key = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.key);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Documentosseries result = new Documentosseries();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Documentosseries result = new Documentosseries();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.codigovalidacao = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.estado = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.integracao = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.key = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.numero = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.numerolinha = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.regimeiva = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.serie = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 8: {
                this.tipo = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 9: {
                this.tipodocumento = (Documentostipos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.codigovalidacao);
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.estado);
                break;
            }
            case 2: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.integracao);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.key);
                break;
            }
            case 4: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.numero);
                break;
            }
            case 5: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.numerolinha);
                break;
            }
            case 6: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.regimeiva);
                break;
            }
            case 7: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.serie);
                break;
            }
            case 8: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipo);
                break;
            }
            case 9: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tipodocumento);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Documentosseries obj, int index) {
        switch (index) {
            case 0: {
                this.codigovalidacao = obj.codigovalidacao;
                break;
            }
            case 1: {
                this.estado = obj.estado;
                break;
            }
            case 2: {
                this.integracao = obj.integracao;
                break;
            }
            case 3: {
                this.key = obj.key;
                break;
            }
            case 4: {
                this.numero = obj.numero;
                break;
            }
            case 5: {
                this.numerolinha = obj.numerolinha;
                break;
            }
            case 6: {
                this.regimeiva = obj.regimeiva;
                break;
            }
            case 7: {
                this.serie = obj.serie;
                break;
            }
            case 8: {
                this.tipo = obj.tipo;
                break;
            }
            case 9: {
                this.tipodocumento = obj.tipodocumento;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Documentosseries)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Documentosseries");
        }
        Documentosseries other = (Documentosseries)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"codigovalidacao", "estado", "integracao", "key", "numero", "numerolinha", "regimeiva", "serie", "tipo", "tipodocumento"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Documentosseries.___jdo$loadClass("java.lang.String"), Documentosseries.___jdo$loadClass("java.lang.Integer"), Documentosseries.___jdo$loadClass("java.lang.Integer"), Documentosseries.___jdo$loadClass("java.lang.String"), Documentosseries.___jdo$loadClass("java.lang.Integer"), Documentosseries.___jdo$loadClass("java.lang.Integer"), Documentosseries.___jdo$loadClass("java.lang.Integer"), Documentosseries.___jdo$loadClass("java.lang.String"), Documentosseries.___jdo$loadClass("java.lang.Integer"), Documentosseries.___jdo$loadClass("org.projectocolibri.api.database.model.Documentostipos")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 24, 21, 21, 21, 21, 21, 5};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 10;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Documentosseries o = (Documentosseries)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static String jdoGetcodigovalidacao(Documentosseries objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 0, objPC.codigovalidacao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"codigovalidacao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.codigovalidacao;
    }

    private static void jdoSetcodigovalidacao(Documentosseries objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 0, objPC.codigovalidacao, val);
        } else {
            objPC.codigovalidacao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static Integer jdoGetestado(Documentosseries objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, (Object)objPC.estado);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"estado\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.estado;
    }

    private static void jdoSetestado(Documentosseries objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, (Object)objPC.estado, (Object)val);
        } else {
            objPC.estado = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static Integer jdoGetintegracao(Documentosseries objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 2, (Object)objPC.integracao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"integracao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.integracao;
    }

    private static void jdoSetintegracao(Documentosseries objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 2, (Object)objPC.integracao, (Object)val);
        } else {
            objPC.integracao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static String jdoGetkey(Documentosseries objPC) {
        return objPC.key;
    }

    private static void jdoSetkey(Documentosseries objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.key = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.key, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(3);
        }
    }

    private static Integer jdoGetnumero(Documentosseries objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 4, (Object)objPC.numero);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numero\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numero;
    }

    private static void jdoSetnumero(Documentosseries objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 4, (Object)objPC.numero, (Object)val);
        } else {
            objPC.numero = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static Integer jdoGetnumerolinha(Documentosseries objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 5, (Object)objPC.numerolinha);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numerolinha\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numerolinha;
    }

    private static void jdoSetnumerolinha(Documentosseries objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 5, (Object)objPC.numerolinha, (Object)val);
        } else {
            objPC.numerolinha = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    private static Integer jdoGetregimeiva(Documentosseries objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 6, (Object)objPC.regimeiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"regimeiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.regimeiva;
    }

    private static void jdoSetregimeiva(Documentosseries objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 6, (Object)objPC.regimeiva, (Object)val);
        } else {
            objPC.regimeiva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }

    private static String jdoGetserie(Documentosseries objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 7, objPC.serie);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"serie\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.serie;
    }

    private static void jdoSetserie(Documentosseries objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 7, objPC.serie, val);
        } else {
            objPC.serie = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }

    private static Integer jdoGettipo(Documentosseries objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 8, (Object)objPC.tipo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipo;
    }

    private static void jdoSettipo(Documentosseries objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 8, (Object)objPC.tipo, (Object)val);
        } else {
            objPC.tipo = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(8);
            }
        }
    }

    private static Documentostipos jdoGettipodocumento(Documentosseries objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return (Documentostipos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 9, (Object)objPC.tipodocumento);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tipodocumento\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tipodocumento;
    }

    private static void jdoSettipodocumento(Documentosseries objPC, Documentostipos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 9, (Object)objPC.tipodocumento, (Object)val);
        } else {
            objPC.tipodocumento = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(9);
            }
        }
    }

    private class Despacho_8632 {
        private final boolean active;

        private Despacho_8632() {
            this.active = Documentosseries.this.manager.isPopulated() && Documentosseries.jdoGettipodocumento(Documentosseries.this).isTipodocumentosaftCertificado();
        }

        private String key() {
            StringList list = new StringList();
            list.add((Object)Documentosseries.this.manager.getEmpresa().getNifParsed());
            list.add((Object)Documentosseries.jdoGettipodocumento(Documentosseries.this).getCodigo());
            list.add((Object)Documentosseries.jdoGetserie(Documentosseries.this));
            return list.concat("_");
        }

        private boolean validate(int numero) {
            return numero <= Documentosseries.this.getNumero();
        }

        public boolean validate() {
            return this.validate(this.active ? Activator.PLUGIN_STORE.getInt(this.key()) : Documentosseries.jdoGetnumero(Documentosseries.this).intValue());
        }

        public boolean log() throws Exception {
            if (this.active) {
                String key = this.key();
                Debug.out((String)"key", (Object)key);
                Activator.PLUGIN_STORE.setValue(key, Documentosseries.jdoGetnumero(Documentosseries.this).intValue());
                Activator.PLUGIN_STORE.save();
                return true;
            }
            return false;
        }
    }
}

