/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringUtils;
import org.dma.java.util.TimeDateUtils;
import org.iban4j.Iban;
import org.iban4j.IbanUtil;
import org.iban4j.UnsupportedCountryException;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.model.Codigospostais;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.core.support.SWIFTBankCodesMap;

@javax.jdo.annotations.PersistenceCapable
public class Contasbancarias
extends AbstractModel
implements Detachable,
PersistenceCapable {
    private Codigospostais codigopostal;
    private String codigo;
    private String iban;
    @Deprecated
    private String nib;
    private String numeroconta;
    private String bicswift;
    private String nomebanco;
    private String titular;
    private String morada;
    private String contacto;
    private String telefone;
    private String fax;
    private String email;
    private String obs;
    private Integer ultimocheque;
    private BigDecimal totaldebito;
    private BigDecimal totalcredito;
    private BigDecimal saldo;
    private Date datacriacao;
    private Date dataalteracao;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    private Contasbancarias() {
        super(TABLES.contasbancarias);
    }

    private Contasbancarias(DatabaseManager manager) {
        super(TABLES.contasbancarias, manager);
    }

    public Contasbancarias(DatabaseManager manager, String codigo) {
        this(manager, codigo, "");
    }

    public Contasbancarias(DatabaseManager manager, String codigo, String nomebanco) {
        this(manager);
        this.codigopostal = manager.loadCodigospostais();
        this.codigo = codigo;
        this.iban = "";
        this.numeroconta = "";
        this.bicswift = "";
        this.nomebanco = nomebanco;
        this.titular = "";
        this.morada = "";
        this.contacto = "";
        this.telefone = "";
        this.fax = "";
        this.email = "";
        this.obs = "";
        this.ultimocheque = 0;
        this.totaldebito = BigDecimal.ZERO;
        this.totalcredito = BigDecimal.ZERO;
        this.saldo = BigDecimal.ZERO;
        this.datacriacao = TimeDateUtils.getCurrentDate();
        this.dataalteracao = TimeDateUtils.getCurrentDate();
    }

    public void clearDeprecated() {
        Contasbancarias.jdoSetnib(this, null);
    }

    @Override
    public Contasbancarias cloneCopy() {
        Contasbancarias clone = new Contasbancarias(this.manager);
        Contasbancarias.jdoSetcodigopostal(clone, Contasbancarias.jdoGetcodigopostal(this));
        Contasbancarias.jdoSetcodigo(clone, Contasbancarias.jdoGetcodigo(this));
        Contasbancarias.jdoSetiban(clone, Contasbancarias.jdoGetiban(this));
        Contasbancarias.jdoSetnib(clone, Contasbancarias.jdoGetnib(this));
        Contasbancarias.jdoSetnumeroconta(clone, Contasbancarias.jdoGetnumeroconta(this));
        Contasbancarias.jdoSetbicswift(clone, Contasbancarias.jdoGetbicswift(this));
        Contasbancarias.jdoSetnomebanco(clone, Contasbancarias.jdoGetnomebanco(this));
        Contasbancarias.jdoSettitular(clone, Contasbancarias.jdoGettitular(this));
        Contasbancarias.jdoSetmorada(clone, Contasbancarias.jdoGetmorada(this));
        Contasbancarias.jdoSetcontacto(clone, Contasbancarias.jdoGetcontacto(this));
        Contasbancarias.jdoSettelefone(clone, Contasbancarias.jdoGettelefone(this));
        Contasbancarias.jdoSetfax(clone, Contasbancarias.jdoGetfax(this));
        Contasbancarias.jdoSetemail(clone, Contasbancarias.jdoGetemail(this));
        Contasbancarias.jdoSetobs(clone, Contasbancarias.jdoGetobs(this));
        Contasbancarias.jdoSetultimocheque(clone, Contasbancarias.jdoGetultimocheque(this));
        Contasbancarias.jdoSettotaldebito(clone, Contasbancarias.jdoGettotaldebito(this));
        Contasbancarias.jdoSettotalcredito(clone, Contasbancarias.jdoGettotalcredito(this));
        Contasbancarias.jdoSetsaldo(clone, Contasbancarias.jdoGetsaldo(this));
        Contasbancarias.jdoSetdatacriacao(clone, Contasbancarias.jdoGetdatacriacao(this));
        Contasbancarias.jdoSetdataalteracao(clone, Contasbancarias.jdoGetdataalteracao(this));
        return clone;
    }

    @Override
    public MessageList validate(IDatabaseModel.ACTION action) {
        return this.validate(action, null);
    }

    public MessageList validate(IDatabaseModel.ACTION action, Contasbancarias stored) {
        MessageList error = super.validate(action);
        switch (action) {
            case DELETE: {
                break;
            }
            case STORE: {
                error.add(this.validate(stored, FIELDS.contasbancarias_totaldebito, FIELDS.contasbancarias_totalcredito, FIELDS.contasbancarias_saldo));
                if (this.isCodigopostalValid()) break;
                error.add((Object)new MessageLine((Object)LABELS.contasbancarias_codigopostal));
            }
        }
        return error;
    }

    public Codigospostais getCodigopostal() {
        return Contasbancarias.jdoGetcodigopostal(this);
    }

    public void setCodigopostal(Codigospostais codigopostal) {
        Codigospostais codigospostais = Contasbancarias.jdoGetcodigopostal(this);
        Codigospostais codigospostais2 = codigopostal;
        Contasbancarias.jdoSetcodigopostal(this, codigospostais2);
        boolean changed = this.firePropertyChange(FIELDS.contasbancarias_codigopostal, (Object)codigospostais, (Object)codigospostais2);
        if (changed) {
            this.firePropertyChange(FIELDS.codigospostais_localidade);
        }
    }

    public boolean isCodigopostalValid() {
        return !this.getLocalidadeToText().isEmpty() && Contasbancarias.jdoGetcodigopostal(this) != null && Contasbancarias.jdoGetcodigopostal(this).isValid(this.manager.isPopulated() ? this.manager.getParametros().getPais() : null);
    }

    @Override
    public String getKey() {
        return Contasbancarias.jdoGetcodigo(this);
    }

    public String getCodigo() {
        return Contasbancarias.jdoGetcodigo(this);
    }

    public String getCodigoToText() {
        return Contasbancarias.jdoGetcodigo(this) == null ? "" : Contasbancarias.jdoGetcodigo(this).toString();
    }

    public void setCodigo(String codigo) {
        String string = Contasbancarias.jdoGetcodigo(this);
        String string2 = codigo;
        Contasbancarias.jdoSetcodigo(this, string2);
        this.firePropertyChange(FIELDS.contasbancarias_codigo, (Object)string, (Object)string2);
    }

    public String getIban() {
        return Contasbancarias.jdoGetiban(this);
    }

    public String getIbanToText() {
        if (Contasbancarias.jdoGetiban(this) != null) {
            try {
                String compacted = StringUtils.compact((String)Contasbancarias.jdoGetiban(this)).toUpperCase();
                return Iban.valueOf((String)compacted).toFormattedString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public void setIban(String iban) {
        String string = Contasbancarias.jdoGetiban(this);
        String string2 = iban;
        Contasbancarias.jdoSetiban(this, string2);
        boolean changed = this.firePropertyChange(FIELDS.contasbancarias_iban, (Object)string, (Object)string2);
        if (changed && this.cascade) {
            try {
                String compacted = iban == null ? "" : StringUtils.compact((String)iban).toUpperCase();
                this.setIban(Iban.valueOf((String)compacted));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setIban(Iban iban) {
        this.setNumeroconta(iban.getAccountNumber());
        SWIFTBankCodesMap.SWIFTCode value = SWIFTBankCodesMap.getInstance().get(iban);
        this.setBicswift(value.bic);
        this.setNomebanco(value.name);
    }

    public boolean isIbanValid() {
        if (!StringUtils.isEmpty((String)Contasbancarias.jdoGetiban(this))) {
            try {
                String compacted = StringUtils.compact((String)Contasbancarias.jdoGetiban(this)).toUpperCase();
                IbanUtil.validate((String)compacted);
            }
            catch (UnsupportedCountryException compacted) {
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public String getNib() {
        if (Contasbancarias.jdoGetnib(this) == null) {
            try {
                String compacted = Contasbancarias.jdoGetiban(this) == null ? "" : StringUtils.compact((String)Contasbancarias.jdoGetiban(this)).toUpperCase();
                return Iban.valueOf((String)compacted).getBban();
            }
            catch (Exception e) {
                return this.getIbanToText();
            }
        }
        return Contasbancarias.jdoGetnib(this);
    }

    public String getNumeroconta() {
        return Contasbancarias.jdoGetnumeroconta(this);
    }

    public String getNumerocontaToText() {
        return Contasbancarias.jdoGetnumeroconta(this) == null ? "" : Contasbancarias.jdoGetnumeroconta(this).toString();
    }

    public void setNumeroconta(String numeroconta) {
        String string = Contasbancarias.jdoGetnumeroconta(this);
        String string2 = numeroconta;
        Contasbancarias.jdoSetnumeroconta(this, string2);
        this.firePropertyChange(FIELDS.contasbancarias_numeroconta, (Object)string, (Object)string2);
    }

    public String getBicswift() {
        return Contasbancarias.jdoGetbicswift(this);
    }

    public String getBicswiftToText() {
        return Contasbancarias.jdoGetbicswift(this) == null ? "" : Contasbancarias.jdoGetbicswift(this).toString();
    }

    public void setBicswift(String bicswift) {
        String string = Contasbancarias.jdoGetbicswift(this);
        String string2 = bicswift;
        Contasbancarias.jdoSetbicswift(this, string2);
        this.firePropertyChange(FIELDS.contasbancarias_bicswift, (Object)string, (Object)string2);
    }

    @Deprecated
    public String getAbreviaturabanco() {
        return Contasbancarias.jdoGetnomebanco(this);
    }

    public String getNomebanco() {
        return Contasbancarias.jdoGetnomebanco(this);
    }

    public String getNomebancoToText() {
        return Contasbancarias.jdoGetnomebanco(this) == null ? "" : Contasbancarias.jdoGetnomebanco(this).toString();
    }

    public void setNomebanco(String nomebanco) {
        String string = Contasbancarias.jdoGetnomebanco(this);
        String string2 = nomebanco;
        Contasbancarias.jdoSetnomebanco(this, string2);
        this.firePropertyChange(FIELDS.contasbancarias_nomebanco, (Object)string, (Object)string2);
    }

    public String getTitular() {
        return Contasbancarias.jdoGettitular(this);
    }

    public String getTitularToText() {
        return Contasbancarias.jdoGettitular(this) == null ? "" : Contasbancarias.jdoGettitular(this).toString();
    }

    public void setTitular(String titular) {
        String string = Contasbancarias.jdoGettitular(this);
        String string2 = titular;
        Contasbancarias.jdoSettitular(this, string2);
        this.firePropertyChange(FIELDS.contasbancarias_titular, (Object)string, (Object)string2);
    }

    public String getMorada() {
        return Contasbancarias.jdoGetmorada(this);
    }

    public String getMoradaToText() {
        return Contasbancarias.jdoGetmorada(this) == null ? "" : FIELDS.contasbancarias_morada.format.format(Contasbancarias.jdoGetmorada(this));
    }

    public void setMorada(String morada) {
        String string = Contasbancarias.jdoGetmorada(this);
        String string2 = morada;
        Contasbancarias.jdoSetmorada(this, string2);
        this.firePropertyChange(FIELDS.contasbancarias_morada, (Object)string, (Object)string2);
    }

    public String getLocalidade() {
        return this.getLocalidadeToText();
    }

    public String getLocalidadeToText() {
        return Contasbancarias.jdoGetcodigopostal(this) == null ? "" : Contasbancarias.jdoGetcodigopostal(this).getDescricaoToText();
    }

    public String getContacto() {
        return Contasbancarias.jdoGetcontacto(this);
    }

    public String getContactoToText() {
        return Contasbancarias.jdoGetcontacto(this) == null ? "" : Contasbancarias.jdoGetcontacto(this).toString();
    }

    public void setContacto(String contacto) {
        String string = Contasbancarias.jdoGetcontacto(this);
        String string2 = contacto;
        Contasbancarias.jdoSetcontacto(this, string2);
        this.firePropertyChange(FIELDS.contasbancarias_contacto, (Object)string, (Object)string2);
    }

    public String getTelefone() {
        return Contasbancarias.jdoGettelefone(this);
    }

    public String getTelefoneToText() {
        return Contasbancarias.jdoGettelefone(this) == null ? "" : Contasbancarias.jdoGettelefone(this).toString();
    }

    public void setTelefone(String telefone) {
        String string = Contasbancarias.jdoGettelefone(this);
        String string2 = telefone;
        Contasbancarias.jdoSettelefone(this, string2);
        this.firePropertyChange(FIELDS.contasbancarias_telefone, (Object)string, (Object)string2);
    }

    public String getFax() {
        return Contasbancarias.jdoGetfax(this);
    }

    public String getFaxToText() {
        return Contasbancarias.jdoGetfax(this) == null ? "" : Contasbancarias.jdoGetfax(this).toString();
    }

    public void setFax(String fax) {
        String string = Contasbancarias.jdoGetfax(this);
        String string2 = fax;
        Contasbancarias.jdoSetfax(this, string2);
        this.firePropertyChange(FIELDS.contasbancarias_fax, (Object)string, (Object)string2);
    }

    public String getEmail() {
        return Contasbancarias.jdoGetemail(this);
    }

    public String getEmailToText() {
        return Contasbancarias.jdoGetemail(this) == null ? "" : Contasbancarias.jdoGetemail(this).toString();
    }

    public void setEmail(String email) {
        String string = Contasbancarias.jdoGetemail(this);
        String string2 = email;
        Contasbancarias.jdoSetemail(this, string2);
        this.firePropertyChange(FIELDS.contasbancarias_email, (Object)string, (Object)string2);
    }

    public String getObs() {
        return Contasbancarias.jdoGetobs(this);
    }

    public String getObsToText() {
        return Contasbancarias.jdoGetobs(this) == null ? "" : FIELDS.contasbancarias_obs.format.format(Contasbancarias.jdoGetobs(this));
    }

    public void setObs(String obs) {
        String string = Contasbancarias.jdoGetobs(this);
        String string2 = obs;
        Contasbancarias.jdoSetobs(this, string2);
        this.firePropertyChange(FIELDS.contasbancarias_obs, (Object)string, (Object)string2);
    }

    public Integer getUltimocheque() {
        return Contasbancarias.jdoGetultimocheque(this);
    }

    public String getUltimochequeToText() {
        return Contasbancarias.jdoGetultimocheque(this) == null ? "" : Contasbancarias.jdoGetultimocheque(this).toString();
    }

    public void setUltimocheque(Integer ultimocheque) {
        Integer n = Contasbancarias.jdoGetultimocheque(this);
        Integer n2 = ultimocheque;
        Contasbancarias.jdoSetultimocheque(this, n2);
        this.firePropertyChange(FIELDS.contasbancarias_ultimocheque, (Object)n, (Object)n2);
    }

    public BigDecimal getTotaldebito() {
        return Contasbancarias.jdoGettotaldebito(this);
    }

    public String getTotaldebitoToText() {
        return Contasbancarias.jdoGettotaldebito(this) == null ? "" : FIELDS.contasbancarias_totaldebito.format.format(Contasbancarias.jdoGettotaldebito(this));
    }

    public void setTotaldebito(BigDecimal totaldebito) {
        BigDecimal bigDecimal = Contasbancarias.jdoGettotaldebito(this);
        BigDecimal bigDecimal2 = totaldebito;
        Contasbancarias.jdoSettotaldebito(this, bigDecimal2);
        this.firePropertyChange(FIELDS.contasbancarias_totaldebito, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getTotalcredito() {
        return Contasbancarias.jdoGettotalcredito(this);
    }

    public String getTotalcreditoToText() {
        return Contasbancarias.jdoGettotalcredito(this) == null ? "" : FIELDS.contasbancarias_totalcredito.format.format(Contasbancarias.jdoGettotalcredito(this));
    }

    public void setTotalcredito(BigDecimal totalcredito) {
        BigDecimal bigDecimal = Contasbancarias.jdoGettotalcredito(this);
        BigDecimal bigDecimal2 = totalcredito;
        Contasbancarias.jdoSettotalcredito(this, bigDecimal2);
        this.firePropertyChange(FIELDS.contasbancarias_totalcredito, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public BigDecimal getSaldo() {
        return Contasbancarias.jdoGetsaldo(this);
    }

    public String getSaldoToText() {
        return Contasbancarias.jdoGetsaldo(this) == null ? "" : FIELDS.contasbancarias_saldo.format.format(Contasbancarias.jdoGetsaldo(this));
    }

    public void setSaldo(BigDecimal saldo) {
        BigDecimal bigDecimal = Contasbancarias.jdoGetsaldo(this);
        BigDecimal bigDecimal2 = saldo;
        Contasbancarias.jdoSetsaldo(this, bigDecimal2);
        this.firePropertyChange(FIELDS.contasbancarias_saldo, (Object)bigDecimal, (Object)bigDecimal2);
    }

    public Date getDatacriacao() {
        return Contasbancarias.jdoGetdatacriacao(this);
    }

    public String getDatacriacaoToText() {
        return Contasbancarias.jdoGetdatacriacao(this) == null ? "" : FIELDS.contasbancarias_datacriacao.format.format(Contasbancarias.jdoGetdatacriacao(this));
    }

    public void setDatacriacao(Date datacriacao) {
        Date date = Contasbancarias.jdoGetdatacriacao(this);
        Date date2 = datacriacao;
        Contasbancarias.jdoSetdatacriacao(this, date2);
        this.firePropertyChange(FIELDS.contasbancarias_datacriacao, (Object)date, (Object)date2);
    }

    public Date getDataalteracao() {
        return Contasbancarias.jdoGetdataalteracao(this);
    }

    public String getDataalteracaoToText() {
        return Contasbancarias.jdoGetdataalteracao(this) == null ? "" : FIELDS.contasbancarias_dataalteracao.format.format(Contasbancarias.jdoGetdataalteracao(this));
    }

    public void setDataalteracao(Date dataalteracao) {
        Date date = Contasbancarias.jdoGetdataalteracao(this);
        Date date2 = dataalteracao;
        Contasbancarias.jdoSetdataalteracao(this, date2);
        this.firePropertyChange(FIELDS.contasbancarias_dataalteracao, (Object)date, (Object)date2);
    }

    @Override
    public boolean isEditable(FIELDS field) {
        return super.isEditable(field) && field != FIELDS.codigospostais_localidade && field != FIELDS.contasbancarias_totaldebito && field != FIELDS.contasbancarias_totalcredito && field != FIELDS.contasbancarias_saldo;
    }

    @Override
    public void attach(DatabaseManager manager) {
        manager.attach(Contasbancarias.jdoGetcodigopostal(this));
    }

    public String toString() {
        return String.valueOf(Contasbancarias.jdoGetcodigo(this)) + " - " + Contasbancarias.jdoGetnomebanco(this);
    }

    public int hashCode() {
        return Contasbancarias.jdoGetcodigo(this) == null ? 0 : Contasbancarias.jdoGetcodigo(this).hashCode();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    static {
        jdoFieldNames = Contasbancarias.__jdoFieldNamesInit();
        jdoFieldTypes = Contasbancarias.__jdoFieldTypesInit();
        jdoFieldFlags = Contasbancarias.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Contasbancarias.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Contasbancarias.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Contasbancarias.___jdo$loadClass("org.projectocolibri.api.database.model.Contasbancarias"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Contasbancarias());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(1, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.codigo = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.codigo);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Contasbancarias result = new Contasbancarias();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Contasbancarias result = new Contasbancarias();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.bicswift = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.codigo = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.codigopostal = (Codigospostais)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.contacto = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.dataalteracao = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.datacriacao = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.email = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.fax = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 8: {
                this.iban = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 9: {
                this.morada = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 10: {
                this.nib = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 11: {
                this.nomebanco = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 12: {
                this.numeroconta = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 13: {
                this.obs = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 14: {
                this.saldo = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 15: {
                this.telefone = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 16: {
                this.titular = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 17: {
                this.totalcredito = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 18: {
                this.totaldebito = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 19: {
                this.ultimocheque = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.bicswift);
                break;
            }
            case 1: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.codigo);
                break;
            }
            case 2: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.codigopostal);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.contacto);
                break;
            }
            case 4: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.dataalteracao);
                break;
            }
            case 5: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.datacriacao);
                break;
            }
            case 6: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.email);
                break;
            }
            case 7: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.fax);
                break;
            }
            case 8: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.iban);
                break;
            }
            case 9: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.morada);
                break;
            }
            case 10: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.nib);
                break;
            }
            case 11: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.nomebanco);
                break;
            }
            case 12: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.numeroconta);
                break;
            }
            case 13: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.obs);
                break;
            }
            case 14: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.saldo);
                break;
            }
            case 15: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.telefone);
                break;
            }
            case 16: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.titular);
                break;
            }
            case 17: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.totalcredito);
                break;
            }
            case 18: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.totaldebito);
                break;
            }
            case 19: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.ultimocheque);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Contasbancarias obj, int index) {
        switch (index) {
            case 0: {
                this.bicswift = obj.bicswift;
                break;
            }
            case 1: {
                this.codigo = obj.codigo;
                break;
            }
            case 2: {
                this.codigopostal = obj.codigopostal;
                break;
            }
            case 3: {
                this.contacto = obj.contacto;
                break;
            }
            case 4: {
                this.dataalteracao = obj.dataalteracao;
                break;
            }
            case 5: {
                this.datacriacao = obj.datacriacao;
                break;
            }
            case 6: {
                this.email = obj.email;
                break;
            }
            case 7: {
                this.fax = obj.fax;
                break;
            }
            case 8: {
                this.iban = obj.iban;
                break;
            }
            case 9: {
                this.morada = obj.morada;
                break;
            }
            case 10: {
                this.nib = obj.nib;
                break;
            }
            case 11: {
                this.nomebanco = obj.nomebanco;
                break;
            }
            case 12: {
                this.numeroconta = obj.numeroconta;
                break;
            }
            case 13: {
                this.obs = obj.obs;
                break;
            }
            case 14: {
                this.saldo = obj.saldo;
                break;
            }
            case 15: {
                this.telefone = obj.telefone;
                break;
            }
            case 16: {
                this.titular = obj.titular;
                break;
            }
            case 17: {
                this.totalcredito = obj.totalcredito;
                break;
            }
            case 18: {
                this.totaldebito = obj.totaldebito;
                break;
            }
            case 19: {
                this.ultimocheque = obj.ultimocheque;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Contasbancarias)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Contasbancarias");
        }
        Contasbancarias other = (Contasbancarias)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"bicswift", "codigo", "codigopostal", "contacto", "dataalteracao", "datacriacao", "email", "fax", "iban", "morada", "nib", "nomebanco", "numeroconta", "obs", "saldo", "telefone", "titular", "totalcredito", "totaldebito", "ultimocheque"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Contasbancarias.___jdo$loadClass("java.lang.String"), Contasbancarias.___jdo$loadClass("java.lang.String"), Contasbancarias.___jdo$loadClass("org.projectocolibri.api.database.model.Codigospostais"), Contasbancarias.___jdo$loadClass("java.lang.String"), Contasbancarias.___jdo$loadClass("java.util.Date"), Contasbancarias.___jdo$loadClass("java.util.Date"), Contasbancarias.___jdo$loadClass("java.lang.String"), Contasbancarias.___jdo$loadClass("java.lang.String"), Contasbancarias.___jdo$loadClass("java.lang.String"), Contasbancarias.___jdo$loadClass("java.lang.String"), Contasbancarias.___jdo$loadClass("java.lang.String"), Contasbancarias.___jdo$loadClass("java.lang.String"), Contasbancarias.___jdo$loadClass("java.lang.String"), Contasbancarias.___jdo$loadClass("java.lang.String"), Contasbancarias.___jdo$loadClass("java.math.BigDecimal"), Contasbancarias.___jdo$loadClass("java.lang.String"), Contasbancarias.___jdo$loadClass("java.lang.String"), Contasbancarias.___jdo$loadClass("java.math.BigDecimal"), Contasbancarias.___jdo$loadClass("java.math.BigDecimal"), Contasbancarias.___jdo$loadClass("java.lang.Integer")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 24, 5, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 20;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Contasbancarias o = (Contasbancarias)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static String jdoGetbicswift(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 0, objPC.bicswift);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"bicswift\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.bicswift;
    }

    private static void jdoSetbicswift(Contasbancarias objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 0, objPC.bicswift, val);
        } else {
            objPC.bicswift = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static String jdoGetcodigo(Contasbancarias objPC) {
        return objPC.codigo;
    }

    private static void jdoSetcodigo(Contasbancarias objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.codigo = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 1, objPC.codigo, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(1);
        }
    }

    private static Codigospostais jdoGetcodigopostal(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return (Codigospostais)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 2, (Object)objPC.codigopostal);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"codigopostal\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.codigopostal;
    }

    private static void jdoSetcodigopostal(Contasbancarias objPC, Codigospostais val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 2, (Object)objPC.codigopostal, (Object)val);
        } else {
            objPC.codigopostal = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static String jdoGetcontacto(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.contacto);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"contacto\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.contacto;
    }

    private static void jdoSetcontacto(Contasbancarias objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.contacto, val);
        } else {
            objPC.contacto = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    private static Date jdoGetdataalteracao(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 4, (Object)objPC.dataalteracao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"dataalteracao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.dataalteracao;
    }

    private static void jdoSetdataalteracao(Contasbancarias objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 4, (Object)objPC.dataalteracao, (Object)val);
        } else {
            objPC.dataalteracao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static Date jdoGetdatacriacao(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 5, (Object)objPC.datacriacao);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"datacriacao\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.datacriacao;
    }

    private static void jdoSetdatacriacao(Contasbancarias objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 5, (Object)objPC.datacriacao, (Object)val);
        } else {
            objPC.datacriacao = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    private static String jdoGetemail(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 6, objPC.email);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"email\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.email;
    }

    private static void jdoSetemail(Contasbancarias objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 6, objPC.email, val);
        } else {
            objPC.email = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }

    private static String jdoGetfax(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 7, objPC.fax);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"fax\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.fax;
    }

    private static void jdoSetfax(Contasbancarias objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 7, objPC.fax, val);
        } else {
            objPC.fax = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }

    private static String jdoGetiban(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 8, objPC.iban);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"iban\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.iban;
    }

    private static void jdoSetiban(Contasbancarias objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 8, objPC.iban, val);
        } else {
            objPC.iban = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(8);
            }
        }
    }

    private static String jdoGetmorada(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 9, objPC.morada);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"morada\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.morada;
    }

    private static void jdoSetmorada(Contasbancarias objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 9, objPC.morada, val);
        } else {
            objPC.morada = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(9);
            }
        }
    }

    private static String jdoGetnib(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 10)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 10, objPC.nib);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(10)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"nib\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.nib;
    }

    private static void jdoSetnib(Contasbancarias objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 10, objPC.nib, val);
        } else {
            objPC.nib = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(10);
            }
        }
    }

    private static String jdoGetnomebanco(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 11)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 11, objPC.nomebanco);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(11)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"nomebanco\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.nomebanco;
    }

    private static void jdoSetnomebanco(Contasbancarias objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 11, objPC.nomebanco, val);
        } else {
            objPC.nomebanco = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(11);
            }
        }
    }

    private static String jdoGetnumeroconta(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 12)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 12, objPC.numeroconta);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(12)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numeroconta\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numeroconta;
    }

    private static void jdoSetnumeroconta(Contasbancarias objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 12, objPC.numeroconta, val);
        } else {
            objPC.numeroconta = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(12);
            }
        }
    }

    private static String jdoGetobs(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 13)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 13, objPC.obs);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(13)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"obs\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.obs;
    }

    private static void jdoSetobs(Contasbancarias objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 13, objPC.obs, val);
        } else {
            objPC.obs = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(13);
            }
        }
    }

    private static BigDecimal jdoGetsaldo(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 14)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 14, (Object)objPC.saldo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(14)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"saldo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.saldo;
    }

    private static void jdoSetsaldo(Contasbancarias objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 14, (Object)objPC.saldo, (Object)val);
        } else {
            objPC.saldo = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(14);
            }
        }
    }

    private static String jdoGettelefone(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 15)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 15, objPC.telefone);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(15)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"telefone\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.telefone;
    }

    private static void jdoSettelefone(Contasbancarias objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 15, objPC.telefone, val);
        } else {
            objPC.telefone = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(15);
            }
        }
    }

    private static String jdoGettitular(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 16)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 16, objPC.titular);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(16)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"titular\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.titular;
    }

    private static void jdoSettitular(Contasbancarias objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 16, objPC.titular, val);
        } else {
            objPC.titular = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(16);
            }
        }
    }

    private static BigDecimal jdoGettotalcredito(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 17)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 17, (Object)objPC.totalcredito);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(17)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"totalcredito\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.totalcredito;
    }

    private static void jdoSettotalcredito(Contasbancarias objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 17, (Object)objPC.totalcredito, (Object)val);
        } else {
            objPC.totalcredito = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(17);
            }
        }
    }

    private static BigDecimal jdoGettotaldebito(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 18)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 18, (Object)objPC.totaldebito);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(18)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"totaldebito\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.totaldebito;
    }

    private static void jdoSettotaldebito(Contasbancarias objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 18, (Object)objPC.totaldebito, (Object)val);
        } else {
            objPC.totaldebito = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(18);
            }
        }
    }

    private static Integer jdoGetultimocheque(Contasbancarias objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 19)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 19, (Object)objPC.ultimocheque);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(19)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"ultimocheque\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.ultimocheque;
    }

    private static void jdoSetultimocheque(Contasbancarias objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 19, (Object)objPC.ultimocheque, (Object)val);
        } else {
            objPC.ultimocheque = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(19);
            }
        }
    }

    public static enum RECORDS {
        conta_principal("101", LABELS.DESCONHECIDO.toString());

        public final String codigo;
        public final String nomebanco;

        private RECORDS(String codigo, String nomebanco) {
            this.codigo = codigo;
            this.nomebanco = nomebanco;
        }

        public static Collection<Contasbancarias> create(DatabaseManager manager) {
            ArrayList<Contasbancarias> col = new ArrayList<Contasbancarias>();
            RECORDS[] rECORDSArray = RECORDS.values();
            int n = rECORDSArray.length;
            int n2 = 0;
            while (n2 < n) {
                RECORDS record = rECORDSArray[n2];
                col.add(new Contasbancarias(manager, record.codigo, record.nomebanco));
                ++n2;
            }
            return col;
        }
    }
}

