/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.BitSet;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dma.java.math.BusinessRules;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Cores;
import org.projectocolibri.api.database.model.Moedas;
import org.projectocolibri.api.database.model.Precarios;
import org.projectocolibri.api.database.model.Tamanhos;
import org.projectocolibri.api.database.model.Unidadesmedida;
import org.projectocolibri.api.language.LABELS;

@javax.jdo.annotations.PersistenceCapable
public class Artigosprecos
extends AbstractModel
implements Detachable,
PersistenceCapable {
    private String key;
    private Artigos artigo;
    private Precarios precario;
    private Unidadesmedida unidademedida;
    private Tamanhos tamanho;
    private Cores cor;
    private Integer numerolinha;
    private BigDecimal perclucro;
    private BigDecimal precopvp;
    private BigDecimal precoiva;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    private Artigosprecos() {
        super(TABLES.artigosprecos);
    }

    private Artigosprecos(DatabaseManager manager) {
        super(TABLES.artigosprecos, manager);
    }

    public Artigosprecos(Artigos artigo, Precarios precario, Unidadesmedida unidademedida) {
        this(artigo.getManager());
        this.artigo = artigo;
        this.precario = precario;
        this.unidademedida = unidademedida;
        this.tamanho = this.manager.loadTamanhos();
        this.cor = this.manager.loadCores();
        this.numerolinha = artigo.getPrecos().size() + 1;
        this.perclucro = BigDecimal.ZERO;
        this.precopvp = BigDecimal.ZERO;
        this.precoiva = BigDecimal.ZERO;
        this.key = this.generateKey();
    }

    @Override
    public Artigosprecos cloneCopy() {
        Artigosprecos clone = new Artigosprecos(this.manager);
        Artigosprecos.jdoSetkey(clone, Artigosprecos.jdoGetkey(this));
        Artigosprecos.jdoSetartigo(clone, Artigosprecos.jdoGetartigo(this));
        Artigosprecos.jdoSetprecario(clone, Artigosprecos.jdoGetprecario(this));
        Artigosprecos.jdoSetunidademedida(clone, Artigosprecos.jdoGetunidademedida(this));
        Artigosprecos.jdoSettamanho(clone, Artigosprecos.jdoGettamanho(this));
        Artigosprecos.jdoSetcor(clone, Artigosprecos.jdoGetcor(this));
        Artigosprecos.jdoSetnumerolinha(clone, Artigosprecos.jdoGetnumerolinha(this));
        Artigosprecos.jdoSetperclucro(clone, Artigosprecos.jdoGetperclucro(this));
        Artigosprecos.jdoSetprecopvp(clone, Artigosprecos.jdoGetprecopvp(this));
        Artigosprecos.jdoSetprecoiva(clone, Artigosprecos.jdoGetprecoiva(this));
        return clone;
    }

    Artigosprecos cloneCopy(Artigos artigo) {
        Artigosprecos clone = this.cloneCopy();
        Artigosprecos.jdoSetartigo(clone, artigo);
        clone.setKey();
        return clone;
    }

    @Override
    public MessageList validate(IDatabaseModel.ACTION action) {
        MessageList error = super.validate(action);
        switch (action) {
            case DELETE: {
                break;
            }
            case STORE: {
                if (Artigosprecos.jdoGetartigo(this).containsUnidades(Artigosprecos.jdoGetunidademedida(this))) break;
                error.add((Object)new MessageLine((Object)LABELS.artigosprecos_unidademedida));
            }
        }
        return error.prefix((Object)((Object)LABELS.artigosprecos_numerolinha) + " " + this.getNumerolinhaToText());
    }

    @Override
    public String getKey() {
        return Artigosprecos.jdoGetkey(this);
    }

    public void setKey(String key) {
        String string = Artigosprecos.jdoGetkey(this);
        String string2 = key;
        Artigosprecos.jdoSetkey(this, string2);
        this.firePropertyChange(FIELDS.artigosprecos_key, (Object)string, (Object)string2);
    }

    void setKey() {
        this.setKey(this.generateKey());
    }

    String generateKey() {
        return Artigosprecos.jdoGetartigo(this) == null || Artigosprecos.jdoGetprecario(this) == null || Artigosprecos.jdoGetunidademedida(this) == null || Artigosprecos.jdoGettamanho(this) == null || Artigosprecos.jdoGetcor(this) == null ? null : Artigosprecos.generateKey(Artigosprecos.jdoGetartigo(this).getCodigo(), Artigosprecos.jdoGetprecario(this).getCodigo(), Artigosprecos.jdoGetunidademedida(this).getCodigo(), Artigosprecos.jdoGettamanho(this).getCodigo(), Artigosprecos.jdoGetcor(this).getCodigo());
    }

    public static String generateKey(String artigo, String precario, String unidademedida, String tamanho, String cor) {
        return String.valueOf(artigo) + ":" + precario + ":" + unidademedida + ":" + tamanho + ":" + cor;
    }

    public Artigos getArtigo() {
        return Artigosprecos.jdoGetartigo(this);
    }

    public void setArtigo(Artigos artigo) {
        Artigos artigos = Artigosprecos.jdoGetartigo(this);
        Artigos artigos2 = artigo;
        Artigosprecos.jdoSetartigo(this, artigos2);
        this.firePropertyChange(FIELDS.artigosprecos_artigo, (Object)artigos, (Object)artigos2);
        this.setKey();
    }

    public Precarios getPrecario() {
        return Artigosprecos.jdoGetprecario(this);
    }

    public void setPrecario(Precarios precario) {
        Precarios precarios = Artigosprecos.jdoGetprecario(this);
        Precarios precarios2 = precario;
        Artigosprecos.jdoSetprecario(this, precarios2);
        this.firePropertyChange(FIELDS.artigosprecos_precario, (Object)precarios, (Object)precarios2);
        this.setKey();
    }

    public Unidadesmedida getUnidademedida() {
        return Artigosprecos.jdoGetunidademedida(this);
    }

    public void setUnidademedida(Unidadesmedida unidademedida) {
        Unidadesmedida unidadesmedida = Artigosprecos.jdoGetunidademedida(this);
        Unidadesmedida unidadesmedida2 = unidademedida;
        Artigosprecos.jdoSetunidademedida(this, unidadesmedida2);
        this.firePropertyChange(FIELDS.artigosprecos_unidademedida, (Object)unidadesmedida, (Object)unidadesmedida2);
        this.setKey();
    }

    public Tamanhos getTamanho() {
        return Artigosprecos.jdoGettamanho(this);
    }

    public void setTamanho(Tamanhos tamanho) {
        Tamanhos tamanhos = Artigosprecos.jdoGettamanho(this);
        Tamanhos tamanhos2 = tamanho;
        Artigosprecos.jdoSettamanho(this, tamanhos2);
        this.firePropertyChange(FIELDS.artigosprecos_tamanho, (Object)tamanhos, (Object)tamanhos2);
        this.setKey();
    }

    public Cores getCor() {
        return Artigosprecos.jdoGetcor(this);
    }

    public void setCor(Cores cor) {
        Cores cores = Artigosprecos.jdoGetcor(this);
        Cores cores2 = cor;
        Artigosprecos.jdoSetcor(this, cores2);
        this.firePropertyChange(FIELDS.artigosprecos_cor, (Object)cores, (Object)cores2);
        this.setKey();
    }

    @Deprecated
    public Moedas getMoeda() {
        return null;
    }

    public Integer getNumerolinha() {
        return Artigosprecos.jdoGetnumerolinha(this);
    }

    public String getNumerolinhaToText() {
        return Artigosprecos.jdoGetnumerolinha(this) == null ? "" : Artigosprecos.jdoGetnumerolinha(this).toString();
    }

    protected void setNumerolinha(Integer numerolinha) {
        Integer n = Artigosprecos.jdoGetnumerolinha(this);
        Integer n2 = numerolinha;
        Artigosprecos.jdoSetnumerolinha(this, n2);
        this.firePropertyChange(FIELDS.artigosprecos_numerolinha, (Object)n, (Object)n2);
    }

    public BigDecimal getPerclucro() {
        return Artigosprecos.jdoGetperclucro(this);
    }

    public String getPerclucroToText() {
        return Artigosprecos.jdoGetperclucro(this) == null ? "" : FIELDS.artigosprecos_perclucro.format.format(Artigosprecos.jdoGetperclucro(this));
    }

    public void setPerclucro(BigDecimal perclucro) {
        BigDecimal bigDecimal = Artigosprecos.jdoGetperclucro(this);
        BigDecimal bigDecimal2 = perclucro;
        Artigosprecos.jdoSetperclucro(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.artigosprecos_perclucro, (Object)bigDecimal, (Object)bigDecimal2);
        if (Artigosprecos.jdoGetartigo((Artigosprecos)this).cascade && this.cascade && changed) {
            this.setPrecopvp$Perclucro();
        }
    }

    public void setPerclucro$Precopvp() {
        BigDecimal precocusto = Artigosprecos.jdoGetartigo(this).getPrecocusto(Artigosprecos.jdoGetunidademedida(this));
        this.setPerclucro(BusinessRules.markupPercentage((BigDecimal)Artigosprecos.jdoGetprecopvp(this), (BigDecimal)precocusto));
    }

    public BigDecimal getPrecopvp() {
        return Artigosprecos.jdoGetprecopvp(this);
    }

    public String getPrecopvpToText() {
        return Artigosprecos.jdoGetprecopvp(this) == null ? "" : FIELDS.artigosprecos_precopvp.format.format(Artigosprecos.jdoGetprecopvp(this));
    }

    public void setPrecopvp(BigDecimal precopvp) {
        BigDecimal bigDecimal = Artigosprecos.jdoGetprecopvp(this);
        BigDecimal bigDecimal2 = precopvp;
        Artigosprecos.jdoSetprecopvp(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.artigosprecos_precopvp, (Object)bigDecimal, (Object)bigDecimal2);
        if (Artigosprecos.jdoGetartigo((Artigosprecos)this).cascade && this.cascade && changed) {
            this.setPrecoiva$Precopvp();
            this.setPerclucro$Precopvp();
        }
    }

    @Deprecated
    private void setPrecopvp$Precoiva() {
        this.setPrecopvp(BusinessRules.valueExcluded((BigDecimal)Artigosprecos.jdoGetprecoiva(this), (BigDecimal)Artigosprecos.jdoGetartigo(this).getCodigoiva().getTaxa()));
    }

    public void setPrecopvp$Perclucro() {
        BigDecimal precocusto = Artigosprecos.jdoGetartigo(this).getPrecocusto(Artigosprecos.jdoGetunidademedida(this));
        if (precocusto.signum() != 0) {
            this.setPrecopvp(BusinessRules.valueAdded((BigDecimal)precocusto, (BigDecimal)Artigosprecos.jdoGetperclucro(this)));
        }
    }

    public BigDecimal getPrecoiva() {
        return Artigosprecos.jdoGetprecoiva(this);
    }

    public String getPrecoivaToText() {
        return Artigosprecos.jdoGetprecoiva(this) == null ? "" : FIELDS.artigosprecos_precoiva.format.format(Artigosprecos.jdoGetprecoiva(this));
    }

    public void setPrecoiva(BigDecimal precoiva) {
        BigDecimal bigDecimal = Artigosprecos.jdoGetprecoiva(this);
        BigDecimal bigDecimal2 = FIELDS.artigosprecos_precoiva.format.setScale(precoiva, RoundingMode.HALF_UP);
        Artigosprecos.jdoSetprecoiva(this, bigDecimal2);
        boolean changed = this.firePropertyChange(FIELDS.artigosprecos_precoiva, (Object)bigDecimal, (Object)bigDecimal2);
        if (Artigosprecos.jdoGetartigo((Artigosprecos)this).cascade && this.cascade && changed) {
            this.setPrecopvp(BusinessRules.valueExcluded((BigDecimal)Artigosprecos.jdoGetprecoiva(this), (BigDecimal)Artigosprecos.jdoGetartigo(this).getCodigoiva().getTaxa()));
        }
    }

    public void setPrecoiva$Precopvp() {
        this.setPrecoiva(BusinessRules.valueAdded((BigDecimal)Artigosprecos.jdoGetprecopvp(this), (BigDecimal)Artigosprecos.jdoGetartigo(this).getCodigoiva().getTaxa()));
    }

    @Override
    public boolean isEditable(FIELDS field) {
        return field != FIELDS.artigosprecos_numerolinha;
    }

    @Override
    public void attach(DatabaseManager manager) {
        manager.attach(new AbstractModel[]{Artigosprecos.jdoGetartigo(this), Artigosprecos.jdoGetprecario(this), Artigosprecos.jdoGetunidademedida(this), Artigosprecos.jdoGettamanho(this), Artigosprecos.jdoGetcor(this)});
    }

    public String toString() {
        return Artigosprecos.jdoGetkey(this);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Artigosprecos other) {
        return Artigosprecos.jdoGetkey(this).equals(Artigosprecos.jdoGetkey(other));
    }

    static {
        jdoFieldNames = Artigosprecos.__jdoFieldNamesInit();
        jdoFieldTypes = Artigosprecos.__jdoFieldTypesInit();
        jdoFieldFlags = Artigosprecos.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Artigosprecos.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Artigosprecos.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Artigosprecos.___jdo$loadClass("org.projectocolibri.api.database.model.Artigosprecos"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Artigosprecos());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(2, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.key = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (!((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                    }
                    ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                    return;
                }
                ++i;
            }
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.key);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Artigosprecos result = new Artigosprecos();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        Artigosprecos result = new Artigosprecos();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.artigo = (Artigos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.cor = (Cores)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.key = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.numerolinha = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.perclucro = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.precario = (Precarios)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.precoiva = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.precopvp = (BigDecimal)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 8: {
                this.tamanho = (Tamanhos)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 9: {
                this.unidademedida = (Unidadesmedida)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.artigo);
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.cor);
                break;
            }
            case 2: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.key);
                break;
            }
            case 3: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.numerolinha);
                break;
            }
            case 4: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.perclucro);
                break;
            }
            case 5: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.precario);
                break;
            }
            case 6: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.precoiva);
                break;
            }
            case 7: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.precopvp);
                break;
            }
            case 8: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.tamanho);
                break;
            }
            case 9: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.unidademedida);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(Artigosprecos obj, int index) {
        switch (index) {
            case 0: {
                this.artigo = obj.artigo;
                break;
            }
            case 1: {
                this.cor = obj.cor;
                break;
            }
            case 2: {
                this.key = obj.key;
                break;
            }
            case 3: {
                this.numerolinha = obj.numerolinha;
                break;
            }
            case 4: {
                this.perclucro = obj.perclucro;
                break;
            }
            case 5: {
                this.precario = obj.precario;
                break;
            }
            case 6: {
                this.precoiva = obj.precoiva;
                break;
            }
            case 7: {
                this.precopvp = obj.precopvp;
                break;
            }
            case 8: {
                this.tamanho = obj.tamanho;
                break;
            }
            case 9: {
                this.unidademedida = obj.unidademedida;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Artigosprecos)) {
            throw new IllegalArgumentException("object is not an object of type org.projectocolibri.api.database.model.Artigosprecos");
        }
        Artigosprecos other = (Artigosprecos)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"artigo", "cor", "key", "numerolinha", "perclucro", "precario", "precoiva", "precopvp", "tamanho", "unidademedida"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Artigosprecos.___jdo$loadClass("org.projectocolibri.api.database.model.Artigos"), Artigosprecos.___jdo$loadClass("org.projectocolibri.api.database.model.Cores"), Artigosprecos.___jdo$loadClass("java.lang.String"), Artigosprecos.___jdo$loadClass("java.lang.Integer"), Artigosprecos.___jdo$loadClass("java.math.BigDecimal"), Artigosprecos.___jdo$loadClass("org.projectocolibri.api.database.model.Precarios"), Artigosprecos.___jdo$loadClass("java.math.BigDecimal"), Artigosprecos.___jdo$loadClass("java.math.BigDecimal"), Artigosprecos.___jdo$loadClass("org.projectocolibri.api.database.model.Tamanhos"), Artigosprecos.___jdo$loadClass("org.projectocolibri.api.database.model.Unidadesmedida")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{5, 5, 24, 21, 21, 5, 21, 21, 5, 5};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 10;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        Artigosprecos o = (Artigosprecos)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static Artigos jdoGetartigo(Artigosprecos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return (Artigos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, (Object)objPC.artigo);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"artigo\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.artigo;
    }

    private static void jdoSetartigo(Artigosprecos objPC, Artigos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, (Object)objPC.artigo, (Object)val);
        } else {
            objPC.artigo = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static Cores jdoGetcor(Artigosprecos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (Cores)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, (Object)objPC.cor);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"cor\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.cor;
    }

    private static void jdoSetcor(Artigosprecos objPC, Cores val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, (Object)objPC.cor, (Object)val);
        } else {
            objPC.cor = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static String jdoGetkey(Artigosprecos objPC) {
        return objPC.key;
    }

    private static void jdoSetkey(Artigosprecos objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.key = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 2, objPC.key, val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(2);
        }
    }

    private static Integer jdoGetnumerolinha(Artigosprecos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 3, (Object)objPC.numerolinha);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"numerolinha\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.numerolinha;
    }

    private static void jdoSetnumerolinha(Artigosprecos objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 3, (Object)objPC.numerolinha, (Object)val);
        } else {
            objPC.numerolinha = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    private static BigDecimal jdoGetperclucro(Artigosprecos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 4, (Object)objPC.perclucro);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"perclucro\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.perclucro;
    }

    private static void jdoSetperclucro(Artigosprecos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 4, (Object)objPC.perclucro, (Object)val);
        } else {
            objPC.perclucro = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static Precarios jdoGetprecario(Artigosprecos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return (Precarios)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 5, (Object)objPC.precario);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"precario\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.precario;
    }

    private static void jdoSetprecario(Artigosprecos objPC, Precarios val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 5, (Object)objPC.precario, (Object)val);
        } else {
            objPC.precario = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    private static BigDecimal jdoGetprecoiva(Artigosprecos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 6, (Object)objPC.precoiva);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"precoiva\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.precoiva;
    }

    private static void jdoSetprecoiva(Artigosprecos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 6, (Object)objPC.precoiva, (Object)val);
        } else {
            objPC.precoiva = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(6);
            }
        }
    }

    private static BigDecimal jdoGetprecopvp(Artigosprecos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return (BigDecimal)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 7, (Object)objPC.precopvp);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"precopvp\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.precopvp;
    }

    private static void jdoSetprecopvp(Artigosprecos objPC, BigDecimal val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 7, (Object)objPC.precopvp, (Object)val);
        } else {
            objPC.precopvp = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }

    private static Tamanhos jdoGettamanho(Artigosprecos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return (Tamanhos)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 8, (Object)objPC.tamanho);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tamanho\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tamanho;
    }

    private static void jdoSettamanho(Artigosprecos objPC, Tamanhos val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 8, (Object)objPC.tamanho, (Object)val);
        } else {
            objPC.tamanho = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(8);
            }
        }
    }

    private static Unidadesmedida jdoGetunidademedida(Artigosprecos objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return (Unidadesmedida)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 9, (Object)objPC.unidademedida);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"unidademedida\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.unidademedida;
    }

    private static void jdoSetunidademedida(Artigosprecos objPC, Unidadesmedida val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 9, (Object)objPC.unidademedida, (Object)val);
        } else {
            objPC.unidademedida = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(9);
            }
        }
    }
}

