/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.model;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import javax.jdo.JDOHelper;
import org.apache.commons.lang.NotImplementedException;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.MethodCallback;
import org.projectocolibri.api.database.ModelBeanProperty;
import org.projectocolibri.api.database.manager.AbstractManager;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;

public abstract class AbstractModel
extends ModelBeanProperty
implements Comparable<IDatabaseModel>,
IDatabaseModel {
    protected final TABLES table;
    protected DatabaseManager manager;
    protected final boolean loaded;
    protected boolean busy = false;
    protected boolean cascade = true;

    public boolean setCascade(boolean cascade) {
        boolean value = this.cascade;
        this.cascade = cascade;
        return value;
    }

    @Override
    public int compareTo(IDatabaseModel model) {
        return this.getKey().toString().compareTo(model.getKey().toString());
    }

    @Override
    public TABLES getTable() {
        return this.table;
    }

    @Override
    public DatabaseManager getManager() {
        return this.manager;
    }

    @Override
    public boolean isEdited() {
        return this.loaded;
    }

    @Override
    public boolean isEditable(FIELDS field) {
        return field != this.table.map.getKey() || !this.isEdited();
    }

    public void setManager(DatabaseManager manager) {
        this.manager = manager;
    }

    public IDatabaseModel cloneCopy() {
        throw new NotImplementedException();
    }

    public boolean canRemove() {
        return this.table.canRemove(this.getKey());
    }

    public void attach(DatabaseManager manager) {
    }

    AbstractModel() {
        this(null);
    }

    AbstractModel(TABLES table) {
        this(table, true);
    }

    AbstractModel(TABLES table, DatabaseManager manager) {
        this(table, false);
        this.manager = manager;
    }

    AbstractModel(TABLES table, boolean loaded) {
        this.table = table;
        this.loaded = loaded;
    }

    public Long getJDOVersion() {
        return (Long)JDOHelper.getVersion((Object)this);
    }

    @Override
    public void attachTo(DatabaseManager manager) {
        if (manager != this.manager) {
            this.manager = manager;
            this.attach(this.manager);
        }
    }

    @Override
    public boolean isDirty() {
        if (!super.isDirty() && JDOHelper.isDirty((Object)this)) {
            this.markDirty();
        }
        return super.isDirty();
    }

    public boolean isDirty(Collection<? extends IDatabaseModel> col) {
        if (!super.isDirty()) {
            for (IDatabaseModel iDatabaseModel : col) {
                if (!iDatabaseModel.isDirty()) continue;
                this.markDirty();
            }
        }
        return super.isDirty();
    }

    @Override
    public Object getValue(FIELDS field) {
        try {
            Method method = this.getClass().getDeclaredMethod(IDatabaseModel.METHODS.GET.name(field), new Class[0]);
            return method.invoke((Object)this, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private AbstractModel getValue(FIELDS field, int index) {
        try {
            Method method = this.getClass().getDeclaredMethod(IDatabaseModel.METHODS.GET.name(field), Integer.TYPE);
            return (AbstractModel)method.invoke((Object)this, index);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object getValue(TableFieldKey fieldKey) {
        if (!fieldKey.isEmpty()) {
            try {
                FIELDS rootField = this.table.map.get((TableFieldKey)fieldKey.root()).field;
                switch (rootField.type) {
                    default: {
                        return this.getValue(rootField);
                    }
                    case TABLE: {
                        return ((AbstractModel)this.getValue(rootField)).getValue(fieldKey.child());
                    }
                    case SET: 
                }
                return this.getValue(rootField, fieldKey.index() - 1).getValue(fieldKey.child());
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean setValue(FIELDS field, Object value) {
        try {
            switch (field.type) {
                default: {
                    Method method = this.getClass().getDeclaredMethod(IDatabaseModel.METHODS.SET.name(field), this.getClass().getDeclaredMethod(IDatabaseModel.METHODS.GET.name(field), new Class[0]).getReturnType());
                    method.invoke((Object)this, value);
                    break;
                }
                case SET: {
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean setValue(TableFieldKey fieldKey, Object value) {
        if (!fieldKey.isEmpty()) {
            try {
                Object oldValue = this.getValue(fieldKey);
                FIELDS rootField = this.table.map.get((TableFieldKey)fieldKey.root()).field;
                switch (rootField.type) {
                    default: {
                        return AbstractModel.equals(oldValue, value) ? false : this.setValue(rootField, value);
                    }
                    case TABLE: {
                        return AbstractModel.equals(oldValue, value) ? false : this.setValue(rootField, (Object)this.manager.getTableManager(rootField.childTable).load(value, false));
                    }
                    case SET: 
                }
                return this.getValue(rootField, fieldKey.index() - 1).setValue(fieldKey.child(), value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void create() throws Exception {
        AbstractManager manager = this.manager.getTableManager(this.table);
        if (!manager.exists(this.getKey())) {
            manager.store(this, new MethodCallback[0]).throwException();
        }
    }

    @Override
    public void update() throws Exception {
        AbstractManager manager = this.manager.getTableManager(this.table);
        if (manager.exists(this.getKey())) {
            manager.store(this, new MethodCallback[0]).throwException();
        }
    }

    public MessageList validate(IDatabaseModel.ACTION action) {
        MessageList error = new MessageList();
        if (!this.table.map.isEmpty()) {
            FIELDS field = this.table.map.getKey();
            Object value = this.getValue(field);
            switch (action) {
                case DELETE: {
                    if (this.canRemove()) break;
                    error.add((Object)new MessageLine((Object)this.table.label).brackets(value));
                    break;
                }
                case STORE: {
                    boolean valid;
                    boolean bl = valid = field.isValid(value) && !value.toString().trim().isEmpty();
                    if (valid || this.isEdited()) break;
                    error.add((Object)new MessageLine((Object)field.label));
                }
            }
        }
        return error;
    }

    Object getDefaultValue(FIELDS field) {
        switch (field.type) {
            default: {
                break;
            }
            case TIME: {
                return TimeDateUtils.getCurrentTime();
            }
            case DATE: {
                return TimeDateUtils.getCurrentDate();
            }
            case DECIMAL: {
                return BigDecimal.ZERO;
            }
            case INTEGER: {
                return new Integer(0);
            }
            case STRING: 
            case LONGSTRING: {
                return new String();
            }
            case BOOLEAN: {
                return new Boolean(false);
            }
            case BINARY: {
                return new Byte[0];
            }
        }
        return null;
    }

    MessageList validate(AbstractModel other, FIELDS ... array) {
        MessageList error = new MessageList();
        FIELDS[] fIELDSArray = array.length == 0 ? this.table.fields() : array;
        int n = fIELDSArray.length;
        int n2 = 0;
        while (n2 < n) {
            FIELDS field = fIELDSArray[n2];
            if (!this.isEditable(field)) {
                Object value;
                Object object = value = other == null ? this.getDefaultValue(field) : other.getValue(field);
                if (!AbstractModel.equals(value, this.getValue(field))) {
                    error.add(String.valueOf(field.label.toString()) + " <> " + field.format(value));
                }
            }
            ++n2;
        }
        return error;
    }

    public boolean hasRGPDPermission() {
        return this.manager.getUtilizador().hasRGPDPermission();
    }

    public String parseRGPDValue(String value) {
        return this.hasRGPDPermission() ? value : "*****";
    }

    public BigDecimal parseRGPDValue(BigDecimal value) {
        return this.hasRGPDPermission() || value == null || value.signum() == 0 ? value : BigDecimal.ZERO;
    }

    public String getRGPDValue(String oldValue, String newValue) {
        return this.hasRGPDPermission() ? newValue : oldValue;
    }

    public BigDecimal getRGPDValue(BigDecimal oldValue, BigDecimal newValue) {
        return this.hasRGPDPermission() ? newValue : oldValue;
    }

    protected boolean firePropertyChange(FIELDS property, Object oldValue, Object newValue) {
        if (property != null && this.manager != null && !this.manager.isAuthenticated()) {
            throw new UnsupportedOperationException();
        }
        String propertyName = property == null ? null : property.name;
        return this.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(FIELDS property, String suffix) {
        this.firePropertyChange(String.valueOf(property.name) + suffix, null, null);
    }

    protected void firePropertyChange(FIELDS property) {
        this.firePropertyChange(property, "");
    }
}

