/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.mapper.tree;

import java.util.ArrayList;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.mapper.tree.TreeBranchModel;
import org.projectocolibri.api.database.mapper.tree.TreeGroupModel;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Entidadestipos;

public class TreeList
extends ArrayList<TreeGroupModel> {
    private static final long serialVersionUID = 1L;

    public TreeList(DatabaseManager manager) {
        TreeGroupModel group = new TreeGroupModel(TreeGroupModel.GROUPS.ARTIGOS);
        group.add(new TreeBranchModel(group, TreeBranchModel.BRANCHES.FICHEIRO));
        group.add(new TreeBranchModel(group, TreeBranchModel.BRANCHES.MOVIMENTOS));
        group.add(new TreeBranchModel(group, TreeBranchModel.BRANCHES.DOCUMENTOS));
        for (Documentostipos tipodocumento : manager.getDocumentostiposCollection(0)) {
            if (!tipodocumento.isCodigoValid()) continue;
            group.add(new TreeBranchModel(group, TreeBranchModel.BRANCHES.DOCUMENTOSTIPOS, tipodocumento));
        }
        this.add(group);
        for (Entidadestipos tipoentidade : manager.getEntidadestiposCollection()) {
            if (!tipoentidade.isCodigoValid()) continue;
            group = new TreeGroupModel(TreeGroupModel.GROUPS.ENTIDADES, tipoentidade);
            group.add(new TreeBranchModel(group, TreeBranchModel.BRANCHES.FICHEIRO));
            group.add(new TreeBranchModel(group, TreeBranchModel.BRANCHES.MOVIMENTOS));
            group.add(new TreeBranchModel(group, TreeBranchModel.BRANCHES.DOCUMENTOS));
            for (Documentostipos tipodocumento : manager.getDocumentostiposCollection(tipoentidade.getCodigo())) {
                if (!tipodocumento.isCodigoValid()) continue;
                group.add(new TreeBranchModel(group, TreeBranchModel.BRANCHES.DOCUMENTOSTIPOS, tipodocumento));
            }
            this.add(group);
        }
    }
}

