/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.mapper.tree;

import org.dma.java.io.ByteFile;
import org.dma.java.util.StringList;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.mapper.tree.TreeGroupModel;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Entidadestipos;
import org.projectocolibri.api.language.LABELS;

public class TreeBranchModel {
    public final TreeGroupModel.GROUPS group;
    public final BRANCHES branch;
    public final Entidadestipos tipoentidade;
    public final Documentostipos tipodocumento;

    public TreeBranchModel(TreeGroupModel group, BRANCHES branch) {
        this(group, branch, null);
    }

    public TreeBranchModel(TreeGroupModel group, BRANCHES branch, Documentostipos tipodocumento) {
        this(group.group, branch, group.tipoentidade, tipodocumento);
    }

    public TreeBranchModel(TreeGroupModel.GROUPS group, BRANCHES branch, Entidadestipos tipoentidade, Documentostipos tipodocumento) {
        this.group = group;
        this.branch = branch;
        this.tipoentidade = tipoentidade;
        this.tipodocumento = tipodocumento;
    }

    public String label() {
        switch (this.group) {
            case ARTIGOS: {
                switch (this.branch) {
                    case FICHEIRO: {
                        return LABELS.menutree_artigos_ficheiro.toString();
                    }
                    case MOVIMENTOS: {
                        return LABELS.menutree_artigos_movimentos.toString();
                    }
                    case DOCUMENTOS: {
                        return LABELS.menutree_artigos_documentos.toString();
                    }
                    case DOCUMENTOSTIPOS: {
                        return this.tipodocumento.getDescricao();
                    }
                }
                break;
            }
            case ENTIDADES: {
                switch (this.branch) {
                    case FICHEIRO: {
                        return LABELS.menutree_entidades_ficheiro.format(this.tipoentidade.getDescricao());
                    }
                    case MOVIMENTOS: {
                        return LABELS.menutree_entidades_movimentos.format(this.tipoentidade.getDescricao());
                    }
                    case DOCUMENTOS: {
                        return LABELS.menutree_entidades_documentos.format(this.tipoentidade.getDescricao());
                    }
                    case DOCUMENTOSTIPOS: {
                        return this.tipodocumento.getDescricao();
                    }
                }
            }
        }
        return null;
    }

    public Colibri.ICONS icon() {
        block0 : switch (this.group) {
            case ARTIGOS: {
                switch (this.branch) {
                    case FICHEIRO: {
                        return Colibri.ICONS.GOOGLE_DROPDOWN;
                    }
                    case MOVIMENTOS: {
                        return Colibri.ICONS.GOOGLE_MOVE_UP;
                    }
                    case DOCUMENTOS: {
                        return Colibri.ICONS.GOOGLE_LIST_ALT;
                    }
                    case DOCUMENTOSTIPOS: {
                        return Colibri.ICONS.GOOGLE_DESCRIPTION;
                    }
                }
                break;
            }
            case ENTIDADES: {
                switch (this.tipoentidade.getTipoentidade()) {
                    case 0: {
                        switch (this.branch) {
                            case FICHEIRO: {
                                return Colibri.ICONS.GOOGLE_PERSON;
                            }
                            case MOVIMENTOS: {
                                return Colibri.ICONS.GOOGLE_ARTICLE_SHORTCUT;
                            }
                            case DOCUMENTOS: {
                                return Colibri.ICONS.GOOGLE_LIST_ALT;
                            }
                            case DOCUMENTOSTIPOS: {
                                return Colibri.ICONS.GOOGLE_DESCRIPTION;
                            }
                        }
                        break block0;
                    }
                    case 1: {
                        switch (this.branch) {
                            case FICHEIRO: {
                                return Colibri.ICONS.GOOGLE_LOCAL_SHIPPING;
                            }
                            case MOVIMENTOS: {
                                return Colibri.ICONS.GOOGLE_ARTICLE_SHORTCUT;
                            }
                            case DOCUMENTOS: {
                                return Colibri.ICONS.GOOGLE_LIST_ALT;
                            }
                            case DOCUMENTOSTIPOS: {
                                return Colibri.ICONS.GOOGLE_DESCRIPTION;
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    public byte[] readIcon() {
        return new ByteFile(this.icon().parameters.toString(), new String[0]).read();
    }

    public String toString() {
        StringList list = new StringList(new String[]{this.group.name(), this.branch.name()});
        if (this.tipoentidade != null) {
            list.add((Object)this.tipoentidade.getCodigo());
        }
        if (this.tipodocumento != null) {
            list.add((Object)this.tipodocumento.getCodigo());
        }
        return list.concat(":");
    }

    public static enum BRANCHES {
        FICHEIRO,
        MOVIMENTOS,
        DOCUMENTOS,
        DOCUMENTOSTIPOS;

    }
}

