/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.mapper;

import java.util.Arrays;
import java.util.List;
import org.dma.java.util.StringList;
import org.dma.java.util.StringUtils;
import org.projectocolibri.api.database.mapper.FIELDS;

public class TableFieldKey
extends StringList
implements Comparable<TableFieldKey> {
    private static final long serialVersionUID = 1L;
    private final int index;
    private final String name;

    public static TableFieldKey valueOf(String fieldName) {
        String[] array = fieldName.split(":", 2);
        return new TableFieldKey(array.length == 1 ? 1 : StringUtils.val((String)array[1]), (List<String>)StringUtils.split((String)array[0], (String)"."));
    }

    private static String[] toStringArray(FIELDS ... array) {
        String[] names = new String[array.length];
        int index = 0;
        FIELDS[] fIELDSArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            FIELDS field = fIELDSArray[n2];
            names[index++] = field.name;
            ++n2;
        }
        return names;
    }

    public int index() {
        return this.index;
    }

    public String name() {
        return this.name;
    }

    @Override
    public int compareTo(TableFieldKey other) {
        return this.name.compareTo(other.name);
    }

    public TableFieldKey(FIELDS ... array) {
        this(1, array);
    }

    public TableFieldKey(int index, FIELDS ... array) {
        this(index, TableFieldKey.toStringArray(array));
    }

    private TableFieldKey(String ... array) {
        this(1, array);
    }

    public TableFieldKey(int index, String ... array) {
        this(index, Arrays.asList(array));
    }

    private TableFieldKey(int index, List<String> list) {
        super(list);
        this.index = index;
        this.name = this.concat(".");
    }

    public TableFieldKey cloneCopy(int index) {
        return new TableFieldKey(index, (List<String>)((Object)this));
    }

    public TableFieldKey root() {
        return new TableFieldKey((String)this.get(0));
    }

    public TableFieldKey field() {
        return new TableFieldKey((String)this.get(this.size() - 1));
    }

    public TableFieldKey parent() {
        switch (this.size()) {
            case 3: {
                return new TableFieldKey((String)this.get(0), (String)this.get(1));
            }
            case 2: {
                return this.root();
            }
            case 1: {
                return this;
            }
        }
        throw new UnsupportedOperationException("Unsupported length: " + this.size());
    }

    public TableFieldKey child() {
        switch (this.size()) {
            case 3: {
                return new TableFieldKey((String)this.get(1), (String)this.get(2));
            }
            case 2: {
                return this.field();
            }
            case 1: {
                return this;
            }
        }
        throw new UnsupportedOperationException("Unsupported length: " + this.size());
    }

    public String toString() {
        return this.index > 1 ? String.valueOf(this.name) + ":" + this.index : this.name;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FIELDS) {
            return this.equals((FIELDS)obj);
        }
        if (obj instanceof TableFieldKey) {
            return this.equals((TableFieldKey)obj);
        }
        return this.equals(obj.toString());
    }

    public boolean equals(FIELDS other) {
        return this.equals(other.name);
    }

    public boolean equals(TableFieldKey other) {
        return this.equals(other.toString());
    }

    public boolean equals(String name) {
        return this.toString().equals(name);
    }
}

