/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.mapper;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.dma.java.io.FileParameters;
import org.dma.java.util.ErrorList;
import org.dma.java.util.MessageLine;
import org.dma.java.util.StringList;
import org.dma.java.util.StringUtils;
import org.dma.services.vies.CheckVatHandler;
import org.projectocolibri.api.Activator;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.mapper.CustomFieldFormat;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TableMap;
import org.projectocolibri.api.database.model.Contasbancarias;
import org.projectocolibri.api.database.model.Entidadestipos;
import org.projectocolibri.api.database.model.Isencoesiva;
import org.projectocolibri.api.database.model.Parametros;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.query.QueryFetchplan;
import org.projectocolibri.api.database.query.QueryFetchplanMap;
import org.projectocolibri.api.language.LABELS;

public enum TABLES {
    empresa(false, "0"),
    parametros(2, false, "0"),
    parametrospos(3, false, "0"),
    campos(true, new String[0]),
    layouts(true, "101", "201", "301", "501", "601", "701"),
    pesquisas(true, new String[0]),
    templates(true, new String[0]),
    entidadestipos(true, Entidadestipos.RECORDS.cliente.codigo),
    documentostipos(2, true, new String[0]),
    documentosseries(documentostipos, new String[0]),
    utilizadores(true, Utilizadores.USERS.ADMIN.user, Utilizadores.USERS.COLIBRI.user),
    utilizadoreslogs(false, new String[0]),
    utilizadoresicones(false, new String[0]),
    utilizadoresfiltros(false, new String[0]),
    codigosiva(true, new String[0]),
    isencoesiva(true, Isencoesiva.MOTIVOS_AT.NAMES),
    retencoes(true, "01"),
    unidadesmedida(true, "UN"),
    grupos(false, new String[0]),
    familias(false, new String[0]),
    precarios(true, "001"),
    tamanhos(true, "01"),
    cores(true, "01"),
    condicoespagamento(true, "100"),
    metodospagamento(true, "101"),
    condicoesentrega(true, new String[0]),
    metodostransporte(true, new String[0]),
    tiposmorada(true, "101"),
    codigospostais(false, new String[0]),
    paises(true, CheckVatHandler.COUNTRIES.PT.code),
    armazens(true, "001"),
    funcionarios(true, new String[0]),
    vendedores(true, new String[0]),
    viaturas(true, new String[0]),
    contasbancarias(true, Contasbancarias.RECORDS.conta_principal.codigo),
    tiposmovimento(true, new String[0]),
    moedas(2, true, "EUR"),
    moedascambios(moedas, new String[0]),
    artigos(4, false, new String[0]),
    artigosunidades(artigos, new String[0]),
    artigosprecos(artigos, new String[0]),
    artigoscomposicao(artigos, new String[0]),
    artigosexistencias(artigos, new String[0]),
    artigosdocumentos(4, false, new String[0]),
    artigosdocumentoslinhas(artigosdocumentos, new String[0]),
    artigosmovimentos(3, false, new String[0]),
    entidades(2, false, new String[0]),
    entidadesmoradas(entidades, new String[0]),
    entidadesartigos(false, new String[0]),
    entidadesdocumentos(4, false, new String[0]),
    entidadesdocumentoslinhas(entidadesdocumentos, new String[0]),
    entidadesdocumentosentregas(entidadesdocumentos, new String[0]),
    entidadesdocumentosivas(entidadesdocumentos, new String[0]),
    entidadesdocumentosatws(entidadesdocumentos, new String[0]),
    entidadesmovimentos(2, false, new String[0]);

    public final TableMap map = new TableMap(this);
    public final File file;
    public final Class klass;
    public final LABELS label;
    public final List<String> keys;
    public final int fetchDepth;
    public final TABLES parent;
    public final boolean combo;

    public String toString() {
        return this.label.toString();
    }

    public String varName() {
        return "memvar_" + this.name();
    }

    public String defaultKey() {
        return this.keys.isEmpty() ? null : this.keys.get(0);
    }

    public boolean canRemove(Object key) {
        return !this.keys.contains(key);
    }

    public static ErrorList compile() {
        ErrorList error = new ErrorList();
        int size = 0;
        TABLES[] tABLESArray = TABLES.values();
        int n = tABLESArray.length;
        int n2 = 0;
        while (n2 < n) {
            TABLES table = tABLESArray[n2];
            size += table.map.compile();
            ++n2;
        }
        if (size != 2666) {
            error.warnings().add((Object)new MessageLine((Object)"COMPILED SIZE").brackets((Object)size));
        }
        return error;
    }

    public static String[] classes() {
        StringList list = new StringList();
        TABLES[] tABLESArray = TABLES.values();
        int n = tABLESArray.length;
        int n2 = 0;
        while (n2 < n) {
            TABLES value = tABLESArray[n2];
            if (value.klass != null) {
                list.add((Object)value.klass.getName());
            }
            ++n2;
        }
        return list.toArray();
    }

    public FIELDS[] fields() {
        ArrayList<FIELDS> col = new ArrayList<FIELDS>();
        FIELDS[] fIELDSArray = FIELDS.values();
        int n = fIELDSArray.length;
        int n2 = 0;
        while (n2 < n) {
            FIELDS value = fIELDSArray[n2];
            if (value.table == this) {
                col.add(value);
            }
            ++n2;
        }
        return col.toArray(new FIELDS[col.size()]);
    }

    private TABLES(boolean combo, String ... keys) {
        this(1, combo, keys);
    }

    private TABLES(TABLES parent, String ... keys) {
        this(1, parent, keys);
    }

    private TABLES(int fetchDepth, boolean combo, String ... keys) {
        this(fetchDepth, null, combo, keys);
    }

    private TABLES(int fetchDepth, TABLES parent, String ... keys) {
        this(fetchDepth, parent, false, keys);
    }

    private TABLES(int fetchDepth, TABLES parent, boolean combo, String ... keys) {
        this.file = new FileParameters(StringUtils.capitalize((String)this.name()), "csv", (File)Colibri.FOLDERS.POPULATE_TABELAS.folder).toFile();
        this.klass = Activator.classForName(String.valueOf(Parametros.class.getPackage().getName()) + "." + StringUtils.capitalize((String)this.name()));
        this.label = LABELS.get(this.name());
        this.fetchDepth = fetchDepth;
        this.parent = parent;
        this.combo = combo;
        this.keys = Collections.unmodifiableList(Arrays.asList(keys));
    }

    public QueryFetchplanMap newFetchplan(QueryFetchplan fetchplan) {
        return new QueryFetchplanMap(this, fetchplan);
    }

    public Query newQuery(PersistenceManager pm) {
        return pm.newQuery(this.klass);
    }

    public Query newQuery(PersistenceManager pm, String ... fetchgroup) {
        pm.getFetchPlan().setGroups(fetchgroup);
        return this.newQuery(pm);
    }

    public Query newQuery(PersistenceManager pm, QueryFetchplan fetchplan) {
        this.newFetchplan(fetchplan).addTo(pm);
        return this.newQuery(pm);
    }

    private Object parseKey(Object key) {
        if (this.map.getKey() != null) {
            CustomFieldFormat format = this.map.getKey().format;
            if (format.isUppercase()) {
                return key.toString().toUpperCase();
            }
            if (format.isLowercase()) {
                return key.toString().toLowerCase();
            }
        }
        return key;
    }

    public <T extends IDatabaseModel> T getObject(PersistenceManager pm, Object key) throws JDOObjectNotFoundException {
        if (key != null) {
            try {
                return (T)((IDatabaseModel)pm.getObjectById(this.klass, this.parseKey(key)));
            }
            catch (JDOObjectNotFoundException jDOObjectNotFoundException) {
                return (T)((IDatabaseModel)pm.getObjectById(this.klass, key));
            }
        }
        return null;
    }

    public <T extends IDatabaseModel> T getObjectOrNull(PersistenceManager pm, Object key) {
        try {
            return this.getObject(pm, key);
        }
        catch (JDOObjectNotFoundException jDOObjectNotFoundException) {
            return null;
        }
    }

    public <T extends IDatabaseModel> T loadObject(PersistenceManager pm, Object key) throws JDOObjectNotFoundException {
        pm.getFetchPlan().setMaxFetchDepth(this.fetchDepth);
        T model = this.getObject(pm, key);
        return (T)((IDatabaseModel)pm.detachCopy(model));
    }

    public <T extends IDatabaseModel> T loadObject(PersistenceManager pm, Object key, String ... fetchgroup) throws JDOObjectNotFoundException {
        pm.getFetchPlan().setGroups(fetchgroup);
        return this.loadObject(pm, key);
    }

    public <T extends IDatabaseModel> T loadObject(PersistenceManager pm, Object key, QueryFetchplan fetchplan) throws JDOObjectNotFoundException {
        this.newFetchplan(fetchplan).addTo(pm);
        return this.loadObject(pm, key);
    }
}

