/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.mapper;

import org.dma.java.input.FieldSize;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.database.ColibriDatabase;
import org.projectocolibri.api.database.filter.OPERANDS;
import org.projectocolibri.api.database.mapper.CustomFieldSize;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.model.Parametros;

public enum DEFAULTS {
    TIME(FIELDS.TYPES.TIME, "HH:mm"),
    DATE(FIELDS.TYPES.DATE, Parametros.DATE_PATTERNS[DEFAULTS.getParametros().getFormatodata()]),
    LONGSTRING(FIELDS.TYPES.LONGSTRING, new FieldSize(0)),
    BOOLEAN(FIELDS.TYPES.BOOLEAN, new CustomFieldSize(OPERANDS.VALUES.BOOLEAN.ITEMS)),
    BINARY(FIELDS.TYPES.BINARY, new CustomFieldSize(OPERANDS.VALUES.BINARY.ITEMS)),
    SYSTEM_TIME(FIELDS.TYPES.TIME, "HH:mm:ss"),
    TIME_STAMP(FIELDS.TYPES.DATE, "yyyy-MM-dd HH:mm:ss:SSS"),
    UTILIZADOR_AT(FIELDS.TYPES.STRING, "#########/####"),
    CHAVE_BACKOFFICE(FIELDS.TYPES.STRING, "####-####-####-####"),
    QUANTIDADES(FIELDS.TYPES.DECIMAL, new FieldSize(6, DEFAULTS.getParametros().getDecimaisquantidades().intValue())),
    PRECOSIVA(FIELDS.TYPES.DECIMAL, new FieldSize(9, DEFAULTS.getParametros().getDecimaisprecos().intValue())),
    TOTAIS(FIELDS.TYPES.DECIMAL, new FieldSize(12, DEFAULTS.getParametros().getDecimaistotais().intValue())),
    PRECOS(FIELDS.TYPES.DECIMAL, new FieldSize(9, 6)),
    VALORES(FIELDS.TYPES.DECIMAL, new FieldSize(12, 6)),
    DESCONTOS(FIELDS.TYPES.DECIMAL, new FieldSize(3, 2));

    public final FIELDS.TYPES type;
    public final FieldSize size;
    public final String pattern;

    static {
        Colibri.PREFERENCES.DEFAULTS_LOCK.value.setValue(true);
    }

    private static Parametros getParametros() {
        switch (Colibri.VERSION_TYPE) {
            case INTERNAL: 
            case SERVER: {
                return Parametros.getInstance();
            }
        }
        return ColibriDatabase.getManager().isPopulated() ? ColibriDatabase.getManager().getParametros() : Parametros.getInstance();
    }

    private DEFAULTS(FIELDS.TYPES type, FieldSize size) {
        this(type, size, null);
    }

    private DEFAULTS(FIELDS.TYPES type, String pattern) {
        this(type, new FieldSize(pattern.length()), pattern);
    }

    private DEFAULTS(FIELDS.TYPES type, FieldSize size, String pattern) {
        this.type = type;
        this.size = size;
        this.pattern = pattern;
    }
}

