/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.mapper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.dma.java.input.FieldFormat;
import org.dma.java.input.FieldSize;
import org.eclipse.nebula.widgets.formattedtext.BigDecimalFormatter;
import org.eclipse.nebula.widgets.formattedtext.DateFormatter;
import org.eclipse.nebula.widgets.formattedtext.DoubleFormatter;
import org.eclipse.nebula.widgets.formattedtext.ITextFormatter;
import org.eclipse.nebula.widgets.formattedtext.IntegerFormatter;
import org.eclipse.nebula.widgets.formattedtext.LongFormatter;
import org.eclipse.nebula.widgets.formattedtext.MaskFormatter;
import org.eclipse.nebula.widgets.formattedtext.NumberFormatter;
import org.eclipse.nebula.widgets.formattedtext.TimeFormatter;
import org.eclipse.swt.events.VerifyEvent;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.IFieldProperties;
import org.projectocolibri.api.language.Language;

public class CustomFieldFormat
extends FieldFormat
implements IFieldProperties {
    public static final char[] EXCLUDE_CHARS = new char[]{'\''};
    private final FIELDS.TYPES type;

    public boolean isKey() {
        return this.is(1024);
    }

    public boolean isIndex() {
        return this.is(2048);
    }

    public boolean isLocal() {
        return this.is(4096);
    }

    public boolean isInternal() {
        return this.is(8192);
    }

    public boolean isVirtual() {
        return this.is(16384);
    }

    public CustomFieldFormat(FIELDS.TYPES type, FieldSize size, String pattern, int properties) {
        super(type.type, size, pattern, properties, EXCLUDE_CHARS);
        this.type = type;
    }

    public String format(Object value, DecimalFormatSymbols symbols) {
        return this.type == FIELDS.TYPES.LONGSTRING ? value.toString().replaceAll("\\r\\n|\\r|\\n", FieldFormat.SEPARATOR.SEMICOLON.value) : super.format(value, symbols);
    }

    public String format(Object value) {
        return this.format(value, Language.FORMAT_SYMBOLS);
    }

    public BigDecimal setScale(BigDecimal value, RoundingMode roundingMode) {
        return value.setScale(this.getSize().scale, roundingMode);
    }

    public ITextFormatter getTextFormatter(Locale locale) {
        if (this.getEditPattern() != null) {
            switch (this.getType()) {
                case TIME: {
                    return new TimeFormatter(this.getEditPattern(), locale);
                }
                case DATE: {
                    return new DateFormatter(this.getEditPattern(), locale);
                }
                case LONG: {
                    return new LongFormatter(this.getEditPattern(), this.getDisplayPattern(), locale);
                }
                case DOUBLE: {
                    return new DoubleFormatter(this.getEditPattern(), this.getDisplayPattern(), locale);
                }
                case DECIMAL: {
                    return new BigDecimalFormatter(this.getEditPattern(), this.getDisplayPattern(), locale){

                        public void verifyText(VerifyEvent e) {
                            if (e.keyCode == 16777262 || e.keyCode == 46) {
                                e.text = "" + this.symbols.getDecimalSeparator();
                            }
                            super.verifyText(e);
                        }
                    };
                }
                case INTEGER: {
                    return new IntegerFormatter(this.getEditPattern(), this.getDisplayPattern(), locale);
                }
                case BOOLEAN: {
                    return new NumberFormatter(this.getEditPattern(), this.getDisplayPattern(), locale);
                }
                case STRING: {
                    return new MaskFormatter(this.getEditPattern());
                }
            }
        }
        return null;
    }
}

