/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.manager.tasks;

import java.util.ArrayList;
import java.util.Date;
import org.dma.java.util.Debug;
import org.dma.java.util.MessageList;
import org.projectocolibri.api.database.DatabaseManager;
import org.projectocolibri.api.database.MethodCallback;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.filter.FilterMapRule;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.api.database.query.QueryDefinition;
import org.projectocolibri.api.database.query.QueryOrdering;

public class EntidadesdocumentosTask {
    private final DatabaseManager manager;

    public EntidadesdocumentosTask(DatabaseManager manager) {
        this.manager = manager;
    }

    public MessageList createEntidadesdocumentos(Documentostipos tipodocumento, Date datacriacao) {
        MessageList error = new MessageList();
        QueryDefinition query = new QueryDefinition(TABLES.entidades, QueryOrdering.DIRECTION.ASCENDING);
        query.addRule(new FilterMapRule(FIELDS.entidades_tipoentidade, FIELDS.entidadestipos_codigo).equal(tipodocumento.getTipoentidade().getCodigo())).addRule(tipodocumento.isTipodocumento(2) ? new FilterMapRule(FIELDS.entidades_saldoreal).notEqual(0) : new FilterMapRule(FIELDS.entidades_saldopendente).notEqual(0));
        for (Entidades element : this.manager.getEntidadesCollection(query)) {
            try {
                Entidades entidade = this.manager.loadEntidades(element.getKey());
                Debug.out((Object)entidade);
                Entidadesdocumentos documento = entidade.createDocumento(tipodocumento.getCodigo(), datacriacao);
                ArrayList<Entidadesdocumentoslinhas> list = new ArrayList<Entidadesdocumentoslinhas>();
                switch (tipodocumento.getTabela$Pesquisas()) {
                    case 1: {
                        list.addAll(documento.paste().filter(new FilterMap(TABLES.artigosmovimentos)));
                        break;
                    }
                    case 4: {
                        list.addAll(documento.paste().filter(new FilterMap(TABLES.entidadesmovimentos)));
                        break;
                    }
                }
                if (list.isEmpty()) continue;
                documento.setLinhasdocumento(list);
                error.add(this.manager.storeEntidadesdocumentos(documento, new MethodCallback[0]));
            }
            catch (Exception e) {
                error.add((Throwable)e);
            }
        }
        return error;
    }
}

