/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.manager;

import java.util.Collection;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.dma.java.email.EmailAddress;
import org.dma.java.util.MessageList;
import org.projectocolibri.api.database.MethodCallback;
import org.projectocolibri.api.database.manager.AbstractManager;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.query.QueryOrdering;

public class UtilizadoresManager
extends AbstractManager<Utilizadores> {
    public UtilizadoresManager(PersistenceManagerFactory factory) {
        super(TABLES.utilizadores, factory);
    }

    @Override
    public synchronized MessageList store(Utilizadores utilizador, MethodCallback ... preCommit) {
        utilizador.setChecksum();
        return super.store(utilizador, preCommit);
    }

    public synchronized Utilizadores load$Email(String user) {
        EmailAddress email = new EmailAddress(user);
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        if (email.isValid()) {
            try {
                for (Utilizadores utilizador : (Collection)query.execute()) {
                    if (!email.equals(utilizador.getEmailToText())) continue;
                    Utilizadores utilizadores = (Utilizadores)this.load(utilizador.getUser());
                    return utilizadores;
                }
            }
            finally {
                query.closeAll();
                pm.close();
            }
        }
        return (Utilizadores)this.load(user);
    }

    @Override
    public synchronized Collection<Utilizadores> getCollection() {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setOrdering(String.valueOf(FIELDS.utilizadores_user.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
            Collection collection = pm.detachCopyAll((Collection)query.execute());
            return collection;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    @Override
    public synchronized Collection<Utilizadores> getCollection(Object id) {
        return null;
    }
}

