/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.manager;

import java.util.Collection;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.dma.java.util.StringUtils;
import org.projectocolibri.api.database.manager.AbstractManager;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Moedascambios;
import org.projectocolibri.api.database.query.QueryOrdering;

public class MoedascambiosManager
extends AbstractManager<Moedascambios> {
    public MoedascambiosManager(PersistenceManagerFactory factory) {
        super(TABLES.moedascambios, factory);
    }

    public synchronized Moedascambios load(String moeda, int index) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.moedascambios_moeda.name) + "." + FIELDS.moedas_codigo.name + "==" + StringUtils.quote((String)moeda, (char[])new char[0]));
            query.setOrdering(String.valueOf(FIELDS.moedascambios_data.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.DESCENDING));
            query.setRange((long)index, (long)(index + 1));
            query.setUnique(true);
            Moedascambios moedascambios = (Moedascambios)pm.detachCopy((Object)((Moedascambios)query.execute()));
            return moedascambios;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    @Override
    public synchronized Collection<Moedascambios> getCollection() {
        return null;
    }

    @Override
    public synchronized Collection<Moedascambios> getCollection(Object moeda) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.moedascambios_moeda.name) + "." + FIELDS.moedas_codigo.name + "==" + StringUtils.quote((String)moeda.toString(), (char[])new char[0]));
            query.setOrdering(String.valueOf(FIELDS.moedascambios_data.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.DESCENDING));
            Collection collection = pm.detachCopyAll((Collection)query.execute());
            return collection;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    public synchronized long count(String moeda) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.moedascambios_moeda.name) + "." + FIELDS.moedas_codigo.name + "==" + StringUtils.quote((String)moeda, (char[])new char[0]));
            query.setResult("count(this)");
            long l = (Long)query.execute();
            return l;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }
}

