/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.manager;

import java.util.ArrayList;
import java.util.Collection;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.dma.java.util.Debug;
import org.dma.java.util.MessageList;
import org.projectocolibri.api.database.DatabaseException;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.MethodCallback;
import org.projectocolibri.api.database.SerializedTransaction;
import org.projectocolibri.api.database.manager.AbstractManager;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Moedas;
import org.projectocolibri.api.database.model.Moedascambios;
import org.projectocolibri.api.database.query.QueryOrdering;
import org.projectocolibri.api.language.LABELS;

public class MoedasManager
extends AbstractManager<Moedas> {
    public MoedasManager(PersistenceManagerFactory factory) {
        super(TABLES.moedas, factory);
    }

    @Override
    public synchronized MessageList store(Moedas moeda, MethodCallback ... preCommit) {
        MessageList error = new MessageList();
        PersistenceManager pm = this.factory.getPersistenceManager();
        SerializedTransaction tx = new SerializedTransaction(pm);
        boolean cascade = moeda.setCascade(false);
        try {
            tx.begin();
            boolean exists = this.exists(moeda.getCodigo());
            if (!moeda.isEdited()) {
                if (exists) {
                    throw new DatabaseException(LABELS.erro_database_registoexistente.toString());
                }
            } else if (!exists) {
                throw new DatabaseException(LABELS.erro_database_registoinexistente.toString());
            }
            Moedas stored = (Moedas)this.table.getObjectOrNull(pm, moeda.getCodigo());
            if (error.add(moeda.validate(IDatabaseModel.ACTION.STORE))) {
                MessageList messageList = error;
                return messageList;
            }
            try {
                if (stored != null) {
                    ArrayList<Moedascambios> delete = new ArrayList<Moedascambios>();
                    for (Moedascambios element : stored.getCambios()) {
                        Moedascambios cambio = moeda.getCambios(element.getKey());
                        if (cambio != null) continue;
                        delete.add(element);
                    }
                    Debug.out((String)"DELETE", delete);
                    moeda.removeCambios(delete);
                    pm.deletePersistentAll(delete);
                }
                MethodCallback[] methodCallbackArray = preCommit;
                int n = preCommit.length;
                int n2 = 0;
                while (n2 < n) {
                    MethodCallback callback = methodCallbackArray[n2];
                    if (!callback.run(pm, moeda.cloneCopy())) {
                        throw new InterruptedException();
                    }
                    ++n2;
                }
                pm.makePersistent((Object)moeda);
                tx.commit();
            }
            catch (DatabaseException e) {
                error.add((Throwable)e);
            }
            catch (JDOOptimisticVerificationException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (Exception e) {
                error.add((Throwable)new DatabaseException(e));
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            } else if (!moeda.isEdited()) {
                pm.refresh((Object)moeda);
            }
            moeda.setCascade(cascade);
            pm.close();
        }
        return error;
    }

    @Override
    public synchronized MessageList delete(Object key) {
        MessageList error = new MessageList();
        PersistenceManager pm = this.factory.getPersistenceManager();
        SerializedTransaction tx = new SerializedTransaction(pm);
        try {
            tx.begin();
            Moedas moeda = (Moedas)this.table.getObject(pm, key);
            if (error.add(moeda.validate(IDatabaseModel.ACTION.DELETE))) {
                MessageList messageList = error;
                return messageList;
            }
            try {
                pm.deletePersistentAll(moeda.getCambios());
                pm.deletePersistent((Object)moeda);
                tx.commit();
            }
            catch (JDOOptimisticVerificationException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (JDOObjectNotFoundException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (Exception e) {
                error.add((Throwable)new DatabaseException(e));
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            pm.close();
        }
        return error;
    }

    @Override
    public synchronized Collection<Moedas> getCollection() {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setOrdering(String.valueOf(FIELDS.moedas_codigo.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
            Collection collection = pm.detachCopyAll((Collection)query.execute());
            return collection;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    @Override
    public synchronized Collection<Moedas> getCollection(Object id) {
        return null;
    }
}

