/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.manager;

import java.util.Collection;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.projectocolibri.api.database.manager.AbstractManager;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Familias;
import org.projectocolibri.api.database.query.QueryOrdering;

public class FamiliasManager
extends AbstractManager<Familias> {
    public FamiliasManager(PersistenceManagerFactory factory) {
        super(TABLES.familias, factory);
    }

    public synchronized Familias load(Integer tabela, int index) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.familias_tabela.name) + "==" + tabela);
            query.setOrdering(String.valueOf(FIELDS.familias_codigo.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
            query.setRange((long)index, (long)(index + 1));
            query.setUnique(true);
            Familias familias = (Familias)pm.detachCopy((Object)((Familias)query.execute()));
            return familias;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    @Override
    public synchronized Collection<Familias> getCollection() {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setOrdering(String.valueOf(FIELDS.familias_codigo.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
            Collection collection = pm.detachCopyAll((Collection)query.execute());
            return collection;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    @Override
    public synchronized Collection<Familias> getCollection(Object tabela) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.familias_tabela.name) + "==" + tabela);
            query.setOrdering(String.valueOf(FIELDS.familias_codigo.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
            Collection collection = pm.detachCopyAll((Collection)query.execute());
            return collection;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    public synchronized long count(Integer tabela) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.familias_tabela.name) + "==" + tabela);
            query.setResult("count(this)");
            long l = (Long)query.execute();
            return l;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }
}

