/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.manager;

import java.util.ArrayList;
import java.util.Collection;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.dma.java.util.Debug;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringList;
import org.dma.java.util.StringUtils;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.database.DatabaseException;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.MethodCallback;
import org.projectocolibri.api.database.SerializedTransaction;
import org.projectocolibri.api.database.manager.AbstractManager;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Paises;
import org.projectocolibri.api.database.query.QueryOrdering;
import org.projectocolibri.api.database.query.builder.QueryParametersMap;
import org.projectocolibri.api.language.LABELS;

public class EntidadesManager
extends AbstractManager<Entidades> {
    public EntidadesManager(PersistenceManagerFactory factory) {
        super(TABLES.entidades, factory);
    }

    @Override
    public synchronized MessageList store(Entidades entidade, MethodCallback ... preCommit) {
        MessageList error = new MessageList();
        PersistenceManager pm = this.factory.getPersistenceManager();
        SerializedTransaction tx = new SerializedTransaction(pm);
        boolean cascade = entidade.setCascade(false);
        try {
            Entidades stored;
            tx.begin();
            boolean exists = this.exists(entidade.getKey());
            if (!entidade.isEdited()) {
                if (entidade.getNumero() == -1) {
                    entidade.setNumero(entidade.getNumero$Next());
                }
            } else {
                if (!exists) {
                    throw new DatabaseException(LABELS.erro_database_registoinexistente.toString());
                }
                entidade.setDataalteracao(TimeDateUtils.getCurrentDate());
            }
            if (error.add(entidade.validate(IDatabaseModel.ACTION.STORE, stored = (Entidades)this.table.getObjectOrNull(pm, entidade.getKey())))) {
                MessageList messageList = error;
                return messageList;
            }
            try {
                if (stored != null) {
                    Debug.out((String)"APAGOU");
                    pm.deletePersistentAll(stored.getMoradas());
                    Entidades clone = entidade.cloneCopy();
                    entidade.setMoradas(clone.getMoradas());
                    Debug.out((String)"ACTUALIZOU");
                }
                MethodCallback[] methodCallbackArray = preCommit;
                int n = preCommit.length;
                int n2 = 0;
                while (n2 < n) {
                    MethodCallback callback = methodCallbackArray[n2];
                    if (!callback.run(pm, entidade.cloneCopy())) {
                        throw new InterruptedException();
                    }
                    ++n2;
                }
                pm.makePersistent((Object)entidade);
                tx.commit();
            }
            catch (DatabaseException e) {
                error.add((Throwable)e);
            }
            catch (InterruptedException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (JDOOptimisticVerificationException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (Exception e) {
                error.add((Throwable)new DatabaseException(e));
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            } else if (!entidade.isEdited()) {
                pm.refresh((Object)entidade);
            }
            entidade.setCascade(cascade);
            pm.close();
        }
        return error;
    }

    @Override
    public synchronized MessageList delete(Object key) {
        MessageList error = new MessageList();
        PersistenceManager pm = this.factory.getPersistenceManager();
        SerializedTransaction tx = new SerializedTransaction(pm);
        try {
            tx.begin();
            Entidades entidade = (Entidades)this.table.getObject(pm, key);
            if (error.add(entidade.validate(IDatabaseModel.ACTION.DELETE))) {
                MessageList messageList = error;
                return messageList;
            }
            try {
                Query query = TABLES.entidadesartigos.newQuery(pm);
                query.setFilter(String.valueOf(FIELDS.entidadesartigos_entidade.name) + "." + FIELDS.entidades_key.name + "==" + StringUtils.quote((String)key.toString(), (char[])new char[0]));
                ArrayList artigos = new ArrayList((Collection)query.execute());
                query.closeAll();
                pm.deletePersistentAll(artigos);
                pm.deletePersistentAll(entidade.getMoradas());
                pm.deletePersistent((Object)entidade);
                tx.commit();
            }
            catch (JDOOptimisticVerificationException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (JDOObjectNotFoundException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (Exception e) {
                error.add((Throwable)new DatabaseException(e));
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            pm.close();
        }
        return error;
    }

    public synchronized Collection<Integer> getNumero(String tipoentidade, Paises pais, String nif, int ... estado) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        if (pais != null) {
            try {
                String nif_parsed = pais.parseNif(nif);
                String var_entidadesmoradas = TABLES.entidadesmoradas.varName();
                String var_entidadesmoradas_pais = String.valueOf(TABLES.entidadesmoradas.varName()) + "_" + FIELDS.entidadesmoradas_pais.name;
                String filter = String.valueOf(FIELDS.entidades_moradas.name) + ".contains(" + var_entidadesmoradas + ") && " + var_entidadesmoradas + "." + FIELDS.entidadesmoradas_numerolinha.name + "==1 && " + var_entidadesmoradas + "." + FIELDS.entidadesmoradas_pais.name + "==" + var_entidadesmoradas_pais + " && " + var_entidadesmoradas_pais + "." + FIELDS.paises_codigo.name + "==" + StringUtils.quote((String)pais.getCodigo(), (char[])new char[0]) + " && " + FIELDS.entidades_tipoentidade.name + "." + FIELDS.entidadestipos_codigo.name + "==" + StringUtils.quote((String)tipoentidade, (char[])new char[0]) + " && " + "(" + FIELDS.entidades_nif.name + ".replaceAll(\" \",\"\").equals(" + StringUtils.quote((String)nif_parsed, (char[])new char[0]) + ") || " + FIELDS.entidades_nif.name + ".replaceAll(\" \",\"\").equals(" + StringUtils.quote((String)(String.valueOf(pais.getCodigo()) + nif_parsed), (char[])new char[0]) + "))";
                StringList list = new StringList();
                int[] nArray = estado;
                int n = estado.length;
                int n2 = 0;
                while (n2 < n) {
                    int value = nArray[n2];
                    list.add((Object)(String.valueOf(FIELDS.entidades_estado.name) + "==" + value));
                    ++n2;
                }
                if (!list.isEmpty()) {
                    filter = String.valueOf(filter) + " && (" + list.concat(" || ") + ")";
                }
                query.setFilter(filter);
                query.setOrdering(String.valueOf(FIELDS.entidades_numero.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
                query.setResult(FIELDS.entidades_numero.name);
                ArrayList<Integer> arrayList = new ArrayList<Integer>((Collection)new QueryParametersMap().addVariable(TABLES.entidadesmoradas.klass, var_entidadesmoradas).addVariable(TABLES.paises.klass, var_entidadesmoradas_pais).execute(query));
                return arrayList;
            }
            finally {
                query.closeAll();
                pm.close();
            }
        }
        return new ArrayList<Integer>();
    }

    public synchronized Integer getPreviousNumero(String tipoentidade, Integer numero) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.entidades_tipoentidade.name) + "." + FIELDS.entidadestipos_codigo.name + "==" + StringUtils.quote((String)tipoentidade, (char[])new char[0]) + " && " + FIELDS.entidades_numero.name + "<" + (numero < 0 ? Integer.MAX_VALUE : numero));
            query.setResult("max(" + FIELDS.entidades_numero.name + ")");
            Integer n = (Integer)query.execute();
            return n;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    public synchronized Integer getNextNumero(String tipoentidade) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.entidades_tipoentidade.name) + "." + FIELDS.entidadestipos_codigo.name + "==" + StringUtils.quote((String)tipoentidade, (char[])new char[0]));
            query.setResult("max(" + FIELDS.entidades_numero.name + ")");
            Integer result = (Integer)query.execute();
            Integer n = result == null ? 1 : result + 1;
            return n;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    public synchronized Integer getNextNumero(String tipoentidade, Integer numero) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.entidades_tipoentidade.name) + "." + FIELDS.entidadestipos_codigo.name + "==" + StringUtils.quote((String)tipoentidade, (char[])new char[0]) + " && " + FIELDS.entidades_numero.name + ">" + numero);
            query.setResult("min(" + FIELDS.entidades_numero.name + ")");
            Integer n = (Integer)query.execute();
            return n;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    @Override
    public synchronized Collection<Entidades> getCollection() {
        return null;
    }

    @Override
    public synchronized Collection<Entidades> getCollection(Object tipoentidade) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.entidades_tipoentidade.name) + "." + FIELDS.entidadestipos_codigo.name + "==" + StringUtils.quote((String)tipoentidade.toString(), (char[])new char[0]));
            query.setOrdering(String.valueOf(FIELDS.entidades_numero.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
            Collection collection = pm.detachCopyAll((Collection)query.execute());
            return collection;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    public synchronized long count(String tipoentidade) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.entidades_tipoentidade.name) + "." + FIELDS.entidadestipos_codigo.name + "==" + StringUtils.quote((String)tipoentidade, (char[])new char[0]));
            query.setResult("count(this)");
            long l = (Long)query.execute();
            return l;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }
}

