/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.manager;

import java.util.Collection;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.xml.ws.WebServiceException;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringUtils;
import org.projectocolibri.api.database.DatabaseException;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.SerializedTransaction;
import org.projectocolibri.api.database.manager.AbstractManager;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Documentosseries;
import org.projectocolibri.api.database.query.QueryOrdering;

public class DocumentosseriesManager
extends AbstractManager<Documentosseries> {
    public DocumentosseriesManager(PersistenceManagerFactory factory) {
        super(TABLES.documentosseries, factory);
    }

    public synchronized Documentosseries load(String tipodocumento, int index) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.documentosseries_tipodocumento.name) + "." + FIELDS.documentostipos_codigo.name + "==" + StringUtils.quote((String)tipodocumento, (char[])new char[0]));
            query.setOrdering(String.valueOf(FIELDS.documentosseries_numerolinha.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
            query.setRange((long)index, (long)(index + 1));
            query.setUnique(true);
            Documentosseries documentosseries = (Documentosseries)pm.detachCopy((Object)((Documentosseries)query.execute()));
            return documentosseries;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    @Override
    public synchronized MessageList register(Object key) {
        MessageList error = new MessageList();
        PersistenceManager pm = this.factory.getPersistenceManager();
        SerializedTransaction tx = new SerializedTransaction(pm);
        try {
            tx.begin();
            Documentosseries seriedocumento = (Documentosseries)this.table.getObjectOrNull(pm, key);
            if (seriedocumento == null) {
                throw new DatabaseException("N\u00e3o \u00e9 poss\u00edvel registar s\u00e9ries n\u00e3o gravadas.");
            }
            if (error.add(seriedocumento.validate(IDatabaseModel.ACTION.STORE))) {
                MessageList messageList = error;
                return messageList;
            }
            try {
                pm.makePersistent((Object)seriedocumento);
                pm.checkConsistency();
                seriedocumento.setCodigovalidacao(seriedocumento.service().registar());
                pm.makePersistent((Object)seriedocumento);
                tx.commit();
            }
            catch (DatabaseException e) {
                error.add((Throwable)e);
            }
            catch (JDOOptimisticVerificationException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (WebServiceException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (Exception e) {
                error.add((Throwable)new DatabaseException(e));
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            pm.close();
        }
        return error;
    }

    @Override
    public synchronized MessageList delete(Object key) {
        MessageList error = new MessageList();
        PersistenceManager pm = this.factory.getPersistenceManager();
        SerializedTransaction tx = new SerializedTransaction(pm);
        try {
            tx.begin();
            Documentosseries seriedocumento = (Documentosseries)this.table.getObject(pm, key);
            if (error.add(seriedocumento.validate(IDatabaseModel.ACTION.DELETE))) {
                MessageList messageList = error;
                return messageList;
            }
            try {
                pm.deletePersistent((Object)seriedocumento);
                tx.commit();
            }
            catch (JDOOptimisticVerificationException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (JDOObjectNotFoundException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (Exception e) {
                error.add((Throwable)new DatabaseException(e));
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            pm.close();
        }
        return error;
    }

    public synchronized Integer getNextNumero(String tipodocumento, String serie) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        try {
            Documentosseries seriedocumento = (Documentosseries)this.table.getObject(pm, Documentosseries.generateKey(tipodocumento, serie));
            Integer n = seriedocumento.getNumero() + 1;
            return n;
        }
        catch (JDOObjectNotFoundException jDOObjectNotFoundException) {
        }
        finally {
            pm.close();
        }
        return 1;
    }

    @Override
    public synchronized Collection<Documentosseries> getCollection() {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setOrdering(String.valueOf(FIELDS.documentosseries_key.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
            Collection collection = pm.detachCopyAll((Collection)query.execute());
            return collection;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    @Override
    public synchronized Collection<Documentosseries> getCollection(Object tipodocumento) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.documentosseries_tipodocumento.name) + "." + FIELDS.documentostipos_codigo.name + "==" + StringUtils.quote((String)tipodocumento.toString(), (char[])new char[0]));
            query.setOrdering(String.valueOf(FIELDS.documentosseries_numerolinha.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
            Collection collection = pm.detachCopyAll((Collection)query.execute());
            return collection;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    public synchronized long count(String tipodocumento) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.documentosseries_tipodocumento.name) + "." + FIELDS.documentostipos_codigo.name + "==" + StringUtils.quote((String)tipodocumento, (char[])new char[0]));
            query.setResult("count(this)");
            long l = (Long)query.execute();
            return l;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }
}

