/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.manager;

import java.util.Collection;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.dma.java.util.Debug;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringUtils;
import org.dma.java.util.TimeDateUtils;
import org.projectocolibri.api.database.DatabaseException;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.MethodCallback;
import org.projectocolibri.api.database.SerializedTransaction;
import org.projectocolibri.api.database.manager.AbstractManager;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Artigoscomposicao;
import org.projectocolibri.api.database.query.QueryOrdering;
import org.projectocolibri.api.language.LABELS;

public class ArtigosManager
extends AbstractManager<Artigos> {
    public ArtigosManager(PersistenceManagerFactory factory) {
        super(TABLES.artigos, factory);
    }

    @Override
    public synchronized MessageList store(Artigos artigo, MethodCallback ... preCommit) {
        MessageList error = new MessageList();
        PersistenceManager pm = this.factory.getPersistenceManager();
        SerializedTransaction tx = new SerializedTransaction(pm);
        boolean cascade = artigo.setCascade(false);
        try {
            Artigos stored;
            tx.begin();
            for (Artigoscomposicao linha : artigo.getComposicao()) {
                linha.setComponente((Artigos)TABLES.artigos.getObject(pm, linha.getComponente().getCodigo()));
            }
            boolean exists = this.exists(artigo.getCodigo());
            if (!artigo.isEdited()) {
                if (exists) {
                    throw new DatabaseException(LABELS.erro_database_registoexistente.toString());
                }
            } else {
                if (!exists) {
                    throw new DatabaseException(LABELS.erro_database_registoinexistente.toString());
                }
                artigo.setDataalteracao(TimeDateUtils.getCurrentDate());
            }
            if (error.add(artigo.validate(IDatabaseModel.ACTION.STORE, stored = (Artigos)this.table.getObjectOrNull(pm, artigo.getCodigo())))) {
                MessageList messageList = error;
                return messageList;
            }
            try {
                if (stored != null) {
                    Artigos deleted = stored.cloneCopy();
                    pm.deletePersistentAll(stored.getUnidades());
                    pm.deletePersistentAll(stored.getPrecos());
                    pm.deletePersistentAll(stored.getComposicao());
                    pm.deletePersistentAll(stored.getExistencias());
                    Debug.out((String)"APAGOU");
                    Artigos clone = artigo.cloneCopy();
                    artigo.setUnidades(clone.getUnidades());
                    artigo.setPrecos(clone.getPrecos());
                    artigo.setComposicao(clone.getComposicao());
                    artigo.setExistencias(deleted.getExistencias());
                    Debug.out((String)"ACTUALIZOU");
                }
                MethodCallback[] methodCallbackArray = preCommit;
                int n = preCommit.length;
                int n2 = 0;
                while (n2 < n) {
                    MethodCallback callback = methodCallbackArray[n2];
                    if (!callback.run(pm, artigo.cloneCopy())) {
                        throw new InterruptedException();
                    }
                    ++n2;
                }
                pm.makePersistent((Object)artigo);
                tx.commit();
            }
            catch (DatabaseException e) {
                error.add((Throwable)e);
            }
            catch (InterruptedException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (JDOOptimisticVerificationException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (Exception e) {
                error.add((Throwable)new DatabaseException(e));
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            } else if (!artigo.isEdited()) {
                pm.refresh((Object)artigo);
            }
            artigo.setCascade(cascade);
            pm.close();
        }
        return error;
    }

    @Override
    public synchronized MessageList delete(Object key) {
        MessageList error = new MessageList();
        PersistenceManager pm = this.factory.getPersistenceManager();
        SerializedTransaction tx = new SerializedTransaction(pm);
        try {
            tx.begin();
            Artigos artigo = (Artigos)this.table.getObject(pm, key);
            if (error.add(artigo.validate(IDatabaseModel.ACTION.DELETE))) {
                MessageList messageList = error;
                return messageList;
            }
            try {
                pm.deletePersistentAll(artigo.getUnidades());
                pm.deletePersistentAll(artigo.getPrecos());
                pm.deletePersistentAll(artigo.getComposicao());
                pm.deletePersistentAll(artigo.getExistencias());
                pm.deletePersistent((Object)artigo);
                tx.commit();
            }
            catch (JDOOptimisticVerificationException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (JDOObjectNotFoundException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (Exception e) {
                error.add((Throwable)new DatabaseException(e));
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            pm.close();
        }
        return error;
    }

    public synchronized String getPreviousCodigo(String codigo) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.artigos_codigo.name) + "<" + StringUtils.quote((String)codigo, (char[])new char[0]));
            query.setResult("max(" + FIELDS.artigos_codigo.name + ")");
            String string = (String)query.execute((Object)codigo);
            return string;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    public synchronized String getNextCodigo(String codigo) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setFilter(String.valueOf(FIELDS.artigos_codigo.name) + ">" + StringUtils.quote((String)codigo, (char[])new char[0]));
            query.setResult("min(" + FIELDS.artigos_codigo.name + ")");
            String string = (String)query.execute((Object)codigo);
            return string;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    @Override
    public synchronized Collection<Artigos> getCollection() {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setOrdering(String.valueOf(FIELDS.artigos_codigo.name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
            Collection collection = pm.detachCopyAll((Collection)query.execute());
            return collection;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    @Override
    public synchronized Collection<Artigos> getCollection(Object id) {
        return null;
    }
}

