/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.manager;

import java.util.ArrayList;
import java.util.Collection;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.dma.java.util.MessageList;
import org.dma.java.util.StringList;
import org.projectocolibri.api.database.DatabaseException;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.ITableManager;
import org.projectocolibri.api.database.MethodCallback;
import org.projectocolibri.api.database.SerializedTransaction;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.model.AbstractModel;
import org.projectocolibri.api.database.query.QueryDefinition;
import org.projectocolibri.api.database.query.QueryOrdering;
import org.projectocolibri.api.language.LABELS;

public abstract class AbstractManager<T extends AbstractModel>
implements ITableManager<T> {
    public final TABLES table;
    public final PersistenceManagerFactory factory;

    public AbstractManager(TABLES table, PersistenceManagerFactory factory) {
        this.table = table;
        this.factory = factory;
    }

    public synchronized MessageList register(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized MessageList store(T model, MethodCallback ... preCommit) {
        MessageList error = new MessageList();
        PersistenceManager pm = this.factory.getPersistenceManager();
        SerializedTransaction tx = new SerializedTransaction(pm);
        boolean cascade = ((AbstractModel)model).setCascade(false);
        try {
            tx.begin();
            boolean exists = this.exists(model.getKey());
            if (!((AbstractModel)model).isEdited() && exists) {
                throw new DatabaseException(LABELS.erro_database_registoexistente.toString());
            }
            if (((AbstractModel)model).isEdited() && !exists) {
                throw new DatabaseException(LABELS.erro_database_registoinexistente.toString());
            }
            if (error.add(((AbstractModel)model).validate(IDatabaseModel.ACTION.STORE))) {
                MessageList messageList = error;
                return messageList;
            }
            try {
                MethodCallback[] methodCallbackArray = preCommit;
                int n = preCommit.length;
                int n2 = 0;
                while (n2 < n) {
                    MethodCallback callback = methodCallbackArray[n2];
                    if (!callback.run(pm, ((AbstractModel)model).cloneCopy())) {
                        throw new InterruptedException();
                    }
                    ++n2;
                }
                pm.makePersistent(model);
                tx.commit();
            }
            catch (JDOOptimisticVerificationException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (Exception e) {
                error.add((Throwable)new DatabaseException(e));
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            } else if (!((AbstractModel)model).isEdited()) {
                pm.refresh(model);
            }
            ((AbstractModel)model).setCascade(cascade);
            pm.close();
        }
        return error;
    }

    @Override
    public synchronized MessageList delete(Object key) {
        MessageList error = new MessageList();
        PersistenceManager pm = this.factory.getPersistenceManager();
        SerializedTransaction tx = new SerializedTransaction(pm);
        try {
            tx.begin();
            AbstractModel model = (AbstractModel)this.table.getObject(pm, key);
            if (error.add(model.validate(IDatabaseModel.ACTION.DELETE))) {
                MessageList messageList = error;
                return messageList;
            }
            try {
                pm.deletePersistent((Object)model);
                tx.commit();
            }
            catch (JDOOptimisticVerificationException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (JDOObjectNotFoundException e) {
                error.add((Throwable)new DatabaseException(e));
            }
            catch (Exception e) {
                error.add((Throwable)new DatabaseException(e));
            }
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
            pm.close();
        }
        return error;
    }

    public synchronized T load(Object key) {
        return (T)this.load(key, true);
    }

    @Override
    public synchronized T load(Object key, boolean complete) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        try {
            AbstractModel abstractModel = (AbstractModel)this.table.loadObject(pm, key, complete ? "all" : "default");
            return (T)abstractModel;
        }
        catch (JDOObjectNotFoundException jDOObjectNotFoundException) {
            return null;
        }
        finally {
            pm.close();
        }
    }

    @Override
    public synchronized boolean exists(Object key) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        try {
            try {
                this.table.getObject(pm, key);
            }
            catch (JDOObjectNotFoundException jDOObjectNotFoundException) {
                pm.close();
                return false;
            }
        }
        finally {
            pm.close();
        }
        return true;
    }

    @Override
    public synchronized Collection<T> getCollection(QueryDefinition<T> query) {
        if (!query.table.equals((Object)this.table)) {
            throw new IllegalArgumentException(query.table.name());
        }
        PersistenceManager pm = this.factory.getPersistenceManager();
        try {
            Collection<T> col = query.execute(pm);
            pm.makeTransientAll(col, true);
            ArrayList<T> arrayList = new ArrayList<T>(col);
            return arrayList;
        }
        finally {
            query.close();
            pm.close();
        }
    }

    @Override
    public synchronized String[] getArray(FIELDS field) {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setOrdering(String.valueOf(this.table.map.getKey().name) + " " + (Object)((Object)QueryOrdering.DIRECTION.ASCENDING));
            query.setResult(field == null ? null : field.name);
            Collection col = (Collection)query.execute();
            String[] stringArray = StringList.valueOf((Collection)col).toArray();
            return stringArray;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }

    @Override
    public synchronized long count() {
        PersistenceManager pm = this.factory.getPersistenceManager();
        Query query = this.table.newQuery(pm);
        try {
            query.setResult("count(this)");
            long l = (Long)query.execute();
            return l;
        }
        finally {
            query.closeAll();
            pm.close();
        }
    }
}

