/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database.filter;

import java.util.LinkedHashMap;
import org.dma.java.input.FieldFormat;
import org.dma.java.util.StringList;
import org.dma.java.util.StringUtils;
import org.projectocolibri.api.database.ILabelFormatter;
import org.projectocolibri.api.database.filter.FilterFieldMap;
import org.projectocolibri.api.database.filter.FilterMapRule;
import org.projectocolibri.api.database.filter.FilterMapValidator;
import org.projectocolibri.api.database.filter.FilterOperandMap;
import org.projectocolibri.api.database.filter.OPERANDS;
import org.projectocolibri.api.database.filter.OPERATORS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.mapper.TableFieldMap;

public class FilterMap
extends LinkedHashMap<TableFieldKey, FilterFieldMap> {
    private static final long serialVersionUID = 1L;
    public static final String ELEMENT_SEPARATOR = FieldFormat.SEPARATOR.COMMA.value;
    public static final String LINE_SEPARATOR = FieldFormat.SEPARATOR.SEMICOLON.value;
    public static final char VALUE_DELIMITER = '\'';
    @Deprecated
    public static final char[] CONDITION_DELIMITER = new char[]{'(', ')'};
    public final TABLES table;

    public void print() {
        System.out.println("---FILTER MAP---");
        System.out.println("SIZE=" + this.size());
        System.out.println("TABLE=" + this.table.name());
        for (TableFieldKey fieldKey : this.keySet()) {
            System.out.println("FIELD=" + fieldKey);
            ((FilterFieldMap)this.get(fieldKey)).print();
        }
    }

    public int indexOf(TableFieldKey key, OPERATORS.MATH operator) {
        FilterFieldMap fieldMap = (FilterFieldMap)this.get(key);
        return fieldMap == null ? -1 : fieldMap.indexOf(operator);
    }

    public boolean remove(TableFieldKey key, int index) {
        FilterFieldMap fieldMap = (FilterFieldMap)this.get(key);
        if (fieldMap != null) {
            FilterOperandMap operand = fieldMap.remove(index);
            if (fieldMap.isEmpty()) {
                this.remove(key);
            }
            return operand != null;
        }
        return false;
    }

    public FilterMap addRule(FilterMapRule rule) {
        int index = 0;
        for (FilterOperandMap operand : rule) {
            FilterFieldMap fieldMap = (FilterFieldMap)this.get(rule.fieldKey);
            if (fieldMap == null) {
                fieldMap = new FilterFieldMap();
                this.put(rule.fieldKey, fieldMap);
            }
            if (index == 0) {
                fieldMap.add(operand);
            } else {
                fieldMap.add(operand, rule.getLogicalOperators(index - 1));
            }
            ++index;
        }
        return this;
    }

    public FilterMap setRule(FilterMapRule rule) {
        FilterFieldMap fieldMap = (FilterFieldMap)this.get(rule.fieldKey);
        for (FilterOperandMap operand : rule) {
            if (fieldMap == null) continue;
            fieldMap.remove(operand);
        }
        return this.addRule(rule);
    }

    public FilterMapValidator validator() {
        return new FilterMapValidator(this);
    }

    public FilterMap(TABLES table, String filter) {
        this(table);
        this.put(filter);
    }

    public FilterMap(TABLES table) {
        this.table = table;
    }

    public FilterMap cloneCopy() {
        FilterMap clone = new FilterMap(this.table);
        clone.putAll(this);
        return clone;
    }

    public FilterMap cloneCopy(String filter) {
        return new FilterMap(this.table, filter);
    }

    public FilterMap cleanCopy() {
        FilterMap copy = new FilterMap(this.table);
        for (TableFieldKey fieldKey : this.keySet()) {
            FilterMapRule rule = new FilterMapRule(fieldKey);
            int index = 0;
            FilterFieldMap fieldMap = (FilterFieldMap)this.get(fieldKey);
            for (FilterOperandMap operand : fieldMap) {
                if (operand.getValue() == null && operand.getType() != OPERANDS.TYPES.FIELD) continue;
                if (index == 0) {
                    rule.add(operand);
                } else {
                    rule.add(operand, fieldMap.getLogicalOperators(index - 1));
                }
                ++index;
            }
            copy.addRule(rule);
        }
        return copy;
    }

    public FilterMap update(FilterMap from) {
        if (from.table != this.table) {
            throw new IllegalArgumentException("Expected map from table: " + (Object)((Object)this.table));
        }
        for (TableFieldKey fieldKey : from.keySet()) {
            if (!this.containsKey(fieldKey)) continue;
            this.put(fieldKey, ((FilterFieldMap)from.get(fieldKey)).cloneCopy());
        }
        return this;
    }

    public FilterMap replace(FilterMap from) {
        if (from.table != this.table) {
            throw new IllegalArgumentException("Expected map from table: " + (Object)((Object)this.table));
        }
        for (TableFieldKey fieldKey : from.keySet()) {
            this.put(fieldKey, ((FilterFieldMap)from.get(fieldKey)).cloneCopy());
        }
        return this;
    }

    public FilterMap remove(FilterMap from) {
        if (from.table != this.table) {
            throw new IllegalArgumentException("Expected map from table: " + (Object)((Object)this.table));
        }
        for (TableFieldKey fieldKey : from.keySet()) {
            this.remove(fieldKey);
        }
        return this;
    }

    FilterMap put(String filter) {
        this.clear();
        for (String line : StringUtils.split((String)filter, (String)LINE_SEPARATOR).trim()) {
            TableFieldKey fieldKey;
            StringList elements = StringUtils.split((String)line, (String)ELEMENT_SEPARATOR).trim();
            if (elements.size() <= 0 || ((String)elements.get(0)).isEmpty() || this.containsKey(fieldKey = TableFieldKey.valueOf((String)elements.get(0)))) continue;
            FilterMapRule rule = new FilterMapRule(fieldKey);
            int index = 1;
            while (index < elements.size()) {
                if (index % 2 == 0) {
                    rule.add(OPERATORS.LOGICAL.find((String)elements.get(index)));
                } else {
                    elements.set(index, (Object)StringUtils.unquote((String)((String)elements.get(index)), (char[])CONDITION_DELIMITER).trim());
                    OPERATORS.MATH mathOperator = OPERATORS.MATH.find((String)elements.get(index));
                    if (mathOperator != null) {
                        String value;
                        String operand = StringUtils.removeFirst((String)((String)elements.get(index)), (String)mathOperator.symbol).trim();
                        if (StringUtils.isQuoted((String)operand, (char[])new char[]{'\''})) {
                            value = StringUtils.unquote((String)operand, (char[])new char[]{'\''});
                            rule.add(new FilterOperandMap(mathOperator, value));
                        } else if (operand.startsWith("#")) {
                            rule.add(new FilterOperandMap(mathOperator, operand, OPERANDS.TYPES.VAR));
                        } else if (!operand.isEmpty()) {
                            value = operand.equals("null") ? null : operand;
                            rule.add(new FilterOperandMap(mathOperator, value, OPERANDS.TYPES.FIELD));
                        } else {
                            rule.add(new FilterOperandMap(mathOperator));
                        }
                    } else {
                        rule.add(new FilterOperandMap());
                    }
                }
                ++index;
            }
            this.put(fieldKey, rule);
        }
        return this;
    }

    public FilterMap process() {
        for (TableFieldKey fieldKey : this.keySet()) {
            for (FilterOperandMap operand : (FilterFieldMap)this.get(fieldKey)) {
                TableFieldMap fieldMap = this.table.map.get(fieldKey);
                if (fieldMap == null) continue;
                operand.process(fieldMap.field.type);
            }
        }
        return this;
    }

    public String toReadable(ILabelFormatter formatter) {
        FilterMap copy = this.cleanCopy().process();
        StringBuilder sb = new StringBuilder();
        for (TableFieldKey fieldKey : copy.keySet()) {
            int index = 0;
            FilterFieldMap fieldMap = (FilterFieldMap)copy.get(fieldKey);
            for (FilterOperandMap operand : fieldMap) {
                if (index == 0) {
                    if (sb.length() > 0) {
                        sb.append(ELEMENT_SEPARATOR).append(" ");
                    }
                    sb.append(this.table.map.get(fieldKey).label(formatter)).append(" ");
                } else {
                    sb.append(" ").append((Object)fieldMap.getLogicalOperators((int)(index - 1)).label).append(" ");
                }
                ++index;
                sb.append("(").append((Object)operand.getOperator().label).append(" ");
                if (operand.getValue() != null) {
                    switch (operand.getType()) {
                        case VALUE: 
                        case VAR: {
                            sb.append(StringUtils.quote((String)this.table.map.get((TableFieldKey)fieldKey).field.format(operand.getConverted()), (char[])new char[]{'\''}));
                            break;
                        }
                        case FIELD: {
                            sb.append(this.table.map.get((String)operand.getValue()).field);
                        }
                    }
                }
                sb.append(")");
            }
        }
        return sb.toString();
    }

    private String toString(String separator) {
        StringBuilder sb = new StringBuilder();
        for (TableFieldKey fieldKey : this.keySet()) {
            if (sb.length() > 0) {
                sb.append(LINE_SEPARATOR).append(separator);
            }
            sb.append(fieldKey).append(ELEMENT_SEPARATOR);
            int index = 0;
            FilterFieldMap fieldMap = (FilterFieldMap)this.get(fieldKey);
            for (FilterOperandMap operand : fieldMap) {
                if (index > 0) {
                    sb.append(ELEMENT_SEPARATOR).append(fieldMap.getLogicalOperators((int)(index - 1)).symbol).append(ELEMENT_SEPARATOR);
                }
                sb.append(operand.toString());
                ++index;
            }
        }
        return sb.toString();
    }

    public String toText() {
        return this.toString("\n");
    }

    @Override
    public String toString() {
        return this.toString("");
    }
}

