/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;

public class ModelBeanProperty {
    private boolean dirty = false;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public void print(PersistenceManager pm, String message) {
        System.out.println(message);
        System.out.println("CALLER: " + new Throwable().getStackTrace()[3].getMethodName());
        System.out.println("OBJECT: " + this);
        System.out.println("PM: " + JDOHelper.getPersistenceManager((Object)this));
        System.out.println("ID: " + JDOHelper.getObjectId((Object)this) + " (Version=" + JDOHelper.getVersion((Object)this) + ")");
        System.out.println("STATE: " + JDOHelper.getObjectState((Object)this));
        System.out.println("DIRTY: " + JDOHelper.isDirty((Object)this));
        System.out.println("FETCHPLAN: (DEPTH=" + pm.getFetchPlan().getMaxFetchDepth() + "/SIZE=" + pm.getFetchPlan().getFetchSize() + ") " + pm.getFetchPlan().getGroups());
    }

    public static <T> boolean equals(T a, T b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof BigDecimal && b instanceof BigDecimal) {
            return ((BigDecimal)a).compareTo((BigDecimal)b) == 0;
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).doubleValue() == ((Number)b).doubleValue();
        }
        return a.equals(b);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected boolean firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
        if (!ModelBeanProperty.equals(oldValue, newValue)) {
            this.dirty = true;
            return true;
        }
        return false;
    }
}

