/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.database;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import javax.jdo.JDOCanRetryException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.listener.InstanceLifecycleListener;
import org.dma.java.time.DatePeriod;
import org.dma.java.util.ErrorList;
import org.dma.java.util.MessageLine;
import org.dma.java.util.MessageList;
import org.dma.java.util.TimeDateUtils;
import org.dma.java.util.VersionNumber;
import org.dma.services.vies.CheckVatHandler;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.birt.BIRTEngineFactory;
import org.projectocolibri.api.birt.design.BIRTDesignCache;
import org.projectocolibri.api.database.DatabaseException;
import org.projectocolibri.api.database.DatabaseParameters;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.ILabelFormatter;
import org.projectocolibri.api.database.JDOPropertiesMap;
import org.projectocolibri.api.database.ManagerTableMap;
import org.projectocolibri.api.database.MethodCallback;
import org.projectocolibri.api.database.PersistenceListener;
import org.projectocolibri.api.database.PopulateManager;
import org.projectocolibri.api.database.manager.AbstractManager;
import org.projectocolibri.api.database.manager.UtilizadoresManager;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.tree.TreeBranchModel;
import org.projectocolibri.api.database.mapper.tree.TreeGroupModel;
import org.projectocolibri.api.database.model.Armazens;
import org.projectocolibri.api.database.model.Artigos;
import org.projectocolibri.api.database.model.Artigoscomposicao;
import org.projectocolibri.api.database.model.Artigosdocumentos;
import org.projectocolibri.api.database.model.Artigosdocumentoslinhas;
import org.projectocolibri.api.database.model.Artigosexistencias;
import org.projectocolibri.api.database.model.Artigosmovimentos;
import org.projectocolibri.api.database.model.Artigosprecos;
import org.projectocolibri.api.database.model.Artigosunidades;
import org.projectocolibri.api.database.model.Campos;
import org.projectocolibri.api.database.model.Codigosiva;
import org.projectocolibri.api.database.model.Codigospostais;
import org.projectocolibri.api.database.model.Condicoesentrega;
import org.projectocolibri.api.database.model.Condicoespagamento;
import org.projectocolibri.api.database.model.Contasbancarias;
import org.projectocolibri.api.database.model.Cores;
import org.projectocolibri.api.database.model.Documentosseries;
import org.projectocolibri.api.database.model.Documentostipos;
import org.projectocolibri.api.database.model.Empresa;
import org.projectocolibri.api.database.model.Entidades;
import org.projectocolibri.api.database.model.Entidadesartigos;
import org.projectocolibri.api.database.model.Entidadesdocumentos;
import org.projectocolibri.api.database.model.Entidadesdocumentosatws;
import org.projectocolibri.api.database.model.Entidadesdocumentosentregas;
import org.projectocolibri.api.database.model.Entidadesdocumentosivas;
import org.projectocolibri.api.database.model.Entidadesdocumentoslinhas;
import org.projectocolibri.api.database.model.Entidadesmoradas;
import org.projectocolibri.api.database.model.Entidadesmovimentos;
import org.projectocolibri.api.database.model.Entidadestipos;
import org.projectocolibri.api.database.model.Familias;
import org.projectocolibri.api.database.model.Grupos;
import org.projectocolibri.api.database.model.Isencoesiva;
import org.projectocolibri.api.database.model.Layouts;
import org.projectocolibri.api.database.model.Metodospagamento;
import org.projectocolibri.api.database.model.Metodostransporte;
import org.projectocolibri.api.database.model.Moedas;
import org.projectocolibri.api.database.model.Moedascambios;
import org.projectocolibri.api.database.model.Paises;
import org.projectocolibri.api.database.model.Parametros;
import org.projectocolibri.api.database.model.Parametrospos;
import org.projectocolibri.api.database.model.Pesquisas;
import org.projectocolibri.api.database.model.Precarios;
import org.projectocolibri.api.database.model.Retencoes;
import org.projectocolibri.api.database.model.Tamanhos;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.api.database.model.Tiposmorada;
import org.projectocolibri.api.database.model.Tiposmovimento;
import org.projectocolibri.api.database.model.Unidadesmedida;
import org.projectocolibri.api.database.model.Utilizadores;
import org.projectocolibri.api.database.model.Utilizadoresfiltros;
import org.projectocolibri.api.database.model.Utilizadoresicones;
import org.projectocolibri.api.database.model.Utilizadoreslogs;
import org.projectocolibri.api.database.model.Vendedores;
import org.projectocolibri.api.database.model.Viaturas;
import org.projectocolibri.api.database.query.QueryDefinition;
import org.projectocolibri.api.database.update.UpdateManager;
import org.projectocolibri.api.language.LABELS;
import org.projectocolibri.xml.beans.licencas.ColibriLicenca;

public final class DatabaseManager {
    private Empresa empresa;
    private Parametros parametros;
    private Parametrospos parametrospos;
    private Utilizadores utilizador;
    private final ColibriLicenca licenca;
    private final DatabaseParameters parameters;
    private final PersistenceManagerFactory factory;
    private final ManagerTableMap manager;
    private final BIRTDesignCache design;
    private final IReportEngine engine;

    public ColibriLicenca getLicenca() {
        return this.licenca;
    }

    public DatabaseParameters getParameters() {
        return this.parameters;
    }

    public PersistenceManager getPersistenceManager() {
        return this.factory.getPersistenceManager();
    }

    public AbstractManager getTableManager(TABLES table) {
        return this.getTableManager().get(table);
    }

    public ILabelFormatter getCampos() {
        return this.getTableManager().campos;
    }

    public BIRTDesignCache getDesign() {
        return this.design;
    }

    public IReportEngine getEngine() {
        return this.engine;
    }

    private ManagerTableMap getTableManager() {
        if (!this.isAuthenticated()) {
            throw new RuntimeException("Autenticacao nao efectuada!");
        }
        return this.manager;
    }

    public void dropTable(String tableName) throws Exception {
        this.parameters.driver.executeDropTable(this.factory, tableName);
    }

    public void dropColumn(TABLES table, String ... columns) throws Exception {
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            this.parameters.driver.executeDropColumn(this.factory, table.name(), columnName);
            ++n2;
        }
    }

    public void alterDataType(TABLES table, String columnName, String dataType) throws Exception {
        this.parameters.driver.executeAlterDataType(this.factory, table.name(), columnName, dataType);
    }

    public DatabaseManager(ColibriLicenca licenca, DatabaseParameters parameters) throws Exception {
        this.licenca = licenca;
        this.parameters = parameters;
        if (!licenca.isValid()) {
            throw new Exception(LABELS.erro_licenca_invalida.toString());
        }
        if (!parameters.isHostValid(licenca)) {
            throw new Exception(LABELS.erro_database_hostinvalido.toString());
        }
        this.factory = parameters.createFactory((InstanceLifecycleListener)new PersistenceListener(this), new JDOPropertiesMap(parameters, TABLES.classes()));
        this.manager = new ManagerTableMap(this.factory);
        this.design = new BIRTDesignCache(this.manager.templates);
        this.engine = BIRTEngineFactory.getInstance().createReportEngine();
    }

    public DatabaseManager close() {
        try {
            try {
                this.factory.close();
            }
            catch (JDOCanRetryException jDOCanRetryException) {
                this.close();
                this.design.clear();
                this.engine.destroy();
            }
        }
        finally {
            this.design.clear();
            this.engine.destroy();
        }
        return this;
    }

    public ErrorList authenticate(String user, String password) throws Exception {
        UtilizadoresManager manager = new UtilizadoresManager(this.factory);
        Utilizadores.RECORDS[] rECORDSArray = Utilizadores.RECORDS.values();
        int n = rECORDSArray.length;
        int n2 = 0;
        while (n2 < n) {
            Utilizadores utilizador;
            Utilizadores.RECORDS record = rECORDSArray[n2];
            if (!manager.exists(record.user.user)) {
                utilizador = new Utilizadores(this, record, password);
                switch (record) {
                    case admin: {
                        utilizador.setEmail(this.licenca.getEmailTitular());
                        break;
                    }
                    case colibri: {
                        utilizador.setEmail(Colibri.CONTROL_EMAIL.getEmail());
                    }
                }
                manager.store(utilizador, new MethodCallback[0]).throwException();
            }
            if ((utilizador = (Utilizadores)manager.load(record.user.user)).isValid()) {
                switch (record) {
                    case admin: {
                        break;
                    }
                    case colibri: {
                        utilizador.setPassword(Colibri.VERSION_TYPE.password.secure());
                    }
                }
                utilizador.setPermissoes(record.permissions);
                if (utilizador.isDirty()) {
                    manager.store(utilizador, new MethodCallback[0]).throwException();
                }
            }
            ++n2;
        }
        Utilizadores utilizador = manager.load$Email(user);
        if (utilizador == null || password.isEmpty()) {
            throw new DatabaseException(LABELS.erro_utilizador_invalido.toString());
        }
        if (!utilizador.isValid()) {
            throw new DatabaseException(LABELS.erro_utilizador_corrompido.toString());
        }
        if (utilizador.isEstado(0)) {
            throw new DatabaseException(LABELS.erro_utilizador_inactivo.toString());
        }
        if (!utilizador.authenticate(password)) {
            throw new DatabaseException(LABELS.erro_utilizador_invalido.toString());
        }
        this.utilizador = utilizador;
        return TABLES.compile();
    }

    public ErrorList populate() throws Exception {
        ErrorList error = new ErrorList();
        if (!this.isPopulated()) {
            switch (new PopulateManager(this).execute()) {
                case CANCELED: {
                    throw new DatabaseException(LABELS.info_database_criacaocancelada.toString());
                }
                case SUCCESS: {
                    error.warnings().add(LABELS.info_database_criacaoefectuada.toString());
                }
            }
        }
        return error;
    }

    public ErrorList update() throws Exception {
        ErrorList error = new ErrorList();
        if (this.needsUpdate()) {
            switch (new UpdateManager(this).execute()) {
                case IGNORED: {
                    break;
                }
                case ABORTED: 
                case CANCELED: {
                    throw new DatabaseException(LABELS.info_database_actualizacaocancelada.toString());
                }
                case SUCCESS: {
                    error.warnings().add(LABELS.info_database_actualizacaoefectuada.toString());
                }
            }
        }
        this.licenca.control(this.getEmpresa().getNifParsed(), Colibri.VERSION_TYPE == Colibri.VERSIONS.SERVER ? BigDecimal.ZERO : this.getTotalFacturado());
        return error;
    }

    public BigDecimal getTotalFacturado() {
        return this.sumEntidadesmovimentos(TimeDateUtils.getCurrentYear(), FIELDS.entidadesmovimentos_totaliliquido, 0, 1).add(this.sumEntidadesmovimentos(TimeDateUtils.getCurrentYear(), FIELDS.entidadesmovimentos_totaliliquido, 0, 3)).subtract(this.sumEntidadesmovimentos(TimeDateUtils.getCurrentYear(), FIELDS.entidadesmovimentos_totaliliquido, 0, 4));
    }

    public boolean isPopulated(TABLES table) {
        return this.getTableManager(table).count() > 0L;
    }

    public boolean isPopulated() {
        return this.isPopulated(TABLES.parametros);
    }

    public boolean needsUpdate() throws Exception {
        if (this.utilizador.canRemove()) {
            throw new DatabaseException(LABELS.erro_utilizador_normal.toString());
        }
        if (this.getParametros().getMercado() != Colibri.MARKET_TYPE) {
            throw new Exception(LABELS.erro_database_mercadoinconsistente.toString());
        }
        if (Colibri.VERSION_NUMBER.smallerThan(this.getVersion())) {
            throw new Exception(LABELS.erro_database_versaoinconsistente.toString());
        }
        return UpdateManager.VERSIONS.parse(this.getVersion()).smallerThan(UpdateManager.VERSIONS.parse(Colibri.VERSION_NUMBER));
    }

    public VersionNumber getVersion() {
        return VersionNumber.valueOf((String)this.getParametros().getVersion());
    }

    public boolean updateVersion() {
        Parametros parametros = this.getParametros();
        parametros.setVersion(Colibri.VERSION_NUMBER);
        try {
            parametros.update();
            return this.loadParametros() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void refresh(TABLES table) {
        switch (table) {
            default: {
                break;
            }
            case empresa: {
                this.loadEmpresa();
                break;
            }
            case parametros: {
                this.loadParametros();
                break;
            }
            case parametrospos: {
                this.loadParametrospos();
            }
        }
    }

    public void refresh() {
        TABLES[] tABLESArray = new TABLES[]{TABLES.empresa, TABLES.parametros, TABLES.parametrospos};
        int n = tABLESArray.length;
        int n2 = 0;
        while (n2 < n) {
            TABLES table = tABLESArray[n2];
            this.refresh(table);
            ++n2;
        }
    }

    public <T extends IDatabaseModel> T attach(T model) {
        if (model != null) {
            model.attachTo(this);
        }
        return model;
    }

    public <T extends IDatabaseModel> Collection<T> attach(Collection<T> col) {
        for (IDatabaseModel model : col) {
            this.attach(model);
        }
        return col;
    }

    public <T extends IDatabaseModel> Collection<T> attach(T ... model) {
        return this.attach((Collection<T>)Arrays.asList(model));
    }

    public MessageList log(TABLES table, Utilizadores.COMMANDS command, String descricao, int tipo) {
        Utilizadoreslogs log = new Utilizadoreslogs(this.utilizador, table, command, descricao, tipo);
        return this.utilizador.log ? this.getTableManager().utilizadoreslogs.store(log, new MethodCallback[0]) : new MessageList();
    }

    private MessageList log(MessageList error, TABLES table, Utilizadores.COMMANDS command, Object key) {
        if (error.isEmpty()) {
            error.add(this.log(table, command, key == null ? null : key.toString(), 0));
        } else {
            error.add(this.log(table, command, ((MessageLine)error.get(0)).toString(), 1));
        }
        return error;
    }

    private MessageList store(TABLES table, IDatabaseModel model, MethodCallback ... preCommit) {
        Utilizadores.COMMANDS command = model.isEdited() ? Utilizadores.COMMANDS.EditarRegisto : Utilizadores.COMMANDS.GravarRegisto;
        return this.log(this.getTableManager(table).store(model, preCommit), model.getTable(), command, model.getKey());
    }

    private MessageList delete(TABLES table, Object key) {
        return this.log(this.getTableManager(table).delete(key), table, Utilizadores.COMMANDS.AnularRegisto, key);
    }

    private MessageList register(TABLES table, Object key) {
        return this.log(this.getTableManager(table).register(key), table, Utilizadores.COMMANDS.ComunicarRegisto, key);
    }

    public Empresa getEmpresa() {
        return this.empresa == null ? this.loadEmpresa() : this.empresa;
    }

    public Empresa loadEmpresa() {
        this.empresa = this.loadEmpresa(0);
        return this.empresa;
    }

    public MessageList storeEmpresa(Empresa empresa) {
        MessageList error = this.store(TABLES.empresa, empresa, new MethodCallback[0]);
        if (this.loadEmpresa() == null) {
            error.add((Object)new MessageLine((Object)LABELS.erro_database_registocarregar));
        }
        return error;
    }

    public MessageList deleteEmpresa() {
        return this.delete(TABLES.empresa, 0);
    }

    public boolean existsEmpresa() {
        return this.getTableManager().empresa.exists(0);
    }

    public Empresa loadEmpresa(Integer id) {
        return (Empresa)this.getTableManager().empresa.load(id);
    }

    public long countEmpresas() {
        return this.getTableManager().empresa.count();
    }

    public Parametros getParametros() {
        return this.parametros == null ? this.loadParametros() : this.parametros;
    }

    public Parametros loadParametros() {
        this.parametros = this.loadParametros(0);
        return this.parametros;
    }

    public MessageList storeParametros(Parametros parametros) {
        parametros.setEditor(this.utilizador);
        MessageList error = this.store(TABLES.parametros, parametros, new MethodCallback[0]);
        if (this.loadParametros() == null) {
            error.add((Object)new MessageLine((Object)LABELS.erro_database_registocarregar));
        }
        return error;
    }

    public MessageList deleteParametros() {
        return this.delete(TABLES.parametros, 0);
    }

    public boolean existsParametros() {
        return this.getTableManager().parametros.exists(0);
    }

    public Parametros loadParametros(Integer id) {
        return (Parametros)this.getTableManager().parametros.load(id);
    }

    public long countParametros() {
        return this.getTableManager().parametros.count();
    }

    public Parametrospos getParametrospos() {
        return this.parametrospos == null ? this.loadParametrospos() : this.parametrospos;
    }

    public Parametrospos loadParametrospos() {
        this.parametrospos = this.loadParametrospos(0);
        return this.parametrospos;
    }

    public MessageList storeParametrospos(Parametrospos parametrospos) {
        MessageList error = this.store(TABLES.parametrospos, parametrospos, new MethodCallback[0]);
        if (this.loadParametrospos() == null) {
            error.add((Object)new MessageLine((Object)LABELS.erro_database_registocarregar));
        }
        return error;
    }

    public MessageList deleteParametrospos() {
        return this.delete(TABLES.parametrospos, 0);
    }

    public boolean existsParametrospos() {
        return this.getTableManager().parametrospos.exists(0);
    }

    public Parametrospos loadParametrospos(Integer id) {
        return (Parametrospos)this.getTableManager().parametrospos.load(id);
    }

    public long countParametrospos() {
        return this.getTableManager().parametrospos.count();
    }

    public Campos loadCampos(int index) {
        return this.getTableManager().campos.load(index);
    }

    public MessageList storeCampos(Campos campo) {
        return this.store(TABLES.campos, campo, new MethodCallback[0]);
    }

    public MessageList deleteCampos(String codigo) {
        return this.delete(TABLES.campos, codigo);
    }

    public boolean existsCampos(String codigo) {
        return this.getTableManager().campos.exists(codigo);
    }

    public Campos loadCampos(String codigo) {
        return (Campos)this.getTableManager().campos.load(codigo);
    }

    public Collection<Campos> getCamposCollection() {
        return this.getTableManager().campos.getCollection();
    }

    public Collection<Campos> getCamposCollection(Integer tabela) {
        return this.getTableManager().campos.getCollection(tabela);
    }

    public Collection<Campos> getCamposCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().campos.getCollection(query));
    }

    public long countCampos() {
        return this.getTableManager().campos.count();
    }

    public MessageList storeLayouts(Layouts layout) {
        return this.store(TABLES.layouts, layout, new MethodCallback[0]);
    }

    public MessageList deleteLayouts(String codigo) {
        return this.delete(TABLES.layouts, codigo);
    }

    public boolean existsLayouts(String codigo) {
        return this.getTableManager().layouts.exists(codigo);
    }

    public Layouts loadLayouts(String codigo) {
        return (Layouts)this.getTableManager().layouts.load(codigo);
    }

    public Collection<Layouts> getLayoutsCollection() {
        return this.getTableManager().layouts.getCollection();
    }

    public Collection<Layouts> getLayoutsCollection(Integer tabela) {
        return this.getTableManager().layouts.getCollection(tabela);
    }

    public Collection<Layouts> getLayoutsCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().layouts.getCollection(query));
    }

    public long countLayouts() {
        return this.getTableManager().layouts.count();
    }

    public MessageList storeTemplates(Templates template) {
        MessageList error = this.store(TABLES.templates, template, new MethodCallback[0]);
        this.design.replace(template.getCodigo());
        return error;
    }

    public MessageList deleteTemplates(String codigo) {
        this.design.remove(codigo);
        return this.delete(TABLES.templates, codigo);
    }

    public boolean existsTemplates(String codigo) {
        return this.getTableManager().templates.exists(codigo);
    }

    public Templates loadTemplates(String codigo) {
        return this.loadTemplates(codigo, true);
    }

    public Templates loadTemplates(String codigo, boolean complete) {
        return (Templates)this.getTableManager().templates.load(codigo, complete);
    }

    public Collection<Templates> getTemplatesCollection() {
        return this.getTableManager().templates.getCollection();
    }

    public Collection<Templates> getTemplatesCollection(Integer tabela) {
        return this.getTableManager().templates.getCollection(tabela);
    }

    public Collection<Templates> getTemplatesCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().templates.getCollection(query));
    }

    public long countTemplates() {
        return this.getTableManager().templates.count();
    }

    public MessageList storePesquisas(Pesquisas pesquisa) {
        return this.store(TABLES.pesquisas, pesquisa, new MethodCallback[0]);
    }

    public MessageList deletePesquisas(String codigo) {
        return this.delete(TABLES.pesquisas, codigo);
    }

    public boolean existsPesquisas(String codigo) {
        return this.getTableManager().pesquisas.exists(codigo);
    }

    public Pesquisas loadPesquisas(String codigo) {
        return (Pesquisas)this.getTableManager().pesquisas.load(codigo);
    }

    public Collection<Pesquisas> getPesquisasCollection() {
        return this.getTableManager().pesquisas.getCollection();
    }

    public Collection<Pesquisas> getPesquisasCollection(Integer tabela) {
        return this.getTableManager().pesquisas.getCollection(tabela);
    }

    public Collection<Pesquisas> getPesquisasCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().pesquisas.getCollection(query));
    }

    public long countPesquisas() {
        return this.getTableManager().pesquisas.count();
    }

    public MessageList storeEntidadestipos(Entidadestipos tipoentidade) {
        return this.store(TABLES.entidadestipos, tipoentidade, new MethodCallback[0]);
    }

    public MessageList deleteEntidadestipos(String codigo) {
        return this.delete(TABLES.entidadestipos, codigo);
    }

    public MessageList deleteEntidadestipos(String user, String codigo) {
        MessageList error = this.deleteUtilizadoresicones$User(user, codigo);
        if (error.isEmpty()) {
            error.add(this.deleteEntidadestipos(codigo));
        }
        return error;
    }

    public boolean existsEntidadestipos(String codigo) {
        return this.getTableManager().entidadestipos.exists(codigo);
    }

    public Entidadestipos loadEntidadestipos() {
        return this.loadEntidadestipos(TABLES.entidadestipos.defaultKey());
    }

    public Entidadestipos loadEntidadestipos(String codigo) {
        return (Entidadestipos)this.getTableManager().entidadestipos.load(codigo);
    }

    public Collection<Entidadestipos> getEntidadestiposCollection() {
        return this.getTableManager().entidadestipos.getCollection();
    }

    public Collection<Entidadestipos> getEntidadestiposCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().entidadestipos.getCollection(query));
    }

    public long countEntidadestipos() {
        return this.getTableManager().entidadestipos.count();
    }

    public MessageList storeDocumentostipos(Documentostipos tipodocumento, MethodCallback ... preCommit) {
        return this.store(TABLES.documentostipos, tipodocumento, preCommit);
    }

    public MessageList deleteDocumentostipos(String codigo) {
        return this.delete(TABLES.documentostipos, codigo);
    }

    public boolean existsDocumentostipos(String codigo) {
        return this.getTableManager().documentostipos.exists(codigo);
    }

    public Documentostipos loadDocumentostipos(String codigo) {
        return (Documentostipos)this.getTableManager().documentostipos.load(codigo);
    }

    public Collection<Documentostipos> getDocumentostiposCollection() {
        return this.getTableManager().documentostipos.getCollection();
    }

    public Collection<Documentostipos> getDocumentostiposCollection(Integer tabela) {
        return this.getTableManager().documentostipos.getCollection(tabela);
    }

    public Collection<Documentostipos> getDocumentostiposCollection(String tipoentidade) {
        return this.getTableManager().documentostipos.getCollection(tipoentidade);
    }

    public Collection<Documentostipos> getDocumentostiposCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().documentostipos.getCollection(query));
    }

    public long countDocumentostipos() {
        return this.getTableManager().documentostipos.count();
    }

    public Documentosseries loadDocumentosseries(String tipodocumento, int index) {
        return this.getTableManager().documentosseries.load(tipodocumento, index);
    }

    public MessageList registerDocumentosseries(String key) {
        return this.register(TABLES.documentosseries, key);
    }

    @Deprecated
    private MessageList storeDocumentosseries(Documentosseries seriedocumento) {
        return this.store(TABLES.documentosseries, seriedocumento, new MethodCallback[0]);
    }

    @Deprecated
    private MessageList deleteDocumentosseries(String key) {
        return this.delete(TABLES.documentosseries, key);
    }

    public Integer getDocumentosseries$NextNumero(String tipodocumento, String serie) {
        return this.getTableManager().documentosseries.getNextNumero(tipodocumento, serie);
    }

    public boolean existsDocumentosseries(String key) {
        return this.getTableManager().documentosseries.exists(key);
    }

    public Documentosseries loadDocumentosseries(String key) {
        return (Documentosseries)this.getTableManager().documentosseries.load(key);
    }

    public Collection<Documentosseries> getDocumentosseriesCollection() {
        return this.getTableManager().documentosseries.getCollection();
    }

    public Collection<Documentosseries> getDocumentosseriesCollection(String tipodocumento) {
        return this.getTableManager().documentosseries.getCollection(tipodocumento);
    }

    public Collection<Documentosseries> getDocumentosseriesCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().documentosseries.getCollection(query));
    }

    public long countDocumentosseries(String tipodocumento) {
        return this.getTableManager().documentosseries.count(tipodocumento);
    }

    public boolean isAuthenticated() {
        return this.utilizador != null;
    }

    public Utilizadores getUtilizador() {
        return this.utilizador;
    }

    public MessageList storeUtilizadores(Utilizadores utilizador) {
        return this.store(TABLES.utilizadores, utilizador, new MethodCallback[0]);
    }

    public MessageList deleteUtilizadores(String user) {
        MessageList error = this.deleteUtilizadoresicones$User(user);
        if (error.isEmpty()) {
            error.add(this.deleteUtilizadoresfiltros$User(user));
        }
        if (error.isEmpty()) {
            error.add(this.getTableManager().utilizadores.delete(user));
        }
        return error;
    }

    public boolean existsUtilizadores(String user) {
        return this.getTableManager().utilizadores.exists(user);
    }

    public Utilizadores loadUtilizadores(String user) {
        return (Utilizadores)this.getTableManager().utilizadores.load(user);
    }

    public Utilizadores loadUtilizadores$Email(String user) {
        return this.getTableManager().utilizadores.load$Email(user);
    }

    public Collection<Utilizadores> getUtilizadoresCollection() {
        return this.getTableManager().utilizadores.getCollection();
    }

    public Collection<Utilizadores> getUtilizadoresCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().utilizadores.getCollection(query));
    }

    public long countUtilizadores() {
        return this.getTableManager().utilizadores.count();
    }

    public MessageList storeUtilizadoreslogs(Utilizadoreslogs log) {
        return this.store(TABLES.utilizadoreslogs, log, new MethodCallback[0]);
    }

    public MessageList deleteUtilizadoreslogs(String user, Timestamp data) {
        String key = Utilizadoreslogs.generateKey(user, data);
        return this.delete(TABLES.utilizadoreslogs, key);
    }

    public boolean existsUtilizadoreslogs(String user, Timestamp data) {
        String key = Utilizadoreslogs.generateKey(user, data);
        return this.getTableManager().utilizadoreslogs.exists(key);
    }

    public Utilizadoreslogs loadUtilizadoreslogs(String user, Timestamp data) {
        String key = Utilizadoreslogs.generateKey(user, data);
        return (Utilizadoreslogs)this.getTableManager().utilizadoreslogs.load(key);
    }

    public Collection<Utilizadoreslogs> getUtilizadoreslogsCollection() {
        return this.getTableManager().utilizadoreslogs.getCollection();
    }

    public Collection<Utilizadoreslogs> getUtilizadoreslogsCollection(String user) {
        return this.getTableManager().utilizadoreslogs.getCollection(user);
    }

    public Collection<Utilizadoreslogs> getUtilizadoreslogsCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().utilizadoreslogs.getCollection(query));
    }

    public long countUtilizadoreslogs(String user) {
        return this.getTableManager().utilizadoreslogs.count(user);
    }

    public Utilizadoresicones getUtilizadoresicones(TreeGroupModel.GROUPS group, TreeBranchModel.BRANCHES branch) {
        return this.getUtilizadoresicones(group, branch, null, null);
    }

    public Utilizadoresicones getUtilizadoresicones(TreeGroupModel.GROUPS group, TreeBranchModel.BRANCHES branch, Entidadestipos tipoentidade) {
        return this.getUtilizadoresicones(group, branch, tipoentidade, null);
    }

    public Utilizadoresicones getUtilizadoresicones(TreeGroupModel.GROUPS group, TreeBranchModel.BRANCHES branch, Documentostipos tipodocumento) {
        return this.getUtilizadoresicones(group, branch, tipodocumento.getTipoentidade(), tipodocumento);
    }

    public Utilizadoresicones getUtilizadoresicones(TreeGroupModel.GROUPS group, TreeBranchModel.BRANCHES branch, Entidadestipos tipoentidade, Documentostipos tipodocumento) {
        return this.getUtilizadoresicones(this.utilizador, group, branch, tipoentidade, tipodocumento);
    }

    public Utilizadoresicones getUtilizadoresicones(Utilizadores utilizador, TreeGroupModel.GROUPS group, TreeBranchModel.BRANCHES branch, Entidadestipos tipoentidade, Documentostipos tipodocumento) {
        Utilizadoresicones icone = this.loadUtilizadoresicones(Utilizadoresicones.generateKey(utilizador, group, branch, tipoentidade, tipodocumento));
        return icone == null ? new Utilizadoresicones(utilizador, group, branch, tipoentidade, tipodocumento) : icone;
    }

    public MessageList storeUtilizadoresicones(Utilizadoresicones icone) {
        return this.store(TABLES.utilizadoresicones, icone, new MethodCallback[0]);
    }

    public MessageList deleteUtilizadoresicones(String key) {
        return this.delete(TABLES.utilizadoresicones, key);
    }

    public MessageList deleteUtilizadoresicones$User(String user) {
        return this.getTableManager().utilizadoresicones.delete$User(user);
    }

    public MessageList deleteUtilizadoresicones$User(String user, String tipoentidade) {
        return this.getTableManager().utilizadoresicones.delete$User(user, tipoentidade);
    }

    public boolean existsUtilizadoresicones(String key) {
        return this.getTableManager().utilizadoresicones.exists(key);
    }

    public Utilizadoresicones loadUtilizadoresicones(String key) {
        return this.loadUtilizadoresicones(key, true);
    }

    public Utilizadoresicones loadUtilizadoresicones(String key, boolean complete) {
        return (Utilizadoresicones)this.getTableManager().utilizadoresicones.load(key, complete);
    }

    public Collection<Utilizadoresicones> getUtilizadoresiconesCollection(boolean complete) {
        return this.getTableManager().utilizadoresicones.getCollection(complete);
    }

    public Collection<Utilizadoresicones> getUtilizadoresiconesCollection(String user, boolean complete) {
        return this.getTableManager().utilizadoresicones.getCollection(user, complete);
    }

    public long countUtilizadoresicones(String user) {
        return this.getTableManager().utilizadoresicones.count(user);
    }

    public MessageList storeUtilizadoresfiltros(Pesquisas pesquisa) {
        Utilizadoresfiltros filtro = this.loadUtilizadoresfiltros(this.utilizador.getUser(), pesquisa.getCodigo());
        if (filtro == null) {
            filtro = new Utilizadoresfiltros(this.utilizador, pesquisa);
        }
        filtro.setFiltro(pesquisa.getFiltro());
        return this.storeUtilizadoresfiltros(filtro);
    }

    public MessageList storeUtilizadoresfiltros(Utilizadoresfiltros filtro) {
        return this.store(TABLES.utilizadoresfiltros, filtro, new MethodCallback[0]);
    }

    public MessageList deleteUtilizadoresfiltros(String key) {
        return this.delete(TABLES.utilizadoresfiltros, key);
    }

    public MessageList deleteUtilizadoresfiltros$User(String user) {
        return this.getTableManager().utilizadoresfiltros.delete$User(user);
    }

    public boolean existsUtilizadoresfiltros(String key) {
        return this.getTableManager().utilizadoresfiltros.exists(key);
    }

    public Utilizadoresfiltros loadUtilizadoresfiltros(String key) {
        return (Utilizadoresfiltros)this.getTableManager().utilizadoresfiltros.load(key);
    }

    public Utilizadoresfiltros loadUtilizadoresfiltros(String user, String codigo) {
        return this.loadUtilizadoresfiltros(Utilizadoresfiltros.generateKey(user, codigo));
    }

    public Collection<Utilizadoresfiltros> getUtilizadoresfiltrosCollection() {
        return this.getTableManager().utilizadoresfiltros.getCollection();
    }

    public Collection<Utilizadoresfiltros> getUtilizadoresfiltrosCollection(String user) {
        return this.getTableManager().utilizadoresfiltros.getCollection(user);
    }

    public Collection<Utilizadoresfiltros> getUtilizadoresfiltrosCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().utilizadoresfiltros.getCollection(query));
    }

    public long countUtilizadoresfiltros(String user) {
        return this.getTableManager().utilizadoresfiltros.count(user);
    }

    public MessageList storeCodigosiva(Codigosiva codigoiva) {
        return this.store(TABLES.codigosiva, codigoiva, new MethodCallback[0]);
    }

    public MessageList deleteCodigosiva(String codigo) {
        return this.delete(TABLES.codigosiva, codigo);
    }

    public boolean existsCodigosiva(String codigo) {
        return this.getTableManager().codigosiva.exists(codigo);
    }

    public Codigosiva loadCodigosiva(String codigo) {
        return (Codigosiva)this.getTableManager().codigosiva.load(codigo);
    }

    public Collection<Codigosiva> getCodigosivaCollection() {
        return this.getTableManager().codigosiva.getCollection();
    }

    public Collection<Codigosiva> getCodigosivaCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().codigosiva.getCollection(query));
    }

    public long countCodigosiva() {
        return this.getTableManager().codigosiva.count();
    }

    public MessageList storeIsencoesiva(Isencoesiva isencaoiva) {
        return this.store(TABLES.isencoesiva, isencaoiva, new MethodCallback[0]);
    }

    public MessageList deleteIsencoesiva(String codigo) {
        return this.delete(TABLES.isencoesiva, codigo);
    }

    public boolean existsIsencoesiva(String codigo) {
        return this.getTableManager().isencoesiva.exists(codigo);
    }

    public Isencoesiva loadIsencoesiva() {
        return this.loadIsencoesiva(TABLES.isencoesiva.defaultKey());
    }

    public Isencoesiva loadIsencoesiva(String codigo) {
        return (Isencoesiva)this.getTableManager().isencoesiva.load(codigo);
    }

    public Collection<Isencoesiva> getIsencoesivaCollection() {
        return this.getTableManager().isencoesiva.getCollection();
    }

    public Collection<Isencoesiva> getIsencoesivaCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().isencoesiva.getCollection(query));
    }

    public long countIsencoesiva() {
        return this.getTableManager().isencoesiva.count();
    }

    public MessageList storeRetencoes(Retencoes retencao) {
        return this.store(TABLES.retencoes, retencao, new MethodCallback[0]);
    }

    public MessageList deleteRetencoes(String codigo) {
        return this.delete(TABLES.retencoes, codigo);
    }

    public boolean existsRetencoes(String codigo) {
        return this.getTableManager().retencoes.exists(codigo);
    }

    public Retencoes loadRetencoes() {
        return this.loadRetencoes(TABLES.retencoes.defaultKey());
    }

    public Retencoes loadRetencoes(String codigo) {
        return (Retencoes)this.getTableManager().retencoes.load(codigo);
    }

    public Collection<Retencoes> getRetencoesCollection() {
        return this.getTableManager().retencoes.getCollection();
    }

    public Collection<Retencoes> getRetencoesCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().retencoes.getCollection(query));
    }

    public long countRetencoes() {
        return this.getTableManager().retencoes.count();
    }

    public MessageList storeUnidadesmedida(Unidadesmedida unidademedida) {
        return this.store(TABLES.unidadesmedida, unidademedida, new MethodCallback[0]);
    }

    public MessageList deleteUnidadesmedida(String codigo) {
        return this.delete(TABLES.unidadesmedida, codigo);
    }

    public boolean existsUnidadesmedida(String codigo) {
        return this.getTableManager().unidadesmedida.exists(codigo);
    }

    public Unidadesmedida loadUnidadesmedida() {
        return this.loadUnidadesmedida(TABLES.unidadesmedida.defaultKey());
    }

    public Unidadesmedida loadUnidadesmedida(String codigo) {
        return (Unidadesmedida)this.getTableManager().unidadesmedida.load(codigo);
    }

    public Collection<Unidadesmedida> getUnidadesmedidaCollection() {
        return this.getTableManager().unidadesmedida.getCollection();
    }

    public Collection<Unidadesmedida> getUnidadesmedidaCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().unidadesmedida.getCollection(query));
    }

    public long countUnidadesmedida() {
        return this.getTableManager().unidadesmedida.count();
    }

    public Grupos loadGrupos(Integer tabela, int index) {
        return this.getTableManager().grupos.load(tabela, index);
    }

    public MessageList storeGrupos(Grupos grupo) {
        return this.store(TABLES.grupos, grupo, new MethodCallback[0]);
    }

    public MessageList deleteGrupos(String codigo) {
        return this.delete(TABLES.grupos, codigo);
    }

    public boolean existsGrupos(String codigo) {
        return this.getTableManager().grupos.exists(codigo);
    }

    public Grupos loadGrupos(String codigo) {
        return (Grupos)this.getTableManager().grupos.load(codigo);
    }

    public Collection<Grupos> getGruposCollection() {
        return this.getTableManager().grupos.getCollection();
    }

    public Collection<Grupos> getGruposCollection(Integer tabela) {
        return this.getTableManager().grupos.getCollection(tabela);
    }

    public Collection<Grupos> getGruposCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().grupos.getCollection(query));
    }

    public long countGrupos(Integer tabela) {
        return this.getTableManager().grupos.count(tabela);
    }

    public Familias loadFamilias(Integer tabela, int index) {
        return this.getTableManager().familias.load(tabela, index);
    }

    public MessageList storeFamilias(Familias familia) {
        return this.store(TABLES.familias, familia, new MethodCallback[0]);
    }

    public MessageList deleteFamilias(String codigo) {
        return this.delete(TABLES.familias, codigo);
    }

    public boolean existsFamilias(String codigo) {
        return this.getTableManager().familias.exists(codigo);
    }

    public Familias loadFamilias(String codigo) {
        return (Familias)this.getTableManager().familias.load(codigo);
    }

    public Collection<Familias> getFamiliasCollection() {
        return this.getTableManager().familias.getCollection();
    }

    public Collection<Familias> getFamiliasCollection(Integer tabela) {
        return this.getTableManager().familias.getCollection(tabela);
    }

    public Collection<Familias> getFamiliasCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().familias.getCollection(query));
    }

    public long countFamilias(Integer tabela) {
        return this.getTableManager().familias.count(tabela);
    }

    public MessageList storePrecarios(Precarios precario) {
        return this.store(TABLES.precarios, precario, new MethodCallback[0]);
    }

    public MessageList deletePrecarios(String codigo) {
        return this.delete(TABLES.precarios, codigo);
    }

    public boolean existsPrecarios(String codigo) {
        return this.getTableManager().precarios.exists(codigo);
    }

    public Precarios loadPrecarios() {
        return this.loadPrecarios(TABLES.precarios.defaultKey());
    }

    public Precarios loadPrecarios(String codigo) {
        return (Precarios)this.getTableManager().precarios.load(codigo);
    }

    public Collection<Precarios> getPrecariosCollection() {
        return this.getTableManager().precarios.getCollection();
    }

    public Collection<Precarios> getPrecariosCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().precarios.getCollection(query));
    }

    public long countPrecarios() {
        return this.getTableManager().precarios.count();
    }

    public MessageList storeTamanhos(Tamanhos tamanho) {
        return this.store(TABLES.tamanhos, tamanho, new MethodCallback[0]);
    }

    public MessageList deleteTamanhos(String codigo) {
        return this.delete(TABLES.tamanhos, codigo);
    }

    public boolean existsTamanhos(String codigo) {
        return this.getTableManager().tamanhos.exists(codigo);
    }

    public Tamanhos loadTamanhos() {
        return this.loadTamanhos(TABLES.tamanhos.defaultKey());
    }

    public Tamanhos loadTamanhos(String codigo) {
        return (Tamanhos)this.getTableManager().tamanhos.load(codigo);
    }

    public Collection<Tamanhos> getTamanhosCollection() {
        return this.getTableManager().tamanhos.getCollection();
    }

    public Collection<Tamanhos> getTamanhosCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().tamanhos.getCollection(query));
    }

    public long countTamanhos() {
        return this.getTableManager().tamanhos.count();
    }

    public MessageList storeCores(Cores cor) {
        return this.store(TABLES.cores, cor, new MethodCallback[0]);
    }

    public MessageList deleteCores(String codigo) {
        return this.delete(TABLES.cores, codigo);
    }

    public boolean existsCores(String codigo) {
        return this.getTableManager().cores.exists(codigo);
    }

    public Cores loadCores() {
        return this.loadCores(TABLES.cores.defaultKey());
    }

    public Cores loadCores(String codigo) {
        return (Cores)this.getTableManager().cores.load(codigo);
    }

    public Collection<Cores> getCoresCollection() {
        return this.getTableManager().cores.getCollection();
    }

    public Collection<Cores> getCoresCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().cores.getCollection(query));
    }

    public long countCores() {
        return this.getTableManager().cores.count();
    }

    public MessageList storeCondicoespagamento(Condicoespagamento condicaopagamento) {
        return this.store(TABLES.condicoespagamento, condicaopagamento, new MethodCallback[0]);
    }

    public MessageList deleteCondicoespagamento(String codigo) {
        return this.delete(TABLES.condicoespagamento, codigo);
    }

    public boolean existsCondicoespagamento(String codigo) {
        return this.getTableManager().condicoespagamento.exists(codigo);
    }

    public Condicoespagamento loadCondicoespagamento() {
        return this.loadCondicoespagamento(TABLES.condicoespagamento.defaultKey());
    }

    public Condicoespagamento loadCondicoespagamento(String codigo) {
        return (Condicoespagamento)this.getTableManager().condicoespagamento.load(codigo);
    }

    public Collection<Condicoespagamento> getCondicoespagamentoCollection() {
        return this.getTableManager().condicoespagamento.getCollection();
    }

    public Collection<Condicoespagamento> getCondicoespagamentoCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().condicoespagamento.getCollection(query));
    }

    public long countCondicoespagamento() {
        return this.getTableManager().condicoespagamento.count();
    }

    public MessageList storeMetodospagamento(Metodospagamento metodopagamento) {
        return this.store(TABLES.metodospagamento, metodopagamento, new MethodCallback[0]);
    }

    public MessageList deleteMetodospagamento(String codigo) {
        return this.delete(TABLES.metodospagamento, codigo);
    }

    public boolean existsMetodospagamento(String codigo) {
        return this.getTableManager().metodospagamento.exists(codigo);
    }

    public Metodospagamento loadMetodospagamento() {
        return this.loadMetodospagamento(TABLES.metodospagamento.defaultKey());
    }

    public Metodospagamento loadMetodospagamento(String codigo) {
        return (Metodospagamento)this.getTableManager().metodospagamento.load(codigo);
    }

    public Collection<Metodospagamento> getMetodospagamentoCollection() {
        return this.getTableManager().metodospagamento.getCollection();
    }

    public Collection<Metodospagamento> getMetodospagamentoCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().metodospagamento.getCollection(query));
    }

    public long countMetodospagamento() {
        return this.getTableManager().metodospagamento.count();
    }

    public Condicoesentrega loadCondicoesentrega(int index) {
        return this.getTableManager().condicoesentrega.load(index);
    }

    public MessageList storeCondicoesentrega(Condicoesentrega condicaoentrega) {
        return this.store(TABLES.condicoesentrega, condicaoentrega, new MethodCallback[0]);
    }

    public MessageList deleteCondicoesentrega(String codigo) {
        return this.delete(TABLES.condicoesentrega, codigo);
    }

    public boolean existsCondicoesentrega(String codigo) {
        return this.getTableManager().condicoesentrega.exists(codigo);
    }

    public Condicoesentrega loadCondicoesentrega(String codigo) {
        return (Condicoesentrega)this.getTableManager().condicoesentrega.load(codigo);
    }

    public Collection<Condicoesentrega> getCondicoesentregaCollection() {
        return this.getTableManager().condicoesentrega.getCollection();
    }

    public Collection<Condicoesentrega> getCondicoesentregaCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().condicoesentrega.getCollection(query));
    }

    public long countCondicoesentrega() {
        return this.getTableManager().condicoesentrega.count();
    }

    public Metodostransporte loadMetodostransporte(int index) {
        return this.getTableManager().metodostransporte.load(index);
    }

    public MessageList storeMetodostransporte(Metodostransporte metodotransporte) {
        return this.store(TABLES.metodostransporte, metodotransporte, new MethodCallback[0]);
    }

    public MessageList deleteMetodostransporte(String codigo) {
        return this.delete(TABLES.metodostransporte, codigo);
    }

    public boolean existsMetodostransporte(String codigo) {
        return this.getTableManager().metodostransporte.exists(codigo);
    }

    public Metodostransporte loadMetodostransporte(String codigo) {
        return (Metodostransporte)this.getTableManager().metodostransporte.load(codigo);
    }

    public Collection<Metodostransporte> getMetodostransporteCollection() {
        return this.getTableManager().metodostransporte.getCollection();
    }

    public Collection<Metodostransporte> getMetodostransporteCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().metodostransporte.getCollection(query));
    }

    public long countMetodostransporte() {
        return this.getTableManager().metodostransporte.count();
    }

    public MessageList storeTiposmorada(Tiposmorada tipomorada) {
        return this.store(TABLES.tiposmorada, tipomorada, new MethodCallback[0]);
    }

    public MessageList deleteTiposmorada(String codigo) {
        return this.delete(TABLES.tiposmorada, codigo);
    }

    public boolean existsTiposmorada(String codigo) {
        return this.getTableManager().tiposmorada.exists(codigo);
    }

    public Tiposmorada loadTiposmorada() {
        return this.loadTiposmorada(TABLES.tiposmorada.defaultKey());
    }

    public Tiposmorada loadTiposmorada(String codigo) {
        return (Tiposmorada)this.getTableManager().tiposmorada.load(codigo);
    }

    public Collection<Tiposmorada> getTiposmoradaCollection() {
        return this.getTableManager().tiposmorada.getCollection();
    }

    public Collection<Tiposmorada> getTiposmoradaCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().tiposmorada.getCollection(query));
    }

    public long countTiposmorada() {
        return this.getTableManager().tiposmorada.count();
    }

    public MessageList storeCodigospostais(Codigospostais codigopostal) {
        return this.store(TABLES.codigospostais, codigopostal, new MethodCallback[0]);
    }

    public MessageList deleteCodigospostais(String codigo) {
        return this.delete(TABLES.codigospostais, codigo);
    }

    public boolean existsCodigospostais(String codigo) {
        return this.getTableManager().codigospostais.exists(codigo);
    }

    public Codigospostais loadCodigospostais() {
        return this.isPopulated() ? this.getEmpresa().getCodigopostal() : this.loadCodigospostais(this.licenca.xml.getTitular().getCodigopostal());
    }

    public Codigospostais loadCodigospostais(String codigo) {
        return (Codigospostais)this.getTableManager().codigospostais.load(codigo);
    }

    public Collection<Codigospostais> getCodigospostaisCollection() {
        return this.getTableManager().codigospostais.getCollection();
    }

    public Collection<Codigospostais> getCodigospostaisCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().codigospostais.getCollection(query));
    }

    public long countCodigospostais() {
        return this.getTableManager().codigospostais.count();
    }

    public MessageList storePaises(Paises pais) {
        return this.store(TABLES.paises, pais, new MethodCallback[0]);
    }

    public MessageList deletePaises(String codigo) {
        return this.delete(TABLES.paises, codigo);
    }

    public boolean existsPaises(String codigo) {
        return this.getTableManager().paises.exists(codigo);
    }

    @Deprecated
    private Paises loadPaises() {
        return this.loadPaises(CheckVatHandler.COUNTRIES.PT.code);
    }

    public Paises loadPaises(String codigo) {
        return (Paises)this.getTableManager().paises.load(codigo);
    }

    public Collection<Paises> getPaisesCollection() {
        return this.getTableManager().paises.getCollection();
    }

    public Collection<Paises> getPaisesCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().paises.getCollection(query));
    }

    public long countPaises() {
        return this.getTableManager().paises.count();
    }

    public MessageList storeArmazens(Armazens armazem) {
        return this.store(TABLES.armazens, armazem, new MethodCallback[0]);
    }

    public MessageList deleteArmazens(String codigo) {
        return this.delete(TABLES.armazens, codigo);
    }

    public boolean existsArmazens(String codigo) {
        return this.getTableManager().armazens.exists(codigo);
    }

    public Armazens loadArmazens() {
        return this.loadArmazens(TABLES.armazens.defaultKey());
    }

    public Armazens loadArmazens(String codigo) {
        return (Armazens)this.getTableManager().armazens.load(codigo);
    }

    public Collection<Armazens> getArmazensCollection() {
        return this.getTableManager().armazens.getCollection();
    }

    public Collection<Armazens> getArmazensCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().armazens.getCollection(query));
    }

    public long countArmazens() {
        return this.getTableManager().armazens.count();
    }

    public Vendedores loadVendedores(int index) {
        return this.getTableManager().vendedores.load(index);
    }

    public MessageList storeVendedores(Vendedores vendedor) {
        return this.store(TABLES.vendedores, vendedor, new MethodCallback[0]);
    }

    public MessageList deleteVendedores(String codigo) {
        return this.delete(TABLES.vendedores, codigo);
    }

    public boolean existsVendedores(String codigo) {
        return this.getTableManager().vendedores.exists(codigo);
    }

    public Vendedores loadVendedores(String codigo) {
        return (Vendedores)this.getTableManager().vendedores.load(codigo);
    }

    public Collection<Vendedores> getVendedoresCollection() {
        return this.getTableManager().vendedores.getCollection();
    }

    public Collection<Vendedores> getVendedoresCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().vendedores.getCollection(query));
    }

    public long countVendedores() {
        return this.getTableManager().vendedores.count();
    }

    public Viaturas loadViaturas(int index) {
        return this.getTableManager().viaturas.load(index);
    }

    public MessageList storeViaturas(Viaturas viatura) {
        return this.store(TABLES.viaturas, viatura, new MethodCallback[0]);
    }

    public MessageList deleteViaturas(String codigo) {
        return this.delete(TABLES.viaturas, codigo);
    }

    public boolean existsViaturas(String codigo) {
        return this.getTableManager().viaturas.exists(codigo);
    }

    public Viaturas loadViaturas(String codigo) {
        return (Viaturas)this.getTableManager().viaturas.load(codigo);
    }

    public Collection<Viaturas> getViaturasCollection() {
        return this.getTableManager().viaturas.getCollection();
    }

    public Collection<Viaturas> getViaturasCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().viaturas.getCollection(query));
    }

    public long countViaturas() {
        return this.getTableManager().viaturas.count();
    }

    public MessageList storeContasbancarias(Contasbancarias contabancaria) {
        return this.store(TABLES.contasbancarias, contabancaria, new MethodCallback[0]);
    }

    public MessageList deleteContasbancarias(String codigo) {
        return this.delete(TABLES.contasbancarias, codigo);
    }

    public boolean existsContasbancarias(String codigo) {
        return this.getTableManager().contasbancarias.exists(codigo);
    }

    public Contasbancarias loadContasbancarias() {
        return this.loadContasbancarias(TABLES.contasbancarias.defaultKey());
    }

    public Contasbancarias loadContasbancarias(String codigo) {
        return (Contasbancarias)this.getTableManager().contasbancarias.load(codigo);
    }

    public Collection<Contasbancarias> getContasbancariasCollection() {
        return this.getTableManager().contasbancarias.getCollection();
    }

    public Collection<Contasbancarias> getContasbancariasCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().contasbancarias.getCollection(query));
    }

    public long countContasbancarias() {
        return this.getTableManager().contasbancarias.count();
    }

    public MessageList storeTiposmovimento(Tiposmovimento tipomovimento) {
        return this.store(TABLES.tiposmovimento, tipomovimento, new MethodCallback[0]);
    }

    public MessageList deleteTiposmovimento(String codigo) {
        return this.delete(TABLES.tiposmovimento, codigo);
    }

    public boolean existsTiposmovimento(String codigo) {
        return this.getTableManager().tiposmovimento.exists(codigo);
    }

    public Tiposmovimento loadTiposmovimento(String codigo) {
        return (Tiposmovimento)this.getTableManager().tiposmovimento.load(codigo);
    }

    public Collection<Tiposmovimento> getTiposmovimentoCollection() {
        return this.getTableManager().tiposmovimento.getCollection();
    }

    public Collection<Tiposmovimento> getTiposmovimentoCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().tiposmovimento.getCollection(query));
    }

    public long countTiposmovimento() {
        return this.getTableManager().tiposmovimento.count();
    }

    public MessageList storeMoedas(Moedas moeda) {
        return this.store(TABLES.moedas, moeda, new MethodCallback[0]);
    }

    public MessageList deleteMoedas(String codigo) {
        return this.delete(TABLES.moedas, codigo);
    }

    public boolean existsMoedas(String codigo) {
        return this.getTableManager().moedas.exists(codigo);
    }

    public Moedas loadMoedas() {
        return this.loadMoedas(TABLES.moedas.defaultKey());
    }

    public Moedas loadMoedas(String codigo) {
        return (Moedas)this.getTableManager().moedas.load(codigo);
    }

    public Collection<Moedas> getMoedasCollection() {
        return this.getTableManager().moedas.getCollection();
    }

    public Collection<Moedas> getMoedasCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().moedas.getCollection(query));
    }

    public long countMoedas() {
        return this.getTableManager().moedas.count();
    }

    public Moedascambios loadMoedascambios(String moeda, int index) {
        return this.getTableManager().moedascambios.load(moeda, index);
    }

    @Deprecated
    private MessageList storeMoedascambios(Moedascambios cambio) {
        return this.store(TABLES.moedascambios, cambio, new MethodCallback[0]);
    }

    @Deprecated
    private MessageList deleteMoedascambios(String key) {
        return this.delete(TABLES.moedascambios, key);
    }

    public boolean existsMoedascambios(String key) {
        return this.getTableManager().moedascambios.exists(key);
    }

    public Moedascambios loadMoedascambios(String key) {
        return (Moedascambios)this.getTableManager().moedascambios.load(key);
    }

    public Collection<Moedascambios> getMoedascambiosCollection(String moeda) {
        return this.getTableManager().moedascambios.getCollection(moeda);
    }

    public Collection<Moedascambios> getMoedascambiosCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().moedascambios.getCollection(query));
    }

    public long countMoedascambios(String moeda) {
        return this.getTableManager().moedascambios.count(moeda);
    }

    public MessageList storeArtigos(Artigos artigo, MethodCallback ... preCommit) {
        artigo.setEditor(this.utilizador);
        if (!artigo.isEdited()) {
            artigo.setAutor(this.utilizador);
        }
        return this.store(TABLES.artigos, artigo, preCommit);
    }

    public MessageList deleteArtigos(String codigo) {
        return this.delete(TABLES.artigos, codigo);
    }

    public boolean existsArtigos(String codigo) {
        return this.getTableManager().artigos.exists(codigo);
    }

    @Deprecated
    private boolean existsArtigos$Previous(String codigo) {
        return this.getArtigos$PreviousCodigo(codigo) != null;
    }

    @Deprecated
    private boolean existsArtigos$Next(String codigo) {
        return this.getArtigos$NextCodigo(codigo) != null;
    }

    public Artigos loadArtigos$Previous(String codigo) {
        return this.loadArtigos(this.getArtigos$PreviousCodigo(codigo));
    }

    public Artigos loadArtigos$Next(String codigo) {
        return this.loadArtigos(this.getArtigos$NextCodigo(codigo));
    }

    @Deprecated
    public Artigos loadArtigos$Codigobarras(String codigo) {
        Artigosunidades unidade = this.loadArtigosunidades$Codigobarras(codigo);
        return unidade == null ? null : this.loadArtigos(unidade.getArtigo().getCodigo());
    }

    public Artigos loadArtigos(String codigo) {
        return this.loadArtigos(codigo, true);
    }

    public Artigos loadArtigos(String codigo, boolean complete) {
        return (Artigos)this.getTableManager().artigos.load(codigo, complete);
    }

    public String getArtigos$PreviousCodigo(String codigo) {
        return this.getTableManager().artigos.getPreviousCodigo(codigo);
    }

    public String getArtigos$NextCodigo(String codigo) {
        return this.getTableManager().artigos.getNextCodigo(codigo);
    }

    public Collection<Artigos> getArtigosCollection() {
        return this.getTableManager().artigos.getCollection();
    }

    public Collection<Artigos> getArtigosCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().artigos.getCollection(query));
    }

    public long countArtigos() {
        return this.getTableManager().artigos.count();
    }

    @Deprecated
    public Artigosunidades loadArtigosunidades$Codigobarras(String codigo) {
        return this.getTableManager().artigosunidades.load$Codigobarras(codigo);
    }

    @Deprecated
    private MessageList storeArtigosunidades(Artigosunidades unidade) {
        return this.store(TABLES.artigosunidades, unidade, new MethodCallback[0]);
    }

    @Deprecated
    private MessageList deleteArtigosunidades(String key) {
        return this.delete(TABLES.artigosunidades, key);
    }

    public boolean existsArtigosunidades(String key) {
        return this.getTableManager().artigosunidades.exists(key);
    }

    public Artigosunidades loadArtigosunidades(String key) {
        return (Artigosunidades)this.getTableManager().artigosunidades.load(key);
    }

    public Collection<Artigosunidades> getArtigosunidadesCollection() {
        return this.getTableManager().artigosunidades.getCollection();
    }

    public Collection<Artigosunidades> getArtigosunidadesCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().artigosunidades.getCollection(query));
    }

    public long countArtigosunidades(String artigo) {
        return this.getTableManager().artigosunidades.count(artigo);
    }

    @Deprecated
    private MessageList storeArtigosprecos(Artigosprecos preco) {
        return this.store(TABLES.artigosprecos, preco, new MethodCallback[0]);
    }

    @Deprecated
    private MessageList deleteArtigosprecos(String key) {
        return this.delete(TABLES.artigosprecos, key);
    }

    public boolean existsArtigosprecos(String key) {
        return this.getTableManager().artigosprecos.exists(key);
    }

    public Artigosprecos loadArtigosprecos(String key) {
        return (Artigosprecos)this.getTableManager().artigosprecos.load(key);
    }

    public Collection<Artigosprecos> getArtigosprecosCollection() {
        return this.getTableManager().artigosprecos.getCollection();
    }

    public Collection<Artigosprecos> getArtigosprecosCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().artigosprecos.getCollection(query));
    }

    public long countArtigosprecos(String artigo) {
        return this.getTableManager().artigosprecos.count(artigo);
    }

    @Deprecated
    private MessageList storeArtigoscomposicao(Artigoscomposicao composicao) {
        return this.store(TABLES.artigoscomposicao, composicao, new MethodCallback[0]);
    }

    @Deprecated
    private MessageList deleteArtigoscomposicao(String key) {
        return this.delete(TABLES.artigoscomposicao, key);
    }

    public boolean existsArtigoscomposicao(String key) {
        return this.getTableManager().artigoscomposicao.exists(key);
    }

    public Artigoscomposicao loadArtigoscomposicao(String key) {
        return (Artigoscomposicao)this.getTableManager().artigoscomposicao.load(key);
    }

    public Collection<Artigoscomposicao> getArtigoscomposicaoCollection() {
        return this.getTableManager().artigoscomposicao.getCollection();
    }

    public Collection<Artigoscomposicao> getArtigoscomposicaoCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().artigoscomposicao.getCollection(query));
    }

    public long countArtigoscomposicao(String artigo) {
        return this.getTableManager().artigoscomposicao.count(artigo);
    }

    @Deprecated
    private MessageList storeArtigosexistencias(Artigosexistencias existencia) {
        return this.store(TABLES.artigosexistencias, existencia, new MethodCallback[0]);
    }

    @Deprecated
    private MessageList deleteArtigosexistencias(String key) {
        return this.delete(TABLES.artigosexistencias, key);
    }

    public boolean existsArtigosexistencias(String key) {
        return this.getTableManager().artigosexistencias.exists(key);
    }

    public Artigosexistencias loadArtigosexistencias(String key) {
        return (Artigosexistencias)this.getTableManager().artigosexistencias.load(key);
    }

    @Deprecated
    private Collection<Artigosexistencias> getArtigosexistenciasCollection() {
        return this.getTableManager().artigosexistencias.getCollection();
    }

    @Deprecated
    public Collection<Artigosexistencias> getArtigosexistenciasCollection(String artigo) {
        return this.getTableManager().artigosexistencias.getCollection(artigo);
    }

    public Collection<Artigosexistencias> getArtigosexistenciasCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().artigosexistencias.getCollection(query));
    }

    public long countArtigosexistencias(String artigo) {
        return this.getTableManager().artigosexistencias.count(artigo);
    }

    public MessageList storeArtigosdocumentos(Artigosdocumentos documento, MethodCallback ... preCommit) {
        documento.setEditor(this.utilizador);
        if (!documento.isEdited()) {
            documento.setAutor(this.utilizador);
        }
        return this.store(TABLES.artigosdocumentos, documento, preCommit);
    }

    public MessageList deleteArtigosdocumentos(String key) {
        return this.delete(TABLES.artigosdocumentos, key);
    }

    public boolean existsArtigosdocumentos(String key) {
        return this.getTableManager().artigosdocumentos.exists(key);
    }

    @Deprecated
    private boolean existsArtigosdocumentos$Previous(String tipodocumento, String serie, Integer numerodocumento) {
        return this.getArtigosdocumentos$PreviousNumero(tipodocumento, serie, numerodocumento) != null;
    }

    @Deprecated
    private boolean existsArtigosdocumentos$Next(String tipodocumento, String serie, Integer numerodocumento) {
        return this.getArtigosdocumentos$NextNumero(tipodocumento, serie, numerodocumento) != null;
    }

    public Artigosdocumentos loadArtigosdocumentos$Previous(String tipodocumento, String serie, Integer numerodocumento) {
        return this.loadArtigosdocumentos(tipodocumento, serie, this.getArtigosdocumentos$PreviousNumero(tipodocumento, serie, numerodocumento));
    }

    public Artigosdocumentos loadArtigosdocumentos$Next(String tipodocumento, String serie, Integer numerodocumento) {
        return this.loadArtigosdocumentos(tipodocumento, serie, this.getArtigosdocumentos$NextNumero(tipodocumento, serie, numerodocumento));
    }

    public Artigosdocumentos loadArtigosdocumentos(String tipodocumento, String serie, Integer numerodocumento) {
        return this.loadArtigosdocumentos(Artigosdocumentos.generateKey(tipodocumento, serie, numerodocumento));
    }

    public Artigosdocumentos loadArtigosdocumentos(String key) {
        return this.loadArtigosdocumentos(key, false);
    }

    public Artigosdocumentos loadArtigosdocumentos(String key, boolean complete) {
        return (Artigosdocumentos)this.getTableManager().artigosdocumentos.load(key, complete);
    }

    public Integer getArtigosdocumentos$PreviousNumero(String tipodocumento, String serie, Integer numerodocumento) {
        return this.getTableManager().artigosdocumentos.getPreviousNumero(tipodocumento, serie, numerodocumento);
    }

    public Integer getArtigosdocumentos$NextNumero(String tipodocumento, String serie, Integer numerodocumento) {
        return this.getTableManager().artigosdocumentos.getNextNumero(tipodocumento, serie, numerodocumento);
    }

    public Collection<Artigosdocumentos> getArtigosdocumentosCollection() {
        return this.getTableManager().artigosdocumentos.getCollection();
    }

    public Collection<Artigosdocumentos> getArtigosdocumentosCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().artigosdocumentos.getCollection(query));
    }

    public long countArtigosdocumentos() {
        return this.getTableManager().artigosdocumentos.count();
    }

    @Deprecated
    private MessageList storeArtigosdocumentoslinhas(Artigosdocumentoslinhas linha) {
        return this.store(TABLES.artigosdocumentoslinhas, linha, new MethodCallback[0]);
    }

    @Deprecated
    private MessageList deleteArtigosdocumentoslinhas(String key) {
        return this.delete(TABLES.artigosdocumentoslinhas, key);
    }

    public boolean existsArtigosdocumentoslinhas(String key) {
        return this.getTableManager().artigosdocumentoslinhas.exists(key);
    }

    public Artigosdocumentoslinhas loadArtigosdocumentoslinhas(String key) {
        return (Artigosdocumentoslinhas)this.getTableManager().artigosdocumentoslinhas.load(key);
    }

    public Collection<Artigosdocumentoslinhas> getArtigosdocumentoslinhasCollection(String documento) {
        return this.getTableManager().artigosdocumentoslinhas.getCollection(documento);
    }

    public Collection<Artigosdocumentoslinhas> getArtigosdocumentoslinhasCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().artigosdocumentoslinhas.getCollection(query));
    }

    public long countArtigosdocumentoslinhas(String documento) {
        return this.getTableManager().artigosdocumentoslinhas.count(documento);
    }

    @Deprecated
    private MessageList storeArtigosmovimentos(Artigosmovimentos movimento) {
        return this.store(TABLES.artigosmovimentos, movimento, new MethodCallback[0]);
    }

    @Deprecated
    private MessageList deleteArtigosmovimentos(String key) {
        return this.delete(TABLES.artigosmovimentos, key);
    }

    public boolean existsArtigosmovimentos(String key) {
        return this.getTableManager().artigosmovimentos.exists(key);
    }

    public Artigosmovimentos loadArtigosmovimentos(String key) {
        return (Artigosmovimentos)this.getTableManager().artigosmovimentos.load(key);
    }

    public Collection<Artigosmovimentos> getArtigosmovimentosCollection(String tipodocumento) {
        return this.getTableManager().artigosmovimentos.getCollection(tipodocumento);
    }

    public Collection<Artigosmovimentos> getArtigosmovimentosCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().artigosmovimentos.getCollection(query));
    }

    public long countArtigosmovimentos() {
        return this.getTableManager().artigosmovimentos.count();
    }

    public MessageList storeEntidades(Entidades entidade, MethodCallback ... preCommit) {
        entidade.setEditor(this.utilizador);
        if (!entidade.isEdited()) {
            entidade.setAutor(this.utilizador);
        }
        return this.store(TABLES.entidades, entidade, preCommit);
    }

    public MessageList deleteEntidades(String key) {
        return this.delete(TABLES.entidades, key);
    }

    public boolean existsEntidades(String key) {
        return this.getTableManager().entidades.exists(key);
    }

    public boolean existsEntidades(String tipoentidade, Integer numero) {
        return this.existsEntidades(Entidades.generateKey(tipoentidade, numero));
    }

    public boolean existsEntidades(String tipoentidade, String pais, String nif, int ... estado) {
        return this.getEntidades$Numero(tipoentidade, pais, nif, estado) != null;
    }

    @Deprecated
    private boolean existsEntidades$Previous(String tipoentidade, Integer numero) {
        return this.getEntidades$PreviousNumero(tipoentidade, numero) != null;
    }

    @Deprecated
    private boolean existsEntidades$Next(String tipoentidade, Integer numero) {
        return this.getEntidades$NextNumero(tipoentidade, numero) != null;
    }

    public Entidades loadEntidades$First(String tipoentidade) {
        return this.loadEntidades$Next(tipoentidade, -1);
    }

    public Entidades loadEntidades$Next(String tipoentidade, Integer numero) {
        return this.loadEntidades(tipoentidade, this.getEntidades$NextNumero(tipoentidade, numero));
    }

    public Entidades loadEntidades(String tipoentidade, String pais, String nif, int ... estado) {
        return this.loadEntidades(tipoentidade, this.getEntidades$Numero(tipoentidade, pais, nif, estado));
    }

    public Entidades loadEntidades$Previous(String tipoentidade, Integer numero) {
        return this.loadEntidades(tipoentidade, this.getEntidades$PreviousNumero(tipoentidade, numero));
    }

    public Entidades loadEntidades(String tipoentidade, Integer numero) {
        return this.loadEntidades(Entidades.generateKey(tipoentidade, numero));
    }

    public Entidades loadEntidades(String key) {
        return (Entidades)this.getTableManager().entidades.load(key);
    }

    public Integer getEntidades$PreviousNumero(String tipoentidade, Integer numero) {
        return this.getTableManager().entidades.getPreviousNumero(tipoentidade, numero);
    }

    public Integer getEntidades$NextNumero(String tipoentidade) {
        return this.getTableManager().entidades.getNextNumero(tipoentidade);
    }

    public Integer getEntidades$NextNumero(String tipoentidade, Integer numero) {
        return this.getTableManager().entidades.getNextNumero(tipoentidade, numero);
    }

    public Integer getEntidades$Numero(String tipoentidade, String pais, String nif, int ... estado) {
        Collection<Integer> numero = this.getEntidadesCollection$Numero(tipoentidade, pais, nif, estado);
        return numero.size() == 0 ? null : numero.iterator().next();
    }

    public Collection<Integer> getEntidadesCollection$Numero(String tipoentidade, String pais, String nif, int ... estado) {
        return this.getTableManager().entidades.getNumero(tipoentidade, this.loadPaises(pais), nif, estado);
    }

    public Collection<Entidades> getEntidadesCollection(String tipoentidade) {
        return this.getTableManager().entidades.getCollection(tipoentidade);
    }

    public Collection<Entidades> getEntidadesCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().entidades.getCollection(query));
    }

    public long countEntidades(String tipoentidade) {
        return this.getTableManager().entidades.count(tipoentidade);
    }

    @Deprecated
    private MessageList storeEntidadesmoradas(Entidadesmoradas morada) {
        return this.store(TABLES.entidadesmoradas, morada, new MethodCallback[0]);
    }

    @Deprecated
    private MessageList deleteEntidadesmoradas(String key) {
        return this.delete(TABLES.entidadesmoradas, key);
    }

    public boolean existsEntidadesmoradas(String key) {
        return this.getTableManager().entidadesmoradas.exists(key);
    }

    public Entidadesmoradas loadEntidadesmoradas(String key) {
        return (Entidadesmoradas)this.getTableManager().entidadesmoradas.load(key);
    }

    @Deprecated
    private Collection<Entidadesmoradas> getEntidadesmoradasCollection() {
        return this.getTableManager().entidadesmoradas.getCollection();
    }

    public Collection<Entidadesmoradas> getEntidadesmoradasCollection(String entidade) {
        return this.getTableManager().entidadesmoradas.getCollection(entidade);
    }

    public Collection<Entidadesmoradas> getEntidadesmoradasCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().entidadesmoradas.getCollection(query));
    }

    public long countEntidadesmoradas(String entidade) {
        return this.getTableManager().entidadesmoradas.count(entidade);
    }

    public MessageList storeEntidadesartigos(Entidadesartigos artigo) {
        return this.store(TABLES.entidadesartigos, artigo, new MethodCallback[0]);
    }

    public MessageList deleteEntidadesartigos(String key) {
        return this.delete(TABLES.entidadesartigos, key);
    }

    public boolean existsEntidadesartigos(String key) {
        return this.getTableManager().entidadesartigos.exists(key);
    }

    public Entidadesartigos loadEntidadesartigos(String key) {
        return (Entidadesartigos)this.getTableManager().entidadesartigos.load(key);
    }

    @Deprecated
    private Collection<Entidadesartigos> getEntidadesartigosCollection() {
        return this.getTableManager().entidadesartigos.getCollection();
    }

    public Collection<Entidadesartigos> getEntidadesartigosCollection(String entidade) {
        return this.getTableManager().entidadesartigos.getCollection(entidade);
    }

    public Collection<Entidadesartigos> getEntidadesartigosCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().entidadesartigos.getCollection(query));
    }

    public long countEntidadesartigos(String entidade) {
        return this.getTableManager().entidadesartigos.count(entidade);
    }

    public MessageList registerEntidadesdocumentos(String key) {
        return this.getTableManager().entidadesdocumentos.register(key);
    }

    public MessageList incrementEntidadesdocumentos(String key, FIELDS field) {
        return this.getTableManager().entidadesdocumentos.increment(key, field);
    }

    public MessageList storeEntidadesdocumentos(Entidadesdocumentos documento, MethodCallback ... preCommit) {
        documento.setEditor(this.utilizador);
        if (!documento.isEdited()) {
            documento.setAutor(this.utilizador);
        }
        return this.store(TABLES.entidadesdocumentos, documento, preCommit);
    }

    public MessageList deleteEntidadesdocumentos(String key) {
        return this.delete(TABLES.entidadesdocumentos, key);
    }

    public boolean existsEntidadesdocumentos(String key) {
        return this.getTableManager().entidadesdocumentos.exists(key);
    }

    @Deprecated
    private boolean existsEntidadesdocumentos$Previous(String tipodocumento, String serie, Integer numerodocumento) {
        return this.getEntidadesdocumentos$PreviousNumero(tipodocumento, serie, numerodocumento, new int[0]) != null;
    }

    @Deprecated
    private boolean existsEntidadesdocumentos$Next(String tipodocumento, String serie, Integer numerodocumento) {
        return this.getEntidadesdocumentos$NextNumero(tipodocumento, serie, numerodocumento) != null;
    }

    public Entidadesdocumentos loadEntidadesdocumentos$Previous(String tipodocumento, String serie, Integer numerodocumento, int ... estado) {
        return this.loadEntidadesdocumentos(tipodocumento, serie, this.getEntidadesdocumentos$PreviousNumero(tipodocumento, serie, numerodocumento, estado));
    }

    public Entidadesdocumentos loadEntidadesdocumentos$Next(String tipodocumento, String serie, Integer numerodocumento) {
        return this.loadEntidadesdocumentos(tipodocumento, serie, this.getEntidadesdocumentos$NextNumero(tipodocumento, serie, numerodocumento));
    }

    public Entidadesdocumentos loadEntidadesdocumentos(String tipodocumento, String serie, Integer numerodocumento) {
        return this.loadEntidadesdocumentos(Entidadesdocumentos.generateKey(tipodocumento, serie, numerodocumento));
    }

    public Entidadesdocumentos loadEntidadesdocumentos(String tipodocumento, String numeroauxiliar) {
        return this.loadEntidadesdocumentos(this.getEntidadesdocumentos$MaxKey(tipodocumento, numeroauxiliar));
    }

    public Entidadesdocumentos loadEntidadesdocumentos(String key) {
        return this.loadEntidadesdocumentos(key, false);
    }

    public Entidadesdocumentos loadEntidadesdocumentos(String key, boolean complete) {
        return (Entidadesdocumentos)this.getTableManager().entidadesdocumentos.load(key, complete);
    }

    public String getEntidadesdocumentos$MaxKey(String tipodocumento, String numeroauxiliar) {
        return this.getTableManager().entidadesdocumentos.getMaxKey(tipodocumento, numeroauxiliar);
    }

    public Integer getEntidadesdocumentos$PreviousNumero(String tipodocumento, String serie, Integer numerodocumento, int ... estado) {
        return this.getTableManager().entidadesdocumentos.getPreviousNumero(tipodocumento, serie, numerodocumento, estado);
    }

    public Integer getEntidadesdocumentos$NextNumero(String tipodocumento, String serie, Integer numerodocumento) {
        return this.getTableManager().entidadesdocumentos.getNextNumero(tipodocumento, serie, numerodocumento);
    }

    public Collection<Entidadesdocumentos> getEntidadesdocumentosCollection(String tipoentidade) {
        return this.getTableManager().entidadesdocumentos.getCollection(tipoentidade);
    }

    public Collection<Entidadesdocumentos> getEntidadesdocumentosCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().entidadesdocumentos.getCollection(query));
    }

    public long countEntidadesdocumentos(String tipoentidade) {
        return this.getTableManager().entidadesdocumentos.count(tipoentidade);
    }

    @Deprecated
    private MessageList storeEntidadesdocumentoslinhas(Entidadesdocumentoslinhas linha) {
        return this.store(TABLES.entidadesdocumentoslinhas, linha, new MethodCallback[0]);
    }

    @Deprecated
    private MessageList deleteEntidadesdocumentoslinhas(String key) {
        return this.delete(TABLES.entidadesdocumentoslinhas, key);
    }

    public boolean existsEntidadesdocumentoslinhas(String key) {
        return this.getTableManager().entidadesdocumentoslinhas.exists(key);
    }

    public Entidadesdocumentoslinhas loadEntidadesdocumentoslinhas(String key) {
        return (Entidadesdocumentoslinhas)this.getTableManager().entidadesdocumentoslinhas.load(key);
    }

    public Collection<Entidadesdocumentoslinhas> getEntidadesdocumentoslinhasCollection(String tipoentidade) {
        return this.getTableManager().entidadesdocumentoslinhas.getCollection(tipoentidade);
    }

    public Collection<Entidadesdocumentoslinhas> getEntidadesdocumentoslinhasCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().entidadesdocumentoslinhas.getCollection(query));
    }

    public long countEntidadesdocumentoslinhas(String documento) {
        return this.getTableManager().entidadesdocumentoslinhas.count(documento);
    }

    @Deprecated
    public MessageList storeEntidadesdocumentosentregas(Entidadesdocumentosentregas entrega) {
        return this.store(TABLES.entidadesdocumentosentregas, entrega, new MethodCallback[0]);
    }

    @Deprecated
    private MessageList deleteEntidadesdocumentosentregas(String key) {
        return this.delete(TABLES.entidadesdocumentosentregas, key);
    }

    public boolean existsEntidadesdocumentosentregas(String key) {
        return this.getTableManager().entidadesdocumentosentregas.exists(key);
    }

    public Entidadesdocumentosentregas loadEntidadesdocumentosentregas(String key) {
        return (Entidadesdocumentosentregas)this.getTableManager().entidadesdocumentosentregas.load(key);
    }

    public Collection<Entidadesdocumentosentregas> getEntidadesdocumentosentregasCollection(String tipoentidade) {
        return this.getTableManager().entidadesdocumentosentregas.getCollection(tipoentidade);
    }

    public Collection<Entidadesdocumentosentregas> getEntidadesdocumentosentregasCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().entidadesdocumentosentregas.getCollection(query));
    }

    public long countEntidadesdocumentosentregas(String documento) {
        return this.getTableManager().entidadesdocumentosentregas.count(documento);
    }

    @Deprecated
    private MessageList storeEntidadesdocumentosivas(Entidadesdocumentosivas iva) {
        return this.store(TABLES.entidadesdocumentosivas, iva, new MethodCallback[0]);
    }

    @Deprecated
    private MessageList deleteEntidadesdocumentosivas(String key) {
        return this.delete(TABLES.entidadesdocumentosivas, key);
    }

    public boolean existsEntidadesdocumentosivas(String key) {
        return this.getTableManager().entidadesdocumentosivas.exists(key);
    }

    public Entidadesdocumentosivas loadEntidadesdocumentosivas(String key) {
        return (Entidadesdocumentosivas)this.getTableManager().entidadesdocumentosivas.load(key);
    }

    public Collection<Entidadesdocumentosivas> getEntidadesdocumentosivasCollection(String tipoentidade) {
        return this.getTableManager().entidadesdocumentosivas.getCollection(tipoentidade);
    }

    public Collection<Entidadesdocumentosivas> getEntidadesdocumentosivasCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().entidadesdocumentosivas.getCollection(query));
    }

    public long countEntidadesdocumentosivas(String documento) {
        return this.getTableManager().entidadesdocumentosivas.count(documento);
    }

    @Deprecated
    private MessageList storeEntidadesdocumentosatws(Entidadesdocumentosatws ws) {
        return this.store(TABLES.entidadesdocumentosatws, ws, new MethodCallback[0]);
    }

    @Deprecated
    private MessageList deleteEntidadesdocumentosatws(String key) {
        return this.delete(TABLES.entidadesdocumentosatws, key);
    }

    public boolean existsEntidadesdocumentosatws(String key) {
        return this.getTableManager().entidadesdocumentosatws.exists(key);
    }

    public Entidadesdocumentosatws loadEntidadesdocumentosatws(String key) {
        return (Entidadesdocumentosatws)this.getTableManager().entidadesdocumentosatws.load(key);
    }

    public Collection<Entidadesdocumentosatws> getEntidadesdocumentosatwsCollection(String tipoentidade) {
        return this.getTableManager().entidadesdocumentosatws.getCollection(tipoentidade);
    }

    public Collection<Entidadesdocumentosatws> getEntidadesdocumentosatwsCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().entidadesdocumentosatws.getCollection(query));
    }

    public long countEntidadesdocumentosatws(String documento) {
        return this.getTableManager().entidadesdocumentosatws.count(documento);
    }

    public BigDecimal sumEntidadesmovimentos(DatePeriod period, FIELDS field, int tiposaldo, int tipodocumento) {
        return this.getTableManager().entidadesmovimentos.sum(period, field, tiposaldo, tipodocumento);
    }

    public BigDecimal sumEntidadesmovimentos(int year, FIELDS field, int tiposaldo, int tipodocumento) {
        return this.sumEntidadesmovimentos(new DatePeriod((Calendar)TimeDateUtils.getCalendar((int)year), (Calendar)TimeDateUtils.getCalendar((int)year, (int)11, (int)31)), field, tiposaldo, tipodocumento);
    }

    @Deprecated
    private MessageList storeEntidadesmovimentos(Entidadesmovimentos movimento) {
        return this.store(TABLES.entidadesmovimentos, movimento, new MethodCallback[0]);
    }

    @Deprecated
    private MessageList deleteEntidadesmovimentos(String key) {
        return this.delete(TABLES.entidadesmovimentos, key);
    }

    public boolean existsEntidadesmovimentos(String key) {
        return this.getTableManager().entidadesmovimentos.exists(key);
    }

    public Entidadesmovimentos loadEntidadesmovimentos(String key) {
        return (Entidadesmovimentos)this.getTableManager().entidadesmovimentos.load(key);
    }

    public Collection<Entidadesmovimentos> getEntidadesmovimentosCollection(String tipoentidade) {
        return this.getTableManager().entidadesmovimentos.getCollection(tipoentidade);
    }

    public Collection<Entidadesmovimentos> getEntidadesmovimentosCollection(QueryDefinition query) {
        return this.attach(this.getTableManager().entidadesmovimentos.getCollection(query));
    }

    public long countEntidadesmovimentos(String tipoentidade) {
        return this.getTableManager().entidadesmovimentos.count(tipoentidade);
    }
}

