/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.birt.report;

import org.dma.java.util.MessageList;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.birt.render.BIRTRender;
import org.projectocolibri.api.birt.render.IBIRTRenderTask;
import org.projectocolibri.api.birt.report.BIRTReportFile;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.model.Templates;

public abstract class BIRTReport
extends MessageList {
    private static final long serialVersionUID = 1L;
    private final Templates template;
    private final boolean resetCount;

    public abstract FilterMap getFilterMap();

    public String getName() {
        return this.template.toString();
    }

    public BIRTReport(Templates template) {
        this(template, false);
    }

    public BIRTReport(Templates template, boolean resetCount) {
        this.template = template.isEmpty() ? template.getManager().loadTemplates(template.getCodigo()) : template.cloneCopy();
        this.resetCount = resetCount;
    }

    public BIRTReportFile process(REPORT_ACTIONS action) {
        return this.process(action, REPORT_FORMATS.PDF);
    }

    public BIRTReportFile process(REPORT_ACTIONS action, REPORT_FORMATS format) {
        return this.process(action, format, this.template.getBirtRenderTask(this.resetCount));
    }

    public BIRTReportFile process(REPORT_ACTIONS action, REPORT_FORMATS format, IBIRTRenderTask task) {
        MessageList error = this.template.getManager().getEmpresa().validate(IDatabaseModel.ACTION.STORE);
        if (!this.add(error)) {
            try {
                return new BIRTRender(this.template, format, this.getFilterMap()).process(action, task).getReportFile().sign(this.template.getManager().getEmpresa().getPdfSignature());
            }
            catch (Exception e) {
                this.add(e);
            }
        }
        return null;
    }

    public static enum REPORT_ACTIONS {
        PREVIEW,
        PRINT,
        EMAIL,
        EMBED,
        ARCHIVE;

    }

    public static enum REPORT_FORMATS {
        PDF(Colibri.ICONS.REPORT_FORMAT_PDF, "pdf", true),
        WEB(Colibri.ICONS.REPORT_FORMAT_WEB, "html", true),
        XLS(Colibri.ICONS.REPORT_FORMAT_XLS, "xls", false);

        public final Colibri.ICONS icon;
        public final String output;
        public final boolean preview;

        private REPORT_FORMATS(Colibri.ICONS icon, String output, boolean preview) {
            this.icon = icon;
            this.output = output;
            this.preview = preview;
        }

        public REPORT_FORMATS next() {
            return REPORT_FORMATS.values()[(this.ordinal() + 1) % REPORT_FORMATS.values().length];
        }

        public static REPORT_FORMATS get(String name) {
            try {
                return REPORT_FORMATS.valueOf(name);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

