/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.birt.render;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.dma.java.time.Chronograph;
import org.dma.java.util.Debug;
import org.eclipse.birt.report.engine.api.EXCELRenderOption;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.projectocolibri.api.birt.design.BIRTParametersMap;
import org.projectocolibri.api.birt.render.BIRTRender;
import org.projectocolibri.api.birt.render.IBIRTRenderTask;
import org.projectocolibri.api.birt.report.BIRTReport;
import org.projectocolibri.api.birt.report.BIRTReportParameters;
import org.projectocolibri.api.database.DatabaseManager;

public class BIRTRenderTask
implements IBIRTRenderTask {
    private final IReportEngine engine;

    public BIRTRenderTask(DatabaseManager manager) {
        this(manager.getEngine());
    }

    public BIRTRenderTask(IReportEngine engine) {
        this.engine = engine;
    }

    @Override
    public HashMap getAppContext() {
        return this.engine.getConfig().getAppContext();
    }

    @Override
    public RenderOption getRenderOption(File outputFile, BIRTReport.REPORT_FORMATS format, int reportType) {
        RenderOption options = new RenderOption();
        options.setOutputFormat(format.output);
        switch (format) {
            case PDF: {
                options = new PDFRenderOption();
                options.setOption("emitterID", (Object)"org.eclipse.birt.report.engine.emitter.pdf");
                break;
            }
            case WEB: {
                options = new HTMLRenderOption();
                options.setOption("emitterID", (Object)"org.eclipse.birt.report.engine.emitter.html");
                break;
            }
            case XLS: {
                options = new EXCELRenderOption();
                options.setOption("emitterID", (Object)"org.eclipse.birt.report.engine.emitter.prototype.excel");
            }
        }
        options.setOutputFileName(outputFile.getAbsolutePath());
        return options;
    }

    @Override
    public BIRTParametersMap getParameterMap(BIRTReportParameters parameters, int reportType, int copyIndex, int renderCount) {
        return new BIRTParametersMap(parameters, reportType, copyIndex, renderCount);
    }

    @Override
    public File renderCopy(File designFile, RenderOption options, BIRTParametersMap parameters, BIRTRender.BACKGROUND background) throws Exception {
        Chronograph time = new Chronograph().start();
        try {
            try {
                IReportRunnable reportRunnable = this.engine.openReportDesign(designFile.getAbsolutePath());
                IRunAndRenderTask task = this.engine.createRunAndRenderTask(reportRunnable);
                task.setRenderOption((IRenderOption)options);
                task.setParameterValues((Map)parameters);
                background.addImage(reportRunnable);
                task.run();
                task.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
        }
        finally {
            Debug.out((String)"RENDER EXECUTED", (Object)time.stop());
        }
        return new File(options.getOutputFileName());
    }
}

