/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.birt.render;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.dma.java.io.ByteFile;
import org.dma.java.io.PdfFile;
import org.dma.java.time.Chronograph;
import org.dma.java.util.Debug;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.birt.report.BIRTReport;
import org.projectocolibri.api.birt.report.BIRTReportFile;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.api.language.LABELS;

public class BIRTRenderFiles
extends ArrayList<File> {
    private static final long serialVersionUID = 1L;
    protected final Templates template;
    protected final BIRTReport.REPORT_FORMATS format;
    private BIRTReportFile file;

    public BIRTReportFile getReportFile() throws Exception {
        if (this.isEmpty()) {
            throw new Exception(LABELS.erro_ficheiro_vazio.toString());
        }
        if (this.file == null) {
            this.file = new BIRTReportFile(this.mergeFiles(), this.format);
        }
        return this.file;
    }

    public BIRTRenderFiles(Templates template, BIRTReport.REPORT_FORMATS format) {
        this.template = template.isEmpty() ? template.getManager().loadTemplates(template.getCodigo()) : template.cloneCopy();
        this.format = format;
    }

    public boolean isFormatValid() {
        return this.format == BIRTReport.REPORT_FORMATS.PDF || this.template.getManager().getLicenca().allows(Colibri.FUNCIONALIDADES.REPORT_MULTIFORMAT);
    }

    private File mergeFiles() throws Exception {
        if (this.size() > 1) {
            File temp = this.template.getFileParameters(this.format).createTempFile();
            if (this.isEmpty()) {
                return temp;
            }
            Chronograph time = new Chronograph().start();
            switch (this.format) {
                case PDF: {
                    new PdfFile(temp).merge((Collection)this);
                    break;
                }
                case WEB: {
                    new ByteFile(temp).append((Collection)this);
                    break;
                }
                case XLS: {
                    new ByteFile(temp).append((File)this.get(0));
                }
            }
            Debug.out((String)"MERGE EXECUTED", (Object)time.stop());
            for (File file : this) {
                file.delete();
            }
            temp.renameTo((File)this.get(0));
        }
        return (File)this.get(0);
    }
}

