/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.birt.render;

import java.io.File;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.dma.java.io.ByteFile;
import org.dma.java.time.DatePeriod;
import org.dma.java.util.Debug;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.element.IScriptStyleDesign;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.birt.render.BIRTRenderFiles;
import org.projectocolibri.api.birt.render.IBIRTRenderTask;
import org.projectocolibri.api.birt.report.BIRTReport;
import org.projectocolibri.api.birt.report.BIRTReportCopies;
import org.projectocolibri.api.birt.report.BIRTReportParameters;
import org.projectocolibri.api.database.IDatabaseModel;
import org.projectocolibri.api.database.IDocumentoModel;
import org.projectocolibri.api.database.filter.FilterMap;
import org.projectocolibri.api.database.filter.FilterOperandMap;
import org.projectocolibri.api.database.filter.OPERATORS;
import org.projectocolibri.api.database.manager.AbstractManager;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TableFieldKey;
import org.projectocolibri.api.database.mapper.TableLayout;
import org.projectocolibri.api.database.model.Templates;
import org.projectocolibri.api.database.query.QueryDefinition;
import org.projectocolibri.api.database.query.QueryOrdering;
import org.projectocolibri.api.language.LABELS;

public class BIRTRender
extends BIRTRenderFiles {
    private static final long serialVersionUID = 1L;
    private final FilterMap filterMap;

    public BIRTRender(Templates template, BIRTReport.REPORT_FORMATS format, FilterMap filterMap) {
        super(template, format);
        this.filterMap = filterMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIRTRenderFiles process(BIRTReport.REPORT_ACTIONS action, IBIRTRenderTask task) throws Exception {
        if (this.filterMap.table != this.template.table()) {
            throw new UnsupportedOperationException(this.filterMap.table.toString());
        }
        if (!this.template.isValid()) {
            throw new InvalidParameterException(LABELS.erro_template_invalido.toString());
        }
        if (!this.isFormatValid()) {
            throw new InvalidParameterException(LABELS.erro_formato_invalido.toString());
        }
        QueryDefinition query = new QueryDefinition(this.filterMap, QueryOrdering.DIRECTION.ASCENDING);
        query.addFetchplan(this.template.getLayoutArray()).replace(this.template.getFiltroToMap());
        Date[] periodo = new DatePeriod().toArray();
        switch (this.template.getTipo()) {
            case 0: {
                switch (this.template.getTabela()) {
                    case 2: {
                        query.addOrdering(new TableFieldKey(FIELDS.artigosdocumentos_tipodocumento, FIELDS.documentostipos_codigo), new TableFieldKey(FIELDS.artigosdocumentos_seriedocumento, FIELDS.documentosseries_serie), new TableFieldKey(FIELDS.artigosdocumentos_numerodocumento));
                        break;
                    }
                    case 5: {
                        query.addOrdering(new TableFieldKey(FIELDS.entidadesdocumentos_tipodocumento, FIELDS.documentostipos_codigo), new TableFieldKey(FIELDS.entidadesdocumentos_seriedocumento, FIELDS.documentosseries_serie), new TableFieldKey(FIELDS.entidadesdocumentos_numerodocumento));
                    }
                }
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                TableFieldKey fieldKey = new TableLayout(this.template).findFirst(FIELDS.TYPES.DATE);
                if (fieldKey == null) break;
                Debug.out((String)"FIELD", (Object)fieldKey);
                int index = query.indexOf(fieldKey, OPERATORS.MATH.BIGGER_EQUAL);
                Debug.out((String)"INDEX", (Object)index);
                if (index != 0) break;
                List operands = (List)query.process().get(fieldKey);
                int i = 0;
                while (i < Math.min(operands.size(), periodo.length)) {
                    periodo[i] = (Date)((FilterOperandMap)((Object)operands.get(i))).getConverted();
                    ++i;
                }
                Debug.out((String)"PERIODO", Arrays.asList(periodo));
                query.remove(fieldKey, index);
            }
        }
        AbstractManager manager = this.template.getManager().getTableManager(query.table);
        Collection col = manager.getCollection(query);
        if (col.isEmpty()) {
            throw new Exception(LABELS.info_operacao_nula.toString());
        }
        ByteFile designFile = this.template.getManager().getDesign().get(this.template.getCodigo());
        Debug.out((Object)designFile);
        switch (this.template.getTipo()) {
            case 0: {
                for (IDatabaseModel element : col) {
                    AbstractManager abstractManager = manager;
                    synchronized (abstractManager) {
                        IDocumentoModel model = (IDocumentoModel)manager.load(element.getKey());
                        IDocumentoModel copy = model.reportCopy();
                        task.getAppContext().put(query.table.name(), Arrays.asList(copy));
                        BIRTReportParameters parameters = new BIRTReportParameters(model);
                        BIRTReportCopies copies = copy.getReportCopies(action);
                        int copyIndex = copies.first();
                        while (copyIndex <= copies.last()) {
                            File outputFile = this.template.getFileParameters(copy, this.format).createTempFile();
                            this.add(task.renderCopy((File)designFile, task.getRenderOption(outputFile, this.format, this.template.getTipo()), task.getParameterMap(parameters, this.template.getTipo(), copyIndex, copy.getContadorvias()), copy.getReportBackground()));
                            ++copyIndex;
                        }
                        if (copies.count() > 0) {
                            model.incrementContadorvias();
                        }
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                AbstractManager abstractManager = manager;
                synchronized (abstractManager) {
                    File outputFile = this.template.getFileParameters(this.format).createTempFile();
                    task.getAppContext().put(query.table.name(), this.template.getManager().attach(col));
                    BIRTReportParameters parameters = new BIRTReportParameters(this.template, query, new DatePeriod(periodo[0], periodo[1]));
                    this.add(task.renderCopy((File)designFile, task.getRenderOption(outputFile, this.format, this.template.getTipo()), task.getParameterMap(parameters, this.template.getTipo(), 0, 0), BACKGROUND.NONE));
                    break;
                }
            }
        }
        task.getAppContext().remove(query.table.name());
        return this;
    }

    public static enum BACKGROUND {
        NONE(null),
        DRAFT(Colibri.FILES.IMAGES.REPORT_DRAFT),
        DELETED(Colibri.FILES.IMAGES.REPORT_DELETED),
        WATERMARK(Colibri.FILES.IMAGES.REPORT_WATERMARK);

        private final Colibri.FILES.IMAGES image;

        private BACKGROUND(Colibri.FILES.IMAGES image) {
            this.image = image;
        }

        public void addImage(IReportRunnable reportRunnable) throws ScriptException {
            if (this.image != null) {
                IScriptStyleDesign style = reportRunnable.getDesignInstance().getMasterPage("Masterpage").getStyle();
                style.setBackgroundImage(this.image.pathname);
                style.setBackgroundRepeat("no-repeat");
                if (style.getBackGroundPositionX().equals("0%")) {
                    style.setBackGroundPositionX("center");
                }
                if (style.getBackGroundPositionY().equals("0%")) {
                    style.setBackGroundPositionY("center");
                }
            }
        }
    }
}

