/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.birt.design;

import java.sql.Date;
import java.util.LinkedHashMap;
import org.dma.java.util.Debug;
import org.dma.java.util.StringUtils;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.birt.report.BIRTReportParameters;
import org.projectocolibri.api.database.mapper.FIELDS;

public class BIRTParametersMap
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 1L;

    public void print() {
        System.out.println("---BIRT PARAMETERS---");
        System.out.println("SIZE = " + this.size());
        for (String key : this.keySet()) {
            System.out.println(String.valueOf(key) + "=" + this.get(key));
        }
    }

    public BIRTParametersMap(BIRTReportParameters parameters, int reportType, int copyIndex, int renderCount) {
        Debug.out((String)"reportType", (Object)((Object)PARAMETERS.get(reportType)));
        Debug.out((String)"copyIndex", (Object)copyIndex);
        Debug.out((String)"renderCount", (Object)renderCount);
        LinkedHashMap<PARAMETERS_TYPES, Object> map = new LinkedHashMap<PARAMETERS_TYPES, Object>();
        map.put(PARAMETERS_TYPES.company_name, parameters.getEmpresa().getNomeToText());
        map.put(PARAMETERS_TYPES.company_address, parameters.getEmpresa().getMoradaToText());
        map.put(PARAMETERS_TYPES.company_zipcode, String.valueOf(parameters.getEmpresa().getCodigopostal().getCodigo()) + " " + parameters.getEmpresa().getLocalidadeToText());
        map.put(PARAMETERS_TYPES.company_location, parameters.getEmpresa().getLocalidadeToText());
        map.put(PARAMETERS_TYPES.company_tax_number, parameters.getEmpresa().getNifToText());
        map.put(PARAMETERS_TYPES.company_phone, parameters.getEmpresa().getTelefoneToText());
        map.put(PARAMETERS_TYPES.company_phone_2, parameters.getEmpresa().getTelefone2ToText());
        map.put(PARAMETERS_TYPES.company_mobile, parameters.getEmpresa().getTelemovelToText());
        map.put(PARAMETERS_TYPES.company_fax, parameters.getEmpresa().getFaxToText());
        map.put(PARAMETERS_TYPES.company_website, parameters.getEmpresa().getUrlToText());
        map.put(PARAMETERS_TYPES.company_email, parameters.getEmpresa().getEmailToText());
        map.put(PARAMETERS_TYPES.company_conservatory, parameters.getEmpresa().getConservatoriaToText());
        map.put(PARAMETERS_TYPES.company_commercial_registry, parameters.getEmpresa().getRegistocomercialToText());
        map.put(PARAMETERS_TYPES.company_capital_share, parameters.getEmpresa().getCapitalsocialToText());
        map.put(PARAMETERS_TYPES.company_establishment, parameters.getEmpresa().getEstabelecimentoToText());
        map.put(PARAMETERS_TYPES.account_bank, parameters.getParametros().getContabancaria().getNomebancoToText());
        map.put(PARAMETERS_TYPES.account_IBAN, parameters.getParametros().getContabancaria().getIbanToText());
        map.put(PARAMETERS_TYPES.account_BIC, parameters.getParametros().getContabancaria().getBicswiftToText());
        map.put(PARAMETERS_TYPES.project_name, Colibri.PROJECTO_NOME);
        map.put(PARAMETERS_TYPES.project_version, Colibri.PROJECTO_VERSAO);
        map.put(PARAMETERS_TYPES.legal_statement, parameters.getLicenca().getMencaoLegal(Colibri.PROJECTO_TITULO));
        map.put(PARAMETERS_TYPES.report_copy, String.valueOf(FIELDS.documentostipos_copias.values[copyIndex]) + (renderCount > 0 ? " - 2\u00aaVIA" : ""));
        map.put(PARAMETERS_TYPES.report_title, parameters.getTitulo());
        map.put(PARAMETERS_TYPES.report_filter, parameters.getFiltro());
        map.put(PARAMETERS_TYPES.report_message, parameters.getMensagem());
        map.put(PARAMETERS_TYPES.default_currency, parameters.getParametros().getMoeda().getCodigo());
        map.put(PARAMETERS_TYPES.AT_CUD, parameters.getATCUD());
        map.put(PARAMETERS_TYPES.AT_QR_code, parameters.getATQRCode());
        map.put(PARAMETERS_TYPES.AT_document_code, parameters.getATDocumentCode());
        map.put(PARAMETERS_TYPES.document_date, parameters.getDataDocumento());
        map.put(PARAMETERS_TYPES.document_total, parameters.getTotalCambio());
        map.put(PARAMETERS_TYPES.written_total, parameters.getTotalExtenso());
        map.put(PARAMETERS_TYPES.MB_entity, parameters.getMultibanco().getEntityToText());
        map.put(PARAMETERS_TYPES.MB_reference, parameters.getMultibanco().getRef9ToText());
        map.put(PARAMETERS_TYPES.MB_amount, parameters.getMultibanco().getValueToText());
        map.put(PARAMETERS_TYPES.initial_date, new Date(parameters.getPeriodo().getStartDate().getTime()));
        map.put(PARAMETERS_TYPES.final_date, new Date(parameters.getPeriodo().getEndDate().getTime()));
        for (PARAMETERS_TYPES key : map.keySet()) {
            PARAMETERS_TYPES parameter = PARAMETERS.get(reportType, key.name);
            if (parameter == null) continue;
            this.put(parameter.name, map.get((Object)parameter));
        }
    }

    public static enum PARAMETERS {
        DOCUMENTO(PARAMETERS_TYPES.company_name, PARAMETERS_TYPES.company_address, PARAMETERS_TYPES.company_zipcode, PARAMETERS_TYPES.company_location, PARAMETERS_TYPES.company_tax_number, PARAMETERS_TYPES.company_phone, PARAMETERS_TYPES.company_phone_2, PARAMETERS_TYPES.company_mobile, PARAMETERS_TYPES.company_fax, PARAMETERS_TYPES.company_website, PARAMETERS_TYPES.company_email, PARAMETERS_TYPES.company_conservatory, PARAMETERS_TYPES.company_commercial_registry, PARAMETERS_TYPES.company_capital_share, PARAMETERS_TYPES.company_establishment, PARAMETERS_TYPES.account_bank, PARAMETERS_TYPES.account_IBAN, PARAMETERS_TYPES.account_BIC, PARAMETERS_TYPES.project_name, PARAMETERS_TYPES.project_version, PARAMETERS_TYPES.legal_statement, PARAMETERS_TYPES.report_copy, PARAMETERS_TYPES.report_title, PARAMETERS_TYPES.report_message, PARAMETERS_TYPES.default_currency, PARAMETERS_TYPES.AT_CUD, PARAMETERS_TYPES.AT_QR_code, PARAMETERS_TYPES.AT_document_code, PARAMETERS_TYPES.document_date, PARAMETERS_TYPES.document_total, PARAMETERS_TYPES.written_total, PARAMETERS_TYPES.MB_entity, PARAMETERS_TYPES.MB_reference, PARAMETERS_TYPES.MB_amount),
        LISTAGEM_STANDARD(PARAMETERS_TYPES.company_name, PARAMETERS_TYPES.company_address, PARAMETERS_TYPES.company_zipcode, PARAMETERS_TYPES.company_location, PARAMETERS_TYPES.company_tax_number, PARAMETERS_TYPES.company_phone, PARAMETERS_TYPES.company_phone_2, PARAMETERS_TYPES.company_mobile, PARAMETERS_TYPES.company_fax, PARAMETERS_TYPES.company_website, PARAMETERS_TYPES.company_email, PARAMETERS_TYPES.project_name, PARAMETERS_TYPES.project_version, PARAMETERS_TYPES.legal_statement, PARAMETERS_TYPES.report_title, PARAMETERS_TYPES.report_filter, PARAMETERS_TYPES.report_message),
        LISTAGEM_ACUMULADOS(PARAMETERS_TYPES.company_name, PARAMETERS_TYPES.company_address, PARAMETERS_TYPES.company_zipcode, PARAMETERS_TYPES.company_location, PARAMETERS_TYPES.company_tax_number, PARAMETERS_TYPES.company_phone, PARAMETERS_TYPES.company_phone_2, PARAMETERS_TYPES.company_mobile, PARAMETERS_TYPES.company_fax, PARAMETERS_TYPES.company_website, PARAMETERS_TYPES.company_email, PARAMETERS_TYPES.project_name, PARAMETERS_TYPES.project_version, PARAMETERS_TYPES.legal_statement, PARAMETERS_TYPES.report_title, PARAMETERS_TYPES.report_filter, PARAMETERS_TYPES.report_message, PARAMETERS_TYPES.initial_date, PARAMETERS_TYPES.final_date);

        public final PARAMETERS_TYPES[] array;

        private PARAMETERS(PARAMETERS_TYPES ... array) {
            this.array = array;
        }

        public static PARAMETERS get(int reportType) {
            return PARAMETERS.values()[reportType];
        }

        public static PARAMETERS_TYPES get(int reportType, String parameterName) {
            PARAMETERS_TYPES[] pARAMETERS_TYPESArray = PARAMETERS.get((int)reportType).array;
            int n = PARAMETERS.get((int)reportType).array.length;
            int n2 = 0;
            while (n2 < n) {
                PARAMETERS_TYPES parameter = pARAMETERS_TYPESArray[n2];
                if (parameter.name.equals(parameterName)) {
                    return parameter;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum PARAMETERS_TYPES {
        company_name(FIELDS.empresa_nome.type),
        company_address(FIELDS.empresa_morada.type),
        company_zipcode(FIELDS.codigospostais_codigo.type),
        company_location(FIELDS.empresa_localidade.type),
        company_tax_number(FIELDS.empresa_nif.type),
        company_phone(FIELDS.empresa_telefone.type),
        company_phone_2(FIELDS.empresa_telefone2.type),
        company_mobile(FIELDS.empresa_telemovel.type),
        company_fax(FIELDS.empresa_fax.type),
        company_website(FIELDS.empresa_url.type),
        company_email(FIELDS.empresa_email.type),
        company_conservatory(FIELDS.empresa_conservatoria.type),
        company_commercial_registry(FIELDS.empresa_registocomercial.type),
        company_capital_share(FIELDS.empresa_capitalsocial.type),
        company_establishment(FIELDS.empresa_estabelecimento.type),
        account_bank(FIELDS.contasbancarias_nomebanco.type),
        account_IBAN(FIELDS.contasbancarias_iban.type),
        account_BIC(FIELDS.contasbancarias_bicswift.type),
        project_name(FIELDS.TYPES.STRING),
        project_version(FIELDS.TYPES.STRING),
        legal_statement(FIELDS.TYPES.STRING),
        report_copy(FIELDS.TYPES.STRING),
        report_title(FIELDS.TYPES.STRING),
        report_filter(FIELDS.TYPES.STRING),
        report_message(FIELDS.TYPES.STRING),
        default_currency(FIELDS.TYPES.STRING),
        AT_CUD(FIELDS.TYPES.STRING),
        AT_QR_code(FIELDS.TYPES.STRING),
        AT_document_code(FIELDS.TYPES.STRING),
        document_date(FIELDS.TYPES.STRING),
        document_total(FIELDS.TYPES.DECIMAL),
        written_total(FIELDS.TYPES.STRING),
        MB_entity(FIELDS.TYPES.STRING),
        MB_reference(FIELDS.TYPES.STRING),
        MB_amount(FIELDS.TYPES.STRING),
        initial_date(FIELDS.TYPES.DATE),
        final_date(FIELDS.TYPES.DATE);

        public final String name = this.name().replace('_', '-');
        public final FIELDS.TYPES type;
        public final String expression;

        private PARAMETERS_TYPES(FIELDS.TYPES type) {
            this.type = type;
            this.expression = "params[" + StringUtils.quote((String)this.name, (char[])new char[0]) + "]";
        }
    }
}

