/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.birt.design;

import java.util.Iterator;
import org.dma.java.util.Debug;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.projectocolibri.api.birt.design.BIRTColumnProperties;
import org.projectocolibri.api.birt.design.BIRTParametersMap;
import org.projectocolibri.api.database.ILabelFormatter;
import org.projectocolibri.api.database.mapper.FIELDS;
import org.projectocolibri.api.database.mapper.TABLES;
import org.projectocolibri.api.database.mapper.TableFieldKey;

public class BIRTDesignHelper {
    public static String createColumnName(int dataSetIndex, int rowNumber) {
        return "d" + String.valueOf(dataSetIndex + 1) + "-" + String.valueOf(rowNumber);
    }

    public static String createDisplayName(TABLES table, ILabelFormatter formatter, TableFieldKey fieldKey, int dataSetIndex, int rowNumber, int columnNumber) throws Exception {
        String displayName = String.valueOf(BIRTDesignHelper.createColumnName(dataSetIndex, rowNumber)) + ": " + table.name() + " - " + table.map.get(fieldKey).label(formatter);
        return columnNumber > 0 ? String.valueOf(displayName) + " #" + String.valueOf(columnNumber) : displayName;
    }

    public static String createDisplayNameKey(TABLES table, TableFieldKey fieldKey, int columnNumber) throws Exception {
        String alias = String.valueOf(table.name()) + "." + fieldKey;
        return columnNumber > 0 ? String.valueOf(alias) + ":" + columnNumber : alias;
    }

    public static BIRTColumnProperties createColumnProperties(TABLES table, ILabelFormatter formatter, TableFieldKey fieldKey, int dataSetIndex, int rowNumber, int columnNumber) throws Exception {
        return new BIRTColumnProperties(rowNumber, BIRTDesignHelper.createColumnName(dataSetIndex, rowNumber), table.map.get((TableFieldKey)fieldKey).field.type, BIRTDesignHelper.createDisplayName(table, formatter, fieldKey, dataSetIndex, rowNumber, columnNumber), BIRTDesignHelper.createDisplayNameKey(table, fieldKey, columnNumber));
    }

    public static void setColumnProperties(ScriptDataSetHandle dataSetHandle, BIRTColumnProperties columnProperties) throws Exception {
        PropertyHandle columnHintsProp = dataSetHandle.getPropertyHandle("columnHints");
        ColumnHint columnHint = StructureFactory.createColumnHint();
        columnHint.setProperty("columnName", (Object)columnProperties.getName());
        columnHint.setProperty("displayName", (Object)columnProperties.getDisplayName());
        columnHint.setProperty("displayNameID", (Object)columnProperties.getDisplayNameKey());
        columnHintsProp.addItem((IStructure)columnHint);
        PropertyHandle resultSetProp = dataSetHandle.getPropertyHandle("resultSet");
        ResultSetColumn resultSetColumn = StructureFactory.createResultSetColumn();
        resultSetColumn.setPosition(Integer.valueOf(columnProperties.getPosition()));
        resultSetColumn.setColumnName(columnProperties.getName());
        resultSetColumn.setDataType(columnProperties.getType().birt);
        resultSetProp.addItem((IStructure)resultSetColumn);
    }

    public static DataItemHandle createDataItemColumn(ReportDesignHandle design, String name, FIELDS.TYPES type, String expression) throws Exception {
        ComputedColumn computedColumn = StructureFactory.createComputedColumn();
        computedColumn.setName(name);
        computedColumn.setDataType(type.birt);
        computedColumn.setDisplayName(name);
        computedColumn.setDisplayNameID(name);
        computedColumn.setExpression(expression);
        DataItemHandle dataItem = design.getElementFactory().newDataItem(name);
        dataItem.setResultSetColumn(name);
        dataItem.addColumnBinding(computedColumn, true);
        return dataItem;
    }

    public static DataItemHandle createDataItemColumn(ReportDesignHandle design, int reportType, BIRTParametersMap.PARAMETERS_TYPES parameter) throws Exception {
        return BIRTDesignHelper.createDataItemColumn(design, parameter.name, parameter.type, parameter.expression);
    }

    public static String findDatasource(ReportDesignHandle design) throws Exception {
        String datasource = "Database";
        Iterator iterator = design.getDataSources().iterator();
        while (iterator.hasNext()) {
            datasource = ((DataSourceHandle)iterator.next()).getName();
        }
        return datasource;
    }

    public static ScriptDataSetHandle findDataset(ReportDesignHandle design, String scriptDataSetName) throws Exception {
        for (ScriptDataSetHandle dataSetHandle : design.getDataSets()) {
            if (!dataSetHandle.getName().equals(scriptDataSetName)) continue;
            return dataSetHandle;
        }
        return null;
    }

    public static boolean existsDatasetColumn(ScriptDataSetHandle dataSetHandle, TABLES table, TableFieldKey fieldKey, int columnNumber) throws Exception {
        Iterator iterator = dataSetHandle.columnHintsIterator();
        while (iterator.hasNext()) {
            ColumnHintHandle columnHintHandle = (ColumnHintHandle)iterator.next();
            if (!BIRTDesignHelper.createDisplayNameKey(table, fieldKey, columnNumber).equals(columnHintHandle.getDisplayNameKey())) continue;
            return true;
        }
        return false;
    }

    public static int countDatasetColumns(ScriptDataSetHandle dataSetHandle) throws Exception {
        int count = 0;
        Iterator iterator = dataSetHandle.columnHintsIterator();
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }

    public static DataItemHandle findSlotColumn(SlotHandle slotHandle, String columnName) throws Exception {
        DataItemHandle itemHandle = null;
        Iterator iterator = slotHandle.iterator();
        while (iterator.hasNext() && itemHandle == null) {
            DataItemHandle itemHandle2;
            DesignElementHandle elementHandle = (DesignElementHandle)iterator.next();
            if (elementHandle instanceof TableHandle) {
                TableHandle tableHandle = (TableHandle)elementHandle;
                itemHandle = BIRTDesignHelper.findSlotColumn(tableHandle.getHeader(), columnName);
                if (itemHandle != null || (itemHandle = BIRTDesignHelper.findSlotColumn(tableHandle.getDetail(), columnName)) != null || (itemHandle = BIRTDesignHelper.findSlotColumn(tableHandle.getFooter(), columnName)) != null) continue;
                itemHandle = BIRTDesignHelper.findSlotColumn(tableHandle.getColumns(), columnName);
                continue;
            }
            if (elementHandle instanceof GridHandle) {
                GridHandle gridHandle = (GridHandle)elementHandle;
                itemHandle = BIRTDesignHelper.findSlotColumn(gridHandle.getRows(), columnName);
                if (itemHandle != null) continue;
                itemHandle = BIRTDesignHelper.findSlotColumn(gridHandle.getColumns(), columnName);
                continue;
            }
            if (elementHandle instanceof RowHandle) {
                RowHandle rowHandle = (RowHandle)elementHandle;
                itemHandle = BIRTDesignHelper.findSlotColumn(rowHandle.getCells(), columnName);
                continue;
            }
            if (elementHandle instanceof CellHandle) {
                CellHandle cellHandle = (CellHandle)elementHandle;
                itemHandle = BIRTDesignHelper.findSlotColumn(cellHandle.getContent(), columnName);
                continue;
            }
            if (!(elementHandle instanceof DataItemHandle) || !(itemHandle2 = (DataItemHandle)elementHandle).getResultSetColumn().equals(columnName)) continue;
            Debug.out((String)"FOUND", (Object)columnName);
            itemHandle = itemHandle2;
        }
        return itemHandle;
    }
}

