/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.birt.design;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dma.java.io.ByteFile;
import org.dma.java.util.Debug;
import org.projectocolibri.api.Colibri;
import org.projectocolibri.api.birt.design.BIRTDesign;
import org.projectocolibri.api.database.MethodCallback;
import org.projectocolibri.api.database.manager.TemplatesManager;
import org.projectocolibri.api.database.model.Templates;

public final class BIRTDesignCache
extends ConcurrentHashMap<String, ByteFile> {
    private static final long serialVersionUID = 1L;
    private final TemplatesManager manager;

    public BIRTDesignCache(TemplatesManager manager) {
        this.manager = manager;
    }

    @Override
    public void clear() {
        if (Colibri.VERSION_TYPE == Colibri.VERSIONS.SERVER) {
            for (ByteFile designFile : this.values()) {
                designFile.delete();
            }
        }
        super.clear();
    }

    public ByteFile remove(String codigo) {
        ByteFile designFile = (ByteFile)super.remove(codigo);
        if (designFile != null && Colibri.VERSION_TYPE == Colibri.VERSIONS.SERVER) {
            designFile.delete();
        }
        return designFile;
    }

    public ByteFile get(String codigo) throws Exception {
        ByteFile designFile = (ByteFile)super.get(codigo);
        if (designFile == null || !designFile.exists()) {
            Templates template = (Templates)this.manager.load(codigo);
            designFile = template.createDesignFile();
            if (designFile.length() == 0L) {
                new BIRTDesign(template).create((File)designFile);
            }
            Debug.err((String)"CREATED", (Object)designFile);
            this.put(codigo, designFile);
        }
        Debug.out((String)"CACHE", (Object)this.keySet());
        return designFile;
    }

    public void replace(String codigo) {
        if (this.remove(codigo) != null) {
            try {
                this.get(codigo);
            }
            catch (Exception exception) {}
        }
    }

    public void store() {
        for (Map.Entry entry : this.entrySet()) {
            Templates template = (Templates)this.manager.load(entry.getKey());
            byte[] designBytes = ((ByteFile)entry.getValue()).read();
            if (Arrays.equals(template.getTemplate(), designBytes)) continue;
            template.setTemplate(designBytes);
            Debug.out((String)"SAVING", entry.getValue());
            this.manager.store(template, new MethodCallback[0]);
        }
    }
}

