/*
 * Decompiled with CFR 0.152.
 */
package org.projectocolibri.api.birt;

import java.util.Locale;
import java.util.logging.Level;
import org.dma.eclipse.core.jobs.CustomJob;
import org.dma.java.io.CustomFile;
import org.dma.java.io.Folder;
import org.dma.java.time.Chronograph;
import org.dma.java.util.Debug;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManagerFactory;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.projectocolibri.api.Colibri;

public class BIRTEngineFactory {
    private static final CustomJob JOB = new CustomJob(){
        private boolean scheduled;

        public synchronized void schedule(ISchedulingRule rule) {
            if (!this.scheduled) {
                super.schedule(rule);
                this.scheduled = true;
            }
        }
    }.addTask((IAction)new Action(){

        public void run() {
            Chronograph time = new Chronograph().start();
            FontMappingManagerFactory.getInstance().getFontMappingManager("pdf", Locale.getDefault());
            Debug.err((String)"MAPPING EXECUTED", (Object)time.stop());
        }
    });
    private static final EngineConfig CONFIG = BIRTEngineFactory.getConfig();
    private static BIRTEngineFactory instance;
    private final IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");

    private static EngineConfig getConfig() {
        EngineConfig config = new EngineConfig();
        config.setTempDir(Folder.temporary((String[])new String[0]).getPath());
        config.setResourcePath(Colibri.FOLDERS.WORKSPACE.folder.getPath());
        config.setFontConfig(new CustomFile(Colibri.FILES.CONFIG.FONTS.pathname, new String[0]).toURL());
        config.setLogConfig(null, Level.SEVERE);
        return config;
    }

    public static BIRTEngineFactory getInstance() {
        if (instance == null) {
            instance = new BIRTEngineFactory();
        }
        return instance;
    }

    private BIRTEngineFactory() {
    }

    public void startup() throws BirtException {
        if (!Platform.runningEclipse()) {
            Platform.startup((PlatformConfig)CONFIG);
        }
    }

    public IReportEngine createReportEngine() throws BirtException {
        if (!Platform.runningEclipse()) {
            throw new BirtException("Platform not started");
        }
        IReportEngine engine = this.factory.createReportEngine(CONFIG);
        JOB.schedule(null);
        return engine;
    }
}

