/*
 * Decompiled with CFR 0.152.
 */
package org.dma.xml.beans;

import java.io.File;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.InvoiceLineType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.ItemIdentificationType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.ItemType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.PriceType;
import oasisNamesSpecificationUblSchemaXsdCommonAggregateComponents2.TaxCategoryType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.CustomizationIDType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.DocumentCurrencyCodeType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.DueDateType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.IDType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.InvoiceTypeCodeType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.InvoicedQuantityType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.IssueDateType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.LineExtensionAmountType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.NameType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.PercentType;
import oasisNamesSpecificationUblSchemaXsdCommonBasicComponents2.PriceAmountType;
import oasisNamesSpecificationUblSchemaXsdInvoice2.InvoiceDocument;
import oasisNamesSpecificationUblSchemaXsdInvoice2.InvoiceType;
import org.apache.xmlbeans.XmlOptions;
import org.dma.java.io.CustomFile;
import org.dma.java.io.FileParameters;
import org.dma.java.util.TimeDateUtils;
import org.dma.xml.IXMLExport;

public class InvoiceExport
implements IXMLExport {
    public static final String VERSAO = "2.1";
    public static final String NIF = "999999990";
    private final InvoiceDocument invoiceDocument = InvoiceDocument.Factory.newInstance();
    private final InvoiceType invoice = this.invoiceDocument.addNewInvoice();

    public FileParameters getFileParameters(File folder) {
        String prefix = "999999990_CIUS-PT_" + TimeDateUtils.getDateFormatted((String)"yyyy-MM-dd");
        return new FileParameters(prefix, "xml", folder);
    }

    @Override
    public boolean save(File file) {
        if (!file.isDirectory()) {
            try {
                XmlOptions options = new XmlOptions();
                options.setSavePrettyPrint();
                options.setUseDefaultNamespace();
                options.setSaveAggressiveNamespaces();
                LinkedHashMap<String, String> prefixes = new LinkedHashMap<String, String>();
                prefixes.put("urn:oasis:names:specification:ubl:schema:xsd:Invoice-2", "");
                prefixes.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
                prefixes.put("urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", "cbc");
                prefixes.put("urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2", "cac");
                options.setSaveSuggestedPrefixes(prefixes);
                options.setCharacterEncoding(CustomFile.UTF8_CHARSET.name());
                this.invoiceDocument.save(file, options);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return this.save((File)this.getFileParameters(file).toFile());
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.invoice.getInvoiceLineList().isEmpty();
    }

    @Override
    public boolean isValid() {
        return this.invoice.validate();
    }

    public void process() {
        this.createCustomizationID();
        this.createInvoiceLines();
    }

    private void createCustomizationID() {
        this.createCustomizationID(this.invoice.addNewCustomizationID(), this.invoice.addNewID(), this.invoice.addNewIssueDate(), this.invoice.addNewDocumentCurrencyCode());
        InvoiceTypeCodeType invoiceTypeCodeType = this.invoice.addNewInvoiceTypeCode();
        invoiceTypeCodeType.setListID("UNCL1001");
        invoiceTypeCodeType.setStringValue("380");
        DueDateType dueDateType = this.invoice.addNewDueDate();
        dueDateType.setCalendarValue(TimeDateUtils.getCalendarWithoutTimezone());
    }

    private void createCustomizationID(CustomizationIDType customizationIDType, IDType IDType2, IssueDateType issueDateType, DocumentCurrencyCodeType documentCurrencyCodeType) {
        customizationIDType.setStringValue("urn:cen.eu:en16931:2017#compliant#urn:feap.gov.pt:CIUS-PT:2.1");
        IDType2.setStringValue("Desconhecido");
        issueDateType.setCalendarValue(TimeDateUtils.getCalendarWithoutTimezone());
        documentCurrencyCodeType.setListID("ISO4217");
        documentCurrencyCodeType.setStringValue("PT");
    }

    private void createInvoiceLines() {
        InvoiceLineType invoiceLineType = this.invoice.addNewInvoiceLine();
        IDType IDType2 = invoiceLineType.addNewID();
        IDType2.setStringValue("1");
        InvoicedQuantityType invoicedQuantityType = invoiceLineType.addNewInvoicedQuantity();
        invoicedQuantityType.setBigDecimalValue(BigDecimal.ONE);
        invoicedQuantityType.setUnitCode("ZZ");
        LineExtensionAmountType lineExtensionAmountType = invoiceLineType.addNewLineExtensionAmount();
        lineExtensionAmountType.setBigDecimalValue(BigDecimal.ONE);
        lineExtensionAmountType.setCurrencyID("EUR");
        this.createItem(invoiceLineType);
        this.createPrice(invoiceLineType);
    }

    private void createItem(InvoiceLineType invoiceLineType) {
        ItemType itemType = invoiceLineType.addNewItem();
        NameType nameType = itemType.addNewName();
        nameType.setStringValue("Desconhecido");
        ItemIdentificationType itemSellersIdentificationType = itemType.addNewSellersItemIdentification();
        IDType IDType2 = itemSellersIdentificationType.addNewID();
        IDType2.setStringValue("Desconhecido");
        this.createTaxCategory(itemType);
    }

    private void createTaxCategory(ItemType itemType) {
        TaxCategoryType taxCategoryType = itemType.addNewClassifiedTaxCategory();
        IDType IDType2 = taxCategoryType.addNewID();
        IDType2.setStringValue("Desconhecido");
        PercentType percentType = taxCategoryType.addNewPercent();
        percentType.setBigDecimalValue(BigDecimal.ONE);
    }

    private void createPrice(InvoiceLineType invoiceLineType) {
        PriceType priceType = invoiceLineType.addNewPrice();
        PriceAmountType priceAmountType = priceType.addNewPriceAmount();
        priceAmountType.setBigDecimalValue(BigDecimal.ONE);
        priceAmountType.setCurrencyID("EUR");
    }
}

