/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import org.eclipse.birt.report.engine.emitter.HTMLEncodeUtil;
import org.eclipse.birt.report.engine.emitter.XMLWriter;

public class HTMLWriter
extends XMLWriter {
    public HTMLWriter() {
        this.bImplicitCloseTag = false;
    }

    public void style(String name, String value) {
        assert (name != null && name.length() > 0);
        if (value == null || value.length() == 0) {
            return;
        }
        if (!this.bPairedFlag) {
            this.print('>');
            this.bPairedFlag = true;
        }
        if (this.bIndent) {
            ++this.indentCount;
            this.println();
            this.print(this.indent());
            --this.indentCount;
        }
        this.print(name);
        this.print(" {");
        this.print(value);
        this.print('}');
    }

    public void writeCode(String code) {
        if (!this.bPairedFlag) {
            this.print('>');
            this.bPairedFlag = true;
        }
        if (this.bIndent) {
            this.println();
            this.print(super.indent());
        }
        this.print(code);
    }

    public void outputDoctype() {
        this.print("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
    }

    public void comment(String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        if (!this.bPairedFlag) {
            this.print('>');
            this.bPairedFlag = true;
        }
        this.print("<!--");
        this.print(HTMLEncodeUtil.encodeCdata(value));
        this.print("-->");
        this.bText = true;
    }

    public void text(String value) {
        this.text(value, true);
    }

    public void text(String value, boolean whitespace) {
        if (value == null || value.length() == 0) {
            return;
        }
        if (!this.bPairedFlag) {
            this.print('>');
            this.bPairedFlag = true;
        }
        String stringToPrint = HTMLEncodeUtil.encodeText(value, whitespace);
        this.print(stringToPrint);
        this.bText = true;
    }

    protected String encodeText(String text) {
        return HTMLEncodeUtil.encodeText(text, false);
    }

    protected String encodeText(String text, boolean whitespace) {
        return HTMLEncodeUtil.encodeText(text, whitespace);
    }
}

