/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultMetaData
implements IResultMetaData {
    protected IResultMetaData parentMetaData;
    protected String[] selectedColumns;
    private ArrayList metaEntries = new ArrayList();

    public ResultMetaData(IBaseQueryDefinition query, String[] selectedColumns) {
        this.initializeMetaData(query);
        this.selectedColumns = selectedColumns;
    }

    public ResultMetaData(IBaseQueryDefinition query) {
        this.initializeMetaData(query);
        this.selectedColumns = null;
    }

    public ResultMetaData(IBaseQueryDefinition query, DesignElementHandle handle) {
        this.initializeMetaData(query, handle);
        this.selectedColumns = null;
    }

    public ResultMetaData(IResultMetaData parentMetaData, String[] selectedColumns) {
        this.parentMetaData = parentMetaData;
        this.selectedColumns = selectedColumns;
    }

    public ResultMetaData(org.eclipse.birt.data.engine.api.IResultMetaData dteMeta) {
        this.adaptDTE(dteMeta);
    }

    private void adaptDTE(org.eclipse.birt.data.engine.api.IResultMetaData dteMeta) {
        if (dteMeta == null) {
            return;
        }
        int count = dteMeta.getColumnCount();
        int index = 0;
        while (index < count) {
            try {
                this.metaEntries.add(new MetaDataEntry(dteMeta.getColumnName(index + 1), dteMeta.getColumnLabel(index + 1), dteMeta.getColumnType(index + 1)));
            }
            catch (BirtException birtException) {}
            ++index;
        }
    }

    protected void initializeMetaData(IBaseQueryDefinition query) {
        this.initializeMetaData(query, null);
    }

    protected void initializeMetaData(IBaseQueryDefinition query, DesignElementHandle handle) {
        this.appendMetaData(query, handle);
    }

    protected void appendMetaData(IBaseQueryDefinition query, DesignElementHandle handle) {
        TableHandle tableHandle = null;
        ArrayList columnList = null;
        ArrayList<String> notAllowed = new ArrayList<String>();
        if (handle != null && handle instanceof TableHandle) {
            tableHandle = (TableHandle)handle;
        }
        if (tableHandle != null) {
            columnList = (ArrayList)tableHandle.getProperty("boundDataColumns");
        }
        if (columnList != null) {
            int i = 0;
            while (i < columnList.size()) {
                if (!((ComputedColumn)columnList.get(i)).allowExport()) {
                    notAllowed.add(((ComputedColumn)columnList.get(i)).getName());
                }
                ++i;
            }
        }
        Map bindings = query.getBindings();
        for (Map.Entry entry : bindings.entrySet()) {
            String name = (String)entry.getKey();
            IBinding binding = (IBinding)entry.getValue();
            try {
                if (!binding.exportable()) continue;
                this.metaEntries.add(new MetaDataEntry(name, binding.getDisplayName(), binding.getDataType(), this.isColumnAllowedExport(name, notAllowed)));
            }
            catch (DataException dataException) {}
        }
    }

    private boolean isColumnAllowedExport(String columnName, ArrayList<String> notAllowed) {
        if (notAllowed == null || notAllowed.size() <= 0) {
            return true;
        }
        int i = 0;
        while (i < notAllowed.size()) {
            if (columnName.equals(notAllowed.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int getColumnCount() {
        if (this.selectedColumns != null) {
            return this.selectedColumns.length;
        }
        if (this.parentMetaData != null) {
            return this.parentMetaData.getColumnCount();
        }
        return this.metaEntries.size();
    }

    @Override
    public String getColumnName(int index) throws BirtException {
        index = this.getColumnIndex(index);
        if (this.parentMetaData != null) {
            return this.parentMetaData.getColumnName(index);
        }
        MetaDataEntry entry = (MetaDataEntry)this.metaEntries.get(index);
        return entry.name;
    }

    @Override
    public String getColumnAlias(int index) throws BirtException {
        return this.getColumnName(index);
    }

    @Override
    public int getColumnType(int index) throws BirtException {
        index = this.getColumnIndex(index);
        if (this.parentMetaData != null) {
            return this.parentMetaData.getColumnType(index);
        }
        MetaDataEntry entry = (MetaDataEntry)this.metaEntries.get(index);
        return entry.type;
    }

    @Override
    public String getColumnTypeName(int index) throws BirtException {
        int type = this.getColumnType(index);
        return DataType.getName((int)type);
    }

    @Override
    public String getColumnLabel(int index) throws BirtException {
        String columnLabel;
        index = this.getColumnIndex(index);
        if (this.parentMetaData != null) {
            columnLabel = this.parentMetaData.getColumnLabel(index);
        } else {
            MetaDataEntry entry = (MetaDataEntry)this.metaEntries.get(index);
            columnLabel = entry.displayName;
        }
        if (columnLabel == null) {
            columnLabel = this.getColumnName(index);
        }
        return columnLabel;
    }

    @Override
    public boolean getAllowExport(int index) throws BirtException {
        boolean allowExport;
        index = this.getColumnIndex(index);
        if (this.parentMetaData != null) {
            allowExport = this.parentMetaData.getAllowExport(index);
        } else {
            MetaDataEntry entry = (MetaDataEntry)this.metaEntries.get(index);
            allowExport = entry.allowExport;
        }
        return allowExport;
    }

    private int getColumnIndex(int index) throws BirtException {
        if (this.selectedColumns == null) {
            return index;
        }
        String name = this.selectedColumns[index];
        if (this.parentMetaData != null) {
            int i = 0;
            while (i < this.parentMetaData.getColumnCount()) {
                String columnName = this.parentMetaData.getColumnName(i);
                if (columnName.equals(name)) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.metaEntries.size()) {
                MetaDataEntry entry = (MetaDataEntry)this.metaEntries.get(i);
                if (entry.name.equals(name)) {
                    return i;
                }
                ++i;
            }
        }
        throw new EngineException("Error.InvalidColumnIndexError");
    }

    private static class MetaDataEntry {
        String name;
        String displayName;
        int type;
        boolean allowExport;

        MetaDataEntry(String name, String displayName, int type) {
            this(name, displayName, type, true);
        }

        MetaDataEntry(String name, String displayName, int type, boolean allowExport) {
            this.name = name;
            this.displayName = displayName;
            this.type = type;
            this.allowExport = allowExport;
        }
    }
}

