/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.datanucleus.enhancer.DataNucleusEnhancer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_5)
public class EnhancerProcessor
extends AbstractProcessor {
    DataNucleusEnhancer enhancer = new DataNucleusEnhancer();
    Set<String> classNames = new HashSet<String>();
    Set<URL> classpathURLs = new HashSet<URL>();
    final Set<File> locations = new HashSet<File>();
    EnhanceRunnable enhanceRunnable = new EnhanceRunnable();
    Thread enhancementThread = new Thread(this.enhanceRunnable);
    Thread hook = new Thread(new ShutDownHook());
    boolean errorRaised = false;

    @Override
    public boolean process(Set<? extends TypeElement> arg0, RoundEnvironment roundEnv) {
        if (roundEnv.errorRaised()) {
            this.errorRaised = true;
        }
        String classpath = "";
        try {
            FileObject f = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", "d");
            classpath = new File(new URL(f.toUri().toString()).toURI()).getParentFile().getAbsolutePath() + File.separatorChar;
            this.classpathURLs.add(new URL("file:/" + classpath));
        }
        catch (Exception e1) {
            try {
                FileObject f = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "", "d");
                classpath = new File(new URL(f.toUri().toString()).toURI()).getParentFile().getAbsolutePath() + File.separatorChar;
                this.classpathURLs.add(new URL("file:/" + classpath));
            }
            catch (Exception e2) {
                try {
                    FileObject f = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", "d");
                    classpath = new File(new URL(f.toUri().toString()).toURI()).getParentFile().getAbsolutePath() + File.separatorChar;
                    this.classpathURLs.add(new URL("file:/" + classpath));
                }
                catch (Exception e3) {
                    // empty catch block
                }
                try {
                    classpath = System.getProperty("user.dir") + File.separatorChar;
                    this.classpathURLs.add(new File(classpath).toURI().toURL());
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        HashSet<TypeElement> classes = new HashSet<TypeElement>();
        classes.addAll(ElementFilter.typesIn(roundEnv.getRootElements()));
        for (TypeElement el : classes) {
            try {
                File location = new File(classpath + el.getQualifiedName().toString().replace('.', File.separatorChar) + ".class");
                this.locations.add(location);
                this.classNames.add(el.getQualifiedName().toString());
                this.classpathURLs.add(location.toURI().toURL());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (roundEnv.processingOver()) {
            Runtime.getRuntime().addShutdownHook(this.hook);
            this.enhancementThread.start();
        }
        return false;
    }

    private class ShutDownHook
    implements Runnable {
        private ShutDownHook() {
        }

        public void run() {
            while (!EnhancerProcessor.this.enhanceRunnable.finished) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public class EnhanceRunnable
    implements Runnable {
        public boolean running;
        public boolean finished;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.running = true;
            try {
                for (int i = 0; i < 1000 && !this.existsAll() && !EnhancerProcessor.this.errorRaised; ++i) {
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                EnhancerProcessor.this.enhancer.setClassLoader(new URLClassLoader(EnhancerProcessor.this.classpathURLs.toArray(new URL[EnhancerProcessor.this.classpathURLs.size()]), EnhancerProcessor.class.getClassLoader()));
                EnhancerProcessor.this.enhancer.addClasses(EnhancerProcessor.this.classNames.toArray(new String[EnhancerProcessor.this.classNames.size()]));
                EnhancerProcessor.this.enhancer.enhance();
            }
            finally {
                this.running = false;
                this.finished = true;
                try {
                    Runtime.getRuntime().removeShutdownHook(EnhancerProcessor.this.hook);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }

        private boolean existsAll() {
            Iterator<File> elems = new HashSet<File>(EnhancerProcessor.this.locations).iterator();
            while (elems.hasNext()) {
                if (elems.next().exists()) continue;
                return false;
            }
            return true;
        }
    }
}

