/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.series;

import java.util.Collection;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.util.ChartDefaultValueUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.PaletteEditorComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class SeriesPaletteSheet
extends AbstractPopupSheet
implements SelectionListener {
    private SeriesDefinition cSeriesDefn = null;
    private SeriesDefinition[] vSeriesDefns = null;
    private ChartWizardContext context = null;
    private boolean isGroupedSeries = false;
    private StackLayout slPalette = null;
    private Group grpPalette = null;
    private PaletteEditorComposite cmpPE = null;
    private Composite cmpMPE = null;
    private TabFolder tf = null;
    private final int iFillChooserStyle;
    private Button btnAutoPals;
    private Composite cmpContent;

    public SeriesPaletteSheet(String title, ChartWizardContext context, SeriesDefinition cSeriesDefn, SeriesDefinition[] vSeriesDefns, boolean isGroupedSeries, int iFillChooserStyle) {
        super(title, context, true);
        this.context = context;
        this.cSeriesDefn = cSeriesDefn;
        this.vSeriesDefns = vSeriesDefns;
        this.isGroupedSeries = isGroupedSeries;
        this.iFillChooserStyle = iFillChooserStyle;
    }

    public Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.SeriesPalette_ID");
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout();
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        this.cmpContent.setLayout((Layout)glContent);
        this.btnAutoPals = new Button(this.cmpContent, 32);
        this.btnAutoPals.setText(Messages.getString("SeriesPaletteSheet.Label.Auto"));
        this.btnAutoPals.addSelectionListener((SelectionListener)this);
        this.btnAutoPals.setVisible(this.context.getUIFactory().supportAutoUI());
        this.createPaletteUI(this.cmpContent);
        this.updateUIStatus();
        this.cmpContent.pack();
        return this.cmpContent;
    }

    protected void updateSeriesPalette() {
        ChartDefaultValueUtil.updateSeriesPalettes((Chart)this.getChart(), (Collection)this.getChart().eAdapters());
    }

    private void createPaletteUI(Composite cmpContent) {
        boolean isAutoPalette = ChartDefaultValueUtil.isAutoSeriesPalette((Chart)this.getChart());
        this.slPalette = new StackLayout();
        this.grpPalette = new Group(cmpContent, 0);
        GridData gdGRPPalette = new GridData(1808);
        gdGRPPalette.heightHint = 300;
        this.grpPalette.setLayoutData((Object)gdGRPPalette);
        this.grpPalette.setLayout((Layout)this.slPalette);
        this.grpPalette.setText(Messages.getString("BaseSeriesAttributeSheetImpl.Lbl.Palette"));
        if (cmpContent.isVisible()) {
            this.grpPalette.getShell().pack();
        }
        Chart chart = this.getChart();
        if (isAutoPalette) {
            chart = this.getChart().copyInstance();
            ChartDefaultValueUtil.updateSeriesPalettes((Chart)chart, (Collection)chart.eAdapters());
            this.vSeriesDefns = ChartUtil.getValueSeriesDefinitions((Chart)chart);
            this.cSeriesDefn = ChartUtil.getCategorySeriesDefinition((Chart)chart);
        }
        this.cmpPE = new PaletteEditorComposite((Composite)this.grpPalette, this.getContext(), this.cSeriesDefn.getSeriesPalette(), this.vSeriesDefns, this.iFillChooserStyle);
        this.cmpPE.setEnabled(!isAutoPalette);
        this.cmpMPE = new Composite((Composite)this.grpPalette, 0);
        GridLayout gl = new GridLayout();
        gl.marginLeft = 0;
        gl.marginRight = 0;
        this.cmpMPE.setLayoutData((Object)new GridData(1808));
        this.cmpMPE.setLayout((Layout)gl);
        this.tf = new TabFolder(this.cmpMPE, 0);
        this.tf.setLayoutData((Object)new GridData(1808));
        if (this.isGroupedSeries && this.isColoredByValue()) {
            int i = 0;
            while (i < this.vSeriesDefns.length) {
                TabItem ti = new TabItem(this.tf, 0);
                ti.setText(String.valueOf(Messages.getString("SeriesPaletteSheet.Tab.Series")) + (i + 1));
                PaletteEditorComposite pec = new PaletteEditorComposite((Composite)this.tf, this.getContext(), this.vSeriesDefns[i].getSeriesPalette(), null, this.iFillChooserStyle);
                pec.setEnabled(!isAutoPalette);
                ti.setControl((Control)pec);
                ++i;
            }
            this.tf.setSelection(0);
            this.slPalette.topControl = this.cmpMPE;
        } else if (this.isMultiAxes() && this.isColoredByValue()) {
            int i = 0;
            while (i < ChartUIUtil.getOrthogonalAxisNumber((Chart)chart)) {
                SeriesDefinition[] seriesDefns = (SeriesDefinition[])ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)chart, (int)i).toArray((Object[])new SeriesDefinition[0]);
                TabItem ti = new TabItem(this.tf, 0);
                ti.setText(String.valueOf(Messages.getString("SeriesPaletteSheet.Tab.Axis")) + (i + 1));
                PaletteEditorComposite pec = new PaletteEditorComposite((Composite)this.tf, this.getContext(), seriesDefns[0].getSeriesPalette(), seriesDefns, this.iFillChooserStyle);
                pec.setEnabled(!isAutoPalette);
                ti.setControl((Control)pec);
                ++i;
            }
            this.tf.setSelection(0);
            this.slPalette.topControl = this.cmpMPE;
        } else {
            this.slPalette.topControl = this.cmpPE;
        }
    }

    private void updateUIStatus() {
        if (this.context.getUIFactory().supportAutoUI() && ChartDefaultValueUtil.isAutoSeriesPalette((Chart)this.getChart())) {
            this.btnAutoPals.setSelection(true);
            this.grpPalette.setEnabled(false);
        } else {
            this.btnAutoPals.setSelection(false);
            this.grpPalette.setEnabled(true);
        }
    }

    public void setGroupedPalette(boolean isGroupedSeries) {
        this.isGroupedSeries = isGroupedSeries;
    }

    public void setCategorySeries(SeriesDefinition sd) {
        this.cSeriesDefn = sd;
    }

    private boolean isColoredByValue() {
        return this.context.getModel().getLegend().getItemType().getValue() == 0;
    }

    private boolean isMultiAxes() {
        return ChartUIUtil.getOrthogonalAxisNumber((Chart)this.context.getModel()) > 1;
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.btnAutoPals == e.widget) {
            if (this.btnAutoPals.getSelection()) {
                this.grpPalette.setEnabled(false);
                this.grpPalette.setVisible(false);
                ChartDefaultValueUtil.removeSerlesPalettes((Chart)this.getChart());
            } else {
                this.grpPalette.setEnabled(true);
                this.grpPalette.setVisible(true);
                this.updateSeriesPalette();
            }
            this.refreshPaletteUI();
        }
    }

    private void refreshPaletteUI() {
        this.vSeriesDefns = ChartUtil.getValueSeriesDefinitions((Chart)this.getChart());
        this.cSeriesDefn = ChartUtil.getCategorySeriesDefinition((Chart)this.getChart());
        if (this.grpPalette != null && !this.grpPalette.isDisposed()) {
            this.grpPalette.dispose();
        }
        this.createPaletteUI(this.cmpContent);
        this.updateUIStatus();
        this.cmpContent.getShell().layout();
        this.cmpContent.getShell().pack();
    }
}

