/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.barcode.ui;

import org.eclipse.birt.report.item.barcode.model.BarcodeBuilder;
import org.eclipse.birt.report.item.barcode.model.BarcodeContentType;
import org.eclipse.birt.report.item.barcode.model.BarcodeData;
import org.eclipse.birt.report.item.barcode.model.BarcodeItem;
import org.eclipse.birt.report.item.barcode.ui.BarcodeDefaults;
import org.eclipse.birt.report.item.barcode.ui.BarcodeUIHelper;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class BarcodeFigure
extends Figure {
    private BarcodeItem barcodeItem;
    private BarcodeData lastData;
    private Image cachedImage;

    public BarcodeFigure(BarcodeItem barcodeItem) {
        this.barcodeItem = barcodeItem;
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        return this.getPreferredSize(wHint, hHint);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        BarcodeData data = new BarcodeData(this.barcodeItem);
        if (data.getWidth() < 1.0E-4 || data.getHeight() < 1.0E-4) {
            return BarcodeDefaults.getDefault(data.getBarcodeType()).getDimension();
        }
        int dpi = Display.getDefault().getDPI().x;
        int width = BarcodeBuilder.convertToPx(data.getWidth(), data.getWidthUnits(), dpi);
        int height = BarcodeBuilder.convertToPx(data.getHeight(), data.getHeightUnits(), dpi);
        return new Dimension(width, height);
    }

    protected void paintClientArea(Graphics graphics) {
        BarcodeData data = new BarcodeData(this.barcodeItem);
        if (this.cachedImage == null || this.cachedImage.isDisposed() || !data.equals(this.lastData)) {
            BarcodeDefaults barcodeDefaults = BarcodeDefaults.getDefault(data.getBarcodeType());
            if (data.getContentType() == BarcodeContentType.SCRIPT) {
                data.setContent(barcodeDefaults.getContent());
            }
            if (data.getWidth() < 0.1 || data.getHeight() < 0.1) {
                data.setWidth(new Double(barcodeDefaults.getDimension().width));
                data.setWidthUnits("px");
                data.setHeight(new Double(barcodeDefaults.getDimension().height));
                data.setHeightUnits("px");
            }
            this.dispose();
            try {
                this.cachedImage = BarcodeBuilder.createBarcodeImage(data, BarcodeUIHelper.screenDPI());
                this.lastData = data;
            }
            catch (Exception exception) {
                this.cachedImage = BarcodeUIHelper.loadIconImage("icon_alert.gif");
            }
        }
        Rectangle r = this.getClientArea().getCopy();
        graphics.drawImage(this.cachedImage, r.x, r.y);
    }

    public void dispose() {
        if (this.cachedImage != null && !this.cachedImage.isDisposed()) {
            this.cachedImage.dispose();
        }
    }

    public void setBarcodeItem(BarcodeItem barcodeItem) {
        this.barcodeItem = barcodeItem;
    }
}

