/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.barcode.ui;

import com.google.zxing.BarcodeFormat;
import java.util.HashMap;
import org.eclipse.draw2d.geometry.Dimension;

public class BarcodeDefaults {
    private static HashMap<BarcodeFormat, BarcodeDefaults> barcodeDefaults = new HashMap();
    private final String content;
    private final Dimension dimension;

    static {
        barcodeDefaults.put(BarcodeFormat.QR_CODE, new BarcodeDefaults("BIRT rocks!", new Dimension(90, 90)));
        barcodeDefaults.put(BarcodeFormat.CODE_128, new BarcodeDefaults("BIRT rocks", new Dimension(90, 35)));
        barcodeDefaults.put(BarcodeFormat.CODE_39, new BarcodeDefaults("ABCDE12345", new Dimension(90, 35)));
        barcodeDefaults.put(BarcodeFormat.CODABAR, new BarcodeDefaults("A1234A", new Dimension(90, 35)));
        barcodeDefaults.put(BarcodeFormat.PDF_417, new BarcodeDefaults("BIRT rocks!", new Dimension(90, 35)));
        barcodeDefaults.put(BarcodeFormat.EAN_13, new BarcodeDefaults("1234567890128", new Dimension(90, 35)));
        barcodeDefaults.put(BarcodeFormat.EAN_8, new BarcodeDefaults("12345670", new Dimension(90, 35)));
        barcodeDefaults.put(BarcodeFormat.UPC_A, new BarcodeDefaults("12345678901", new Dimension(90, 35)));
        barcodeDefaults.put(BarcodeFormat.ITF, new BarcodeDefaults("30712345000010", new Dimension(90, 35)));
    }

    private BarcodeDefaults(String content, Dimension dimension) {
        this.content = content;
        this.dimension = dimension;
    }

    public String getContent() {
        return this.content;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public static BarcodeDefaults getDefault(BarcodeFormat format) {
        BarcodeDefaults value = barcodeDefaults.get(format);
        return value == null ? new BarcodeDefaults("", new Dimension(90, 90)) : value;
    }
}

