/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.barcode.model;

import java.awt.Toolkit;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.ReportItemPresentationBase;
import org.eclipse.birt.report.item.barcode.model.BarcodeBuilder;
import org.eclipse.birt.report.item.barcode.model.BarcodeContentType;
import org.eclipse.birt.report.item.barcode.model.BarcodeData;
import org.eclipse.birt.report.item.barcode.model.BarcodeItem;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;

public class BarcodePresentation
extends ReportItemPresentationBase {
    private BarcodeItem barcodeItem;

    public void setModelObject(ExtendedItemHandle modelHandle) {
        try {
            this.barcodeItem = (BarcodeItem)modelHandle.getReportItem();
        }
        catch (ExtendedElementException e) {
            e.printStackTrace();
        }
    }

    public int getOutputType() {
        return 1;
    }

    public Object onRowSets(IBaseResultSet[] results) throws BirtException {
        if (this.barcodeItem != null) {
            BarcodeData data = new BarcodeData(this.barcodeItem);
            data.setBarcodeType(data.getBarcodeType());
            data.setCorrection(data.getCorrection());
            String content = this.getResult(data.getContent(), data.getContentType(), results);
            data.setContent(content);
            if (content != null && content.length() > 0) {
                try {
                    return BarcodeBuilder.createBarcodeBytes(data, this.getRenderDPI());
                }
                catch (Exception e) {
                    System.err.println(String.valueOf(content) + " " + e.getMessage());
                }
            }
        }
        return null;
    }

    private String getResult(String input, BarcodeContentType type, IBaseResultSet[] results) throws BirtException {
        if (type == BarcodeContentType.CONSTANT) {
            return input;
        }
        if (type == BarcodeContentType.SCRIPT) {
            return this.evaluate(input, results);
        }
        throw new RuntimeException((Object)((Object)type) + " is not a valid type");
    }

    private String evaluate(String expression, IBaseResultSet[] results) throws BirtException {
        if (expression == null || expression.equalsIgnoreCase("null")) {
            return null;
        }
        if (results != null && results.length > 0) {
            IBaseResultSet baseResultSet = results[0];
            if (baseResultSet instanceof IQueryResultSet) {
                IQueryResultSet queryResultSet = (IQueryResultSet)baseResultSet;
                if (queryResultSet.isBeforeFirst()) {
                    queryResultSet.next();
                }
                Object object = queryResultSet.evaluate(expression);
                return String.valueOf(object);
            }
            if (baseResultSet instanceof ICubeResultSet) {
                ICubeResultSet cubeResultSet = (ICubeResultSet)baseResultSet;
                Object object = cubeResultSet.evaluate(expression);
                return String.valueOf(object);
            }
            return baseResultSet == null ? expression : String.valueOf(baseResultSet.getClass().getName()) + " " + expression;
        }
        Object object = this.context.evaluate(expression);
        return String.valueOf(object);
    }

    public int getRenderDPI() {
        int imageDPI;
        ReportDesignHandle handle;
        Object renderDPI = this.context.getRenderOption().getOption("RenderDpi");
        if (renderDPI != null && renderDPI instanceof Integer) {
            return (Integer)renderDPI;
        }
        this.modelHandle = this.barcodeItem.getModelHandle();
        if (this.modelHandle.getModuleHandle() instanceof ReportDesignHandle) {
            handle = (ReportDesignHandle)this.modelHandle.getModuleHandle();
            this.dpi = handle.getImageDPI();
        }
        if (this.modelHandle != null && this.modelHandle.getRoot() instanceof ReportDesignHandle && (imageDPI = (handle = (ReportDesignHandle)this.modelHandle.getRoot()).getImageDPI()) > 0) {
            return imageDPI;
        }
        try {
            int screenDPI = Toolkit.getDefaultToolkit().getScreenResolution();
            if (screenDPI > 0) {
                return screenDPI;
            }
        }
        catch (Exception exception) {}
        return 96;
    }
}

