/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.barcode.model;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import org.eclipse.birt.report.item.barcode.model.BarcodeContentType;
import org.eclipse.birt.report.item.barcode.model.BarcodeItem;

public class BarcodeData {
    private BarcodeFormat barcodeType;
    private ErrorCorrectionLevel correction;
    private String content;
    private final BarcodeContentType contentType;
    private Double width;
    private Double height;
    private String heightUnits;
    private String widthUnits;

    public BarcodeData(BarcodeItem item) {
        this.barcodeType = item.getBarcodeType().getStringValue() == null ? BarcodeFormat.QR_CODE : BarcodeFormat.valueOf((String)item.getBarcodeType().getStringValue());
        this.correction = item.getCorrection().getStringValue() == null ? ErrorCorrectionLevel.L : ErrorCorrectionLevel.valueOf((String)item.getCorrection().getStringValue());
        this.content = item.getContent().getStringValue() == null ? "" : item.getContent().getStringValue();
        this.contentType = item.getContent().getStringValue() == null ? BarcodeContentType.CONSTANT : BarcodeContentType.fromExpressionType(item.getContent().getType());
        this.width = item.getWidth();
        this.height = item.getHeight();
        this.widthUnits = item.getWidthUnits();
        this.heightUnits = item.getHeightUnits();
    }

    public BarcodeFormat getBarcodeType() {
        return this.barcodeType;
    }

    public void setBarcodeType(BarcodeFormat barcodeType) {
        this.barcodeType = barcodeType;
    }

    public ErrorCorrectionLevel getCorrection() {
        return this.correction;
    }

    public void setCorrection(ErrorCorrectionLevel correction) {
        this.correction = correction;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public BarcodeContentType getContentType() {
        return this.contentType;
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public String getWidthUnits() {
        return this.widthUnits;
    }

    public void setWidthUnits(String widthUnits) {
        this.widthUnits = widthUnits;
    }

    public String getHeightUnits() {
        return this.heightUnits;
    }

    public void setHeightUnits(String heightUnits) {
        this.heightUnits = heightUnits;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.barcodeType == null ? 0 : this.barcodeType.hashCode());
        result = prime * result + (this.correction == null ? 0 : this.correction.hashCode());
        result = prime * result + (this.content == null ? 0 : this.content.hashCode());
        result = prime * result + (this.contentType == null ? 0 : this.contentType.hashCode());
        result = prime * result + (this.width == null ? 0 : this.width.hashCode());
        result = prime * result + (this.height == null ? 0 : this.height.hashCode());
        result = prime * result + (this.widthUnits == null ? 0 : this.widthUnits.hashCode());
        result = prime * result + (this.heightUnits == null ? 0 : this.heightUnits.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BarcodeData other = (BarcodeData)obj;
        if (this.barcodeType == null && other.barcodeType != null) {
            return false;
        }
        if (this.barcodeType != null && other.barcodeType == null) {
            return false;
        }
        if (!this.barcodeType.equals((Object)other.barcodeType)) {
            return false;
        }
        if (this.correction == null && other.correction != null) {
            return false;
        }
        if (this.correction != null && other.correction == null) {
            return false;
        }
        if (!this.correction.equals((Object)other.correction)) {
            return false;
        }
        if (this.content == null && other.content != null) {
            return false;
        }
        if (this.content != null && other.content == null) {
            return false;
        }
        if (!this.content.equals(other.content)) {
            return false;
        }
        if (this.contentType == null && other.contentType != null) {
            return false;
        }
        if (this.contentType != null && other.contentType == null) {
            return false;
        }
        if (!this.contentType.equals((Object)other.contentType)) {
            return false;
        }
        if (this.width == null && other.width != null) {
            return false;
        }
        if (this.width != null && other.width == null) {
            return false;
        }
        if (!this.width.equals(other.width)) {
            return false;
        }
        if (this.height == null && other.height != null) {
            return false;
        }
        if (this.height != null && other.height == null) {
            return false;
        }
        if (!this.height.equals(other.height)) {
            return false;
        }
        if (this.widthUnits == null && other.widthUnits != null) {
            return false;
        }
        if (this.widthUnits != null && other.widthUnits == null) {
            return false;
        }
        if (!this.widthUnits.equals(other.widthUnits)) {
            return false;
        }
        if (this.heightUnits == null && other.heightUnits != null) {
            return false;
        }
        if (this.heightUnits != null && other.heightUnits == null) {
            return false;
        }
        return this.heightUnits.equals(other.heightUnits);
    }
}

