/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.barcode.model;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import org.eclipse.birt.report.item.barcode.model.BarcodeData;
import org.eclipse.birt.report.item.barcode.model.BarcodeType;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class BarcodeBuilder {
    public static Image createBarcodeImage(BarcodeData data, int dpi) throws Exception {
        byte[] imageBytes = BarcodeBuilder.createBarcodeBytes(data, dpi);
        ImageData imageData = new ImageData((InputStream)new ByteArrayInputStream(imageBytes));
        return new Image((Device)Display.getDefault(), imageData);
    }

    public static byte[] createBarcodeBytes(BarcodeData data, int dpi) throws Exception {
        HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>(2);
        hints.put(EncodeHintType.CHARACTER_SET, BarcodeType.getDefaultEncoding());
        hints.put(EncodeHintType.ERROR_CORRECTION, (String)data.getCorrection());
        String content = data.getContent();
        BarcodeFormat barcodeFormat = data.getBarcodeType();
        int width = BarcodeBuilder.convertToPx(data.getWidth(), data.getWidthUnits(), dpi);
        int height = BarcodeBuilder.convertToPx(data.getHeight(), data.getHeightUnits(), dpi);
        BitMatrix matrix = new MultiFormatWriter().encode(content, barcodeFormat, width, height, hints);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageOutputStream ios = ImageIO.createImageOutputStream(baos);
        ImageIO.write((RenderedImage)MatrixToImageWriter.toBufferedImage((BitMatrix)matrix), "png", ios);
        ios.flush();
        ios.close();
        return baos.toByteArray();
    }

    public static int convertToPx(Double value, String unit, int dpi) {
        if ("px".equals(unit)) {
            return value.intValue();
        }
        DimensionValue dimension = DimensionUtil.convertTo((double)value, (String)unit, (String)"pt");
        Double convertedValue = dimension.getMeasure() / 72.0 * (double)dpi;
        return convertedValue.intValue();
    }
}

