/*******************************************************************************
 * Copyright 2008-2025 Marco Lopes (marcolopespt@gmail.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors
 * Marco Lopes (marcolopespt@gmail.com)
 *******************************************************************************/
package org.dma.java.cipher;

import org.dma.java.util.RandomValue;

public class BlowfishCipher extends CryptoCipher {

	/**
	 * https://www.schneier.com/academic/blowfish/
	 */
	public BlowfishCipher(String key) {
		super(key.getBytes(), "Blowfish");
	}


	public static void main(String[] args) throws Exception {

		BlowfishCipher cipher=new BlowfishCipher(new RandomValue().string(16));

		String message = "The quick brown fox jumps over the lazy dog.";
		System.out.println(cipher.BASE64encrypt(message, 0));

	}

}
