/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.barcode.ui;

import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class BarcodeUIHelper {
    public static int screenDPI() {
        int screenDpi = Toolkit.getDefaultToolkit().getScreenResolution();
        return screenDpi > 0 ? screenDpi : 96;
    }

    public static Image createIconImage(String fileName, int width, int height) {
        Image image = BarcodeUIHelper.loadIconImage(fileName);
        Image scaled = new Image((Device)Display.getDefault(), image.getImageData().scaledTo(width, height));
        image.dispose();
        return scaled;
    }

    public static Image loadIconImage(String filename) {
        ImageDescriptor descriptor = BarcodeUIHelper.getImageDescriptor(BarcodeUIHelper.class, "icons/" + filename);
        return descriptor.createImage();
    }

    public static ImageDescriptor getImageDescriptor(Class location, String resource) {
        try {
            return BarcodeUIHelper.getImageDescriptor(location.getClassLoader().getResourceAsStream(resource));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ImageDescriptor getImageDescriptor(InputStream stream) throws IOException {
        try {
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromImageData((ImageData)new ImageData(stream));
            return imageDescriptor;
        }
        finally {
            stream.close();
        }
    }
}

